/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.beanutils;

import com.bmc.thirdparty.org.apache.commons.beanutils.PropertyUtils;
import com.bmc.thirdparty.org.apache.commons.collections.Transformer;
import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import java.lang.reflect.InvocationTargetException;

public class BeanToPropertyValueTransformer
implements Transformer {
    private final Log log = LogFactory.getLog(this.getClass());
    private String propertyName;
    private boolean ignoreNull;

    public BeanToPropertyValueTransformer(String propertyName) {
        this(propertyName, false);
    }

    public BeanToPropertyValueTransformer(String propertyName, boolean ignoreNull) {
        if (propertyName == null || propertyName.length() <= 0) {
            throw new IllegalArgumentException("propertyName cannot be null or empty");
        }
        this.propertyName = propertyName;
        this.ignoreNull = ignoreNull;
    }

    public Object transform(Object object) {
        Object propertyValue = null;
        try {
            propertyValue = PropertyUtils.getProperty(object, this.propertyName);
        }
        catch (IllegalArgumentException e2) {
            String errorMsg = "Problem during transformation. Null value encountered in property path...";
            if (this.ignoreNull) {
                this.log.warn("WARNING: Problem during transformation. Null value encountered in property path...", e2);
            }
            this.log.error("ERROR: Problem during transformation. Null value encountered in property path...", e2);
            throw e2;
        }
        catch (IllegalAccessException e3) {
            String errorMsg = "Unable to access the property provided.";
            this.log.error("Unable to access the property provided.", e3);
            throw new IllegalArgumentException("Unable to access the property provided.");
        }
        catch (InvocationTargetException e4) {
            String errorMsg = "Exception occurred in property's getter";
            this.log.error("Exception occurred in property's getter", e4);
            throw new IllegalArgumentException("Exception occurred in property's getter");
        }
        catch (NoSuchMethodException e5) {
            String errorMsg = "No property found for name [" + this.propertyName + "]";
            this.log.error(errorMsg, e5);
            throw new IllegalArgumentException(errorMsg);
        }
        return propertyValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }
}

