/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.ProxyManager;
import com.bmc.arsys.api.ProxyPool;
import com.bmc.arsys.apitransport.ApiProxyI;
import com.bmc.arsys.apitransport.ApiUserContextI;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PoolingProxyManager
extends ProxyManager
implements Serializable {
    private static final long serialVersionUID = -8656598772149963739L;
    private int maxProxiesPerServer;
    private Hashtable<String, ProxyPool> serverProxyPools = new Hashtable();

    PoolingProxyManager(int n2) {
        this.maxProxiesPerServer = n2;
    }

    public ApiProxyI getProxy(ApiUserContextI apiUserContextI) throws ARException {
        ApiProxyI apiProxyI;
        if (apiUserContextI.isProxyInContext()) {
            apiProxyI = apiUserContextI.getProxyI();
        } else {
            ProxyPool proxyPool = this.if(apiUserContextI);
            apiProxyI = proxyPool.get(apiUserContextI);
        }
        apiProxyI.setProxyProperties(apiUserContextI);
        return apiProxyI;
    }

    private synchronized ProxyPool if(ApiUserContextI apiUserContextI) throws ARException {
        if (apiUserContextI.getServer() == null || apiUserContextI.getServer().length() == 0) {
            throw new ARException(2, 150);
        }
        String string = this.do(apiUserContextI);
        ProxyPool proxyPool = this.serverProxyPools.get(string);
        if (proxyPool == null) {
            proxyPool = new ProxyPool(this.maxProxiesPerServer);
            this.serverProxyPools.put(string, proxyPool);
            string = this.a(apiUserContextI);
            this.serverProxyPools.put(string, proxyPool);
        }
        return proxyPool;
    }

    public void releaseProxy(ApiProxyI apiProxyI, ApiUserContextI apiUserContextI) {
        if (apiProxyI == null) {
            return;
        }
        if (!apiUserContextI.isProxyInContext()) {
            try {
                ProxyPool proxyPool = this.if(apiUserContextI);
                proxyPool.put(apiProxyI);
            }
            catch (ARException aRException) {
                return;
            }
        }
    }

    synchronized void clear() {
        Enumeration<String> enumeration = this.serverProxyPools.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            ProxyPool proxyPool = this.serverProxyPools.get(string);
            proxyPool.clear();
        }
        this.serverProxyPools.clear();
    }

    synchronized ProxyManager.PoolInfo[] getInfo() {
        ArrayList<ProxyManager.PoolInfo> arrayList = new ArrayList<ProxyManager.PoolInfo>();
        Enumeration<String> enumeration = this.serverProxyPools.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            ProxyPool proxyPool = this.serverProxyPools.get(string);
            if (proxyPool == null) continue;
            ProxyManager.PoolInfo poolInfo = proxyPool.getInfo(string);
            arrayList.add(poolInfo);
        }
        return arrayList.toArray(new ProxyManager.PoolInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.clear();
        }
        finally {
            super.finalize();
        }
    }

    private String do(ApiUserContextI apiUserContextI) {
        String string = apiUserContextI.getServer();
        int n2 = apiUserContextI.getPort();
        if (n2 != 0) {
            string = string + ":" + n2;
        }
        return string;
    }

    private String a(ApiUserContextI apiUserContextI) {
        return apiUserContextI.getServer();
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).appendSuper(super.toString()).append("Max Proxies Per Server", this.maxProxiesPerServer).append("Server Proxy Pools", this.serverProxyPools).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.maxProxiesPerServer).append(this.serverProxyPools).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PoolingProxyManager)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        PoolingProxyManager poolingProxyManager = (PoolingProxyManager)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append(this.maxProxiesPerServer, poolingProxyManager.maxProxiesPerServer).append(this.serverProxyPools, poolingProxyManager.serverProxyPools).isEquals();
    }
}

