/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet;

import com.bmc.thirdparty.org.springframework.beans.BeanUtils;
import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.context.ApplicationContextException;
import com.bmc.thirdparty.org.springframework.context.ConfigurableApplicationContext;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import com.bmc.thirdparty.org.springframework.web.context.ConfigurableWebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.context.WebApplicationContext;
import com.bmc.thirdparty.org.springframework.web.context.support.ServletRequestHandledEvent;
import com.bmc.thirdparty.org.springframework.web.context.support.WebApplicationContextUtils;
import com.bmc.thirdparty.org.springframework.web.servlet.HttpServletBean;
import com.bmc.thirdparty.org.springframework.web.util.NestedServletException;
import com.bmc.thirdparty.org.springframework.web.util.WebUtils;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class FrameworkServlet
extends HttpServletBean {
    public static final String DEFAULT_NAMESPACE_SUFFIX = "-servlet";
    public static final Class DEFAULT_CONTEXT_CLASS = class$org$springframework$web$context$support$XmlWebApplicationContext == null ? (class$org$springframework$web$context$support$XmlWebApplicationContext = FrameworkServlet.class$("com.bmc.thirdparty.org.springframework.web.context.support.XmlWebApplicationContext")) : class$org$springframework$web$context$support$XmlWebApplicationContext;
    public static final String SERVLET_CONTEXT_PREFIX = (class$org$springframework$web$servlet$FrameworkServlet == null ? (class$org$springframework$web$servlet$FrameworkServlet = FrameworkServlet.class$("com.bmc.thirdparty.org.springframework.web.servlet.FrameworkServlet")) : class$org$springframework$web$servlet$FrameworkServlet).getName() + ".CONTEXT.";
    private Class contextClass = DEFAULT_CONTEXT_CLASS;
    private String namespace;
    private String contextConfigLocation;
    private boolean publishContext = true;
    private boolean publishEvents = true;
    private WebApplicationContext webApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$context$support$XmlWebApplicationContext;
    static /* synthetic */ Class class$org$springframework$web$servlet$FrameworkServlet;
    static /* synthetic */ Class class$org$springframework$web$context$ConfigurableWebApplicationContext;

    public void setContextClass(Class contextClass) {
        this.contextClass = contextClass;
    }

    public Class getContextClass() {
        return this.contextClass;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace != null ? this.namespace : this.getServletName() + DEFAULT_NAMESPACE_SUFFIX;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public void setPublishContext(boolean publishContext) {
        this.publishContext = publishContext;
    }

    public boolean isPublishContext() {
        return this.publishContext;
    }

    public void setPublishEvents(boolean publishEvents) {
        this.publishEvents = publishEvents;
    }

    public boolean isPublishEvents() {
        return this.publishEvents;
    }

    protected final void initServletBean() throws ServletException, BeansException {
        long startTime = System.currentTimeMillis();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("FrameworkServlet '" + this.getServletName() + "': initialization started");
        }
        try {
            this.webApplicationContext = this.initWebApplicationContext();
            this.initFrameworkServlet();
        }
        catch (ServletException ex) {
            this.logger.error("Context initialization failed", ex);
            throw ex;
        }
        catch (BeansException ex) {
            this.logger.error("Context initialization failed", ex);
            throw ex;
        }
        if (this.logger.isInfoEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.logger.info("FrameworkServlet '" + this.getServletName() + "': initialization completed in " + elapsedTime + " ms");
        }
    }

    protected WebApplicationContext initWebApplicationContext() throws BeansException {
        this.getServletContext().log("Loading WebApplicationContext for Spring FrameworkServlet '" + this.getServletName() + "'");
        WebApplicationContext parent = WebApplicationContextUtils.getWebApplicationContext(this.getServletContext());
        WebApplicationContext wac = this.createWebApplicationContext(parent);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Using context class [" + wac.getClass().getName() + "] for servlet '" + this.getServletName() + "'");
        }
        if (this.isPublishContext()) {
            String attrName = this.getServletContextAttributeName();
            this.getServletContext().setAttribute(attrName, (Object)wac);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Published WebApplicationContext of servlet '" + this.getServletName() + "' as ServletContext attribute with name [" + attrName + "]");
            }
        }
        return wac;
    }

    protected WebApplicationContext createWebApplicationContext(WebApplicationContext parent) throws BeansException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Servlet with name '" + this.getServletName() + "' will try to create custom WebApplicationContext context of class '" + this.getContextClass().getName() + "'" + ", using parent context [" + parent + "]");
        }
        if (!(class$org$springframework$web$context$ConfigurableWebApplicationContext == null ? (class$org$springframework$web$context$ConfigurableWebApplicationContext = FrameworkServlet.class$("com.bmc.thirdparty.org.springframework.web.context.ConfigurableWebApplicationContext")) : class$org$springframework$web$context$ConfigurableWebApplicationContext).isAssignableFrom(this.getContextClass())) {
            throw new ApplicationContextException("Fatal initialization error in servlet with name '" + this.getServletName() + "': custom WebApplicationContext class [" + this.getContextClass().getName() + "] is not of type ConfigurableWebApplicationContext");
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass(this.getContextClass());
        wac.setParent(parent);
        wac.setServletContext(this.getServletContext());
        wac.setServletConfig(this.getServletConfig());
        wac.setNamespace(this.getNamespace());
        if (this.getContextConfigLocation() != null) {
            wac.setConfigLocations(StringUtils.tokenizeToStringArray(this.getContextConfigLocation(), ",; \t\n"));
        }
        wac.refresh();
        return wac;
    }

    public String getServletContextAttributeName() {
        return SERVLET_CONTEXT_PREFIX + this.getServletName();
    }

    public final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected void initFrameworkServlet() throws ServletException, BeansException {
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected final void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected final void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        Throwable failureCause = null;
        try {
            try {
                this.doService(request, response);
            }
            catch (ServletException ex) {
                failureCause = ex;
                throw ex;
            }
            catch (IOException ex) {
                failureCause = ex;
                throw ex;
            }
            catch (Throwable ex) {
                failureCause = ex;
                throw new NestedServletException("Request processing failed", ex);
            }
            Object var8_5 = null;
            if (failureCause != null) {
                this.logger.debug("Could not complete request", failureCause);
            } else {
                this.logger.debug("Successfully completed request");
            }
            if (!this.isPublishEvents()) return;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (failureCause != null) {
                this.logger.debug("Could not complete request", failureCause);
            } else {
                this.logger.debug("Successfully completed request");
            }
            if (!this.isPublishEvents()) throw throwable;
            long processingTime = System.currentTimeMillis() - startTime;
            this.webApplicationContext.publishEvent(new ServletRequestHandledEvent((Object)this, request.getRequestURI(), request.getRemoteAddr(), request.getMethod(), this.getServletConfig().getServletName(), WebUtils.getSessionId(request), this.getUsernameForRequest(request), processingTime, failureCause));
            throw throwable;
        }
        long processingTime = System.currentTimeMillis() - startTime;
        this.webApplicationContext.publishEvent(new ServletRequestHandledEvent((Object)this, request.getRequestURI(), request.getRemoteAddr(), request.getMethod(), this.getServletConfig().getServletName(), WebUtils.getSessionId(request), this.getUsernameForRequest(request), processingTime, failureCause));
    }

    protected String getUsernameForRequest(HttpServletRequest request) {
        Principal userPrincipal = request.getUserPrincipal();
        return userPrincipal != null ? userPrincipal.getName() : null;
    }

    protected abstract void doService(HttpServletRequest var1, HttpServletResponse var2) throws Exception;

    public void destroy() {
        this.getServletContext().log("Closing WebApplicationContext of Spring FrameworkServlet '" + this.getServletName() + "'");
        if (this.webApplicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)((Object)this.webApplicationContext)).close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

