/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.support.lob;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.dao.DataAccessResourceFailureException;
import com.bmc.thirdparty.org.springframework.dao.InvalidDataAccessApiUsageException;
import com.bmc.thirdparty.org.springframework.jdbc.support.lob.AbstractLobHandler;
import com.bmc.thirdparty.org.springframework.jdbc.support.lob.LobCreator;
import com.bmc.thirdparty.org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import com.bmc.thirdparty.org.springframework.util.FileCopyUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OracleLobHandler
extends AbstractLobHandler {
    private static final String BLOB_CLASS_NAME = "oracle.sql.BLOB";
    private static final String CLOB_CLASS_NAME = "oracle.sql.CLOB";
    private static final String DURATION_SESSION_FIELD_NAME = "DURATION_SESSION";
    private static final String MODE_READWRITE_FIELD_NAME = "MODE_READWRITE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private NativeJdbcExtractor nativeJdbcExtractor;
    private Boolean cache = Boolean.TRUE;
    private Class blobClass;
    private Class clobClass;
    private final Map durationSessionConstants = new HashMap(2);
    private final Map modeReadWriteConstants = new HashMap(2);
    static /* synthetic */ Class class$java$sql$Connection;

    public void setNativeJdbcExtractor(NativeJdbcExtractor nativeJdbcExtractor) {
        this.nativeJdbcExtractor = nativeJdbcExtractor;
    }

    public void setCache(boolean cache) {
        this.cache = new Boolean(cache);
    }

    protected synchronized void initOracleDriverClasses(Connection con) {
        if (this.blobClass == null) {
            try {
                this.blobClass = con.getClass().getClassLoader().loadClass(BLOB_CLASS_NAME);
                this.durationSessionConstants.put(this.blobClass, new Integer(this.blobClass.getField(DURATION_SESSION_FIELD_NAME).getInt(null)));
                this.modeReadWriteConstants.put(this.blobClass, new Integer(this.blobClass.getField(MODE_READWRITE_FIELD_NAME).getInt(null)));
                this.clobClass = con.getClass().getClassLoader().loadClass(CLOB_CLASS_NAME);
                this.durationSessionConstants.put(this.clobClass, new Integer(this.clobClass.getField(DURATION_SESSION_FIELD_NAME).getInt(null)));
                this.modeReadWriteConstants.put(this.clobClass, new Integer(this.clobClass.getField(MODE_READWRITE_FIELD_NAME).getInt(null)));
            }
            catch (Exception ex) {
                throw new InvalidDataAccessApiUsageException("Couldn't initialize OracleLobHandler because Oracle driver classes are not available. Note that OracleLobHandler requires Oracle JDBC driver 9i or higher!", ex);
            }
        }
    }

    public byte[] getBlobAsBytes(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning Oracle BLOB as bytes");
        Blob blob = rs.getBlob(columnIndex);
        return blob != null ? blob.getBytes(1L, (int)blob.length()) : null;
    }

    public InputStream getBlobAsBinaryStream(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning Oracle BLOB as binary stream");
        Blob blob = rs.getBlob(columnIndex);
        return blob != null ? blob.getBinaryStream() : null;
    }

    public String getClobAsString(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning Oracle CLOB as string");
        Clob clob = rs.getClob(columnIndex);
        return clob != null ? clob.getSubString(1L, (int)clob.length()) : null;
    }

    public InputStream getClobAsAsciiStream(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning Oracle CLOB as ASCII stream");
        Clob clob = rs.getClob(columnIndex);
        return clob != null ? clob.getAsciiStream() : null;
    }

    public Reader getClobAsCharacterStream(ResultSet rs, int columnIndex) throws SQLException {
        this.logger.debug("Returning Oracle CLOB as character stream");
        Clob clob = rs.getClob(columnIndex);
        return clob != null ? clob.getCharacterStream() : null;
    }

    public LobCreator getLobCreator() {
        return new OracleLobCreator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static interface LobCallback {
        public void populateLob(Object var1) throws Exception;
    }

    protected class OracleLobCreator
    implements LobCreator {
        private final List createdLobs = new LinkedList();

        protected OracleLobCreator() {
        }

        public void setBlobAsBytes(PreparedStatement ps, int paramIndex, final byte[] content) throws SQLException {
            if (content != null) {
                Blob blob = (Blob)this.createLob(ps, false, new LobCallback(){

                    public void populateLob(Object lob) throws Exception {
                        Method methodToInvoke = lob.getClass().getMethod("getBinaryOutputStream", new Class[0]);
                        OutputStream out = (OutputStream)methodToInvoke.invoke(lob, (Object[])null);
                        FileCopyUtils.copy(content, out);
                    }
                });
                ps.setBlob(paramIndex, blob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug("Set bytes for Oracle BLOB with length " + blob.length());
                }
            } else {
                ps.setBlob(paramIndex, (Blob)null);
                OracleLobHandler.this.logger.debug("Set Oracle BLOB to null");
            }
        }

        public void setBlobAsBinaryStream(PreparedStatement ps, int paramIndex, final InputStream binaryStream, int contentLength) throws SQLException {
            if (binaryStream != null) {
                Blob blob = (Blob)this.createLob(ps, false, new LobCallback(){

                    public void populateLob(Object lob) throws Exception {
                        Method methodToInvoke = lob.getClass().getMethod("getBinaryOutputStream", null);
                        OutputStream out = (OutputStream)methodToInvoke.invoke(lob, (Object[])null);
                        FileCopyUtils.copy(binaryStream, out);
                    }
                });
                ps.setBlob(paramIndex, blob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug("Set binary stream for Oracle BLOB with length " + blob.length());
                }
            } else {
                ps.setBlob(paramIndex, (Blob)null);
                OracleLobHandler.this.logger.debug("Set Oracle BLOB to null");
            }
        }

        public void setClobAsString(PreparedStatement ps, int paramIndex, final String content) throws SQLException {
            if (content != null) {
                Clob clob = (Clob)this.createLob(ps, true, new LobCallback(){

                    public void populateLob(Object lob) throws Exception {
                        Method methodToInvoke = lob.getClass().getMethod("getCharacterOutputStream", null);
                        Writer writer = (Writer)methodToInvoke.invoke(lob, (Object[])null);
                        FileCopyUtils.copy(content, writer);
                    }
                });
                ps.setClob(paramIndex, clob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug("Set string for Oracle CLOB with length " + clob.length());
                }
            } else {
                ps.setClob(paramIndex, (Clob)null);
                OracleLobHandler.this.logger.debug("Set Oracle CLOB to null");
            }
        }

        public void setClobAsAsciiStream(PreparedStatement ps, int paramIndex, final InputStream asciiStream, int contentLength) throws SQLException {
            if (asciiStream != null) {
                Clob clob = (Clob)this.createLob(ps, true, new LobCallback(){

                    public void populateLob(Object lob) throws Exception {
                        Method methodToInvoke = lob.getClass().getMethod("getAsciiOutputStream", null);
                        OutputStream out = (OutputStream)methodToInvoke.invoke(lob, (Object[])null);
                        FileCopyUtils.copy(asciiStream, out);
                    }
                });
                ps.setClob(paramIndex, clob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug("Set ASCII stream for Oracle CLOB with length " + clob.length());
                }
            } else {
                ps.setClob(paramIndex, (Clob)null);
                OracleLobHandler.this.logger.debug("Set Oracle CLOB to null");
            }
        }

        public void setClobAsCharacterStream(PreparedStatement ps, int paramIndex, final Reader characterStream, int contentLength) throws SQLException {
            if (characterStream != null) {
                Clob clob = (Clob)this.createLob(ps, true, new LobCallback(){

                    public void populateLob(Object lob) throws Exception {
                        Method methodToInvoke = lob.getClass().getMethod("getCharacterOutputStream", null);
                        Writer writer = (Writer)methodToInvoke.invoke(lob, (Object[])null);
                        FileCopyUtils.copy(characterStream, writer);
                    }
                });
                ps.setClob(paramIndex, clob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug("Set character stream for Oracle CLOB with length " + clob.length());
                }
            } else {
                ps.setClob(paramIndex, (Clob)null);
                OracleLobHandler.this.logger.debug("Set Oracle CLOB to null");
            }
        }

        protected Object createLob(PreparedStatement ps, boolean clob, LobCallback callback) throws SQLException {
            Connection con = null;
            try {
                con = this.getOracleConnection(ps);
                OracleLobHandler.this.initOracleDriverClasses(con);
                Object lob = this.prepareLob(con, clob ? OracleLobHandler.this.clobClass : OracleLobHandler.this.blobClass);
                callback.populateLob(lob);
                lob.getClass().getMethod("close", null).invoke(lob, (Object[])null);
                this.createdLobs.add(lob);
                if (OracleLobHandler.this.logger.isDebugEnabled()) {
                    OracleLobHandler.this.logger.debug("Created new Oracle " + (clob ? "CLOB" : "BLOB"));
                }
                return lob;
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (InvocationTargetException ex) {
                if (ex.getTargetException() instanceof SQLException) {
                    throw (SQLException)ex.getTargetException();
                }
                if (con != null && ex.getTargetException() instanceof ClassCastException) {
                    throw new InvalidDataAccessApiUsageException("OracleLobCreator needs to work on [oracle.jdbc.OracleConnection], not on [" + con.getClass().getName() + "]: specify a corresponding NativeJdbcExtractor", ex.getTargetException());
                }
                throw new DataAccessResourceFailureException("Could not create Oracle LOB", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not create Oracle LOB", ex);
            }
        }

        protected Connection getOracleConnection(PreparedStatement ps) throws SQLException, ClassNotFoundException {
            return OracleLobHandler.this.nativeJdbcExtractor != null ? OracleLobHandler.this.nativeJdbcExtractor.getNativeConnectionFromStatement(ps) : ps.getConnection();
        }

        protected Object prepareLob(Connection con, Class lobClass) throws Exception {
            Method createTemporary = lobClass.getMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = OracleLobHandler.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            Object lob = createTemporary.invoke(null, con, OracleLobHandler.this.cache, OracleLobHandler.this.durationSessionConstants.get(lobClass));
            Method open = lobClass.getMethod("open", Integer.TYPE);
            open.invoke(lob, OracleLobHandler.this.modeReadWriteConstants.get(lobClass));
            return lob;
        }

        public void close() {
            try {
                Iterator it = this.createdLobs.iterator();
                while (it.hasNext()) {
                    Object lob = it.next();
                    Method freeTemporary = lob.getClass().getMethod("freeTemporary", new Class[0]);
                    freeTemporary.invoke(lob, new Object[0]);
                    it.remove();
                }
            }
            catch (InvocationTargetException ex) {
                OracleLobHandler.this.logger.error("Could not free Oracle LOB", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new DataAccessResourceFailureException("Could not free Oracle LOB", ex);
            }
        }
    }
}

