/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.client;

import com.bmc.arsys.ws.client.PWCallback;
import com.bmc.arsys.ws.client.PolicyDetails;
import com.bmc.arsys.ws.client.WsPluginReceiver;
import com.bmc.arsys.ws.client.WsPluginSender;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axis.Handler;
import org.apache.axis.client.Call;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Element;

class WSPolicyProcessor {
    public static final String SECURITY_ACTION_SIGN_ENCRYPT = "Signature Encrypt";

    WSPolicyProcessor() {
    }

    public static void processPolicy(PolicyDetails policyDetails, Call call, String string) throws IOException {
        policyDetails.setWebSvcNmSpace(string);
        Handler handler = WSPolicyProcessor.getRequestHandlers(policyDetails, call);
        Handler handler2 = WSPolicyProcessor.getResponseHandlers(policyDetails, call);
        call.setClientHandlers(handler, handler2);
    }

    private static Handler getRequestHandlers(PolicyDetails policyDetails, Call call) throws IOException {
        String string = "";
        String string2 = policyDetails.getRequestSecurityAction();
        if (string2 == null) {
            return null;
        }
        WsPluginSender wsPluginSender = new WsPluginSender(policyDetails);
        if (string2.indexOf("Timestamp") > -1) {
            string = "Timestamp";
        }
        if (string2.indexOf(SECURITY_ACTION_SIGN_ENCRYPT) > -1) {
            wsPluginSender.setOption("signatureKeyIdentifier", policyDetails.getSignKeyID());
            byte[] byArray = policyDetails.getPropBytes();
            String string3 = new String(byArray);
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            properties.load(byteArrayInputStream);
            wsPluginSender.setOption("SignaturePropRefId", properties);
            wsPluginSender.setOption("encryptionPropRefId", properties);
            wsPluginSender.setOption("user", policyDetails.getUserAlias());
            wsPluginSender.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(policyDetails, string2));
            wsPluginSender.setOption("encryptionKeyIdentifier", policyDetails.getEncKeyID());
            wsPluginSender.setOption("encryptionUser", policyDetails.getEncryptionUserAlias());
            String string4 = policyDetails.getEncSymAlg();
            if (string4 != null) {
                if (string4.equals("AES_192")) {
                    wsPluginSender.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#aes192-cbc");
                }
                if (string4.equals("AES_256")) {
                    wsPluginSender.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
                }
                if (string4.equals("Triple DES")) {
                    wsPluginSender.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
                }
            }
            if (policyDetails.isHeaderEncFlagSet()) {
                String string5 = null;
                if (string.indexOf("Timestamp") > -1) {
                    string5 = "{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;";
                }
                if (string5 != null) {
                    string5 = string5 + "{Content}{http://schemas.xmlsoap.org/soap/envelope/}Body";
                }
                if (string5 != null) {
                    wsPluginSender.setOption("signatureParts", string5);
                }
            }
            string = string.length() > 0 ? string + ' ' + SECURITY_ACTION_SIGN_ENCRYPT : SECURITY_ACTION_SIGN_ENCRYPT;
        } else if (string2.indexOf("Signature") > -1) {
            wsPluginSender.setOption("signatureKeyIdentifier", policyDetails.getSignKeyID());
            byte[] byArray = policyDetails.getPropBytes();
            String string6 = new String(byArray);
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            properties.load(byteArrayInputStream);
            wsPluginSender.setOption("SignaturePropRefId", properties);
            if (policyDetails.isHeaderEncFlagSet()) {
                String string7 = null;
                if (string.indexOf("Timestamp") > -1) {
                    string7 = "{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;";
                }
                if (string7 != null) {
                    string7 = string7 + "{Content}{http://schemas.xmlsoap.org/soap/envelope/}Body";
                }
                if (string7 != null) {
                    wsPluginSender.setOption("signatureParts", string7);
                }
            }
            string = string.length() > 0 ? string + ' ' + "Signature" : "Signature";
            wsPluginSender.setOption("user", policyDetails.getUserAlias());
            wsPluginSender.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(policyDetails, string2));
        } else if (string2.indexOf("Encrypt") > -1) {
            wsPluginSender.setOption("encryptionKeyIdentifier", policyDetails.getEncKeyID());
            byte[] byArray = policyDetails.getPropBytes();
            String string8 = new String(byArray);
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            properties.load(byteArrayInputStream);
            wsPluginSender.setOption("encryptionPropRefId", properties);
            string = string.length() > 0 ? string + ' ' + "Encrypt" : "Encrypt";
            wsPluginSender.setOption("encryptionUser", policyDetails.getEncryptionUserAlias());
            wsPluginSender.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(policyDetails, string2));
            String string9 = policyDetails.getEncSymAlg();
            if (string9 != null) {
                if (string9.equals("AES_192")) {
                    wsPluginSender.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#aes192-cbc");
                }
                if (string9.equals("AES_256")) {
                    wsPluginSender.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
                }
                if (string9.equals("Triple DES")) {
                    wsPluginSender.setOption("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
                }
            }
            if (policyDetails.isHeaderEncFlagSet()) {
                wsPluginSender.setOption("encryptionParts", "{Element}{" + policyDetails.getWebSvcNmSpace() + "}AuthenticationInfo;{Content}{http://schemas.xmlsoap.org/soap/envelope/}Body");
            }
        } else {
            return null;
        }
        wsPluginSender.setOption("action", string);
        wsPluginSender.setOption("mustUnderstand", "false");
        return wsPluginSender;
    }

    private static Handler getResponseHandlers(PolicyDetails policyDetails, Call call) throws IOException {
        String string = "";
        String string2 = policyDetails.getResponseSecurityAction();
        if (string2 == null) {
            return null;
        }
        WsPluginReceiver wsPluginReceiver = new WsPluginReceiver(policyDetails);
        if (string2.indexOf("Timestamp") > -1) {
            string = string + "Timestamp";
        }
        if (string2.indexOf(SECURITY_ACTION_SIGN_ENCRYPT) > -1) {
            string = string.length() > 0 ? string + ' ' + SECURITY_ACTION_SIGN_ENCRYPT : SECURITY_ACTION_SIGN_ENCRYPT;
            byte[] byArray = policyDetails.getPropBytes();
            String string3 = new String(byArray);
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            properties.load(byteArrayInputStream);
            wsPluginReceiver.setOption("SignaturePropRefId", properties);
            wsPluginReceiver.setOption("decryptionPropRefId", properties);
            wsPluginReceiver.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(policyDetails, string2));
        } else if (string2.indexOf("Signature") > -1) {
            string = string.length() > 0 ? string + ' ' + "Signature" : "Signature";
            byte[] byArray = policyDetails.getPropBytes();
            String string4 = new String(byArray);
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            properties.load(byteArrayInputStream);
            wsPluginReceiver.setOption("SignaturePropRefId", properties);
            wsPluginReceiver.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(policyDetails, string2));
        } else if (string2.indexOf("Encrypt") > -1) {
            string = string.length() > 0 ? string + ' ' + "Encrypt" : "Encrypt";
            byte[] byArray = policyDetails.getPropBytes();
            String string5 = new String(byArray);
            Properties properties = new Properties();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            properties.load(byteArrayInputStream);
            wsPluginReceiver.setOption("decryptionPropRefId", properties);
            wsPluginReceiver.setOption("passwordCallbackRef", WSPolicyProcessor.getPasswordCB(policyDetails, string2));
        } else if (string.length() == 0) {
            return null;
        }
        wsPluginReceiver.setOption("action", string);
        wsPluginReceiver.setOption("mustUnderstand", "false");
        if (policyDetails.getSignConfirm()) {
            wsPluginReceiver.setOption("enableSignatureConfirmation", "false");
        } else {
            wsPluginReceiver.setOption("enableSignatureConfirmation", "true");
        }
        return wsPluginReceiver;
    }

    static CallbackHandler getPasswordCB(PolicyDetails policyDetails, String string) {
        String string2 = null;
        if (string.indexOf("Signature") > -1) {
            string2 = policyDetails.getUserAliasPassword();
        } else if (string.indexOf("Encrypt") > -1) {
            string2 = policyDetails.getEncryptionUserAliasPassword();
        }
        return new PWCallback(string2);
    }

    public static void dumpEnvelop(SOAPEnvelope sOAPEnvelope, PrintWriter printWriter) throws Exception {
        XMLUtils.PrettyElementToWriter((Element)sOAPEnvelope.getAsDOM(), (Writer)printWriter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        TIMESTAMP,
        SIGN,
        ENCRYPT,
        SIGN_ENCRYPT,
        NONE;

    }
}

