/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.binding;

import com.bmc.arsys.arthreadlocal.ARThreadLocalStorable;
import com.bmc.arsys.arthreadlocal.ARThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.ARPluginSvrThreadLocalStorageBlock;
import com.bmc.arsys.pluginsvr.legacy.PluginProxy;
import com.bmc.arsys.pluginsvr.plugins.ARPluginLoaderRouter;
import com.bmc.arsys.utils.CatalogReader;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARPluginSvrThreadPoolExecutor
extends ThreadPoolExecutor {
    private static Logger log = Logger.getLogger(ARPluginSvrThreadPoolExecutor.class);
    private static boolean readyForRpcCall;
    private static int prestartedThreadCount;
    private static int prestartInitializedCount;
    private static int skipCount;
    private final ReentrantLock lock = new ReentrantLock();

    public ARPluginSvrThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue) {
        super(n, n2, l, timeUnit, blockingQueue);
    }

    public ARPluginSvrThreadPoolExecutor(int n, int n2, long l, TimeUnit timeUnit, BlockingQueue<Runnable> blockingQueue, ThreadFactory threadFactory) {
        super(n, n2, l, timeUnit, blockingQueue, threadFactory);
    }

    @Override
    public int prestartAllCoreThreads() {
        prestartedThreadCount = super.prestartAllCoreThreads();
        String string = "Java plug-in server is initializing all plug-ins for " + prestartedThreadCount + " core threads. Please wait ...";
        if (log.isInfoEnabled()) {
            log.info((Object)string);
        } else {
            log.warn((Object)("INFO: " + string));
        }
        System.out.println(string);
        int n = 0;
        while (n < prestartedThreadCount + skipCount && !readyForRpcCall) {
            this.execute(new Runnable(){

                public void run() {
                }
            });
            if (++n < prestartedThreadCount) continue;
            this.checkSkipCountThread(n);
        }
        return prestartedThreadCount;
    }

    private void checkSkipCountThread(int n) {
        if (n >= prestartedThreadCount + skipCount || n % prestartedThreadCount == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (skipCount > 0 && n > prestartedThreadCount * 3 && !readyForRpcCall && n % prestartedThreadCount == 0) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            log.warn((Object)("ThreadPoolExecutor initialized " + prestartInitializedCount + " threads to receive RPC calls." + " SkipCount : " + skipCount));
        }
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        boolean bl = ARPluginSvrThreadLocalStorageBlock.isTLBExist();
        if (!bl) {
            log.info((Object)("Will iniPlugins for thread: " + thread.getId() + " " + thread));
            this.iniPlugins(thread);
        } else if (!readyForRpcCall) {
            ++skipCount;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Same thread: " + thread.getId() + " " + thread);
            ARPluginLoaderRouter aRPluginLoaderRouter = ARPluginLoaderRouter.getPluginRouter(thread);
            if (aRPluginLoaderRouter != null) {
                stringBuilder.append(" already instantiated.");
            } else {
                stringBuilder.append(" skipped");
            }
            log.info((Object)stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected boolean iniPlugins(Thread thread) {
        boolean bl = true;
        try {
            Object object;
            try {
                object = new ARPluginSvrThreadLocalStorageBlock();
                ((ARPluginSvrThreadLocalStorageBlock)((Object)object)).init(thread);
                ARThreadLocalStorageBlock.registerTLB((ARThreadLocalStorable)object);
                log.info((Object)("Done iniPlugins for thread: " + thread.getId()));
            }
            catch (Throwable throwable) {
                bl = false;
                log.error((Object)CatalogReader.getInstance().getMessage(8790), throwable);
            }
            try {
                object = PluginProxy.getInstance();
                if (object != null) {
                    ((PluginProxy)object).createInstancesForThread();
                }
            }
            catch (Throwable throwable) {
                log.error((Object)"Native plugin createInstancesForThread() failed.");
                log.error((Object)CatalogReader.getInstance().getMessage(8790), throwable);
            }
            Object var5_6 = null;
            if (readyForRpcCall) return bl;
            this.lock.lock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (readyForRpcCall) throw throwable;
            this.lock.lock();
            try {}
            catch (Throwable throwable2) {
                Object var10_19 = null;
                this.lock.unlock();
                throw throwable2;
            }
            if (!readyForRpcCall && prestartedThreadCount == ++prestartInitializedCount) {
                try {}
                catch (Throwable throwable3) {
                    Object var8_13 = null;
                    readyForRpcCall = true;
                    throw throwable3;
                }
                if (skipCount > 0) {
                    log.info((Object)("Skipped empty runnable: " + skipCount));
                }
                String string = "Java plug-in server has initialized plug-ins for all " + prestartedThreadCount + " core threads. The server is ready to receive RPC calls.";
                if (log.isInfoEnabled()) {
                    log.info((Object)string);
                } else {
                    log.warn((Object)("INFO: " + string));
                }
                System.out.println(string);
                Object var8_12 = null;
                readyForRpcCall = true;
            }
            Object var10_18 = null;
            this.lock.unlock();
            throw throwable;
        }
        try {
            if (!readyForRpcCall && prestartedThreadCount == ++prestartInitializedCount) {
                try {
                    if (skipCount > 0) {
                        log.info((Object)("Skipped empty runnable: " + skipCount));
                    }
                    String string = "Java plug-in server has initialized plug-ins for all " + prestartedThreadCount + " core threads. The server is ready to receive RPC calls.";
                    if (log.isInfoEnabled()) {
                        log.info((Object)string);
                    } else {
                        log.warn((Object)("INFO: " + string));
                    }
                    System.out.println(string);
                    Object var8_10 = null;
                    readyForRpcCall = true;
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    readyForRpcCall = true;
                    throw throwable;
                }
            }
            Object var10_16 = null;
            this.lock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public boolean isReadyForRpcCall() {
        return readyForRpcCall;
    }

    @Override
    public void shutdown() {
        this.cleanUp();
        super.shutdown();
    }

    protected void cleanUp() {
        Set<Thread> set = ARPluginLoaderRouter.getAllThreads();
        for (Thread object : set) {
            if (!object.isAlive()) continue;
            try {
                ARPluginLoaderRouter throwable = ARPluginLoaderRouter.getPluginRouter(object);
                if (throwable == null) continue;
                throwable.cleanUpPlugins();
            }
            catch (Throwable throwable) {
                log.debug((Object)("Clean up plugins for thread " + object.getId()));
                log.error((Object)CatalogReader.getInstance().getMessage(8794), throwable);
            }
        }
        set.clear();
        log.info((Object)"Worker thread executor cleaned up routers and plugins.");
        try {
            if (PluginProxy.IsNativeMethodAccessible()) {
                log.info((Object)"clean up native plugins");
                PluginProxy throwable = PluginProxy.getInstance();
                if (throwable != null) {
                    throwable.deleteInstancesForThread();
                }
            }
        }
        catch (Throwable throwable) {
            log.error((Object)CatalogReader.getInstance().getMessage(8790), throwable);
        }
    }

    static {
        prestartInitializedCount = 0;
        skipCount = 0;
    }
}

