/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsplugin;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.SignalType;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.fts.FTSService;
import com.bmc.arsys.fts.FTSServiceException;
import com.bmc.arsys.fts.impl.DocHandler.DocumentHandlerException;
import com.bmc.arsys.fts.impl.DocHandler.TikaDocHandler;
import com.bmc.arsys.fts.impl.FTSConfiguration;
import com.bmc.arsys.fts.impl.lucene.LuceneFTSService;
import com.bmc.arsys.pluginsvr.plugins.ARFilterAPIPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSPlugin
extends ARFilterAPIPlugin {
    private static FTSService m_service = null;
    private static TikaDocHandler m_docHandler = new TikaDocHandler();
    private static final Logger LOGGER = Logger.getLogger(FTSPlugin.class);
    private ARPluginInfo pluginInfo = new ARPluginInfo("ARSYS.ARF.FTS", this);
    private static final int AR_DEFAULT_FT_OPTIMIZE_THRESHOLD = 1000;
    private static final int AR_MIN_FT_OPTIMIZE_THRESHOLD = 10;
    private static final String strSeeLogMsg = new String("-See logfile for details.");
    private static int deletePolicyTime = 120;
    private static String getIndexSearcherRetry = "1:0";
    private static Map<Integer, Set<Integer>> currentlyBeingReindexed = null;
    private static boolean isSecondaryPlugin = false;

    public static void init(ARPluginContext aRPluginContext) throws ARException {
        LOGGER.info((Object)"FTSPlugin initialize()");
        m_service = LuceneFTSService.getLuceneFTSService();
        if (aRPluginContext != null) {
            String string;
            String string2 = aRPluginContext.getConfigItem("ftCollectionDir");
            String string3 = aRPluginContext.getConfigItem("ftConfigDir");
            String string4 = aRPluginContext.getConfigItem("ftCaseSensitivity");
            int n = 0;
            if ("false".equals(string4)) {
                n = 1;
            }
            String string5 = aRPluginContext.getConfigItem("ftStopFile");
            String string6 = aRPluginContext.getConfigItem("ftOptimizeThreshold");
            int n2 = 1000;
            if (string6 != null) {
                n2 = new Integer(string6);
            }
            if (n2 < 10) {
                n2 = 10;
            }
            String string7 = aRPluginContext.getConfigItem("ftLangCode");
            int n3 = 1000000;
            String string8 = aRPluginContext.getConfigItem("ftSearchThreshold");
            try {
                if (string8 != null) {
                    n3 = new Integer(string8);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string9 = aRPluginContext.getConfigItem("ftDeletePolicyTime");
            if (string9 != null) {
                deletePolicyTime = new Integer(string9);
            }
            if ((string = aRPluginContext.getConfigItem("ftGetIndexSearcherRetry")) != null) {
                getIndexSearcherRetry = string;
            }
            FTSPlugin.initializeSearchService(string2, string3, n, n2, string7, n3, deletePolicyTime, getIndexSearcherRetry, false);
        }
    }

    @Override
    public void terminate(ARPluginContext aRPluginContext) throws ARException {
        LOGGER.info((Object)"FTSPlugin terminate()");
        this.closeOperation();
    }

    @Override
    public List<Value> filterAPICall(ARPluginContext aRPluginContext, List<Value> list) throws ARException {
        if (m_service == null) {
            LOGGER.error((Object)"FTSPlugin filterAPICall: SearchService is invalid");
            throw new ARException(2, 657, "filterAPICall: SearchService is invalid");
        }
        if (list == null || list.size() == 0) {
            LOGGER.error((Object)"FTSPlugin filterAPICall: No input values supplied");
            throw new ARException(2, 862, "filterAPICall: No input values supplied");
        }
        Value value = list.get(0);
        if (value.getDataType() != DataType.INTEGER) {
            LOGGER.error((Object)"FTSPlugin filterAPICall: OP Code needs to be an integer value between 0-5");
            throw new ARException(2, 663);
        }
        int n = (Integer)value.getValue();
        LOGGER.info((Object)("FTSPlugin filterAPICall: OP Code = " + n));
        switch (n) {
            case 0: {
                this.initOperation(aRPluginContext, list);
                break;
            }
            case 1: {
                this.createUpdateOperation(n, list);
                break;
            }
            case 2: {
                this.createUpdateOperation(n, list);
                break;
            }
            case 3: {
                this.deleteOperation(list);
                break;
            }
            case 4: {
                return this.getOperation(list);
            }
            case 5: {
                this.closeOperation();
                break;
            }
            case 6: {
                this.commitOperation();
                break;
            }
            case 7: {
                this.updateConfigOperation();
                break;
            }
            case 8: {
                return this.multiGetOperation(list);
            }
            case 9: {
                this.setDocBoost(list);
                break;
            }
            case 10: {
                this.syncReIndexingTasks(list);
                break;
            }
            default: {
                LOGGER.error((Object)("FTSPlugin filterAPICall: Invalid OP Code: " + n));
                throw new ARException(2, 864, new String("filterAPICall: Invalid OP Code: " + n));
            }
        }
        return null;
    }

    private synchronized void syncReIndexingTasks(List<Value> list) throws ARException {
        if (list.size() != 2) {
            LOGGER.error((Object)"FTSPlugin syncReindexingTasks: Not enough input values provided");
            throw new ARException(2, 862, "syncReindexingTasks");
        }
        String string = null;
        Value value = list.get(1);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string = value.toString();
        }
        if (string == null) {
            LOGGER.error((Object)"FTSPlugin syncReindexingTasks: invalid input values provided");
            throw new ARException(2, 442, "syncReindexingTasks");
        }
        if (currentlyBeingReindexed == null) {
            currentlyBeingReindexed = new HashMap<Integer, Set<Integer>>();
        } else {
            currentlyBeingReindexed.clear();
        }
        if (string != null) {
            this.parseReindexingTasks(string);
            LOGGER.info((Object)("Received sync from server with reindexing tasks " + string));
        } else {
            LOGGER.info((Object)"Received sync from server with no in-progress reindexing tasks ");
        }
    }

    private void parseReindexingTasks(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("#")) {
            String[] stringArray2 = string2.split(";");
            int n = 0;
            try {
                n = Integer.parseInt(stringArray2[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 1; i < stringArray2.length; ++i) {
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(stringArray2[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n2 == 0) continue;
                hashSet.add(n2);
            }
            if (n == 0) continue;
            currentlyBeingReindexed.put(n, hashSet);
        }
    }

    private void sendSignalToServer(ARPluginContext aRPluginContext) {
        int n;
        String string;
        block5: {
            string = aRPluginContext.getARConfigEntry("Server-Name");
            if (string == null) {
                LOGGER.error((Object)"AR Server configuration file does not have a server name");
                return;
            }
            String string2 = aRPluginContext.getARConfigEntry("TCD-Specific-Port");
            n = 0;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.error((Object)("Bad port number " + string2 + " in config file "));
            }
            try {
                ARServerUser aRServerUser = new ARServerUser("AR_SIGNAL", "", null, string, n);
                aRServerUser.login();
                aRServerUser.setTimeoutNormal(300);
                HashMap<SignalType, String> hashMap = new HashMap<SignalType, String>();
                hashMap.put(SignalType.FULL_TEXT_REINDEXING_SYNC, "REINDEXING TASK SYNC");
                aRServerUser.signalServer(hashMap);
            }
            catch (ARException aRException) {
                LOGGER.error((Object)("Error signaling " + string + " at port " + n));
                String string3 = aRException.getMessage();
                if (string3 == null) break block5;
                LOGGER.error((Object)("Signaling error " + string3));
            }
        }
        LOGGER.info((Object)("Signaled server " + string + " at port " + n + " for schema/fields currently being re-indexed"));
    }

    private synchronized void initOperation(ARPluginContext aRPluginContext, List<Value> list) throws ARException {
        if (list.size() < 7) {
            LOGGER.error((Object)"FTSPlugin initOperation: Not enough input values provided");
            throw new ARException(2, 862, "initOperation: Not enough input values provided");
        }
        String string = null;
        Value value = list.get(1);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string = value.toString();
        }
        if (string == null) {
            LOGGER.error((Object)"FTSPlugin initOperation: Collection Directory not provided");
            throw new ARException(2, 656, "initOperation: Collection Directory not provided");
        }
        String string2 = null;
        value = list.get(2);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string2 = value.toString();
        }
        if (string2 == null) {
            LOGGER.error((Object)"FTSPlugin initOperation: Configuration Directory not provided");
            throw new ARException(2, 656, "initOperation: Configuration Directory not provided");
        }
        int n = 1;
        value = list.get(3);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            n = (Integer)value.getValue();
        }
        String string3 = null;
        value = list.get(4);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string3 = value.toString();
        }
        if (string3 == null) {
            LOGGER.error((Object)"FTSPlugin initOperation: Configuration Directory not provided");
            throw new ARException(2, 656, "initOperation: FTS Stop word filename is not provided");
        }
        int n2 = 1000;
        value = list.get(5);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            n2 = (Integer)value.getValue();
        }
        if (n2 < 10) {
            n2 = 10;
        }
        String string4 = null;
        value = list.get(6);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string4 = value.toString();
        }
        int n3 = -1;
        int n4 = -1;
        if (list.size() >= 8) {
            value = list.get(7);
            if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
                n3 = value.getIntValue();
            }
            if (n3 < 0) {
                String string5 = "FTSPlugin initOperation: searchThreshold value is invalid and was ignored/not set.  Value recieved: " + n3 + "   Value must be and integer equal to or greather than (>=) '" + 0 + "'";
                LOGGER.warn((Object)string5);
            }
        } else {
            n4 = 1000000;
            if (aRPluginContext != null) {
                try {
                    n4 = new Integer(aRPluginContext.getConfigItem("ftSearchThreshold"));
                }
                catch (Exception exception) {
                    n4 = 1000000;
                    aRPluginContext.setConfigItem("ftSearchThreshold", new Integer(n4).toString());
                }
            }
        }
        boolean bl = true;
        if (list.size() >= 10 && (value = list.get(9)).getDataType() == DataType.INTEGER && value.getValue() != null && value.getIntValue() == 0) {
            bl = false;
        }
        if (!bl) {
            isSecondaryPlugin = true;
        }
        String string6 = null;
        if (isSecondaryPlugin) {
            value = list.get(8);
            if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
                string6 = value.toString();
            }
            if (string6 != null) {
                if (string6.equals("-1")) {
                    if (currentlyBeingReindexed == null) {
                        this.sendSignalToServer(aRPluginContext);
                    }
                } else {
                    if (currentlyBeingReindexed == null) {
                        currentlyBeingReindexed = Collections.synchronizedMap(new HashMap());
                    }
                    this.parseReindexingTasks(string6);
                }
            }
        }
        LOGGER.info((Object)("FTSPlugin initOperation: FTCollDir=" + string + " FTConfiguration=" + string2 + " FTCaseSensitivity=" + n + " FTStopWordFileName=" + string3 + " FTOptimizeThreshold=" + n2 + " FTLangCode=" + string4 + "FTSearchThreshold=" + n3 + " isIndexer=" + bl + "beingReindexed=" + string6));
        FTSPlugin.initializeSearchService(string, string2, n, n2, string4, n3 > -1 ? n3 : n4, deletePolicyTime, getIndexSearcherRetry, bl);
        if (aRPluginContext != null) {
            boolean bl2;
            aRPluginContext.setConfigItem("ftCollectionDir", string);
            aRPluginContext.setConfigItem("ftConfigDir", string2);
            boolean bl3 = bl2 = n == 0;
            if (bl2) {
                aRPluginContext.setConfigItem("ftCaseSensitivity", "true");
            } else {
                aRPluginContext.setConfigItem("ftCaseSensitivity", "false");
            }
            aRPluginContext.setConfigItem("ftStopFile", string3);
            aRPluginContext.setConfigItem("ftOptimizeThreshold", new Integer(n2).toString());
            aRPluginContext.setConfigItem("ftLangCode", string4);
            if (n3 > -1) {
                aRPluginContext.setConfigItem("ftSearchThreshold", new Integer(n3).toString());
            }
        }
    }

    private void createUpdateOperation(int n, List<Value> list) throws ARException {
        String[] stringArray = new String[3];
        String[] stringArray2 = new String[3];
        BitSet[] bitSetArray = new BitSet[3];
        float f = 1.0f;
        float[] fArray = new float[3];
        BitSet bitSet = new BitSet(2);
        bitSet.set(0);
        if (list.size() < 9) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: Not enough input values provided");
            throw new ARException(2, 862, "createUpdateOperation");
        }
        String string = null;
        Value value = list.get(1);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            string = ((Integer)value.getValue()).toString();
        }
        if (string == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: schemaId not provided");
            throw new ARException(2, 872, "schemaId not provided");
        }
        String string2 = null;
        value = list.get(2);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string2 = value.toString();
        }
        if (string2 == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: fieldId not provided");
            throw new ARException(2, 867, "fieldId not provided");
        }
        String string3 = null;
        value = list.get(3);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string3 = value.toString();
        }
        if (string3 == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: entryId not provided");
            throw new ARException(2, 656, "entryId not provided");
        }
        String string4 = null;
        value = list.get(4);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            string4 = ((Integer)value.getValue()).toString();
        }
        if (string4 == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: modifiedTime not provided");
            throw new ARException(2, 867, "modifiedTime not provided");
        }
        stringArray[0] = "modifiedTime";
        stringArray2[0] = string4;
        bitSetArray[0] = bitSet;
        String string5 = null;
        value = list.get(5);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            string5 = ((Integer)value.getValue()).toString();
        }
        if (string5 == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: createTime not provided");
            throw new ARException(2, 867, "createTime not provided");
        }
        stringArray[1] = "createTime";
        stringArray2[1] = string5;
        bitSetArray[1] = bitSet;
        value = list.get(6);
        String string6 = this.readFieldValue(value);
        if (string6 == null) {
            LOGGER.error((Object)"FTSPlugin createUpdateOperation: fieldValue not provided");
            throw new ARException(2, 867, "fieldValue not provided");
        }
        stringArray[2] = string2;
        stringArray2[2] = string6;
        int n2 = 1;
        value = list.get(7);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            n2 = (Integer)value.getValue();
        }
        BitSet bitSet2 = new BitSet(2);
        bitSet2.set(0, n2 == 1);
        bitSet2.set(1, n2 == 2);
        bitSetArray[2] = bitSet2;
        if (list.size() >= 10) {
            String string7;
            value = list.get(9);
            if (value.getDataType() == DataType.REAL && value.getValue() != null) {
                f = (float)value.getDoubleValue();
            }
            if (f < -2000.0f) {
                string7 = "FTSPlugin createUpdateOperation: docBoost value supplied is less than the minimum allowed value.  The minimum value will be used.  Supplied Value='" + f + "'  Minimum value='" + -2000.0f + "'";
                LOGGER.warn((Object)string7);
                f = -2000.0f;
            } else if (f > 2000.0f) {
                string7 = "FTSPlugin createUpdateOperation: docBoost value supplied exceeds the maximum value.  The maximum value will be used.  Supplied Value='" + f + "'  Maximum value='" + 2000.0f + "'";
                LOGGER.warn((Object)string7);
                f = 2000.0f;
            }
        }
        for (int i = 0; i < 3; ++i) {
            fArray[i] = 1.0f;
        }
        if (list.size() >= 11) {
            value = list.get(10);
            if (value.getDataType() == DataType.REAL && value.getValue() != null) {
                fArray[2] = (float)value.getDoubleValue();
            }
            if (fArray[2] < -2000.0f || fArray[2] > 2000.0f) {
                String string8 = "FTSPlugin createUpdateOperation: fieldBoost value is invalid as was ignored/not set.  -2000.0 <= fieldBoost <= 2000.0, 1.0=default/noBoost, value supplied=" + fArray[0];
                LOGGER.warn((Object)string8);
                fArray[2] = 1.0f;
            }
        }
        int n3 = 0;
        value = list.get(8);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            n3 = (Integer)value.getValue();
        }
        LOGGER.info((Object)("FTSPlugin createUpdateOperation: opCode=" + n + " schemaId=" + string + " entryId=" + string3 + " fieldId=" + string2 + " ftoption=" + n2 + " commitFlag=" + n3 + " fieldBoost=" + fArray[2] + " docBoost=" + f));
        if (n == 2) {
            this.deleteFieldFromDocument(string2, string, string3);
        }
        try {
            m_service.indexEntryFields(string, string3, f, stringArray, stringArray2, bitSetArray, fArray, n3);
        }
        catch (FTSServiceException fTSServiceException) {
            String string9 = "FTSPlugin::createUpdateOperation - Error " + (n == 2 ? "updating" : "creating") + " the document index.  Message from FTSService: " + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException) + " Plugin details: opCode=" + n + " schemaId=" + string + " entryId=" + string3 + " fieldId=" + string2 + " ftoption=" + n2 + " commitFlag=" + n3;
            LOGGER.error((Object)string9);
            String string10 = "FTSPlugin::createUpdateOperation - Document index failure while " + (n == 2 ? "updating" : "creating") + " the index entry.  " + fTSServiceException.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, string10);
        }
    }

    private void deleteOperation(List<Value> list) throws ARException {
        Object object;
        Value value;
        Object object2;
        Object object3;
        if (list.size() < 1 || list.size() > 5) {
            LOGGER.error((Object)"FTSPlugin deleteOperation: Not enough input values provided");
            throw new ARException(2, 862, "deleteOperation");
        }
        int n = 0;
        if (list.size() > 1 && (object3 = list.get(1)).getDataType() == DataType.INTEGER && object3.getValue() != null) {
            n = (Integer)object3.getValue();
        }
        object3 = null;
        if (list.size() > 2 && (object2 = list.get(2)).getDataType() == DataType.CHAR && object2.getValue() != null) {
            object3 = object2.toString();
        }
        object2 = null;
        if (list.size() > 3 && (value = list.get(3)).getDataType() == DataType.CHAR && value.getValue() != null) {
            object2 = value.toString();
        }
        int n2 = 1;
        if (list.size() > 4 && (object = list.get(4)).getDataType() == DataType.INTEGER && object.getValue() != null) {
            n2 = (Integer)object.getValue();
        }
        LOGGER.info((Object)("FTSPlugin deleteOperation:  schemaId=" + n + " entryId=" + (String)object2 + " fieldId=" + (String)object3 + " commitFlag=" + n2));
        try {
            if (n == 0) {
                m_service.deleteIndexDir();
            } else {
                object = Integer.valueOf(n).toString();
                if (object3 == null || ((String)object3).length() == 0) {
                    if (object2 == null || ((String)object2).length() == 0) {
                        m_service.deleteDocumentsContainingField("schemaId", (String)object);
                    } else {
                        m_service.deleteEntryDocument((String)object, (String)object2);
                    }
                } else {
                    this.deleteFieldFromDocument((String)object3, (String)object, (String)object2, n2);
                }
            }
        }
        catch (FTSServiceException fTSServiceException) {
            String string = "FTSPlugin::deleteOperation - Error while modifying and/or deleting the index item(s) for the document. schemaId=" + n + " entryId=" + (String)object2 + " fieldId=" + (String)object3 + "  Message from FTSService: " + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException);
            LOGGER.error((Object)string);
            String string2 = "FTSPlugin::deleteOperation - Index data modification/deletion error.  " + fTSServiceException.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Value> getOperation(List<Value> list) throws ARException {
        Object object;
        if (list.size() != 5) {
            LOGGER.error((Object)"FTSPlugin getOperation: Not enough input values provided");
            throw new ARException(2, 862, "getOperation");
        }
        int n = 0;
        Value value = list.get(1);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            n = (Integer)value.getValue();
        }
        if (n == 0) {
            LOGGER.error((Object)"FTSPlugin getOperation: schemaId not provided");
            throw new ARException(2, 872, "getOperation: schemaId not provided");
        }
        String string = null;
        value = list.get(2);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string = value.toString();
        }
        if (string == null || string.length() == 0) {
            LOGGER.error((Object)"FTSPlugin getOperation: fieldId not provided");
            throw new ARException(2, 867, "getOperation: fieldId not provided");
        }
        if (isSecondaryPlugin) {
            object = this;
            synchronized (object) {
                if (currentlyBeingReindexed == null) {
                    LOGGER.info((Object)"Search Service still waiting for list of schema being currently indexed, falling back to the best effort.");
                } else {
                    if (currentlyBeingReindexed.containsKey(-1234)) {
                        LOGGER.info((Object)"FTSPlugin getOperation: index collection is un-available for search pending reindexing operation");
                        throw new ARException(2, 879, "getOperation");
                    }
                    Set<Integer> set = currentlyBeingReindexed.get(n);
                    if (set != null) {
                        int n2 = 0;
                        try {
                            n2 = Integer.parseInt(string);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (set.contains(0) || set.isEmpty()) {
                            LOGGER.info((Object)("FTSPlugin getOperation: schema " + n + " is un-available for search pending reindexing operation"));
                            throw new ARException(2, 879, "getOperation");
                        }
                        if (set.contains(string)) {
                            LOGGER.info((Object)("FTSPlugin getOperation: schema " + n + "field  " + string + " is un-available for search pending reindexing operation"));
                            throw new ARException(2, 880, "getOperation");
                        }
                    }
                }
            }
        }
        object = null;
        value = list.get(3);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            object = value.toString();
        }
        if (object == null || ((String)object).length() == 0) {
            LOGGER.error((Object)"FTSPlugin getOperation: Search query not provided");
            throw new ARException(2, 872, "getOperation: Search query not provided");
        }
        int n3 = 1;
        value = list.get(4);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            n3 = (Integer)value.getValue();
        }
        BitSet[] bitSetArray = new BitSet[]{new BitSet(2)};
        bitSetArray[0].set(0, n3 == 1);
        bitSetArray[0].set(1, n3 == 2);
        LOGGER.info((Object)("FTSPlugin getOperation:  schemaId=" + n + " fieldId=" + string + " ftoption=" + n3));
        String[] stringArray = new String[]{string};
        String[] stringArray2 = new String[]{object};
        List<FTSService.EntryData> list2 = null;
        try {
            list2 = m_service.getEntryIdsByQuery(Integer.valueOf(n).toString(), stringArray, stringArray2, bitSetArray);
        }
        catch (FTSServiceException fTSServiceException) {
            String string2 = "FTSPlugin::getOperation - Error during index query.  SchemaId='" + n + " fieldId=" + string + " ftoption=" + n3 + "'. " + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException);
            LOGGER.error((Object)string2);
            String string3 = "FTSPlugin::getOperation - Error while querying the index.  " + fTSServiceException.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, string3);
        }
        return this.buildGetFTSResponse(list2);
    }

    private void closeOperation() throws ARException {
        LOGGER.info((Object)"FTSPlugin closeOperation");
        if (m_service != null) {
            try {
                m_service.close();
                m_service = null;
            }
            catch (FTSServiceException fTSServiceException) {
                String string = "FTSPlugin::closeOperation - Error closing the index.  Message from FTSService: " + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException);
                LOGGER.error((Object)string);
                String string2 = "FTSPlugin::closeOperation - Error while closing the index.  " + fTSServiceException.getLocalizedMessage() + strSeeLogMsg;
                throw new ARException(2, 875, string2);
            }
        }
    }

    private void commitOperation() throws ARException {
        LOGGER.info((Object)"FTSPlugin commitOperation");
        if (m_service != null) {
            try {
                m_service.commit();
            }
            catch (FTSServiceException fTSServiceException) {
                String string = "FTSPlugin::commitOperation - Error while committing data inserted into the index.  Message from FTSService: " + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException);
                LOGGER.error((Object)string);
                String string2 = "FTSPlugin::commitOperation - Error performing index commit.  " + fTSServiceException.getLocalizedMessage();
                throw new ARException(2, 875, string2);
            }
        }
    }

    private synchronized void updateConfigOperation() throws ARException {
        LOGGER.info((Object)"FTSPlugin updateConfigOperation");
        if (m_service != null) {
            try {
                m_service.updateConfiguration();
            }
            catch (FTSServiceException fTSServiceException) {
                String string = "FTSPlugin::updateConfigOperation - Error updating the configuration for FTS.  Message from FTSService: " + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException);
                LOGGER.error((Object)string);
                String string2 = "FTSPlugin::updateConfigOperation - Error updating FTS config.  " + fTSServiceException.getLocalizedMessage() + strSeeLogMsg;
                throw new ARException(2, 875, string2);
            }
        }
    }

    private List<Value> buildGetFTSResponse(List<FTSService.EntryData> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        ArrayList<Value> arrayList = new ArrayList<Value>(list.size() * 2);
        for (FTSService.EntryData entryData : list) {
            arrayList.add(new Value(entryData.entryId));
            arrayList.add(new Value((double)entryData.score));
        }
        return arrayList;
    }

    private List<Value> buildMultiGetFTSResponse(FTSService.FTSResultSet fTSResultSet) {
        if (fTSResultSet == null) {
            return null;
        }
        ArrayList<FTSService.EntryData> arrayList = fTSResultSet.resultList;
        String string = new String(new Character('\u0001').toString());
        ArrayList<Value> arrayList2 = new ArrayList<Value>(arrayList.size());
        StringBuffer stringBuffer = new StringBuffer();
        arrayList2.add(new Value(fTSResultSet.numMatches));
        if (arrayList != null && arrayList.size() > 0) {
            for (FTSService.EntryData entryData : arrayList) {
                boolean bl = entryData instanceof FTSService.GlobalEntryData;
                String string2 = bl ? ((FTSService.GlobalEntryData)entryData).createDate : "";
                String string3 = bl ? ((FTSService.GlobalEntryData)entryData).modifiedDate : "";
                String string4 = bl ? ((FTSService.GlobalEntryData)entryData).title : "";
                String string5 = bl ? ((FTSService.GlobalEntryData)entryData).excerpt : "";
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(entryData.schemaId).append(";");
                stringBuffer.append(entryData.entryId).append(";");
                stringBuffer.append(entryData.score).append(";");
                stringBuffer.append(string2).append(";");
                stringBuffer.append(string3).append(";");
                stringBuffer.append(string + string4 + string).append(";");
                stringBuffer.append(string + string5 + string).append(";");
                StringBuffer stringBuffer2 = new StringBuffer();
                if (bl && ((FTSService.GlobalEntryData)entryData).returnFilterFields != null) {
                    stringBuffer2.append(((FTSService.GlobalEntryData)entryData).returnFilterFields.size()).append(";");
                    for (FTSService.ReturnFilterFields returnFilterFields : ((FTSService.GlobalEntryData)entryData).returnFilterFields) {
                        stringBuffer2.append(string).append(returnFilterFields.filterField).append(string).append(";").append(string).append(returnFilterFields.value != null ? returnFilterFields.value : "").append(string).append(";");
                    }
                } else {
                    stringBuffer2.append("0").append(";");
                }
                stringBuffer.append(stringBuffer2);
                arrayList2.add(new Value(stringBuffer.toString()));
            }
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFieldValue(Value value) throws ARException {
        Object object;
        block20: {
            object = null;
            try {
                if (value == null || value.getValue() == null) break block20;
                InputStream inputStream = null;
                DataType dataType = value.getDataType();
                if (dataType == DataType.CHAR) {
                    object = value.toString();
                    break block20;
                }
                if (dataType == DataType.ATTACHMENT) {
                    Object object2;
                    AttachmentValue attachmentValue = (AttachmentValue)value.getValue();
                    if (attachmentValue.getLocationType() == 1) {
                        object2 = new File(attachmentValue.getValueFileName());
                        if (object2 == null) {
                            LOGGER.error((Object)"FTSPlugin readFieldValue: attachment fieldValue has bad location type");
                            throw new ARException(2, 658, "attachment filename is null");
                        }
                        try {
                            inputStream = new FileInputStream((File)object2);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new ARException(2, 658, "attachment file not found: " + ((File)object2).getAbsolutePath());
                        }
                    } else if (attachmentValue.getLocationType() == 2) {
                        inputStream = new ByteArrayInputStream(attachmentValue.getContent());
                    } else {
                        LOGGER.error((Object)"FTSPlugin readFieldValue: attachment fieldValue has bad location type");
                        throw new ARException(2, 658, "attachment fieldValue");
                    }
                    object = m_docHandler.getText(inputStream);
                    if (object != null) {
                        object2 = " " + this.cleanAttachMetadata(attachmentValue.getName()) + " " + this.cleanAttachMetadata(attachmentValue.getValueFileName());
                        if (((String)object).trim().length() == 0) {
                            LOGGER.warn((Object)"FTSPlugin readFieldValue: No indexable data was extracted from the document.  This may be normal if the document is binary in nature, or it may indicate that the document is either an unsupported type or corrupt.");
                            object = object2;
                        } else {
                            object = (String)object + (String)object2;
                        }
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block20;
                    }
                    catch (IOException iOException) {
                        break block20;
                    }
                    finally {
                        inputStream = null;
                    }
                }
                LOGGER.error((Object)("FTSPlugin readFieldValue: Unsupported field value data type. Received datatype = " + dataType));
                throw new ARException(2, 663, "Unsupported field value data type. Received datatype = " + dataType);
            }
            catch (DocumentHandlerException documentHandlerException) {
                LOGGER.error((Object)documentHandlerException.getStackTrace());
                throw new ARException(2, 658, "attachment fieldValue" + documentHandlerException.getMessage());
            }
        }
        return object;
    }

    public String cleanAttachMetadata(String string) {
        String string2 = "";
        if (string != null) {
            string2 = new File(string).getName();
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream readAttachFieldContent(Value value) throws ARException {
        void var2_6;
        Object var2_2 = null;
        if (value == null) return var2_6;
        if (value.getValue() == null) return var2_6;
        DataType dataType = value.getDataType();
        if (dataType != DataType.ATTACHMENT) {
            LOGGER.error((Object)("FTSPlugin readAttachFieldContent: Unsupported field value data type. Received datatype = " + dataType));
            throw new ARException(2, 663, "Unsupported field value data type. Received datatype = " + dataType);
        }
        AttachmentValue attachmentValue = (AttachmentValue)value.getValue();
        if (attachmentValue.getLocationType() == 1) {
            File file = new File(attachmentValue.getValueFileName());
            if (file == null) {
                LOGGER.error((Object)"FTSPlugin readAttachFieldContent: attachment fieldValue has bad location type");
                throw new ARException(2, 658, "attachment filename is null");
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                return var2_6;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ARException(2, 658, "attachment file not found: " + file.getAbsolutePath());
            }
        }
        if (attachmentValue.getLocationType() == 2) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(attachmentValue.getContent());
            return var2_6;
        }
        LOGGER.error((Object)"FTSPlugin readAttachFieldContent: attachment fieldValue has bad location type");
        throw new ARException(2, 658, "attachment fieldValue");
    }

    private void deleteFieldFromDocument(String string, String string2, String string3, int n) throws ARException {
        String[] stringArray = new String[2];
        stringArray[0] = "schemaId";
        stringArray[1] = null;
        String[] stringArray2 = stringArray;
        String[] stringArray3 = new String[]{string2, null};
        if (string3 != null && string3.length() != 0) {
            stringArray2[1] = "entryId";
            stringArray3[1] = string3;
        }
        try {
            m_service.removeFieldFromDocumentsByQuery(string, stringArray2, stringArray3, n);
        }
        catch (FTSServiceException fTSServiceException) {
            String string4 = "FTSPlugin::deleteFieldFromDocument - Error while deleting a field from the documents index entry.  Message from FTSService: " + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException);
            LOGGER.error((Object)string4);
            String string5 = "FTSPlugin::deleteFieldFromDocument - Error modifying index entry.  " + fTSServiceException.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, string5);
        }
    }

    private void deleteFieldFromDocument(String string, String string2, String string3) throws ARException {
        String[] stringArray = new String[2];
        stringArray[0] = "schemaId";
        stringArray[1] = null;
        String[] stringArray2 = stringArray;
        String[] stringArray3 = new String[]{string2, null};
        if (string3 != null && string3.length() != 0) {
            stringArray2[1] = "entryId";
            stringArray3[1] = string3;
        }
        try {
            m_service.removeFieldFromDocumentsByQuery(string, stringArray2, stringArray3);
        }
        catch (FTSServiceException fTSServiceException) {
            String string4 = "FTSPlugin::deleteFieldFromDocument - Error while deleting a field from the documents index entry.  Message from FTSService: " + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException);
            LOGGER.error((Object)string4);
            String string5 = "FTSPlugin::deleteFieldFromDocument - Error deleting index data.  " + fTSServiceException.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, string5);
        }
    }

    private static void initializeSearchService(String string, String string2, int n, int n2, String string3, int n3, int n4, String string4, boolean bl) throws ARException {
        FTSConfiguration fTSConfiguration = new FTSConfiguration();
        fTSConfiguration.setFullTextCollectionDir(string);
        if (!FTSPlugin.getDirectoryExists(string)) {
            LOGGER.error((Object)("FTS: The specified FTS Collection directory could not be found during Initialization.  It may be inaccessible or non-existent. path='" + string + "'"));
        }
        fTSConfiguration.setFullTextConfigurationDir(string2);
        if (!FTSPlugin.getDirectoryExists(string2)) {
            LOGGER.error((Object)("FTS: The specified FTS Configuration directory could not be found during Initialization.  It may be inaccessible or non-existent. path='" + string2 + "'"));
        }
        fTSConfiguration.setFullTextCaseInSensitive(n == 0);
        fTSConfiguration.setFullTextOptimizeThreshold(n2);
        fTSConfiguration.setFullTextLocale(string3);
        fTSConfiguration.setSearchThreshold(n3);
        fTSConfiguration.setDeletePolicyTime(n4);
        fTSConfiguration.setGetIndexSearcherRetry(string4);
        try {
            m_service.init(fTSConfiguration, bl);
        }
        catch (FTSServiceException fTSServiceException) {
            String string5 = "FTSPlugin::initializeSearchService - Error initializing the FTSService:" + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException);
            LOGGER.error((Object)string5);
            String string6 = string5;
            throw new ARException(2, 875, string6);
        }
    }

    private static boolean getDirectoryExists(String string) {
        File file = null;
        boolean bl = false;
        if (string != null && string.length() > 0) {
            file = new File(string);
            bl = file.exists();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private List<Value> multiGetOperation(List<Value> list) throws ARException {
        void var14_19;
        Object object2;
        if (list.size() < 13) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Not enough input values provided");
            throw new ARException(2, 862, "multiGetOperation");
        }
        if (isSecondaryPlugin) {
            object2 = this;
            synchronized (object2) {
                if (currentlyBeingReindexed == null) {
                    LOGGER.info((Object)"Search Service still waiting for list of schema being currently indexed, falling back to the best effort.");
                } else if (currentlyBeingReindexed.containsKey(-1234)) {
                    LOGGER.info((Object)"FTSPlugin getOperation: index collection is un-available for search pending reindexing operation");
                    throw new ARException(2, 879, "multiGetOperation");
                }
            }
        }
        object2 = new ArrayList();
        this.populateQuerySchemas(list, (ArrayList<FTSService.QuerySchemas>)object2);
        String string = null;
        Value value = list.get(4);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null && value.toString().length() != 0) {
            string = value.toString();
        }
        String string2 = null;
        value = list.get(5);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null && value.toString().length() != 0) {
            string2 = value.toString();
        }
        String string3 = null;
        value = list.get(6);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null && value.toString().length() != 0) {
            string3 = value.toString();
        }
        if (string == null && string2 == null && string3 == null) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Search query not provided");
            throw new ARException(2, 872, "multiGetOperation: Search query not provided");
        }
        String string4 = null;
        value = list.get(7);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null && value.toString().length() != 0) {
            string4 = value.toString();
        }
        int n = 0;
        value = list.get(8);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            n = (Integer)value.getValue();
        }
        String string5 = null;
        value = list.get(9);
        if (value.getDataType() == DataType.CHAR && (string5 = value.toString()) != null && string5.trim().length() == 0) {
            string5 = null;
        }
        ArrayList<FTSService.ReturnFilterFields> arrayList = null;
        String string6 = null;
        String string7 = "  No returnFields information/names provided.";
        value = list.get(10);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null && value.toString().length() != 0) {
            string6 = value.toString();
        }
        arrayList = new ArrayList<FTSService.ReturnFilterFields>();
        this.populateFilterFields(string6, arrayList);
        if (arrayList.size() > 0) {
            string7 = "  Requested Filter Fields: ";
            for (FTSService.ReturnFilterFields object3 : arrayList) {
                string7 = string7 + " '" + object3.filterField + "' ";
            }
        }
        int n2 = 0;
        value = list.get(11);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            n2 = (Integer)value.getValue();
        }
        Object var14_17 = null;
        value = list.get(12);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null && value.toString().length() != 0) {
            String string8 = value.toString();
        }
        LOGGER.info((Object)("FTSPlugin multiGetOperation: mustQuery=" + string + " shouldQuery=" + string2 + " notQuery=" + string3 + " filterQuery=" + string4 + " excerptOption=" + n + " sortOrder='" + string5 + "resultMax='" + n2 + "returnEntries='" + (String)var14_19 + "'  msg=" + string7));
        FTSService.FTSResultSet fTSResultSet = null;
        try {
            fTSResultSet = m_service.getEntryIdsByGlobalQuery(string2, string, string3, (ArrayList<FTSService.QuerySchemas>)object2, string4, arrayList, string5, n, (String)var14_19, n2);
        }
        catch (FTSServiceException fTSServiceException) {
            String string9 = "FTSPlugin::multiGetOperation - Error during multi-get operation for FTS.  mustQuery='" + string + "' shouldQuery='" + string2 + "' notQuery='" + string3 + "' filterQuery='" + string4 + "' excerptOption='" + n + "' sortOrder='" + string5 + "' resultMax='" + n2 + "' returnEntries='" + (String)var14_19 + "' filterFields=" + string7 + "'  Message from FTSService: " + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException);
            LOGGER.error((Object)string9);
            String string10 = "FTSPlugin::multiGetOperation - " + fTSServiceException.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, string10);
        }
        return this.buildMultiGetFTSResponse(fTSResultSet);
    }

    void populateFilterFields(String string, ArrayList<FTSService.ReturnFilterFields> arrayList) {
        if (arrayList != null && string != null && string.length() > 0) {
            String[] stringArray;
            arrayList.clear();
            for (String string2 : stringArray = string.split(";")) {
                arrayList.add(new FTSService.ReturnFilterFields(string2));
            }
        } else {
            LOGGER.info((Object)"FTSPlugin multiGetOperation->populateFilterFields: The returnFields value is invalid.");
        }
    }

    void populateQuerySchemas(List<Value> list, ArrayList<FTSService.QuerySchemas> arrayList) throws ARException {
        String string = null;
        Value value = list.get(1);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string = (String)value.getValue();
        }
        if (string == null) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Schema List not provided");
            throw new ARException(2, 872, "multiGetOperation: Schema List is not provided");
        }
        String string2 = null;
        value = list.get(2);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string2 = (String)value.getValue();
        }
        if (string2 == null) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Field Lists for schemas not provided");
            throw new ARException(2, 867, "multiGetOperation: Field Lists for schemas not provided");
        }
        String string3 = null;
        value = list.get(3);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string3 = (String)value.getValue();
        }
        if (string3 == null) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: FT option list for fields not provided");
            throw new ARException(2, 867, "multiGetOperation: FT option list for fields not provided");
        }
        String[] stringArray = string.split(";");
        String[] stringArray2 = string2.split("#");
        String[] stringArray3 = string3.split("#");
        if (stringArray2.length != stringArray.length) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: Field Lists for schemas not provided in correct format");
            throw new ARException(2, 867, "multiGetOperation: Field Lists for schemas not provided in correct format");
        }
        if (stringArray3.length != stringArray.length) {
            LOGGER.error((Object)"FTSPlugin multiGetOperation: FT Option Lists for schemas not provided in correct format");
            throw new ARException(2, 867, "multiGetOperation: FT Option Lists for schemas not provided in correct format");
        }
        this.populateQuerySchemasList(arrayList, stringArray, stringArray2, stringArray3);
    }

    private void populateQuerySchemasList(ArrayList<FTSService.QuerySchemas> arrayList, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        for (int i = 0; i < stringArray.length; ++i) {
            FTSService.QuerySchemas querySchemas = new FTSService.QuerySchemas();
            querySchemas.schemaId = new String(stringArray[i]);
            querySchemas.queryFieldNames = new ArrayList();
            querySchemas.fullTextOptions = new ArrayList();
            String string = stringArray2[i];
            String[] stringArray4 = string.split(";");
            for (int j = 0; j < stringArray4.length; ++j) {
                querySchemas.queryFieldNames.add(stringArray4[j]);
            }
            String string2 = stringArray3[i];
            String[] stringArray5 = string2.split(";");
            for (int j = 0; j < stringArray5.length; ++j) {
                int n = new Integer(stringArray5[j]);
                BitSet[] bitSetArray = new BitSet[]{new BitSet(2)};
                bitSetArray[0].set(0, n == 1);
                bitSetArray[0].set(1, n == 2);
                querySchemas.fullTextOptions.add(bitSetArray[0]);
            }
            arrayList.add(querySchemas);
        }
    }

    public void setDocBoost(List<Value> list) throws ARException {
        String string = null;
        float f = 1.0f;
        if (m_service == null) {
            String string2 = "FTSPlugin setDocBoost: SearchService is invalid";
            LOGGER.error((Object)string2);
            throw new ARException(2, 657, string2);
        }
        if (list.size() != 4) {
            LOGGER.error((Object)"FTSPlugin setDocBoost: Not enough input values provided.  The operation could not be completed");
            throw new ARException(2, 862, "setDocBoost");
        }
        String string3 = null;
        Value value = list.get(1);
        if (value.getDataType() == DataType.INTEGER && value.getValue() != null) {
            string3 = ((Integer)value.getValue()).toString();
        }
        if (string3 == null || string3.length() == 0) {
            string = "setDocBoost: SchemaID was not provided and is required for this operation.";
            LOGGER.error((Object)"FTSPlugin setDocBoost: SchemaID was not provided");
            throw new ARException(2, 872, string);
        }
        String string4 = null;
        value = list.get(2);
        if (value.getDataType() == DataType.CHAR && value.getValue() != null) {
            string4 = (String)value.getValue();
        }
        if (string4 == null || string4.length() == 0) {
            LOGGER.info((Object)"FTSPlugin setDocBoost: EntryID was not provided, it is a bulk operation");
        }
        if ((value = list.get(3)).getDataType() == DataType.REAL && value.getValue() != null) {
            f = (float)value.getDoubleValue();
        } else if (value.getDataType() != DataType.REAL) {
            LOGGER.warn((Object)"FTSPlugin setDocBoost: The value for docBoost provided was not of type REAL (class DataType)");
        } else {
            LOGGER.warn((Object)("FTSPlugin setDocBoost: The document boost value (docBoost) is null.  The default of 1 will be used. SchemaID=" + string3 + "  EntryID=" + string4));
        }
        LOGGER.info((Object)("FTSPlugin setDocBoost: schemaId=" + string3 + " entryId=" + string4 + " docBoost=" + f));
        if (f < -2000.0f) {
            f = -2000.0f;
        } else if (f > 2000.0f) {
            f = 2000.0f;
        }
        try {
            m_service.setDocBoost(string3, string4, f);
        }
        catch (FTSServiceException fTSServiceException) {
            String string5 = "FTSPlugin::setDocBoost - Error setting the boost value for the document. SchemaId='" + string3 + "'  EntryId='" + string4 + "'  Document boost value='" + f + ".  Message from FTSService: " + fTSServiceException.getLocalizedMessage() + FTSPlugin.getFTSSEPassedExceptionInfo(fTSServiceException);
            LOGGER.error((Object)string5);
            String string6 = "FTSPlugin::setDocBoost - Error setting document index boost value.  " + fTSServiceException.getLocalizedMessage() + strSeeLogMsg;
            throw new ARException(2, 875, string6);
        }
    }

    private static String getFTSSEPassedExceptionInfo(FTSServiceException fTSServiceException) {
        String string = "";
        if (fTSServiceException.getCause() != null) {
            string = " Root Exception: " + fTSServiceException.getCause().getLocalizedMessage();
        }
        return string;
    }
}

