/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfFileHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfigPluginConstants;
import com.bmc.arsys.plugins.ftsconfig.helper.RegexFileLineFilter;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.AbstractEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.PropertiesConfigurationFile;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.PropertyEntry;
import com.bmc.arsys.plugins.ftsconfig.helper.shared.XMLParser;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSConfigConfFileCreate {
    public static final String UTF_8 = "UTF-8";
    private static Logger log = Logger.getLogger(FTSConfigConfFileCreate.class);
    private static int javaPluginLocation_;

    public void createEntryFTS(File file, File file2, File file3, File file4, String string, String string2, String string3, String string4, String string5, String string6, String string7, Entry entry) throws ARException {
        try {
            Value value = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_FTS_AGENT_ENABLED.getFieldID());
            Value value2 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_SERVER_CONFIGURATION.getFieldID());
            Value value3 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_FTS_PORT1.getFieldID());
            Value value4 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_MAX_JVM_MEM1.getFieldID());
            Value value5 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_PRIMARY_SVR_NAME.getFieldID());
            Value value6 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_FTS_PORT2.getFieldID());
            Value value7 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_MAX_JVM_MEM2.getFieldID());
            Value value8 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_FTS_COLLECTION_DIR.getFieldID());
            String string8 = value8.getValue() != null ? value8.toString() : "";
            Value value9 = (Value)entry.get((Object)FTSConfigPluginConstants.FIELD_FTS_CONFIG_DIR.getFieldID());
            String string9 = value8.getValue() != null ? value9.toString() : "";
            int n = value != null && value.getValue() != null ? Integer.parseInt(value.toString()) : 1;
            int n2 = value2 != null && value2.getValue() != null ? Integer.parseInt(value2.toString()) : 0;
            int n3 = value3 != null && value3.getValue() != null ? Integer.parseInt(value3.toString()) : 0;
            int n4 = value4 != null && value4.getValue() != null ? Integer.parseInt(value4.toString()) : 0;
            String string10 = value5 != null && value5.getValue() != null ? value5.toString() : "";
            int n5 = value6 != null && value6.getValue() != null ? Integer.parseInt(value6.toString()) : 0;
            int n6 = value7 != null && value7.getValue() != null ? Integer.parseInt(value7.toString()) : 0;
            log.debug((Object)("Entries Given by User: FTS Agent:" + n + ":Server Configuration:" + n2 + ":FTS Port1:" + n3 + ":MAX JVM Memory1:" + n4 + ":prim_svr_name_str:" + string10 + ":fts_port2_value:" + n5 + ":max_jvm_mem2_value:" + n6 + ":FTS Collection Directory:" + string8 + ":FTS Configuration Directory:" + string9));
            this.createArcfgConfiguration(file, n2, n3, string10, n5, string4, string2, string8, string9, n);
            log.debug((Object)"After FTSConfigConfFileCreate.createArcfgConfiguration");
            this.createArmonConfiguration(file2, n, n2, n4, n6, string4, file3, file4, string, string5, string2, string3);
            log.debug((Object)"After FTSConfigConfFileCreate.createArmonConfiguration");
            if (n2 == 0) {
                this.createftsprimConfiguration(file3, n3);
            } else if (n2 == 1) {
                this.createftsprimConfiguration(file3, n3);
                this.createftsprimConfiguration(file4, n5);
            }
            log.debug((Object)"After FTSConfigConfFileCreate.createftsprimConfiguration");
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to Create or Update File " + exception.getLocalizedMessage());
        }
    }

    public void createArcfgConfiguration(File file, int n, int n2, String string, int n3, String string2, String string3, String string4, String string5, int n4) throws Exception {
        try {
            String string6 = "Server-Plugin-Alias";
            String string7 = "ARSYS.ARF.FTS ARSYS.ARF.FTS ";
            String string8 = "";
            int n5 = 0;
            if (n == 2) {
                n5 = n3;
                string8 = string7 + string + ":" + n5;
            } else {
                n5 = n2;
                string8 = string7 + string3 + ":" + n5;
            }
            String string9 = this.readArcfgForProperty(file, "Server-Group-Member");
            if (n == 2 && n4 == 1) {
                this.removeCFGentry(file, string6, string7 + string + ":" + n3);
                this.removeCFGentry(file, string6, string7 + string3 + ":" + n2);
                this.setCFGentry(file, string6, string8, string7);
                if (string9 != null && string9.length() > 0 && string9.equalsIgnoreCase("T")) {
                    this.setCFGentry(file, "Full-Text-Mode", "Server-Group-secondary", "Server-Group-secondary");
                }
                return;
            }
            this.setCFGentry(file, string6, string8, string7);
            string6 = "Full-Text-Mode";
            string8 = n == 0 ? (string7 = "Single-Server") : (n == 1 ? (string9 != null && string9.length() > 0 && string9.equalsIgnoreCase("T") ? (string7 = "Server-Group-primary") : (string7 = "Single-Server")) : (n == 2 ? (string9 != null && string9.length() > 0 && string9.equalsIgnoreCase("T") ? (string7 = "Server-Group-secondary") : (string7 = "Single-Server")) : (string7 = "Disabled")));
            this.setCFGentry(file, string6, string8, string7);
            if ((n == 1 || n == 2) && string9 != null && string9.length() > 0 && string9.equalsIgnoreCase("T")) {
                string8 = string7 = String.valueOf(n3);
                string6 = "Full-Text-Secondary-Plugin-Port";
                this.setCFGentry(file, string6, string8, string7);
            }
            this.setCFGentry(file, string6, string8, string7);
            this.setCFGentry(file, "Full-Text-Collection-Directory", string4, "");
            this.setCFGentry(file, "Full-Text-Configuration-Directory", string5, "");
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to set ar.conf entry.In method createArcfgConfiguration:" + exception.getLocalizedMessage());
        }
    }

    public void createArmonConfiguration(File file, int n, int n2, int n3, int n4, String string, File file2, File file3, String string2, String string3, String string4, String string5) throws Exception {
        try {
            String string6 = FTSConfFileHelper.getOsName();
            String string7 = "";
            String string8 = "";
            string7 = FTSConfFileHelper.isMemberWindows(string6) ? "fts" + FTSConfFileHelper.getFileSeparator() + FTSConfFileHelper.getFileSeparator() + "primary" : "fts" + FTSConfFileHelper.getFileSeparator() + "primary";
            string8 = FTSConfFileHelper.isMemberWindows(string6) ? "fts" + FTSConfFileHelper.getFileSeparator() + FTSConfFileHelper.getFileSeparator() + "secondary" : "fts" + FTSConfFileHelper.getFileSeparator() + "secondary";
            String string9 = " -Xmx" + n3 + "m";
            String string10 = " -Xmx" + n4 + "m";
            String string11 = " -Djava.net.preferIPv4Stack=true -Djava.net.preferIPv6Addresses=false";
            String string12 = FTSConfFileHelper.getOsArchitecture();
            if (string6 != null && string6.startsWith("Windows") && !FTSConfFileHelper.is64bitWindows(string12)) {
                string11 = "";
            }
            String string13 = " -classpath ";
            String string14 = file2.getParent();
            String string15 = file3.getParent();
            String string16 = string5 + FTSConfFileHelper.getFileSeparator() + "arpluginsvr7604_build002.jar";
            String string17 = " com.bmc.arsys.pluginsvr.ARPluginServerMain ";
            String string18 = "\"" + string3 + "\"" + string9 + string11 + string13 + "\"" + string14 + ";" + string2 + ";" + string5 + ";" + string16 + "\"" + string17 + "-x " + string4 + " -i " + "\"" + string + "\"" + " -m";
            String string19 = "\"" + string3 + "\"" + string10 + string11 + string13 + "\"" + string15 + ";" + string2 + ";" + string5 + ";" + string16 + "\"" + string17 + "-x " + string4 + " -i " + "\"" + string + "\"" + " -m";
            String string20 = string3 + string9 + string11 + string13 + string14 + ":" + string2 + ":" + string5 + ":" + string16 + ":" + string17 + "-x " + string4 + " -i " + string + " -m";
            String string21 = string3 + string10 + string11 + string13 + string15 + ":" + string2 + ":" + string5 + ":" + string16 + ":" + string17 + "-x " + string4 + " -i " + string + " -m";
            if (n == 0) {
                if (n2 == 0) {
                    if (FTSConfFileHelper.isMemberWindows(string6)) {
                        this.createFTSMonitorRentry(file, string7, string18);
                        this.unsetFTSMONITORentry(file, string8, string19);
                    } else {
                        this.createFTSMonitorRentry(file, string7, string20);
                        this.unsetFTSMONITORentry(file, string8, string21);
                    }
                } else if (n2 == 1) {
                    if (FTSConfFileHelper.isMemberWindows(string6)) {
                        this.createFTSMonitorRentry(file, string7, string18);
                        this.createFTSMonitorRentry(file, string8, string19);
                    } else {
                        this.createFTSMonitorRentry(file, string7, string20);
                        this.createFTSMonitorRentry(file, string8, string21);
                    }
                } else if (FTSConfFileHelper.isMemberWindows(string6)) {
                    this.unsetFTSMONITORentry(file, string7, string18);
                    this.unsetFTSMONITORentry(file, string8, string19);
                } else {
                    this.unsetFTSMONITORentry(file, string7, string20);
                    this.unsetFTSMONITORentry(file, string8, string21);
                }
            } else if (FTSConfFileHelper.isMemberWindows(string6)) {
                this.unsetFTSMONITORentry(file, string7, string18);
                this.unsetFTSMONITORentry(file, string8, string19);
            } else {
                this.unsetFTSMONITORentry(file, string7, string20);
                this.unsetFTSMONITORentry(file, string8, string21);
            }
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to set ar.conf entry.In method createArcfgConfiguration:" + exception.getLocalizedMessage());
        }
    }

    public void createftsprimConfiguration(File file, int n) throws Exception {
        try {
            String string = String.valueOf(n);
            XMLParser xMLParser = new XMLParser(file.getAbsolutePath());
            if (string != null && !string.trim().equals("")) {
                try {
                    xMLParser.updateNodeValue("/pluginsvr_config/port", string);
                    xMLParser.commit();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to set ar.conf entry.In method createftsprimConfiguration:" + exception.getLocalizedMessage());
        }
    }

    public String retrievePort(File file) throws Exception {
        String string = "";
        try {
            XMLParser xMLParser = new XMLParser(file.getAbsolutePath());
            string = xMLParser.getNodeValue("/pluginsvr_config/port");
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to set ar.conf entry.In method createftsprimConfiguration:" + exception.getLocalizedMessage());
        }
        return string;
    }

    private void createFTSMonitorRentry(File file, String string, String string2) throws Exception {
        try {
            log.info((Object)"In Method createFTSMonitorRentry");
            String string3 = ".*" + string + ".*";
            RegexFileLineFilter regexFileLineFilter = new RegexFileLineFilter(string3);
            List<String> list = FTSConfFileHelper.readLines(file, null);
            ListIterator<String> listIterator = list.listIterator();
            String string4 = "";
            boolean bl = false;
            while (listIterator.hasNext()) {
                string4 = listIterator.next();
                if (!regexFileLineFilter.acceptLine(string4)) continue;
                bl = true;
                if (!string4.startsWith("#")) {
                    listIterator.set(string2);
                    continue;
                }
                listIterator.remove();
                listIterator.add(string2);
            }
            if (!bl) {
                list.add(string2);
            }
            if (file != null && file.exists() && file.canWrite()) {
                FTSConfFileHelper.writeLines(list, file);
                log.info((Object)("Updated SuccessFully" + list.toString()));
            } else {
                log.warn((Object)("Could Not Write in File" + file.getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to set armonitor.conf entry.In method createFTSMonitorRentry:" + exception.getLocalizedMessage());
        }
    }

    private void unsetFTSMONITORentry(File file, String string, String string2) throws Exception {
        try {
            log.info((Object)"In Method unsetFTSMONITORentry");
            String string3 = ".*" + string + ".*";
            RegexFileLineFilter regexFileLineFilter = new RegexFileLineFilter(string3);
            List<String> list = FTSConfFileHelper.readLines(file, null);
            ListIterator<String> listIterator = list.listIterator();
            String string4 = "";
            boolean bl = false;
            while (listIterator.hasNext()) {
                string4 = listIterator.next();
                if (!regexFileLineFilter.acceptLine(string4)) continue;
                bl = true;
                if (string4.startsWith("#")) continue;
                listIterator.set("#" + string4);
            }
            if (!bl) {
                list.add("#" + string2);
            }
            if (file != null && file.exists() && file.canWrite()) {
                FTSConfFileHelper.writeLines(list, file);
                log.info((Object)("Updated SuccessFully" + list.toString()));
            } else {
                log.warn((Object)("Could Not Write in File" + file.getAbsolutePath()));
            }
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to unset armonitor.conf entry.In method unsetFTSMONITORentry:" + exception.getLocalizedMessage());
        }
    }

    private void setCFGentry(File file, String string, String string2, String string3) {
        try {
            log.debug((Object)"In setCFGentry");
            PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
            propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
            propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
            propertiesConfigurationFile.parse(file);
            List<String> list = propertiesConfigurationFile.getProperties(string);
            if (!list.isEmpty()) {
                if (!this.isValueExists(list, string3)) {
                    if (list.size() >= 1) {
                        PropertyEntry propertyEntry = new PropertyEntry(string, string2);
                        propertyEntry.setSeparator(':');
                        propertyEntry.setSeparatorValueSpacing(" ");
                        propertyEntry.setUseSeparatorValueSpacing(true);
                        propertyEntry.setValue(string2);
                        propertiesConfigurationFile.setProperty(propertyEntry);
                        propertiesConfigurationFile.save(file);
                    }
                } else if (list.size() == 0) {
                    PropertyEntry propertyEntry = propertiesConfigurationFile.getPropertyEntry(string, list.get(0));
                    propertyEntry.setSeparator(':');
                    propertyEntry.setSeparatorValueSpacing(" ");
                    propertyEntry.setUseSeparatorValueSpacing(true);
                    propertyEntry.setValue(string2);
                    propertiesConfigurationFile.setProperty(propertyEntry);
                    propertiesConfigurationFile.save(file);
                } else if (string.equalsIgnoreCase("Server-Plugin-Alias")) {
                    PropertyEntry propertyEntry = propertiesConfigurationFile.getPropertyEntry(string, list.get(javaPluginLocation_));
                    propertyEntry.setSeparator(':');
                    propertyEntry.setSeparatorValueSpacing(" ");
                    propertyEntry.setUseSeparatorValueSpacing(true);
                    propertyEntry.setValue(string2);
                    propertiesConfigurationFile.save(file);
                }
            } else {
                PropertyEntry propertyEntry = new PropertyEntry(string, string2);
                propertyEntry.setSeparator(':');
                propertyEntry.setSeparatorValueSpacing(" ");
                propertyEntry.setUseSeparatorValueSpacing(true);
                propertiesConfigurationFile.addProperty(propertyEntry);
                propertiesConfigurationFile.save(file);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String readArMonitorforJVM(File file, String string) throws Exception {
        String string2;
        block4: {
            string2 = "";
            try {
                List<String> list = FTSConfFileHelper.readLines(file, null);
                ListIterator<String> listIterator = list.listIterator();
                String string3 = ".*" + string + ".*";
                RegexFileLineFilter regexFileLineFilter = new RegexFileLineFilter(string3);
                String string4 = "";
                while (listIterator.hasNext()) {
                    String[] stringArray;
                    string4 = listIterator.next();
                    if (!regexFileLineFilter.acceptLine(string4)) continue;
                    for (String string5 : stringArray = string4.split(" ")) {
                        if (string5.length() == 0 || !string5.startsWith("-Xmx")) continue;
                        string2 = string5.substring(4, string5.length() - 1);
                        break block4;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                throw new ARException(2, 8750, "Failed to read armonitor.conf .In method readArMonitorforPort:" + exception.getLocalizedMessage());
            }
        }
        return string2;
    }

    public String readArcfgForProperty(File file, String string) throws ARException {
        String string2 = null;
        try {
            PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
            propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
            propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
            propertiesConfigurationFile.parse(file);
            List<String> list = propertiesConfigurationFile.getProperties(string);
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
            }
            string2 = stringBuilder.toString();
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to read ar.conf " + exception.getLocalizedMessage());
        }
        return string2;
    }

    public String readArcfgforPort(File file, String string, String string2) throws Exception {
        String string3;
        block7: {
            string3 = "";
            try {
                PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
                propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
                propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
                propertiesConfigurationFile.parse(file);
                List<String> list = propertiesConfigurationFile.getProperties(string);
                if (list.isEmpty()) break block7;
                if (this.isValueExists(list, string2)) {
                    string3 = list.get(javaPluginLocation_);
                    if (string3 != null && string3.length() > 0) {
                        String[] stringArray = string3.split(" ");
                        string3 = stringArray[2];
                    } else {
                        string3 = "";
                    }
                    break block7;
                }
                for (AbstractEntry abstractEntry : propertiesConfigurationFile.getEntries()) {
                    String string4;
                    if (abstractEntry.getType() != 1 || (string4 = abstractEntry.toString()) == null || string4.equals("") || !string4.startsWith("#" + string)) continue;
                    String string5 = string4.substring(string4.indexOf(":") + 1);
                    if (string5 != null && string5.length() > 0 && string5.trim().startsWith(string2)) {
                        String[] stringArray = string5.trim().split(" ");
                        string3 = stringArray[2];
                        break;
                    }
                    string3 = "";
                }
            }
            catch (Exception exception) {
                throw new ARException(2, 8750, "Failed to read armonitor.conf .In method readArMonitorforPort:" + exception.getLocalizedMessage());
            }
        }
        return string3;
    }

    public boolean isArcfgCommented(File file, String string, String string2) throws Exception {
        boolean bl = false;
        try {
            PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
            propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
            propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
            propertiesConfigurationFile.parse(file);
            List<String> list = propertiesConfigurationFile.getProperties(string);
            if (!list.isEmpty()) {
                bl = !this.isValueExists(list, string2);
            }
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to read armonitor.conf .In method isArcfgCommented:" + exception.getLocalizedMessage());
        }
        return bl;
    }

    public boolean readArMonitorforConfig(File file, String string) throws Exception {
        boolean bl = false;
        try {
            List<String> list = FTSConfFileHelper.readLines(file, null);
            ListIterator<String> listIterator = list.listIterator();
            String string2 = ".*" + string + ".*";
            RegexFileLineFilter regexFileLineFilter = new RegexFileLineFilter(string2);
            String string3 = "";
            while (listIterator.hasNext()) {
                string3 = listIterator.next();
                if (!regexFileLineFilter.acceptLine(string3) || string3.startsWith("#")) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to read armonitor.conf .In method readArMonitorforConfig:" + exception.getLocalizedMessage());
        }
        return bl;
    }

    private boolean isValueExists(List<String> list, String string) {
        boolean bl = false;
        try {
            for (String string2 : list) {
                if (string.equals("") || !string2.contains(string)) continue;
                bl = true;
                javaPluginLocation_ = list.indexOf(string2);
                break;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    private void removeCFGentry(File file, String string, String string2) {
        try {
            PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
            propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
            propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
            propertiesConfigurationFile.parse(file);
            List<String> list = propertiesConfigurationFile.getProperties(string);
            if (!list.isEmpty() && list.contains(string2)) {
                String string3 = "";
                string3 = list.size() > 1 ? string2 : list.get(0);
                PropertyEntry propertyEntry = propertiesConfigurationFile.getPropertyEntry(string, string3);
                propertyEntry.setSeparator(':');
                propertyEntry.setValue(string3);
                propertyEntry.setSeparatorValueSpacing(" ");
                propertyEntry.setUseSeparatorValueSpacing(true);
                propertiesConfigurationFile.removeEntry(propertyEntry);
                propertiesConfigurationFile.save(file);
            }
        }
        catch (Throwable throwable) {
            log.debug((Object)("In unsetCFGentry" + throwable));
        }
    }

    private void unsetCFGentry(File file, String string, String string2) {
        try {
            PropertiesConfigurationFile propertiesConfigurationFile = new PropertiesConfigurationFile();
            propertiesConfigurationFile.setAllowMultipleValuesPerKey(true);
            propertiesConfigurationFile.setUseSeparatorValueSpacing(true);
            propertiesConfigurationFile.parse(file);
            List<String> list = propertiesConfigurationFile.getProperties(string);
            if (!list.isEmpty() && list.contains(string2)) {
                String string3 = "";
                string3 = list.size() > 1 ? string2 : list.get(0);
                PropertyEntry propertyEntry = propertiesConfigurationFile.getPropertyEntry(string, string3);
                propertyEntry.setSeparator(':');
                propertyEntry.setValue(string3);
                propertyEntry.setSeparatorValueSpacing(" ");
                propertyEntry.setUseSeparatorValueSpacing(true);
                propertiesConfigurationFile.commentProperty("#", propertyEntry);
                propertiesConfigurationFile.save(file);
            }
        }
        catch (Throwable throwable) {
            log.debug((Object)("In unsetCFGentry" + throwable));
        }
    }
}

