/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.DocHandler;

import com.bmc.arsys.fts.DocumentHandler;
import com.bmc.arsys.fts.FileHandler;
import com.bmc.arsys.fts.impl.DocHandler.DocumentHandlerException;
import com.bmc.arsys.fts.impl.DocHandler.FileHandlerException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;

public class ExtensionFileHandler
implements FileHandler {
    private Properties m_props;

    public ExtensionFileHandler(Properties properties) {
        this.m_props = properties;
    }

    public String getText(File file) throws FileHandlerException {
        try {
            DocumentHandler documentHandler = this.getDocumentHandler(file.getName());
            return documentHandler.getText(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileHandlerException("File not found: " + file.getAbsolutePath(), fileNotFoundException);
        }
        catch (DocumentHandlerException documentHandlerException) {
            throw new FileHandlerException("Document cannot be handled: " + file.getAbsolutePath(), documentHandlerException);
        }
    }

    public String getText(String string, byte[] byArray) throws DocumentHandlerException {
        DocumentHandler documentHandler = this.getDocumentHandler(string);
        return documentHandler.getText(new ByteArrayInputStream(byArray));
    }

    private DocumentHandler getDocumentHandler(String string) throws DocumentHandlerException {
        Object object;
        String string2 = null;
        int n = string.indexOf(".");
        if (n > 0 && n < string.length()) {
            object = string.substring(n + 1, string.length());
            string2 = this.m_props.getProperty((String)object);
        }
        if (string2 == null) {
            string2 = this.m_props.getProperty("txt");
        }
        try {
            object = Class.forName(string2);
            return (DocumentHandler)((Class)object).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DocumentHandlerException("Cannot create instance of : " + string2, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new DocumentHandlerException("Cannot create instance of : " + string2, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DocumentHandlerException("Cannot create instance of : " + string2, illegalAccessException);
        }
    }
}

