/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.XdrDecodingStream;

public class XdrUdpDecodingStream
extends XdrDecodingStream {
    private DatagramSocket socket;
    private InetAddress senderAddress = null;
    private int senderPort = 0;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferHighmark;

    public XdrUdpDecodingStream(DatagramSocket datagramSocket, int n2) {
        this.socket = datagramSocket;
        if (n2 < 1024) {
            n2 = 1024;
        }
        if ((n2 & 3) != 0) {
            n2 = n2 + 4 & 0xFFFFFFFC;
        }
        this.buffer = new byte[n2];
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public InetAddress getSenderAddress() {
        return this.senderAddress;
    }

    public int getSenderPort() {
        return this.senderPort;
    }

    public void beginDecoding() throws OncRpcException, IOException {
        DatagramPacket datagramPacket = new DatagramPacket(this.buffer, this.buffer.length);
        this.socket.receive(datagramPacket);
        this.senderAddress = datagramPacket.getAddress();
        this.senderPort = datagramPacket.getPort();
        this.bufferIndex = 0;
        this.bufferHighmark = datagramPacket.getLength() - 4;
    }

    public void endDecoding() throws OncRpcException, IOException {
        this.bufferIndex = 0;
        this.bufferHighmark = -4;
    }

    public void close() throws OncRpcException, IOException {
        this.buffer = null;
        this.socket = null;
    }

    public int xdrDecodeInt() throws OncRpcException, IOException {
        if (this.bufferIndex <= this.bufferHighmark) {
            int n2 = this.buffer[this.bufferIndex++];
            n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            n2 = (n2 << 8) + (this.buffer[this.bufferIndex++] & 0xFF);
            return n2;
        }
        throw new OncRpcException(43);
    }

    public byte[] xdrDecodeOpaque(int n2) throws OncRpcException, IOException {
        int n3 = n2;
        if ((n3 & 3) != 0) {
            n3 = (n3 & 0xFFFFFFFC) + 4;
        }
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            if (this.bufferIndex <= this.bufferHighmark - n3 + 4) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.bufferIndex += n3;
        return byArray;
    }

    public void xdrDecodeOpaque(byte[] byArray, int n2, int n3) throws OncRpcException, IOException {
        int n4 = n3;
        if ((n4 & 3) != 0) {
            n4 = (n4 & 0xFFFFFFFC) + 4;
        }
        if (n3 > 0) {
            if (this.bufferIndex <= this.bufferHighmark - n4 + 4) {
                System.arraycopy(this.buffer, this.bufferIndex, byArray, n2, n3);
            } else {
                throw new OncRpcException(43);
            }
        }
        this.bufferIndex += n4;
    }
}

