/*
 * Decompiled with CFR 0.152.
 */
package org.acplt.oncrpc.server;

import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.server.OncRpcServerTransport;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;

public abstract class OncRpcServerStub {
    public OncRpcServerTransport[] transports;
    public OncRpcServerTransportRegistrationInfo[] info;
    protected Object shutdownSignal = new Object();
    private String characterEncoding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws OncRpcException, IOException {
        try {
            this.unregister(this.transports);
        }
        catch (OncRpcException oncRpcException) {
            // empty catch block
        }
        this.register(this.transports);
        this.run(this.transports);
        try {
            this.unregister(this.transports);
        }
        finally {
            this.close(this.transports);
        }
    }

    public void register(OncRpcServerTransport[] oncRpcServerTransportArray) throws OncRpcException {
        int n2 = oncRpcServerTransportArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            oncRpcServerTransportArray[i2].register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(OncRpcServerTransport[] oncRpcServerTransportArray) {
        int n2 = oncRpcServerTransportArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            oncRpcServerTransportArray[i2].listen();
        }
        while (true) {
            Object object = this.shutdownSignal;
            synchronized (object) {
                try {
                    this.shutdownSignal.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRpcProcessing() {
        if (this.shutdownSignal != null) {
            Object object = this.shutdownSignal;
            synchronized (object) {
                this.shutdownSignal.notify();
            }
        }
    }

    public void unregister(OncRpcServerTransport[] oncRpcServerTransportArray) throws OncRpcException {
        int n2 = oncRpcServerTransportArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            oncRpcServerTransportArray[i2].unregister();
        }
    }

    public void close(OncRpcServerTransport[] oncRpcServerTransportArray) {
        int n2 = oncRpcServerTransportArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            oncRpcServerTransportArray[i2].close();
        }
    }

    public void setCharacterEncoding(String string) {
        this.characterEncoding = string;
        int n2 = this.transports.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.transports[i2].setCharacterEncoding(string);
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }
}

