/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.orm.toplink;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.orm.toplink.SessionFactoryUtils;
import com.bmc.thirdparty.org.springframework.orm.toplink.SessionHolder;
import com.bmc.thirdparty.org.springframework.orm.toplink.TopLinkAccessor;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionSynchronizationManager;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.sessions.Session;

public class TopLinkInterceptor
extends TopLinkAccessor
implements MethodInterceptor {
    private boolean exceptionConversionEnabled = true;

    public void setExceptionConversionEnabled(boolean exceptionConversionEnabled) {
        this.exceptionConversionEnabled = exceptionConversionEnabled;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        boolean existingTransaction = false;
        Session session = SessionFactoryUtils.getSession(this.getSessionFactory(), true);
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            this.logger.debug("Found thread-bound Session for TopLink interceptor");
            existingTransaction = true;
        } else {
            this.logger.debug("Using new Session for TopLink interceptor");
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
        }
        try {
            Object object = methodInvocation.proceed();
            return object;
        }
        catch (TopLinkException ex) {
            if (this.exceptionConversionEnabled) {
                throw this.convertTopLinkAccessException(ex);
            }
            throw ex;
        }
        finally {
            if (existingTransaction) {
                this.logger.debug("Not closing pre-bound TopLink Session after interceptor");
            } else {
                TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
                SessionFactoryUtils.releaseSession(session, this.getSessionFactory());
            }
        }
    }
}

