/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.aop.target;

import com.bmc.thirdparty.org.springframework.aop.TargetSource;
import com.bmc.thirdparty.org.springframework.util.Assert;
import java.io.Serializable;

public final class SingletonTargetSource
implements TargetSource,
Serializable {
    private final Object target;

    public SingletonTargetSource(Object target) {
        Assert.notNull(target, "Target is required");
        this.target = target;
    }

    public Class getTargetClass() {
        return this.target.getClass();
    }

    public Object getTarget() {
        return this.target;
    }

    public void releaseTarget(Object target) {
    }

    public boolean isStatic() {
        return true;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingletonTargetSource)) {
            return false;
        }
        SingletonTargetSource otherTargetSource = (SingletonTargetSource)other;
        return this.target.equals(otherTargetSource.target);
    }

    public String toString() {
        return "SingletonTargetSource for target: " + this.target;
    }
}

