/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.nio.ArTcpServerTransportBase;
import com.bmc.arsys.pluginsvr.ARPluginRPCCallQueueProcessor;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import com.bmc.arsys.pluginsvr.oncrpcext.ARPluginSvrTcpServerTransport;
import com.bmc.arsys.utils.ARCommonConfig;
import java.io.IOException;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.apache.log4j.Logger;

public class ARPluginServerManager {
    private static final ARPluginServerManager theInstance = new ARPluginServerManager();
    ARPluginServerConfiguration config;
    private static ARPluginRPCCallQueueProcessor rpcDispatcher = null;
    private static ArTcpServerTransportBase transport;
    private static Logger log;

    public static ARPluginServerManager getInstance() {
        return theInstance;
    }

    public ARPluginServerConfiguration loadConfiguration(String[] stringArray) throws ARException {
        this.config = ARPluginServerConfiguration.getInstance();
        this.config.initialize(stringArray);
        ARCommonConfig.getInstance();
        ARPluginServerEncryptionInfo.initialize();
        this.config.setupPluginAuth();
        return this.config;
    }

    public void initRpcDispatcher() throws ARException, OncRpcException, IOException {
        assert (rpcDispatcher == null);
        ARPluginServerConfiguration aRPluginServerConfiguration = ARPluginServerConfiguration.getInstance();
        rpcDispatcher = new ARPluginRPCCallQueueProcessor(aRPluginServerConfiguration.getHostID(), aRPluginServerConfiguration.getPort(), aRPluginServerConfiguration.isRegisteredWithPortMapper());
    }

    public void initTransport() throws OncRpcException, IOException {
        assert (transport == null);
        ARPluginServerConfiguration aRPluginServerConfiguration = ARPluginServerConfiguration.getInstance();
        transport = new ARPluginSvrTcpServerTransport((OncRpcDispatchable)rpcDispatcher, aRPluginServerConfiguration.getHostID(), aRPluginServerConfiguration.getPort(), ARPluginServerManager.rpcDispatcher.info, 132768, aRPluginServerConfiguration.isRegisteredWithPortMapper());
        transport.register();
    }

    public static ArTcpServerTransportBase getTransport() {
        return transport;
    }

    public ARPluginServerConfiguration getConfig() {
        return this.config;
    }

    static {
        log = Logger.getLogger(ARPluginServerManager.class);
    }
}

