/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper.shared;

import java.util.Locale;

public final class UnicodeHelper {
    private static final String SPECIAL_CHARACTERS = "=: \t\r\n\f#!";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encodeString(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(UnicodeHelper.toHex(c >> 12 & 0xF));
                        stringBuffer.append(UnicodeHelper.toHex(c >> 8 & 0xF));
                        stringBuffer.append(UnicodeHelper.toHex(c >> 4 & 0xF));
                        stringBuffer.append(UnicodeHelper.toHex(c & 0xF));
                        continue block8;
                    }
                    if (SPECIAL_CHARACTERS.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String decodeString(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c;
            if ((c = string.charAt(n2++)) == '\\') {
                if (n2 < n) {
                    if ((c = string.charAt(n2++)) == 'u') {
                        boolean bl = false;
                        if (n2 + 4 <= n) {
                            bl = UnicodeHelper.isUnicode(string.substring(n2, n2 + 4).toUpperCase(Locale.US));
                        }
                        int n3 = 0;
                        if (bl) {
                            block6: for (int i = 0; i < 4; ++i) {
                                c = string.charAt(n2++);
                                switch (c) {
                                    case '0': 
                                    case '1': 
                                    case '2': 
                                    case '3': 
                                    case '4': 
                                    case '5': 
                                    case '6': 
                                    case '7': 
                                    case '8': 
                                    case '9': {
                                        n3 = (n3 << 4) + c - 48;
                                        continue block6;
                                    }
                                    case 'a': 
                                    case 'b': 
                                    case 'c': 
                                    case 'd': 
                                    case 'e': 
                                    case 'f': {
                                        n3 = (n3 << 4) + 10 + c - 97;
                                        continue block6;
                                    }
                                    case 'A': 
                                    case 'B': 
                                    case 'C': 
                                    case 'D': 
                                    case 'E': 
                                    case 'F': {
                                        n3 = (n3 << 4) + 10 + c - 65;
                                        continue block6;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                    }
                                }
                            }
                            stringBuffer.append((char)n3);
                            continue;
                        }
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        continue;
                    }
                    if (c == 't') {
                        c = '\t';
                        stringBuffer.append(c);
                        continue;
                    }
                    if (c == 'r') {
                        c = '\r';
                        stringBuffer.append(c);
                        continue;
                    }
                    if (c == 'n') {
                        c = '\n';
                        stringBuffer.append(c);
                        continue;
                    }
                    if (c == 'f') {
                        c = '\f';
                        stringBuffer.append(c);
                        continue;
                    }
                    stringBuffer.append('\\');
                    stringBuffer.append(c);
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static boolean isUnicode(String string) {
        String string2 = "0123456789ABCDEF";
        boolean bl = true;
        for (int i = 0; i < 4; ++i) {
            if (string2.indexOf(string.charAt(i)) != -1) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static char toHex(int n) {
        return HEX_DIGITS[n & 0xF];
    }

    private UnicodeHelper() {
    }
}

