/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfFileHelper;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfigConfFileCreate;
import com.bmc.arsys.plugins.ftsconfig.helper.FTSConfigPluginConstants;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSConfigPlugin
extends ARDBCPlugin {
    private static Logger log = Logger.getLogger(FTSConfigPlugin.class);
    private static FTSConfigConfFileCreate ftsFileHelper;
    private static String armonitorstr;
    private static File armonitorFile;
    private static String arconfStr;
    private static File arconfFile;
    private static String ftsFolder;
    private static File ftsPrimaryConfigFile;
    private static String ftsJavaPath;
    private static File ftsSecondaryConfigFile;
    private static String ftscoreFolder;
    private static String arhome;
    private static String arserverName;
    private static String pluginsvrFolder;
    private static String ftsCollectionDirectory;
    private static String ftsConfigurationDirectory;

    public static void init(ARPluginContext aRPluginContext) throws ARException {
        log.info((Object)"###############################################################");
        log.info((Object)"Plugin initialization.");
        log.info((Object)("Plugin name is " + aRPluginContext.getPluginInfo().getName()));
        log.info((Object)("Plugin version is " + aRPluginContext.getPluginInfo().getVersion()));
        ftsFileHelper = new FTSConfigConfFileCreate();
        arconfStr = aRPluginContext.getConfigItem("arconfPath");
        arconfStr = arconfStr.replace("/", FTSConfFileHelper.getFileSeparator());
        log.debug((Object)("AR Conf Path: " + arconfStr));
        armonitorstr = aRPluginContext.getConfigItem("armonitorPath");
        armonitorstr = armonitorstr.replace("/", FTSConfFileHelper.getFileSeparator());
        log.debug((Object)("AR Monitor Path: " + armonitorstr));
        ftsFolder = aRPluginContext.getConfigItem("ftsFolder");
        ftsFolder = ftsFolder.replace("/", FTSConfFileHelper.getFileSeparator());
        log.debug((Object)("FTS Folder Path: " + ftsFolder));
        ftsJavaPath = aRPluginContext.getConfigItem("ftsJavaPath");
        ftsJavaPath = ftsJavaPath.replace("/", FTSConfFileHelper.getFileSeparator());
        log.debug((Object)("FTS java Path:" + ftsJavaPath));
        arhome = arconfStr;
        arconfFile = new File(arconfStr + FTSConfFileHelper.getFileSeparator() + "conf" + FTSConfFileHelper.getFileSeparator() + "ar" + FTSConfFileHelper.getConfExtension());
        armonitorFile = new File(armonitorstr + FTSConfFileHelper.getFileSeparator() + "armonitor" + FTSConfFileHelper.getConfExtension());
        ftsPrimaryConfigFile = new File(ftsFolder + FTSConfFileHelper.getFileSeparator() + "primary" + FTSConfFileHelper.getFileSeparator() + "pluginsvr_config.xml");
        ftsSecondaryConfigFile = new File(ftsFolder + FTSConfFileHelper.getFileSeparator() + "secondary" + FTSConfFileHelper.getFileSeparator() + "pluginsvr_config.xml");
        ftscoreFolder = ftsFolder + FTSConfFileHelper.getFileSeparator() + "core";
        arserverName = aRPluginContext.getARConfigEntry("Server-Name");
        ftsCollectionDirectory = aRPluginContext.getARConfigEntry("Full-Text-Collection-Directory");
        ftsConfigurationDirectory = aRPluginContext.getARConfigEntry("Full-Text-Configuration-Directory");
        pluginsvrFolder = arhome + FTSConfFileHelper.getFileSeparator() + "pluginsvr";
        log.info((Object)"###############################################################");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, Entry entry) throws ARException {
        String string2 = "";
        try {
            Class<FTSConfigPlugin> clazz = FTSConfigPlugin.class;
            synchronized (FTSConfigPlugin.class) {
                log.debug((Object)"In Method createEntry");
                ftsFileHelper.createEntryFTS(arconfFile, armonitorFile, ftsPrimaryConfigFile, ftsSecondaryConfigFile, ftscoreFolder, arserverName, pluginsvrFolder, arhome, ftsJavaPath, ftsCollectionDirectory, ftsConfigurationDirectory, entry);
                // ** MonitorExit[var8_7] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to Create or Update File " + exception.getLocalizedMessage());
        }
        {
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Entry getEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2, int[] nArray) throws ARException {
        Entry entry;
        try {
            Class<FTSConfigPlugin> clazz = FTSConfigPlugin.class;
            synchronized (FTSConfigPlugin.class) {
                entry = this.readconfFile();
                // ** MonitorExit[var9_7] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("The FTS Config Plugin could not retrieve getEntry", throwable);
        }
        {
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2, Entry entry, Timestamp timestamp) throws ARException {
        try {
            Class<FTSConfigPlugin> clazz = FTSConfigPlugin.class;
            synchronized (FTSConfigPlugin.class) {
                log.debug((Object)"In Method setEntry");
                Entry entry2 = this.readconfFile();
                entry2.putAll((Map)entry);
                ftsFileHelper.createEntryFTS(arconfFile, armonitorFile, ftsPrimaryConfigFile, ftsSecondaryConfigFile, ftscoreFolder, arserverName, pluginsvrFolder, arhome, ftsJavaPath, ftsCollectionDirectory, ftsConfigurationDirectory, entry2);
                // ** MonitorExit[var9_8] (shouldn't be in output)
            }
        }
        catch (Exception exception) {
            throw new ARException(2, 8750, "Failed to Create or Update File " + exception.getLocalizedMessage());
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Entry> getListEntryWithFields(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, QualifierInfo qualifierInfo, List<SortInfo> list2, List<EntryListFieldInfo> list3, int n, int n2, OutputInteger outputInteger) throws ARException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        try {
            Class<FTSConfigPlugin> clazz = FTSConfigPlugin.class;
            synchronized (FTSConfigPlugin.class) {
                Entry entry = this.readconfFile();
                log.debug((Object)"In Method getListEntryWithFields");
                entry.put(Integer.valueOf(1), new Value("000000000000001"));
                arrayList.add(entry);
                if (outputInteger != null) {
                    outputInteger.setValue(arrayList.size());
                }
                // ** MonitorExit[var13_12] (shouldn't be in output)
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException("The FTS Config Plugin could not retrieve getListEntryWithFields", throwable);
        }
        {
            return arrayList;
        }
    }

    @Override
    public void terminate(ARPluginContext aRPluginContext) throws ARException {
        arconfFile = null;
        armonitorFile = null;
        ftsPrimaryConfigFile = null;
        ftsSecondaryConfigFile = null;
        if (log.isInfoEnabled()) {
            log.info((Object)"###############################################################");
            log.info((Object)("Plugin name is " + aRPluginContext.getPluginInfo().getName()));
            log.info((Object)"Plugin terminated");
            log.info((Object)"###############################################################");
        }
    }

    public Entry readconfFile() {
        Entry entry = new Entry();
        try {
            Object object;
            log.debug((Object)"In Method getEntry");
            String string = FTSConfFileHelper.getOsName();
            int n = 1;
            int n2 = 0;
            String string2 = "";
            String string3 = "";
            string2 = FTSConfFileHelper.isMemberWindows(string) ? "fts" + FTSConfFileHelper.getFileSeparator() + FTSConfFileHelper.getFileSeparator() + "primary" : "fts" + FTSConfFileHelper.getFileSeparator() + "primary";
            string3 = FTSConfFileHelper.isMemberWindows(string) ? "fts" + FTSConfFileHelper.getFileSeparator() + FTSConfFileHelper.getFileSeparator() + "secondary" : "fts" + FTSConfFileHelper.getFileSeparator() + "secondary";
            String string4 = ftsFileHelper.readArMonitorforJVM(armonitorFile, string2);
            if (string4 == null || string4.equals("")) {
                string4 = "0";
            }
            log.debug((Object)("In Method readconfFile:strPrimaryJVM" + string4));
            String string5 = ftsFileHelper.readArMonitorforJVM(armonitorFile, string3);
            if (string5 == null || string5.equals("")) {
                string5 = "0";
            }
            log.debug((Object)("In Method readconfFile:strSecondaryJVM" + string5));
            boolean bl = ftsFileHelper.isArcfgCommented(arconfFile, "Server-Plugin-Alias", "ARSYS.ARF.FTS ARSYS.ARF.FTS");
            String string6 = ftsFileHelper.readArcfgforPort(arconfFile, "Server-Plugin-Alias", "ARSYS.ARF.FTS ARSYS.ARF.FTS");
            String string7 = "";
            String string8 = "";
            if (string6 != null && !string6.equals("")) {
                object = string6.split(":");
                string7 = object[0];
                string8 = object[1];
            }
            log.debug((Object)("In Method readconfFile:primserverName" + string7 + string8));
            object = ftsFileHelper.retrievePort(ftsPrimaryConfigFile);
            log.debug((Object)("In Method readconfFile:ftsport1" + (String)object));
            String string9 = ftsFileHelper.retrievePort(ftsSecondaryConfigFile);
            log.debug((Object)("In Method readconfFile:ftsport2" + string9));
            if (object == null || ((String)object).equals("") || ((String)object).equalsIgnoreCase("PLUGINPORT")) {
                object = "0";
            }
            if (string9 == null || string9.equals("") || string9.equalsIgnoreCase("PLUGINPORT")) {
                string9 = "0";
            }
            boolean bl2 = ftsFileHelper.readArMonitorforConfig(armonitorFile, string2);
            boolean bl3 = ftsFileHelper.readArMonitorforConfig(armonitorFile, string3);
            n = bl2 || bl3 ? 0 : 1;
            String string10 = ftsFileHelper.readArcfgForProperty(arconfFile, "Full-Text-Mode");
            String string11 = ftsFileHelper.readArcfgForProperty(arconfFile, "Server-Group-Member");
            n2 = bl2 && bl3 ? (string11 != null && !string11.equals("") && string11.equalsIgnoreCase("T") ? 1 : 0) : (!bl2 && !bl3 ? (string11 != null && !string11.equals("") && string11.equalsIgnoreCase("T") ? (string10 != null && !string10.equals("") && string10.equalsIgnoreCase("Server-Group-primary") ? 1 : (string10 != null && !string10.equals("") && string10.equalsIgnoreCase("Server-Group-secondary") ? 2 : 0)) : 0) : (bl2 && !bl3 ? 0 : (!bl2 && bl3 ? (string11 != null && !string11.equals("") && string11.equalsIgnoreCase("T") ? 1 : 0) : 0)));
            if (string8 != null && ((String)object).equals(string8)) {
                log.info((Object)"Port in ar.cfg matches writer port");
            } else if (string8 != null && string9.equals(string8)) {
                log.info((Object)"Port in ar.cfg matches reader port");
            } else {
                if (string8 != null && !string8.equals("") && n2 == 2) {
                    string9 = string8;
                    log.info((Object)"Setting Port for Secondary Server from ar.cfg");
                }
                log.info((Object)"Incosistent Port in ar.cfg and pluginsvr_config.xml");
            }
            if (n2 == 2 && bl) {
                n = 1;
            } else if (n2 == 2 && !bl) {
                n = 0;
            }
            String string12 = ftsFileHelper.readArcfgForProperty(arconfFile, "Full-Text-Collection-Directory");
            String string13 = ftsFileHelper.readArcfgForProperty(arconfFile, "Full-Text-Configuration-Directory");
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_FTS_AGENT_ENABLED.getFieldID()), new Value(n));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_SERVER_CONFIGURATION.getFieldID()), new Value(n2));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_FTS_PORT1.getFieldID()), new Value(Integer.parseInt((String)object)));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_MAX_JVM_MEM1.getFieldID()), new Value(Integer.parseInt(string4)));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_PRIMARY_SVR_NAME.getFieldID()), new Value(string7));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_FTS_PORT2.getFieldID()), new Value(Integer.parseInt(string9)));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_MAX_JVM_MEM2.getFieldID()), new Value(Integer.parseInt(string5)));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_FTS_COLLECTION_DIR.getFieldID()), new Value(string12));
            entry.put(Integer.valueOf(FTSConfigPluginConstants.FIELD_FTS_CONFIG_DIR.getFieldID()), new Value(string13));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could Not Retrieve FTS Configuration data from Files.", throwable);
        }
        return entry;
    }

    static {
        armonitorstr = "";
        armonitorFile = null;
        arconfStr = "";
        arconfFile = null;
        ftsFolder = "";
        ftsPrimaryConfigFile = null;
        ftsJavaPath = "";
        ftsSecondaryConfigFile = null;
        ftscoreFolder = "";
        arhome = "";
        arserverName = "";
        pluginsvrFolder = "";
        ftsCollectionDirectory = "";
        ftsConfigurationDirectory = "";
    }
}

