/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.Config;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuItem
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8218361475056612432L;
    private String m_label;
    private MENUTYPE m_type;
    private String value;
    private List<MenuItem> subMenu;
    public static String AR_DEF_MENU_DELIMITER = "\\\\";
    public static char AR_DEF_MENU_COMMENT = (char)35;
    public static char AR_DEF_MENU_LINE_INDENT = (char)9;
    public static String AR_DEF_MENU_KEYWORD_ESCAPE = "$\\";
    public static String AR_DEF_MENU_KEYWORD_NO_ESCAPE = "$_SLASH";

    public MenuItem() {
    }

    public MenuItem(String string, String string2) {
        this.m_type = MENUTYPE.Value;
        this.m_label = string;
        this.value = string2;
    }

    public MenuItem(String string, List<MenuItem> list) {
        this.m_type = MENUTYPE.SubMenu;
        this.m_label = string;
        this.subMenu = list;
    }

    public Object clone() throws CloneNotSupportedException {
        MenuItem menuItem = null;
        menuItem = (MenuItem)super.clone();
        if (this.m_type == MENUTYPE.SubMenu && this.subMenu != null) {
            menuItem.subMenu = new ArrayList<MenuItem>();
            int n2 = this.subMenu.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                menuItem.subMenu.add((MenuItem)this.subMenu.get(i2).clone());
            }
        }
        return menuItem;
    }

    public int getType() {
        if (this.m_type == MENUTYPE.Value) {
            return 1;
        }
        if (this.m_type == MENUTYPE.SubMenu) {
            return 2;
        }
        return 0;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String string) {
        this.m_label = string;
    }

    public Object getContent() {
        if (this.m_type == MENUTYPE.Value) {
            return this.getValue();
        }
        if (this.m_type == MENUTYPE.SubMenu) {
            return this.getSubMenu();
        }
        return null;
    }

    public List<MenuItem> getSubMenu() {
        return this.subMenu;
    }

    public void setSubMenu(List<MenuItem> list) {
        this.m_type = MENUTYPE.SubMenu;
        this.value = null;
        this.subMenu = list;
    }

    public void setSubMenu(MenuItem menuItem) {
        if (this.m_type == MENUTYPE.SubMenu) {
            this.subMenu.add(menuItem);
        } else {
            this.m_type = MENUTYPE.SubMenu;
            this.subMenu = new ArrayList<MenuItem>();
            this.subMenu.add(menuItem);
            this.value = null;
        }
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.m_type = MENUTYPE.Value;
        this.subMenu = null;
        this.value = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof MenuItem)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        MenuItem menuItem = (MenuItem)object;
        return new EqualsBuilder().append(this.m_label, menuItem.m_label).append((Object)this.m_type, (Object)menuItem.m_type).append(this.value, menuItem.value).append(this.subMenu, menuItem.subMenu).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_label).append((Object)this.m_type).append(this.value).append(this.subMenu).toHashCode();
    }

    Object toVariant(ARServerUser aRServerUser) {
        Object[] objectArray = new Object[]{this.getLabel(), new Integer(this.getType()), this.m_type == MENUTYPE.SubMenu ? new Object[]{1, ARTypeMgr.getInstance().ObjectToVariant(this.getContent(), aRServerUser)} : ARTypeMgr.getInstance().ObjectToVariant(this.getContent(), aRServerUser)};
        return objectArray;
    }

    public static List<MenuItem> decode(String string) throws ARException {
        if (string == null) {
            return new ArrayList<MenuItem>();
        }
        Scanner scanner = new Scanner(string);
        List<MenuItem> list = MenuItem.bufferToMenuItemList(scanner);
        scanner.close();
        return list;
    }

    public static List<MenuItem> bufferToMenuItemList(Scanner scanner) throws ARException {
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        int n2 = 0;
        while (scanner.hasNextLine()) {
            String string;
            String string2 = scanner.nextLine();
            ++n2;
            if (string2.length() > 0 && string2.charAt(0) == AR_DEF_MENU_COMMENT) continue;
            int n3 = 0;
            while (string2.length() > 0 && string2.charAt(0) == AR_DEF_MENU_LINE_INDENT) {
                ++n3;
                string2 = string2.substring(1);
            }
            if (n3 > 15) {
                throw new ARException(2, 321, null);
            }
            string2 = string2.replace(AR_DEF_MENU_KEYWORD_ESCAPE, AR_DEF_MENU_KEYWORD_NO_ESCAPE);
            Scanner scanner2 = new Scanner(string2).useDelimiter(AR_DEF_MENU_DELIMITER);
            if (string2.length() == 0 || !scanner2.hasNext()) continue;
            if (arrayList.isEmpty() && n3 != 0) {
                string = "at line " + n2;
                throw new ARException(2, 130, string);
            }
            string = scanner2.next();
            String string3 = new String();
            if (scanner2.hasNext()) {
                string3 = scanner2.next();
            }
            if (string3.equals("")) {
                string3 = string;
            }
            string3 = string3.replace(AR_DEF_MENU_KEYWORD_NO_ESCAPE, AR_DEF_MENU_KEYWORD_ESCAPE);
            MenuItem menuItem = new MenuItem(string, string3);
            if (n3 == 0) {
                arrayList.add(menuItem);
                continue;
            }
            MenuItem menuItem2 = MenuItem.a(arrayList, n3 - 1);
            if (menuItem2 == null) continue;
            menuItem2.setSubMenu(menuItem);
        }
        return arrayList;
    }

    private static MenuItem a(List<MenuItem> list, int n2) {
        MenuItem menuItem = list.get(list.size() - 1);
        if (n2 == 0) {
            return menuItem;
        }
        return menuItem.getSubMenu() == null ? null : MenuItem.a(menuItem.getSubMenu(), n2 - 1);
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Label", this.m_label).append("Type", (Object)this.m_type).append("Value", this.value).append("Sub Menu", this.subMenu).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MENUTYPE {
        None,
        Value,
        SubMenu;

    }
}

