/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.oncrpcext;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.arrpc.nio.ArEncryptionContext;
import com.bmc.arsys.arrpc.nio.ArEncryptionInfoI;
import com.bmc.arsys.arrpc.nio.ArNioXdrTcpDecodingStream;
import com.bmc.arsys.pluginsvr.encrypt.ARPluginServerEncryptionInfo;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import org.acplt.oncrpc.OncRpcException;
import org.apache.log4j.Logger;

public class ARPluginSvrXdrTcpDecodingStream
extends ArNioXdrTcpDecodingStream {
    private static Logger log = Logger.getLogger(ARPluginSvrXdrTcpDecodingStream.class);
    private ArEncryptionContext mConnection;
    private ArEncryptionInfoI mEncryptionInfo;

    public ARPluginSvrXdrTcpDecodingStream(ArEncryptionContext arEncryptionContext, SocketChannel socketChannel, int n) throws IOException {
        super(socketChannel, n);
        this.mConnection = arEncryptionContext;
        try {
            this.mEncryptionInfo = ARPluginServerEncryptionInfo.getInstance();
        }
        catch (ARException aRException) {
            this.mEncryptionInfo = null;
        }
    }

    public byte[] arEncBeforeUnXdrDecoding(byte[] byArray) throws OncRpcException, IOException {
        byte[] byArray2 = null;
        if (this.isArEncryptionOn() && this.isArProcessOn()) {
            try {
                byArray2 = this.mEncryptionInfo.unXdrAndDecryptData(byArray, this.mConnection);
            }
            catch (OncRpcException oncRpcException) {
                if ("Rpc encryption error".equals(oncRpcException.getMessage())) {
                    super.endDecoding();
                    int n = 0;
                    try {
                        n = this.mConnection.getCurrentSessionId();
                    }
                    catch (OncRpcException oncRpcException2) {
                        log.debug((Object)("sessionId = " + n));
                    }
                    log.error((Object)("Decrypting of the input arguments failed for sessionId: " + n), (Throwable)oncRpcException);
                    throw new OncRpcException("Rpc decryption error");
                }
                if (oncRpcException.getReason() != 2 && oncRpcException.getReason() != 7) {
                    log.error((Object)"Decoding of the input arguments failed", (Throwable)oncRpcException);
                }
                this.mConnection.setCurrentCallEncryption(false);
                throw oncRpcException;
            }
        }
        byArray2 = byArray;
        return byArray2;
    }

    public void resetArFlags() {
        this.setXdrDecodeDone(false);
        this.setDataNotInXdrBuffer(false);
    }

    public boolean isXdrDecodeDone() {
        return super.isXdrDecodeDone();
    }
}

