/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FTSRootCharacterFilter
extends TokenFilter {
    private Hashtable<String, String> rootCharTable;
    private char[] output = new char[512];
    private int outputPos;
    private TermAttribute termAtt;

    public FTSRootCharacterFilter(TokenStream tokenStream, Hashtable<String, String> hashtable) {
        super(tokenStream);
        this.rootCharTable = hashtable;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] cArray = this.termAtt.termBuffer();
            int n = this.termAtt.termLength();
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (c < '\u0080') continue;
                this.foldToASCII(cArray, n);
                this.termAtt.setTermBuffer(this.output, 0, this.outputPos);
                break;
            }
            return true;
        }
        return false;
    }

    public void foldToASCII(char[] cArray, int n) {
        int n2 = 4 * n;
        if (this.output.length < n2) {
            this.output = new char[ArrayUtil.getNextSize((int)n2)];
        }
        this.outputPos = 0;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                this.output[this.outputPos++] = c;
                continue;
            }
            String string = Character.toString(c);
            if (this.rootCharTable.containsKey(string)) {
                char[] cArray2 = this.rootCharTable.get(string).toCharArray();
                for (int j = 0; j < cArray2.length; ++j) {
                    this.output[this.outputPos++] = cArray2[j];
                }
                continue;
            }
            this.output[this.outputPos++] = c;
        }
    }
}

