/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene.analyzers;

import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzerConfigReader;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSRootCharacterFilter;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSStemmingFilter;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSThesaurusFilter;
import com.bmc.arsys.fts.impl.lucene.analyzers.LiteralTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.SinkTokenizer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.index.Term;
import org.tartarus.snowball.SnowballProgram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSAnalyzer
extends Analyzer {
    private static final Logger LOGGER = Logger.getLogger(FTSAnalyzer.class);
    private Set<String> stopSet = new HashSet<String>();
    private Hashtable<String, String> rootTable = new Hashtable();
    private Hashtable<String, String> rootCharTable = new Hashtable();
    private static Hashtable<String, String[]> thesTable = new Hashtable();
    private Set<String> regexSet = new HashSet<String>();
    private Analyzer indexAnalyzer = null;
    private Analyzer searchAnalyzer = null;
    private SnowballProgram stemmer = null;
    private boolean useStopwords = false;
    private boolean useRootwords = false;
    private boolean useRootchar = false;
    private boolean useThesuarus = false;
    private boolean useRegex = false;
    private boolean useIndexAnalyzer = false;
    private boolean useSearchAnalyzer = false;
    private boolean useStemmer = false;
    private boolean isSearch = false;
    private FTSAnalyzerConfigReader.FTSAnalyzerConfig config = null;
    public static final String[] STOP_WORDS = StopAnalyzer.ENGLISH_STOP_WORDS;
    public static final String STOPWORD_TOKEN = "~!~STOPWORD~!~";
    private boolean isCaseSensitive = false;
    private boolean isLiteral = false;
    private boolean doStemming = true;
    private boolean isInWildcardProcessing = false;
    public SinkTokenizer sink1 = new SinkTokenizer(null);
    public TokenStream source1 = null;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;

    public FTSAnalyzer(FTSAnalyzerConfigReader.FTSAnalyzerConfig fTSAnalyzerConfig, boolean bl) {
        this.config = fTSAnalyzerConfig;
        this.reload(bl);
    }

    public void reload(boolean bl) {
        char c;
        String string;
        int n;
        String[] stringArray;
        String[] stringArray2;
        Iterator iterator;
        HashSet hashSet;
        Serializable serializable;
        this.isCaseSensitive = bl;
        if (this.config.rootwordfile != null && !this.config.rootwordfile.equals("") && ((File)(serializable = new File(this.config.rootwordfile))).exists()) {
            try {
                hashSet = new HashSet();
                hashSet = WordlistLoader.getWordSet((File)serializable);
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    stringArray2 = ((String)iterator.next()).split(" ");
                    stringArray = stringArray2[0];
                    for (n = 0; n < stringArray2.length; ++n) {
                        this.rootTable.put(stringArray2[n], (String)stringArray);
                    }
                }
                this.useRootwords = true;
            }
            catch (IOException iOException) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + serializable), (Throwable)iOException);
            }
        }
        if (this.config.rootcharacterfile != null && !this.config.rootcharacterfile.equals("") && ((File)(serializable = new File(this.config.rootcharacterfile))).exists()) {
            try {
                hashSet = new HashSet();
                hashSet = WordlistLoader.getWordSet((File)serializable);
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    stringArray2 = ((String)iterator.next()).split(" ");
                    stringArray = stringArray2[0];
                    for (n = 1; n < stringArray2.length; ++n) {
                        string = stringArray2[n];
                        if (string.length() != 6) continue;
                        int n2 = Integer.parseInt(string.substring(2), 16);
                        c = (char)n2;
                        this.rootCharTable.put(String.valueOf(c), (String)stringArray);
                    }
                }
                this.useRootchar = true;
            }
            catch (IOException iOException) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + serializable), (Throwable)iOException);
            }
        }
        if (this.config.thesaurusfile != null && !this.config.thesaurusfile.equals("") && ((File)(serializable = new File(this.config.thesaurusfile))).exists()) {
            try {
                hashSet = new HashSet();
                hashSet = WordlistLoader.getWordSet((File)serializable);
                iterator = hashSet.iterator();
                int n3 = 0;
                while (iterator.hasNext()) {
                    stringArray = ((String)iterator.next()).split(" ");
                    for (n = 0; n < stringArray.length; ++n) {
                        string = stringArray[n];
                        String[] stringArray3 = new String[stringArray.length - 1];
                        for (c = '\u0000'; c < stringArray.length; c = (char)(c + 1)) {
                            int n4 = 0;
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (stringArray[i].equals(string)) continue;
                                stringArray3[n4] = stringArray[i];
                                ++n4;
                            }
                        }
                        thesTable.put(string, stringArray3);
                        ++n3;
                    }
                }
                this.useThesuarus = true;
            }
            catch (IOException iOException) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + serializable), (Throwable)iOException);
            }
        }
        if (this.config.regexfile != null && !this.config.regexfile.equals("") && ((File)(serializable = new File(this.config.regexfile))).exists()) {
            try {
                this.regexSet = WordlistLoader.getWordSet((File)serializable);
                this.useRegex = true;
            }
            catch (IOException iOException) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + serializable), (Throwable)iOException);
            }
        }
        if (this.config.stemmer != null && !this.config.stemmer.equals("")) {
            try {
                serializable = this.config.stemmer.indexOf(".") > -1 ? Class.forName(this.config.stemmer) : Class.forName("org.tartarus.snowball.ext." + this.config.stemmer + "Stemmer");
                this.stemmer = (SnowballProgram)((Class)serializable).newInstance();
                this.useStemmer = true;
            }
            catch (Exception exception) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to instantiate the stemmer"), (Throwable)exception);
            }
        }
        if (this.config.stopwordfile != null && !this.config.stopwordfile.equals("") && ((File)(serializable = new File(this.config.stopwordfile))).exists()) {
            try {
                this.stopSet = this.stopwordStemmer(WordlistLoader.getWordSet((File)serializable));
                this.useStopwords = true;
            }
            catch (IOException iOException) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + serializable), (Throwable)iOException);
            }
        }
        if (this.config.indexAnalyzer != null && !this.config.indexAnalyzer.equals("")) {
            try {
                serializable = Class.forName(this.config.indexAnalyzer);
                this.indexAnalyzer = (Analyzer)((Class)serializable).newInstance();
                this.useIndexAnalyzer = true;
            }
            catch (Exception exception) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to instantiate the indexAnalyzer"), (Throwable)exception);
            }
        }
        if (this.config.searchAnalyzer != null && !this.config.searchAnalyzer.equals("")) {
            try {
                serializable = Class.forName(this.config.searchAnalyzer);
                this.searchAnalyzer = (Analyzer)((Class)serializable).newInstance();
                this.useSearchAnalyzer = true;
            }
            catch (Exception exception) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to instantiate the searchAnalyzer"), (Throwable)exception);
            }
        }
        this.setPreviousTokenStream(null);
    }

    private Set<String> stopwordStemmer(HashSet<String> hashSet) {
        if (this.doStemming && this.stemmer != null) {
            HashSet<String> hashSet2 = new HashSet<String>();
            for (String string : hashSet) {
                this.stemmer.setCurrent(string);
                this.stemmer.stem();
                hashSet2.add(this.stemmer.getCurrent());
            }
            return hashSet2;
        }
        return hashSet;
    }

    public FTSAnalyzer(String string, boolean bl) {
        File file;
        this.isCaseSensitive = bl;
        if (string != null && !string.equals("") && (file = new File(string)).exists()) {
            try {
                this.stopSet = WordlistLoader.getWordSet((File)file);
            }
            catch (IOException iOException) {
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " FTSAnalyzer: Failed to open " + file), (Throwable)iOException);
            }
        }
    }

    public TokenStream tokenStream(String string, Reader reader) {
        StandardTokenizer standardTokenizer;
        Object object;
        this.checkFieldName(string);
        if (this.isLiteral) {
            LiteralTokenizer literalTokenizer = new LiteralTokenizer(reader);
            if (!this.isCaseSensitive) {
                literalTokenizer = new LowerCaseFilter((TokenStream)literalTokenizer);
            }
            return literalTokenizer;
        }
        if (this.useIndexAnalyzer && !this.isSearch) {
            object = this.indexAnalyzer.tokenStream(string, reader);
        } else if (this.useSearchAnalyzer && this.isSearch) {
            object = this.searchAnalyzer.tokenStream(string, reader);
        } else {
            standardTokenizer = new StandardTokenizer(reader, true);
            standardTokenizer.setMaxTokenLength(this.maxTokenLength);
            object = new StandardFilter((TokenStream)standardTokenizer);
        }
        if (!this.isCaseSensitive && !this.useIndexAnalyzer) {
            object = new LowerCaseFilter(object);
        }
        if (!this.isSearch && this.useThesuarus && this.doStemming) {
            object = new FTSThesaurusFilter((TokenStream)object, thesTable);
        }
        if (this.useRootchar) {
            object = new FTSRootCharacterFilter((TokenStream)object, this.rootCharTable);
        }
        if (this.doStemming && this.useStemmer) {
            object = new FTSStemmingFilter((TokenStream)object, this.stemmer, this.rootTable);
        }
        if (this.useStopwords) {
            standardTokenizer = new StopFilter(object, this.stopSet);
            standardTokenizer.setEnablePositionIncrements(true);
            object = standardTokenizer;
        }
        return object;
    }

    public void setMaxTokenLength(int n) {
        this.maxTokenLength = n;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    private void checkFieldName(String string) {
        this.isLiteral = string.endsWith("_literal") || string.endsWith("_literalCase");
        if (string.equals("entryid") || string.equals("docid") || string.equals("schemaid")) {
            this.isLiteral = true;
        }
        if (string.endsWith("_noStem") || string.endsWith("_caseNoStem")) {
            this.doStemming = false;
        } else if (!this.isInWildcardProcessing) {
            this.doStemming = true;
        }
    }

    private String getFilteredTokenStreamKey() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isLiteral) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (this.isCaseSensitive) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (this.useIndexAnalyzer) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (this.useSearchAnalyzer) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (this.useStopwords) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (this.useThesuarus) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (this.doStemming) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (this.useStemmer) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        if (this.useRootchar) {
            stringBuffer.append("1");
        } else {
            stringBuffer.append("0");
        }
        return stringBuffer.toString();
    }

    public TokenStream reusableTokenStream(String string, Reader reader) throws IOException {
        String string2;
        Object object;
        if (this.useIndexAnalyzer) {
            return this.tokenStream(string, reader);
        }
        this.checkFieldName(string);
        SavedStreams savedStreams = (SavedStreams)this.getPreviousTokenStream();
        if (savedStreams == null) {
            savedStreams = new SavedStreams();
            this.setPreviousTokenStream(savedStreams);
            savedStreams.tokenStream = new StandardTokenizer(reader);
            savedStreams.tokenStreamLiteral = new LiteralTokenizer(reader);
        }
        if ((object = savedStreams.getFilteredTokenStream(string2 = this.getFilteredTokenStreamKey())) == null) {
            if (this.isLiteral) {
                object = !this.isCaseSensitive ? new LowerCaseFilter((TokenStream)savedStreams.tokenStreamLiteral) : savedStreams.tokenStreamLiteral;
            } else {
                object = new StandardFilter((TokenStream)savedStreams.tokenStream);
                if (!this.isCaseSensitive && !this.useIndexAnalyzer) {
                    object = new LowerCaseFilter(object);
                }
                if (!this.isSearch && this.useThesuarus && this.doStemming) {
                    object = new FTSThesaurusFilter((TokenStream)object, thesTable);
                }
                if (this.useRootchar) {
                    object = new FTSRootCharacterFilter((TokenStream)object, this.rootCharTable);
                }
                if (this.doStemming && this.useStemmer) {
                    object = new FTSStemmingFilter((TokenStream)object, this.stemmer, this.rootTable);
                }
                if (this.useStopwords) {
                    StopFilter stopFilter = new StopFilter(object, this.stopSet);
                    stopFilter.setEnablePositionIncrements(true);
                    object = stopFilter;
                }
            }
            savedStreams.setFilteredTokenStream(string2, (TokenStream)object);
        }
        if (this.isLiteral) {
            savedStreams.tokenStreamLiteral.reset(reader);
        } else {
            savedStreams.tokenStream.reset(reader);
        }
        return object;
    }

    public Term analyzeSearchTerm(String string, String string2, boolean bl) {
        if (bl) {
            return this.analyzeSearchWildcardTerm(string, string2);
        }
        return this.analyzeSearchTerm(string, string2);
    }

    public ArrayList<Term> analyzeSearchPhrase(String string, String string2, boolean bl) {
        if (bl) {
            return this.analyzeSearchWildcardPhrase(string, string2);
        }
        return this.analyzeSearchPhrase(string, string2);
    }

    private Term analyzeSearchTerm(String string, String string2) {
        this.isSearch = true;
        Term term = null;
        TokenStream tokenStream = this.tokenStream(string, new StringReader(string2));
        try {
            term = new Term(string, tokenStream.next().term());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isSearch = false;
        return term;
    }

    private ArrayList<Term> analyzeSearchPhrase(String string, String string2) {
        ArrayList<Term> arrayList;
        block6: {
            this.isSearch = true;
            arrayList = new ArrayList<Term>();
            TokenStream tokenStream = this.tokenStream(string, new StringReader(string2));
            boolean bl = true;
            try {
                while (bl) {
                    Token token = tokenStream.next();
                    if (token == null) {
                        bl = false;
                        break;
                    }
                    int n = token.getPositionIncrement();
                    if (n == 0) continue;
                    if (n > 1) {
                        for (int i = 0; i < n - 1; ++i) {
                            arrayList.add(null);
                        }
                    }
                    String string3 = token.term();
                    arrayList.add(new Term(string, string3));
                }
            }
            catch (Exception exception) {
                if (!LOGGER.isDebugEnabled()) break block6;
                LOGGER.error((Object)(((Object)((Object)this)).getClass().getName() + " analyzeSearchPhrase: failed to get next term "), (Throwable)exception);
            }
        }
        this.isSearch = false;
        return arrayList;
    }

    private Term analyzeSearchWildcardTerm(String string, String string2) {
        this.isSearch = true;
        this.checkFieldName(string);
        if (!this.isCaseSensitive) {
            string2 = string2.toLowerCase();
        }
        this.isSearch = false;
        return new Term(string, string2);
    }

    private ArrayList<Term> analyzeSearchWildcardPhrase(String string, String string2) {
        this.isSearch = true;
        this.isInWildcardProcessing = true;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        String[] stringArray = string2.split(" ");
        this.doStemming = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].matches("[\\W && [^\\d] && [^\uac00-\ud7af\u0401\u0451\u0410-\u044f\u3100-\u312f\u3040-\u309f\u30a0-\u30ff\u31f0-\u31ff\u3300-\u337f\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\uff65-\uff9f]]+")) continue;
            ArrayList<Term> arrayList2 = this.analyzeSearchPhrase(string, stringArray[i]);
            if (stringArray[i].indexOf("*") > -1) {
                if (arrayList2.size() > 1) {
                    for (Term term : arrayList2) {
                        if (term == null) {
                            arrayList.add(new Term(string, STOPWORD_TOKEN));
                            continue;
                        }
                        arrayList.add(this.wildcardTheTerm(term, stringArray[i]));
                    }
                    continue;
                }
                if (arrayList2.size() == 0) {
                    arrayList.add(new Term(string, STOPWORD_TOKEN));
                    continue;
                }
                arrayList.add(this.wildcardTheTerm(arrayList2.get(0), stringArray[i]));
                continue;
            }
            if (arrayList2.size() == 0) {
                arrayList.add(new Term(string, STOPWORD_TOKEN));
                continue;
            }
            for (Term term : arrayList2) {
                if (term == null) {
                    arrayList.add(new Term(string, STOPWORD_TOKEN));
                    continue;
                }
                arrayList.add(term);
            }
        }
        this.doStemming = true;
        this.isInWildcardProcessing = false;
        this.isSearch = false;
        return arrayList;
    }

    private Term wildcardTheTerm(Term term, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string2 = term.text();
        String string3 = null;
        string3 = !this.isCaseSensitive ? string.toLowerCase() : string;
        int n = string3.indexOf(string2);
        int n2 = n + string2.length() - 1;
        if (n > 0 && string3.charAt(n - 1) == '*') {
            stringBuffer.append("*");
        }
        stringBuffer.append(string2);
        if (n2 < string3.length() - 1 && string3.charAt(n2 + 1) == '*') {
            stringBuffer.append("*");
        }
        return term.createTerm(stringBuffer.toString());
    }

    private static final class SavedStreams {
        LiteralTokenizer tokenStreamLiteral;
        StandardTokenizer tokenStream;
        private Hashtable<String, TokenStream> filteredTokenStream = new Hashtable();

        private SavedStreams() {
        }

        public TokenStream getFilteredTokenStream(String string) {
            if (this.filteredTokenStream.containsKey(string)) {
                return this.filteredTokenStream.get(string);
            }
            return null;
        }

        public void setFilteredTokenStream(String string, TokenStream tokenStream) {
            this.filteredTokenStream.put(string, tokenStream);
        }
    }
}

