/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data.arx;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.ParseEvent;
import com.bmc.arsys.apiext.data.Parser;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARXParser
extends Parser {
    public static final String SCHEMA_TAG = "SCHEMA";
    public static final String CHARSET_TAG = "CHAR-SET";
    public static final String FIELDS_TAG = "FIELDS";
    public static final String FLDID_TAG = "FLD-ID";
    public static final String DATA_TAG = "DATA";
    public static final String DTYPES_TAG = "DTYPES";
    public static final String DTYPE_INT = "INTEGER";
    public static final String DTYPE_REAL = "REAL";
    public static final String DTYPE_CHAR = "CHAR";
    public static final String DTYPE_DIAR = "DIARY";
    public static final String DTYPE_ENUM = "ENUM";
    public static final String DTYPE_TIME = "TIME";
    public static final String DTYPE_TIME_OF_DAY = "TIMEOFDAY";
    public static final String DTYPE_DECIMAL = "DECIMAL";
    public static final String DTYPE_DATE = "DATE";
    public static final String DTYPE_CURRENCY = "CURRENCY";
    public static final String DTYPE_ATTACH = "ATTACH";
    public static String lineSeparator = null;

    public List<String> parseDataSection(String string, int n) throws ARImportException {
        return this.a(DATA_TAG, string, n);
    }

    private List<String> a(String string, String string2, int n) throws ARImportException {
        if (string == null) {
            throw new ARImportException("Line tag was not supplied.");
        }
        int n2 = 32;
        int n3 = 32;
        int n4 = 32;
        int n5 = 32;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = string2.length();
        for (int i = string.length() + 1; i <= n6; ++i) {
            bl3 = true;
            if (n2 == 34) {
                if (!bl) {
                    bl = true;
                    bl3 = false;
                    bl2 = false;
                } else if (n3 == 92) {
                    if (n4 == 92) {
                        if (n5 == 92) {
                            int n7 = 0;
                            int n8 = i - 2;
                            char c = string2.charAt(n8);
                            while (c == '\\') {
                                ++n7;
                                c = string2.charAt(--n8);
                            }
                            if (n7 % 2 == 0) {
                                bl2 = true;
                                bl3 = false;
                            }
                        } else {
                            bl2 = true;
                            bl3 = false;
                        }
                    }
                } else {
                    bl2 = true;
                    bl3 = false;
                }
            }
            if (n2 == 32) {
                if (!bl) {
                    if (stringBuilder.length() > 0) {
                        if (string.equals(DATA_TAG)) {
                            arrayList.add(stringBuilder.toString().replace("\\\"", "\""));
                        } else {
                            arrayList.add(stringBuilder.toString().replace("\\\"", "\"").replace("\\\\", "\\"));
                        }
                    }
                    stringBuilder = new StringBuilder();
                    bl3 = false;
                    bl = false;
                    bl2 = false;
                } else if (bl2) {
                    if (string.equals(DATA_TAG)) {
                        arrayList.add(stringBuilder.toString().replace("\\\"", "\""));
                    } else {
                        arrayList.add(stringBuilder.toString().replace("\\\"", "\"").replace("\\\\", "\\"));
                    }
                    stringBuilder = new StringBuilder();
                    bl3 = false;
                    bl = false;
                    bl2 = false;
                }
            }
            if (bl3) {
                stringBuilder.append((char)n2);
            }
            n5 = n4;
            n4 = n3;
            n3 = n2;
            if (i != n6) {
                n2 = string2.charAt(i);
                continue;
            }
            if (n2 == 32) continue;
            if (string.equals(DATA_TAG)) {
                arrayList.add(stringBuilder.toString().replace("\\\"", "\""));
                continue;
            }
            arrayList.add(stringBuilder.toString().replace("\\\"", "\"").replace("\\\\", "\\"));
        }
        return arrayList;
    }

    public List<String> parseFieldSection(String string, int n) throws ARImportException {
        if (!string.startsWith(FIELDS_TAG)) {
            throw new ARImportException("String provided is not a FIELDS element.");
        }
        return this.a(FIELDS_TAG, string, n);
    }

    public List<String> parseFldIDSection(String string, int n) throws ARImportException {
        if (!string.startsWith(FLDID_TAG)) {
            throw new ARImportException("String provided is not a FLD-ID element.");
        }
        return this.a(FLDID_TAG, string, n);
    }

    public List<String> parseCharSetSection(String string, int n) throws ARImportException {
        if (!string.contains(CHARSET_TAG)) {
            throw new ARImportException("String provided is not a CHAR-SET element.");
        }
        return this.a(CHARSET_TAG, string, n);
    }

    public List<String> parseSchemaSection(String string, int n) throws ARImportException {
        if (!string.startsWith(SCHEMA_TAG)) {
            throw new ARImportException("String provided is not a SCHEMA element.");
        }
        return this.a(SCHEMA_TAG, string, n);
    }

    public List<String> parseDTypesSection(String string, int n) throws ARImportException {
        if (!string.startsWith(DTYPES_TAG)) {
            throw new ARImportException("String provided is not a DTYPES element.");
        }
        return this.a(DTYPES_TAG, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormInformation> extractFormInformation(String string, boolean bl) throws FileNotFoundException, UnsupportedEncodingException, ARImportException, IOException {
        Logger logger = ThreadLocalStorage.getLogger();
        ArrayList<FormInformation> arrayList = new ArrayList<FormInformation>();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)ImportErrors.EXTRACT_FORM_INFO.toDefMsg());
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.openFile(string, null);
            String string2 = null;
            String string3 = null;
            List<String> list = null;
            List<String> list2 = null;
            List<String> list3 = null;
            FormInformation formInformation = null;
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                if (string2.startsWith(SCHEMA_TAG)) {
                    if (string3 != null) {
                        throw new ARImportException(ImportErrors.PARSE_ERROR_ON_FORM_INFO.toDefMsg() + string3);
                    }
                    formInformation = null;
                    List<String> list4 = this.parseSchemaSection(string2, n);
                    if (list4 != null && list4.size() > 0) {
                        string3 = list4.get(0);
                    }
                } else if (string2.startsWith(FIELDS_TAG)) {
                    list = this.parseFieldSection(string2, n);
                } else if (string2.startsWith(FLDID_TAG)) {
                    list2 = this.parseFldIDSection(string2, n);
                } else if (string2.startsWith(DTYPES_TAG)) {
                    list3 = this.parseDTypesSection(string2, n);
                } else if (string2.startsWith(DATA_TAG) && formInformation != null) {
                    formInformation.setFileRecords(formInformation.getFileRecords() + 1);
                }
                if (string3 == null || list == null || list2 == null || list3 == null) continue;
                formInformation = this.a(string3, list, list2, list3);
                arrayList.add(formInformation);
                string3 = null;
                list = null;
                list2 = null;
                list3 = null;
            }
        }
        catch (IOException iOException) {
            logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PARSING_ARX_FILE.toDefMsg(), iOException), (Throwable)iOException);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return arrayList;
    }

    private FormInformation a(String string, List<String> list, List<String> list2, List<String> list3) throws ARImportException {
        if (list.size() != list2.size() || list.size() != list3.size() || list2.size() != list3.size()) {
            throw new ARImportException(ImportErrors.FIELD_COUNT_NOT_MATCHING.toDefMsg());
        }
        FormInformation formInformation = new FormInformation();
        formInformation.setName(string);
        for (int i = 0; i < list2.size(); ++i) {
            String string2 = list2.get(i);
            String string3 = list.get(i);
            String string4 = list3.get(i);
            FieldInformation fieldInformation = new FieldInformation();
            fieldInformation.setFieldId(Integer.parseInt(string2));
            fieldInformation.setName(string3);
            fieldInformation.setDataType(string4);
            fieldInformation.setTokenIndex(i);
            formInformation.getFields().put(fieldInformation.getFieldId(), fieldInformation);
        }
        return formInformation;
    }

    public BufferedReader openFile(String string, String string2) throws IOException, ARImportException {
        FileInputStream fileInputStream = new FileInputStream(string);
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            Object object;
            if (string2 != null && string2.length() > 0) {
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, string2);
            } else {
                object = new byte[3];
                if (fileInputStream.read((byte[])object) != -1) {
                    if (object[0] == UTF8_BOM[0] && object[1] == UTF8_BOM[1] && object[2] == UTF8_BOM[2]) {
                        fileInputStream.close();
                        fileInputStream = new FileInputStream(string);
                        inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "utf-8");
                    } else {
                        fileInputStream.close();
                        fileInputStream = new FileInputStream(string);
                        inputStreamReader = new InputStreamReader(fileInputStream);
                    }
                }
            }
            bufferedReader = new BufferedReader(inputStreamReader);
            if (string2 == null) {
                object = bufferedReader.readLine();
                String string3 = null;
                if (object != null && object.contains(CHARSET_TAG)) {
                    List<String> list = this.parseCharSetSection((String)object, 0);
                    string3 = list.get(0);
                    bufferedReader.close();
                    return this.openFile(string, string3);
                }
                bufferedReader.close();
                return this.openFile(string, "");
            }
            return bufferedReader;
        }
        catch (IOException iOException) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseFile(String string, String string2, ImportOptions importOptions) throws ARImportException, IOException, ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = this.openFile(string, string2);
            String string3 = null;
            FormInformation formInformation = null;
            String string4 = null;
            List<String> list = null;
            List<String> list2 = null;
            List<String> list3 = null;
            int n = 0;
            while ((string3 = bufferedReader.readLine()) != null && (!this.isAbort() || this.isAbort() && this.isCopyToLog())) {
                List<String> list4;
                ++n;
                if (this.isAbort() && this.isCopyToLog() && string3.startsWith(DATA_TAG)) {
                    this.fireEvent(new ParseEvent(1, null, string3));
                    continue;
                }
                if (string3.startsWith(DATA_TAG)) {
                    list4 = this.parseDataSection(string3, n);
                    this.fireEvent(new ParseEvent(1, list4, string3));
                    continue;
                }
                if (string3.startsWith(SCHEMA_TAG)) {
                    if (string4 != null) {
                        throw new ARImportException(ImportErrors.PARSE_ERROR_ON_FORM_INFO.toDefMsg() + string4);
                    }
                    list4 = this.parseSchemaSection(string3, n);
                    if (list4 != null && list4.size() > 0) {
                        string4 = list4.get(0);
                    }
                    if (string4 == null || list == null || list2 == null || list3 == null) continue;
                    formInformation = this.a(string4, list, list2, list3);
                    if (!importOptions.getFileForms().containsKey(string4)) {
                        importOptions.addFileForm(formInformation);
                    }
                    this.fireEvent(new ParseEvent(0, formInformation));
                    string4 = null;
                    list = null;
                    list2 = null;
                    list3 = null;
                    continue;
                }
                if (string3.startsWith(FIELDS_TAG)) {
                    list = this.parseFieldSection(string3, n);
                    if (string4 == null || list == null || list2 == null || list3 == null) continue;
                    formInformation = this.a(string4, list, list2, list3);
                    if (!importOptions.getFileForms().containsKey(string4)) {
                        importOptions.addFileForm(formInformation);
                    }
                    this.fireEvent(new ParseEvent(0, formInformation));
                    string4 = null;
                    list = null;
                    list2 = null;
                    list3 = null;
                    continue;
                }
                if (string3.startsWith(FLDID_TAG)) {
                    list2 = this.parseFldIDSection(string3, n);
                    if (string4 == null || list == null || list2 == null || list3 == null) continue;
                    formInformation = this.a(string4, list, list2, list3);
                    if (!importOptions.getFileForms().containsKey(string4)) {
                        importOptions.addFileForm(formInformation);
                    }
                    this.fireEvent(new ParseEvent(0, formInformation));
                    string4 = null;
                    list = null;
                    list2 = null;
                    list3 = null;
                    continue;
                }
                if (!string3.startsWith(DTYPES_TAG)) continue;
                list3 = this.parseDTypesSection(string3, n);
                if (string4 == null || list == null || list2 == null || list3 == null) continue;
                formInformation = this.a(string4, list, list2, list3);
                if (!importOptions.getFileForms().containsKey(string4)) {
                    importOptions.addFileForm(formInformation);
                }
                this.fireEvent(new ParseEvent(0, formInformation));
                string4 = null;
                list = null;
                list2 = null;
                list3 = null;
            }
            this.fireEvent(new ParseEvent(2));
        }
        catch (IOException iOException) {
            logger.error((Object)MessageFormat.format(ImportErrors.ERROR_PARSING_ARX_FILE.toDefMsg(), iOException), (Throwable)iOException);
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }
}

