/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.plugins;

import com.bmc.arsys.api.ARNativeAuthenticationInfo;
import com.bmc.arsys.api.internal.ARStructMemTypeInfo;
import com.bmc.arsys.api.internal.ARStructTypeInfo;
import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

@ARStructTypeInfo(Name="PluginContext", NumberOfMembers=3)
public class ARPluginContext
implements ARNativeAuthenticationInfo {
    public static final int PLUGIN_LOG_LEVEL_INFO = 0;
    public static final int PLUGIN_LOG_LEVEL_WARNING = 1;
    public static final int PLUGIN_LOG_LEVEL_ERROR = 2;
    public static final int PLUGIN_LOG_LEVEL_FATAL = 3;
    private static String AR_PLUGIN_USER_DEFINED_TAG = "userDefined";
    @ARStructMemTypeInfo(Name="mUserName", Offset=0)
    private String mUserName;
    @ARStructMemTypeInfo(Name="mSessionGUID", Offset=1)
    private String mSessionGUID;
    @ARStructMemTypeInfo(Name="mAuthString", Offset=2)
    private String mAuthString;
    private String[] mArgs;
    private ARPluginInfo mInfo;
    private String remoteHostCharSet;
    public static final int AR_INTERNAL_REQ_CONFIG = 10005;
    private static Logger logger = Logger.getLogger(ARPluginContext.class);
    private final ReentrantLock lock = new ReentrantLock();

    public ARPluginContext(String string, String string2, String string3) {
        this.mUserName = string;
        this.mSessionGUID = string2;
        this.mAuthString = string3;
    }

    public ARPluginContext(String string, String string2, String string3, String[] stringArray, ARPluginInfo aRPluginInfo) {
        this.mUserName = string;
        this.mSessionGUID = string2;
        this.mAuthString = string3;
        this.mArgs = stringArray;
        this.setPluginInfo(aRPluginInfo);
    }

    public ARPluginContext() {
    }

    public String[] getCmdLineArgs() {
        return this.mArgs;
    }

    void setCmdLineArgs(String[] stringArray) {
        this.mArgs = stringArray;
    }

    public ARPluginInfo getPluginInfo() {
        return this.mInfo;
    }

    void setPluginInfo(ARPluginInfo aRPluginInfo) {
        this.mInfo = aRPluginInfo;
    }

    public String getUser() {
        return this.mUserName;
    }

    public String getUserSessionGuid() {
        return this.mSessionGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logMessage(ARPluginInfo aRPluginInfo, int n, String string) {
        this.lock.lock();
        try {
            ARPluginInfo aRPluginInfo2 = aRPluginInfo;
            if (aRPluginInfo2 == null) {
                aRPluginInfo2 = this.mInfo;
            }
            String string2 = aRPluginInfo2 != null ? aRPluginInfo2.getName() : "";
            switch (n) {
                case 0: {
                    logger.info((Object)("<" + string2 + ">" + string));
                    return;
                }
                case 1: {
                    logger.warn((Object)("<" + string2 + ">" + string));
                    return;
                }
                case 2: {
                    logger.error((Object)("<" + string2 + ">" + string));
                    return;
                }
                case 3: {
                    logger.fatal((Object)("<" + string2 + ">" + string));
                    return;
                }
                default: {
                    logger.info((Object)("<" + string2 + ">" + string));
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void logMessage(int n, String string) {
        this.logMessage(this.mInfo, n, string);
    }

    public String getAuthString() {
        return this.mAuthString;
    }

    public String getConfigItem(ARPluginInfo aRPluginInfo, String string) {
        String string2 = null;
        if (aRPluginInfo != null) {
            string2 = aRPluginInfo.getName();
        }
        return ARPluginServerConfiguration.getInstance().getConfigValue(string2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigItem(ARPluginInfo aRPluginInfo, String string, String string2) {
        if (aRPluginInfo != null) {
            this.lock.lock();
            try {
                ARPluginServerConfiguration.getInstance().setConfigValue(aRPluginInfo.getName(), string, string2);
                ARPluginServerConfiguration.getInstance().saveConfiguration();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public String getConfigItem(String string) {
        String string2 = null;
        ARPluginInfo aRPluginInfo = this.mInfo;
        if (aRPluginInfo != null) {
            string2 = ARPluginServerConfiguration.getInstance().getConfigValue(aRPluginInfo.getName(), string);
        }
        return string2;
    }

    public void setConfigItem(String string, String string2) {
        ARPluginInfo aRPluginInfo = this.mInfo;
        if (string == null || string.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!string.startsWith(AR_PLUGIN_USER_DEFINED_TAG)) {
            stringBuffer.append(AR_PLUGIN_USER_DEFINED_TAG + ".");
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string);
        }
        if (aRPluginInfo != null) {
            ARPluginServerConfiguration.getInstance().setConfigValue(aRPluginInfo.getName(), stringBuffer.toString(), string2);
            ARPluginServerConfiguration.getInstance().saveConfiguration();
        }
    }

    public String getARConfigEntry(String string) {
        String string2 = "";
        if (string != null) {
            string2 = ARPluginServerConfiguration.getInstance().getARConfigEntry(string);
        }
        return string2;
    }

    public String getRemoteHostCharSet() {
        return this.remoteHostCharSet;
    }

    void setRemoteHostCharSet(String string) {
        this.remoteHostCharSet = string;
    }
}

