/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsconfig.helper;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FTSConfFileHelper {
    public static final String UTF_8 = "UTF-8";

    public static boolean isMemberWindows(String string) {
        boolean bl = false;
        if (string != null && string.startsWith("Windows ")) {
            bl = true;
        }
        return bl;
    }

    public static boolean is64bitWindows(String string) {
        Boolean bl = false;
        if (string != null && string.indexOf("64") >= 0) {
            bl = true;
        }
        return bl;
    }

    public static String getConfExtension() {
        String string = FTSConfFileHelper.getOsName();
        if (FTSConfFileHelper.isMemberWindows(string)) {
            return ".cfg";
        }
        return ".conf";
    }

    public static String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public static String getOsName() {
        return System.getProperty("os.name");
    }

    public static String getOsArchitecture() {
        return System.getProperty("os.arch");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static boolean digitsOnly(String string) {
        boolean bl = true;
        if (FTSConfFileHelper.isNullOrEmpty(string, true)) {
            bl = false;
        } else {
            char[] cArray = string.toCharArray();
            for (int i = 0; bl && i < cArray.length; ++i) {
                if (Character.isDigit(cArray[i])) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isNullOrEmpty(String string, boolean bl) {
        boolean bl2 = true;
        if (string != null) {
            String string2 = string;
            if (bl) {
                string2 = string2.trim();
            }
            if (string2.length() > 0) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public static String getUserDir() {
        return System.getProperty("user.dir");
    }

    public static String getJavaIOTmpdir() {
        return System.getProperty("java.io.tmpdir");
    }

    public static String getUserHome() {
        return System.getProperty("user.home");
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static void writeLines(List<String> list, File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            FTSConfFileHelper.createFile(file);
            fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, UTF_8);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            for (String string : list) {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Throwable throwable) {}
            }
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Throwable throwable) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static boolean createFile(File file) throws IOException {
        boolean bl = false;
        if (file != null) {
            bl = true;
            if (!file.exists()) {
                File file2 = file.getParentFile();
                if (file2 != null && !file2.exists()) {
                    bl = file2.mkdirs();
                }
                if (bl) {
                    try {
                        bl = file.createNewFile();
                    }
                    catch (IOException iOException) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        bl = file.createNewFile();
                    }
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file, String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            fileInputStream = new FileInputStream(file);
            inputStreamReader = string == null ? new InputStreamReader(fileInputStream) : new InputStreamReader((InputStream)fileInputStream, string);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable) {}
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Throwable throwable) {}
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return arrayList;
    }

    public static void writeStringToFile(String string, File file) throws IOException {
        FTSConfFileHelper.writeStringToFile(string, file, "UTF_8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(String string, File file, String string2) throws IOException {
        FTSConfFileHelper.createFile(file);
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            filterOutputStream = new BufferedOutputStream(fileOutputStream);
            outputStreamWriter = new OutputStreamWriter((OutputStream)filterOutputStream, string2);
            outputStreamWriter.write(string);
            outputStreamWriter.flush();
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (Throwable throwable) {}
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public static boolean nullableEquals(Object object, Object object2) {
        boolean bl = true;
        if (object == null) {
            if (object2 != null) {
                bl = false;
            }
        } else {
            bl = object2 == null ? false : object.equals(object2);
        }
        return bl;
    }
}

