/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.multipart.cos;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.core.io.Resource;
import com.bmc.thirdparty.org.springframework.web.context.ServletContextAware;
import com.bmc.thirdparty.org.springframework.web.multipart.MaxUploadSizeExceededException;
import com.bmc.thirdparty.org.springframework.web.multipart.MultipartException;
import com.bmc.thirdparty.org.springframework.web.multipart.MultipartHttpServletRequest;
import com.bmc.thirdparty.org.springframework.web.multipart.MultipartResolver;
import com.bmc.thirdparty.org.springframework.web.multipart.cos.CosMultipartHttpServletRequest;
import com.bmc.thirdparty.org.springframework.web.util.WebUtils;
import com.oreilly.servlet.MultipartRequest;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class CosMultipartResolver
implements MultipartResolver,
ServletContextAware {
    public static final String MULTIPART_CONTENT_TYPE = "multipart/form-data";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int maxUploadSize = Integer.MAX_VALUE;
    private String defaultEncoding = "ISO-8859-1";
    private File uploadTempDir;

    public CosMultipartResolver() {
    }

    public CosMultipartResolver(ServletContext servletContext) {
        this.uploadTempDir = WebUtils.getTempDir(servletContext);
    }

    public void setMaxUploadSize(int maxUploadSize) {
        this.maxUploadSize = maxUploadSize;
    }

    protected int getMaxUploadSize() {
        return this.maxUploadSize;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public void setUploadTempDir(Resource uploadTempDir) throws IOException {
        if (!uploadTempDir.exists() && !uploadTempDir.getFile().mkdirs()) {
            throw new IllegalArgumentException("Given uploadTempDir [" + uploadTempDir + "] could not be created");
        }
        this.uploadTempDir = uploadTempDir.getFile();
    }

    protected File getUploadTempDir() {
        return this.uploadTempDir;
    }

    public void setServletContext(ServletContext servletContext) {
        if (this.uploadTempDir == null) {
            this.uploadTempDir = WebUtils.getTempDir(servletContext);
        }
    }

    public boolean isMultipart(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().startsWith(MULTIPART_CONTENT_TYPE);
    }

    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        try {
            MultipartRequest multipartRequest = this.newMultipartRequest(request);
            if (this.logger.isDebugEnabled()) {
                Enumeration fileNames = multipartRequest.getFileNames();
                while (fileNames.hasMoreElements()) {
                    String fileName = (String)fileNames.nextElement();
                    File file = multipartRequest.getFile(fileName);
                    this.logger.debug("Found multipart file '" + fileName + "' of size " + (file != null ? file.length() : 0L) + " bytes with original filename [" + multipartRequest.getOriginalFileName(fileName) + "], " + (file != null ? "stored at [" + file.getAbsolutePath() + "]" : "empty"));
                }
            }
            return new CosMultipartHttpServletRequest(request, multipartRequest);
        }
        catch (IOException ex) {
            if (ex.getMessage().indexOf("exceeds limit") != -1) {
                throw new MaxUploadSizeExceededException(this.maxUploadSize, (Throwable)ex);
            }
            throw new MultipartException("Could not parse multipart request", ex);
        }
    }

    protected MultipartRequest newMultipartRequest(HttpServletRequest request) throws IOException {
        String tempPath = this.uploadTempDir.getAbsolutePath();
        String enc = this.determineEncoding(request);
        return new MultipartRequest(request, tempPath, this.maxUploadSize, enc);
    }

    protected String determineEncoding(HttpServletRequest request) {
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = this.defaultEncoding;
        }
        return enc;
    }

    public void cleanupMultipart(MultipartHttpServletRequest request) {
        MultipartRequest multipartRequest = ((CosMultipartHttpServletRequest)request).getMultipartRequest();
        Enumeration fileNames = multipartRequest.getFileNames();
        while (fileNames.hasMoreElements()) {
            String fileName = (String)fileNames.nextElement();
            File file = multipartRequest.getFile(fileName);
            if (file == null) continue;
            if (file.exists()) {
                if (file.delete()) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Cleaned up multipart file '" + fileName + "' with original filename [" + multipartRequest.getOriginalFileName(fileName) + "], stored at [" + file.getAbsolutePath() + "]");
                    continue;
                }
                this.logger.warn("Could not delete multipart file '" + fileName + "' with original filename [" + multipartRequest.getOriginalFileName(fileName) + "], stored at [" + file.getAbsolutePath() + "]");
                continue;
            }
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Multipart file '" + fileName + "' with original filename [" + multipartRequest.getOriginalFileName(fileName) + "] has already been moved - no cleanup necessary");
        }
    }
}

