/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.core;

import com.bmc.thirdparty.org.springframework.jdbc.core.RowCallbackHandler;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class RowCountCallbackHandler
implements RowCallbackHandler {
    private int rowCount;
    private int columnCount;
    private int[] columnTypes;
    private String[] columnNames;

    public final void processRow(ResultSet rs) throws SQLException {
        if (this.rowCount == 0) {
            ResultSetMetaData rsmd = rs.getMetaData();
            this.columnCount = rsmd.getColumnCount();
            this.columnTypes = new int[this.columnCount];
            this.columnNames = new String[this.columnCount];
            for (int i2 = 0; i2 < this.columnCount; ++i2) {
                this.columnTypes[i2] = rsmd.getColumnType(i2 + 1);
                this.columnNames[i2] = rsmd.getColumnName(i2 + 1);
            }
        }
        this.processRow(rs, this.rowCount++);
    }

    protected void processRow(ResultSet rs, int rowNum) throws SQLException {
    }

    public final int[] getColumnTypes() {
        return this.columnTypes;
    }

    public final String[] getColumnNames() {
        return this.columnNames;
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final int getColumnCount() {
        return this.columnCount;
    }
}

