/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.context.support;

import com.bmc.thirdparty.org.springframework.beans.BeansException;
import com.bmc.thirdparty.org.springframework.context.ApplicationContext;
import com.bmc.thirdparty.org.springframework.context.support.AbstractXmlApplicationContext;
import com.bmc.thirdparty.org.springframework.core.io.FileSystemResource;
import com.bmc.thirdparty.org.springframework.core.io.Resource;

public class FileSystemXmlApplicationContext
extends AbstractXmlApplicationContext {
    private String[] configLocations;

    public FileSystemXmlApplicationContext(String configLocation) throws BeansException {
        this(new String[]{configLocation});
    }

    public FileSystemXmlApplicationContext(String[] configLocations) throws BeansException {
        this(configLocations, null);
    }

    public FileSystemXmlApplicationContext(String[] configLocations, ApplicationContext parent) throws BeansException {
        super(parent);
        this.configLocations = configLocations;
        this.refresh();
    }

    public FileSystemXmlApplicationContext(String[] configLocations, boolean refresh) throws BeansException {
        this(configLocations, refresh, null);
    }

    public FileSystemXmlApplicationContext(String[] configLocations, boolean refresh, ApplicationContext parent) throws BeansException {
        super(parent);
        this.configLocations = configLocations;
        if (refresh) {
            this.refresh();
        }
    }

    protected String[] getConfigLocations() {
        return this.configLocations;
    }

    protected Resource getResourceByPath(String path) {
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        return new FileSystemResource(path);
    }
}

