/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.configuration;

import com.bmc.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.bmc.thirdparty.org.apache.commons.configuration.CombinedConfiguration;
import com.bmc.thirdparty.org.apache.commons.configuration.Configuration;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationBuilder;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationException;
import com.bmc.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.bmc.thirdparty.org.apache.commons.configuration.FileConfiguration;
import com.bmc.thirdparty.org.apache.commons.configuration.HierarchicalConfiguration;
import com.bmc.thirdparty.org.apache.commons.configuration.XMLConfiguration;
import com.bmc.thirdparty.org.apache.commons.configuration.beanutils.BeanDeclaration;
import com.bmc.thirdparty.org.apache.commons.configuration.beanutils.BeanFactory;
import com.bmc.thirdparty.org.apache.commons.configuration.beanutils.BeanHelper;
import com.bmc.thirdparty.org.apache.commons.configuration.beanutils.DefaultBeanFactory;
import com.bmc.thirdparty.org.apache.commons.configuration.beanutils.XMLBeanDeclaration;
import com.bmc.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import com.bmc.thirdparty.org.apache.commons.configuration.tree.OverrideCombiner;
import com.bmc.thirdparty.org.apache.commons.configuration.tree.UnionCombiner;
import com.bmc.thirdparty.org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultConfigurationBuilder
extends XMLConfiguration
implements ConfigurationBuilder {
    public static final String ADDITIONAL_NAME = (class$org$apache$commons$configuration$DefaultConfigurationBuilder == null ? (class$org$apache$commons$configuration$DefaultConfigurationBuilder = DefaultConfigurationBuilder.class$("com.bmc.thirdparty.org.apache.commons.configuration.DefaultConfigurationBuilder")) : class$org$apache$commons$configuration$DefaultConfigurationBuilder).getName() + "/ADDITIONAL_CONFIG";
    static final XPathExpressionEngine EXPRESSION_ENGINE = new XPathExpressionEngine();
    static final String CONFIG_BEAN_FACTORY_NAME = (class$org$apache$commons$configuration$DefaultConfigurationBuilder == null ? (class$org$apache$commons$configuration$DefaultConfigurationBuilder = DefaultConfigurationBuilder.class$("com.bmc.thirdparty.org.apache.commons.configuration.DefaultConfigurationBuilder")) : class$org$apache$commons$configuration$DefaultConfigurationBuilder).getName() + ".CONFIG_BEAN_FACTORY_NAME";
    static final String ATTR_NAME = "[@config-name]";
    static final String ATTR_ATNAME = "at";
    static final String ATTR_AT_RES = "[@config-at]";
    static final String ATTR_AT = "[@at]";
    static final String ATTR_OPTIONALNAME = "optional";
    static final String ATTR_OPTIONAL_RES = "[@config-optional]";
    static final String ATTR_OPTIONAL = "[@optional]";
    static final String ATTR_FILENAME = "[@fileName]";
    static final String SEC_HEADER = "header";
    static final String KEY_UNION = "/additional/*";
    static final String KEY_OVERRIDE1 = "/*[local-name() != 'additional' and local-name() != 'override' and local-name() != 'header']";
    static final String KEY_OVERRIDE2 = "/override/*";
    static final String KEY_OVERRIDE_LIST = "header/combiner/override/list-nodes/node";
    static final String KEY_ADDITIONAL_LIST = "header/combiner/additional/list-nodes/node";
    static final String KEY_RESULT = "header/result";
    static final String KEY_COMBINER = "header/result/nodeCombiner";
    static final String EXT_XML = ".xml";
    private static final ConfigurationProvider PROPERTIES_PROVIDER = new FileExtensionConfigurationProvider(class$org$apache$commons$configuration$XMLPropertiesConfiguration == null ? (class$org$apache$commons$configuration$XMLPropertiesConfiguration = DefaultConfigurationBuilder.class$("com.bmc.thirdparty.org.apache.commons.configuration.XMLPropertiesConfiguration")) : class$org$apache$commons$configuration$XMLPropertiesConfiguration, class$org$apache$commons$configuration$PropertiesConfiguration == null ? (class$org$apache$commons$configuration$PropertiesConfiguration = DefaultConfigurationBuilder.class$("com.bmc.thirdparty.org.apache.commons.configuration.PropertiesConfiguration")) : class$org$apache$commons$configuration$PropertiesConfiguration, ".xml");
    private static final ConfigurationProvider XML_PROVIDER = new FileConfigurationProvider(class$org$apache$commons$configuration$XMLConfiguration == null ? (class$org$apache$commons$configuration$XMLConfiguration = DefaultConfigurationBuilder.class$("com.bmc.thirdparty.org.apache.commons.configuration.XMLConfiguration")) : class$org$apache$commons$configuration$XMLConfiguration);
    private static final ConfigurationProvider JNDI_PROVIDER = new ConfigurationProvider(class$org$apache$commons$configuration$JNDIConfiguration == null ? (class$org$apache$commons$configuration$JNDIConfiguration = DefaultConfigurationBuilder.class$("com.bmc.thirdparty.org.apache.commons.configuration.JNDIConfiguration")) : class$org$apache$commons$configuration$JNDIConfiguration);
    private static final ConfigurationProvider SYSTEM_PROVIDER = new ConfigurationProvider(class$org$apache$commons$configuration$SystemConfiguration == null ? (class$org$apache$commons$configuration$SystemConfiguration = DefaultConfigurationBuilder.class$("com.bmc.thirdparty.org.apache.commons.configuration.SystemConfiguration")) : class$org$apache$commons$configuration$SystemConfiguration);
    private static final ConfigurationProvider PLIST_PROVIDER = new FileExtensionConfigurationProvider(class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration == null ? (class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration = DefaultConfigurationBuilder.class$("com.bmc.thirdparty.org.apache.commons.configuration.plist.XMLPropertyListConfiguration")) : class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration, class$org$apache$commons$configuration$plist$PropertyListConfiguration == null ? (class$org$apache$commons$configuration$plist$PropertyListConfiguration = DefaultConfigurationBuilder.class$("com.bmc.thirdparty.org.apache.commons.configuration.plist.PropertyListConfiguration")) : class$org$apache$commons$configuration$plist$PropertyListConfiguration, ".xml");
    private static final ConfigurationProvider BUILDER_PROVIDER = new ConfigurationBuilderProvider();
    private static final String[] DEFAULT_TAGS = new String[]{"properties", "xml", "hierarchicalXml", "jndi", "system", "plist", "configuration"};
    private static final ConfigurationProvider[] DEFAULT_PROVIDERS = new ConfigurationProvider[]{PROPERTIES_PROVIDER, XML_PROVIDER, XML_PROVIDER, JNDI_PROVIDER, SYSTEM_PROVIDER, PLIST_PROVIDER, BUILDER_PROVIDER};
    private static final long serialVersionUID = -3113777854714492123L;
    private CombinedConfiguration constructedConfiguration;
    private Map providers = new HashMap();
    private String configurationBasePath;
    static /* synthetic */ Class class$org$apache$commons$configuration$DefaultConfigurationBuilder;
    static /* synthetic */ Class class$org$apache$commons$configuration$XMLPropertiesConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$PropertiesConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$XMLConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$JNDIConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$SystemConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$plist$XMLPropertyListConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$plist$PropertyListConfiguration;
    static /* synthetic */ Class class$org$apache$commons$configuration$CombinedConfiguration;

    public DefaultConfigurationBuilder() {
        this.setExpressionEngine(EXPRESSION_ENGINE);
        this.registerDefaultProviders();
    }

    public DefaultConfigurationBuilder(File file) {
        this();
        this.setFile(file);
    }

    public DefaultConfigurationBuilder(String fileName) throws ConfigurationException {
        this();
        this.setFileName(fileName);
    }

    public DefaultConfigurationBuilder(URL url) throws ConfigurationException {
        this();
        this.setURL(url);
    }

    public String getConfigurationBasePath() {
        return this.configurationBasePath != null ? this.configurationBasePath : this.getBasePath();
    }

    public void setConfigurationBasePath(String configurationBasePath) {
        this.configurationBasePath = configurationBasePath;
    }

    public void addConfigurationProvider(String tagName, ConfigurationProvider provider) {
        if (tagName == null) {
            throw new IllegalArgumentException("Tag name must not be null!");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Provider must not be null!");
        }
        this.providers.put(tagName, provider);
    }

    public ConfigurationProvider removeConfigurationProvider(String tagName) {
        return (ConfigurationProvider)this.providers.remove(tagName);
    }

    public ConfigurationProvider providerForTag(String tagName) {
        return (ConfigurationProvider)this.providers.get(tagName);
    }

    public Configuration getConfiguration() throws ConfigurationException {
        return this.getConfiguration(true);
    }

    public CombinedConfiguration getConfiguration(boolean load) throws ConfigurationException {
        CombinedConfiguration result;
        if (load) {
            this.load();
        }
        this.constructedConfiguration = result = this.createResultConfiguration();
        List overrides = this.configurationsAt(KEY_OVERRIDE1);
        overrides.addAll(this.configurationsAt(KEY_OVERRIDE2));
        this.initCombinedConfiguration(result, overrides, KEY_OVERRIDE_LIST);
        List additionals = this.configurationsAt(KEY_UNION);
        if (!additionals.isEmpty()) {
            CombinedConfiguration addConfig = new CombinedConfiguration(new UnionCombiner());
            result.addConfiguration(addConfig, ADDITIONAL_NAME);
            this.initCombinedConfiguration(addConfig, additionals, KEY_ADDITIONAL_LIST);
        }
        return result;
    }

    protected CombinedConfiguration createResultConfiguration() throws ConfigurationException {
        XMLBeanDeclaration decl = new XMLBeanDeclaration(this, KEY_RESULT, true);
        CombinedConfiguration result = (CombinedConfiguration)BeanHelper.createBean(decl, class$org$apache$commons$configuration$CombinedConfiguration == null ? (class$org$apache$commons$configuration$CombinedConfiguration = DefaultConfigurationBuilder.class$("com.bmc.thirdparty.org.apache.commons.configuration.CombinedConfiguration")) : class$org$apache$commons$configuration$CombinedConfiguration);
        if (this.getMaxIndex(KEY_COMBINER) < 0) {
            result.setNodeCombiner(new OverrideCombiner());
        }
        return result;
    }

    protected void initCombinedConfiguration(CombinedConfiguration config, List containedConfigs, String keyListNodes) throws ConfigurationException {
        List listNodes = this.getList(keyListNodes);
        Iterator it = listNodes.iterator();
        while (it.hasNext()) {
            config.getNodeCombiner().addListNode((String)it.next());
        }
        Iterator it2 = containedConfigs.iterator();
        while (it2.hasNext()) {
            HierarchicalConfiguration conf = (HierarchicalConfiguration)it2.next();
            ConfigurationDeclaration decl = new ConfigurationDeclaration(this, conf);
            AbstractConfiguration newConf = this.createConfigurationAt(decl);
            if (newConf == null) continue;
            config.addConfiguration(newConf, decl.getConfiguration().getString(ATTR_NAME), decl.getAt());
        }
    }

    protected void registerDefaultProviders() {
        int i2 = 0;
        while (i2 < DEFAULT_TAGS.length) {
            this.addConfigurationProvider(DEFAULT_TAGS[i2], DEFAULT_PROVIDERS[i2]);
            ++i2;
        }
    }

    protected Object interpolate(Object value) {
        Object result = super.interpolate(value);
        if (this.constructedConfiguration != null) {
            result = this.constructedConfiguration.interpolate(result);
        }
        return result;
    }

    private AbstractConfiguration createConfigurationAt(ConfigurationDeclaration decl) throws ConfigurationException {
        try {
            return (AbstractConfiguration)BeanHelper.createBean(decl);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BeanHelper.registerBeanFactory(CONFIG_BEAN_FACTORY_NAME, new ConfigurationBeanFactory());
    }

    static class ConfigurationBuilderProvider
    extends ConfigurationProvider {
        static /* synthetic */ Class class$org$apache$commons$configuration$DefaultConfigurationBuilder;

        public ConfigurationBuilderProvider() {
            super(class$org$apache$commons$configuration$DefaultConfigurationBuilder == null ? (class$org$apache$commons$configuration$DefaultConfigurationBuilder = ConfigurationBuilderProvider.class$("com.bmc.thirdparty.org.apache.commons.configuration.DefaultConfigurationBuilder")) : class$org$apache$commons$configuration$DefaultConfigurationBuilder);
        }

        public AbstractConfiguration getConfiguration(ConfigurationDeclaration decl) throws Exception {
            DefaultConfigurationBuilder builder = (DefaultConfigurationBuilder)super.getConfiguration(decl);
            return builder.getConfiguration(true);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    static class FileExtensionConfigurationProvider
    extends FileConfigurationProvider {
        private Class matchingClass;
        private Class defaultClass;
        private String fileExtension;

        public FileExtensionConfigurationProvider(Class matchingClass, Class defaultClass, String extension) {
            this.matchingClass = matchingClass;
            this.defaultClass = defaultClass;
            this.fileExtension = extension;
        }

        protected Object createBeanInstance(Class beanClass, BeanDeclaration data) throws Exception {
            String fileName = ((ConfigurationDeclaration)data).getConfiguration().getString(DefaultConfigurationBuilder.ATTR_FILENAME);
            if (fileName != null && fileName.toLowerCase().trim().endsWith(this.fileExtension)) {
                return super.createBeanInstance(this.matchingClass, data);
            }
            return super.createBeanInstance(this.defaultClass, data);
        }
    }

    public static class FileConfigurationProvider
    extends ConfigurationProvider {
        public FileConfigurationProvider() {
        }

        public FileConfigurationProvider(Class configClass) {
            super(configClass);
        }

        public AbstractConfiguration getConfiguration(ConfigurationDeclaration decl) throws Exception {
            FileConfiguration config = (FileConfiguration)((Object)super.getConfiguration(decl));
            config.load();
            return (AbstractConfiguration)((Object)config);
        }

        protected void initBeanInstance(Object bean, BeanDeclaration data) throws Exception {
            FileConfiguration config = (FileConfiguration)bean;
            config.setBasePath(((ConfigurationDeclaration)data).getConfigurationBuilder().getConfigurationBasePath());
            super.initBeanInstance(bean, data);
        }
    }

    static class ConfigurationBeanFactory
    implements BeanFactory {
        static /* synthetic */ Class class$org$apache$commons$configuration$Configuration;

        ConfigurationBeanFactory() {
        }

        public Object createBean(Class beanClass, BeanDeclaration data, Object param) throws Exception {
            ConfigurationDeclaration decl = (ConfigurationDeclaration)data;
            String tagName = decl.getNode().getName();
            ConfigurationProvider provider = decl.getConfigurationBuilder().providerForTag(tagName);
            if (provider == null) {
                throw new ConfigurationRuntimeException("No ConfigurationProvider registered for tag " + tagName);
            }
            try {
                return provider.getConfiguration(decl);
            }
            catch (Exception ex) {
                if (!decl.isOptional()) {
                    throw ex;
                }
                return null;
            }
        }

        public Class getDefaultBeanClass() {
            return class$org$apache$commons$configuration$Configuration == null ? (class$org$apache$commons$configuration$Configuration = ConfigurationBeanFactory.class$("com.bmc.thirdparty.org.apache.commons.configuration.Configuration")) : class$org$apache$commons$configuration$Configuration;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    protected static class ConfigurationDeclaration
    extends XMLBeanDeclaration {
        private DefaultConfigurationBuilder configurationBuilder;

        public ConfigurationDeclaration(DefaultConfigurationBuilder builder, HierarchicalConfiguration config) {
            super(config);
            this.configurationBuilder = builder;
        }

        public DefaultConfigurationBuilder getConfigurationBuilder() {
            return this.configurationBuilder;
        }

        public String getAt() {
            String result = this.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_AT_RES);
            return result == null ? this.getConfiguration().getString(DefaultConfigurationBuilder.ATTR_AT) : result;
        }

        public boolean isOptional() {
            Boolean value = this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_OPTIONAL_RES, null);
            if (value == null) {
                value = this.getConfiguration().getBoolean(DefaultConfigurationBuilder.ATTR_OPTIONAL, Boolean.FALSE);
            }
            return value;
        }

        public String getBeanFactoryName() {
            return CONFIG_BEAN_FACTORY_NAME;
        }

        public String getBeanClassName() {
            return null;
        }

        protected boolean isReservedNode(ConfigurationNode nd) {
            if (super.isReservedNode(nd)) {
                return true;
            }
            return nd.isAttribute() && (DefaultConfigurationBuilder.ATTR_ATNAME.equals(nd.getName()) && nd.getParentNode().getAttributeCount("config-at") == 0 || DefaultConfigurationBuilder.ATTR_OPTIONALNAME.equals(nd.getName()) && nd.getParentNode().getAttributeCount("config-optional") == 0);
        }

        protected Object interpolate(Object value) {
            return this.getConfigurationBuilder().interpolate(value);
        }
    }

    public static class ConfigurationProvider
    extends DefaultBeanFactory {
        private Class configurationClass;

        public ConfigurationProvider() {
            this(null);
        }

        public ConfigurationProvider(Class configClass) {
            this.setConfigurationClass(configClass);
        }

        public Class getConfigurationClass() {
            return this.configurationClass;
        }

        public void setConfigurationClass(Class configurationClass) {
            this.configurationClass = configurationClass;
        }

        public AbstractConfiguration getConfiguration(ConfigurationDeclaration decl) throws Exception {
            return (AbstractConfiguration)this.createBean(this.getConfigurationClass(), decl, null);
        }
    }
}

