/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apitransport.chunking;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.apitransport.chunking.ARChunkReceiveProcessor;
import com.bmc.arsys.arrpc.xdr.ArRpcXdrOut;
import com.bmc.arsys.utils.StringByteUtil;
import org.apache.log4j.Logger;

public abstract class ARChunkArrayBuffer
extends ARChunkReceiveProcessor {
    private static Logger j = Logger.getLogger(ARChunkArrayBuffer.class);
    protected byte[] bytesBuffer;
    private int k;

    public void retrieveChunkingData(ArRpcXdrOut arRpcXdrOut) throws ARException {
        super.retrieveChunkingData(arRpcXdrOut);
        byte[] byArray = this.getOutPutByteBuffer(arRpcXdrOut);
        if (byArray == null) {
            return;
        }
        j.debug("retrieveChunkingData: received data len= " + byArray.length);
        if (this.bytesBuffer == null) {
            int n2 = this.getHeaderLen();
            this.bytesBuffer = StringByteUtil.getByteArrays(byArray, n2, byArray.length - n2);
            j.debug("retrieveChunkingData: headerLen=" + n2 + " buffer len=" + this.bytesBuffer.length);
        } else {
            this.bytesBuffer = StringByteUtil.concatenateByteArrays(this.bytesBuffer, byArray);
            j.debug("retrieveChunkingData: concatenated buffer len=" + this.bytesBuffer.length);
        }
    }

    public void postProcess(ArRpcXdrOut arRpcXdrOut) throws ARException {
        if (this.isCompressed()) {
            if (this.bytesBuffer != null) {
                j.debug("postProcess: compressed data, len=" + this.bytesBuffer.length);
            }
            this.bytesBuffer = this.inflateBytes(this.bytesBuffer);
            if (this.bytesBuffer != null) {
                j.debug("postProcess: decompressed data, len=" + this.bytesBuffer.length);
            }
        }
        this.setBackOutPutByteBuffer(arRpcXdrOut);
    }

    int getHeaderLen() {
        return this.k;
    }

    protected void setHeaderLen(int n2) {
        this.k = n2;
    }

    protected abstract byte[] getOutPutByteBuffer(ArRpcXdrOut var1);

    protected abstract void setBackOutPutByteBuffer(ArRpcXdrOut var1);
}

