/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.PerfJavaDriver;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfThreadControlBlock
extends ThreadControlBlock {
    long auxCount;
    private int resultFileCount;
    private String resultFileName;
    PrintWriter resultFile;
    Stack<String> resultStack;

    @Override
    public boolean isResultFileOpened() {
        if ((PerfJavaDriver.getOutputSetting() & PerfJavaDriver.OUT_MODE_PERF_LOG_MEM) != 0L) {
            return this.resultStack != null;
        }
        return this.resultFile != null;
    }

    @Override
    public void writeInResultFile(String string) {
        if ((PerfJavaDriver.getOutputSetting() & PerfJavaDriver.OUT_MODE_PERF_LOG_MEM) != 0L) {
            if (this.resultStack == null) {
                this.resultStack = new Stack();
            }
            this.resultStack.push(string);
        } else if (PerfJavaDriver.isForOutputFile()) {
            this.resultFile.println(string);
        }
    }

    @Override
    protected void logTransaction(String string) throws IOException {
        super.logTransaction(string);
        if (!JavaDriver.javaDriverOnly && (PerfJavaDriver.getOutputSetting() & (PerfJavaDriver.OUT_MODE_PERF_LOG | PerfJavaDriver.OUT_MODE_PERF_LOG_MEM)) != 0L) {
            if (this.getResultFile() == null) {
                this.initLogMethod();
            }
            this.writeInResultFile(string);
            if (string.startsWith("## transaction end") && this.resultFile != null) {
                this.resultFile.flush();
            }
        }
    }

    public void initLogMethod() throws IOException {
        if ((PerfJavaDriver.getOutputSetting() & PerfJavaDriver.OUT_MODE_PERF_LOG_MEM) != 0L) {
            this.setResultStack();
        } else {
            String string = this.preparePerfResultFileName();
            this.setResultFile(string);
            if (this.getOutputFileName() != null) {
                this.writeInResultFile("\nCorresponding Output File: " + this.getOutputFileName() + "\n");
            }
        }
    }

    protected String preparePerfResultFileName() {
        this.resultFileCount = PerfJavaDriver.getAndIncrementTheFileCount();
        String string = String.valueOf(this.resultFileCount);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = string.length(); i < 5; ++i) {
            stringBuilder.append("0");
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("perf_").append(stringBuilder.toString()).append(string).append(".log");
        String string2 = stringBuilder2.toString();
        if (JavaDriver.getResultDirectory() != null) {
            string2 = JavaDriver.getResultDirectory() + "\\" + string2;
        }
        return string2;
    }

    public long getAuxCount() {
        return this.auxCount;
    }

    public void setAuxCount(long l) {
        this.auxCount = l;
    }

    public Stack<String> getResultStack() {
        return this.resultStack;
    }

    public PrintWriter getResultFile() {
        return this.resultFile;
    }

    public void closeResultFile() {
        if (this.resultFile != null) {
            this.resultFile.flush();
            this.resultFile.close();
            this.resultFile = null;
        }
    }

    public void closeResultStack() {
        if (this.resultStack != null && !this.resultStack.empty()) {
            this.resultStack.clear();
        }
    }

    public void setResultStack() {
        this.resultStack = new Stack();
    }

    public void setResultFile(String string) throws IOException {
        this.resultFileName = string;
        this.resultFile = new PrintWriter(new FileOutputStream(new File(string)));
    }

    public boolean hasResultFile() {
        return this.resultFileName != null;
    }

    public void setResultFileCount(int n) {
        this.resultFileCount = n;
    }

    public int getResultFileCount() {
        return this.resultFileCount;
    }

    @Override
    protected void threadSleep(long l) {
        long l2 = l / 1L;
        long l3 = System.currentTimeMillis() - PerfJavaDriver.driverStartTime;
        String string = PerfJavaDriver.getStatString(l3, this.getCurrentCommand(), 0L, l2);
        this.writeInResultFile(string);
        if (this.resultFile != null) {
            this.resultFile.flush();
        }
        super.threadSleep(l2);
    }
}

