/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.apache.commons.configuration.event;

import com.bmc.thirdparty.org.apache.commons.configuration.event.ConfigurationEvent;
import com.bmc.thirdparty.org.apache.commons.configuration.event.ConfigurationListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class EventSource {
    private Collection listeners;
    private int detailEvents;

    public EventSource() {
        this.clearConfigurationListeners();
    }

    public void addConfigurationListener(ConfigurationListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException("Listener must not be null!");
        }
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l2);
        }
    }

    public boolean removeConfigurationListener(ConfigurationListener l2) {
        Collection collection = this.listeners;
        synchronized (collection) {
            boolean bl = this.listeners.remove(l2);
            return bl;
        }
    }

    public Collection getConfigurationListeners() {
        Collection collection = this.listeners;
        synchronized (collection) {
            Collection collection2 = Collections.unmodifiableCollection(this.listeners);
            return collection2;
        }
    }

    public void clearConfigurationListeners() {
        this.listeners = new LinkedList();
    }

    public boolean isDetailEvents() {
        Collection collection = this.listeners;
        synchronized (collection) {
            boolean bl = this.detailEvents > 0;
            return bl;
        }
    }

    public void setDetailEvents(boolean enable) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.detailEvents = enable ? ++this.detailEvents : --this.detailEvents;
        }
    }

    protected void fireEvent(int type, String propName, Object propValue, boolean before) {
        ArrayList listenersToCall = null;
        Collection collection = this.listeners;
        synchronized (collection) {
            if (this.detailEvents >= 0 && this.listeners.size() > 0) {
                listenersToCall = new ArrayList(this.listeners);
            }
        }
        if (listenersToCall != null) {
            ConfigurationEvent event = this.createEvent(type, propName, propValue, before);
            Iterator it = listenersToCall.iterator();
            while (it.hasNext()) {
                ((ConfigurationListener)it.next()).configurationChanged(event);
            }
        }
    }

    protected ConfigurationEvent createEvent(int type, String propName, Object propValue, boolean before) {
        return new ConfigurationEvent(this, type, propName, propValue, before);
    }
}

