/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.api;

import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ARTypeMgr;
import com.bmc.arsys.api.ArithmeticOperationInfo;
import com.bmc.arsys.api.Config;
import com.bmc.arsys.api.CurrencyPartInfo;
import com.bmc.arsys.api.IQuerySource;
import com.bmc.arsys.api.OperandType;
import com.bmc.arsys.api.QueryFormField;
import com.bmc.arsys.api.QueryInfo;
import com.bmc.arsys.api.StatusHistoryValueIndicator;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.ValueSetQuery;
import com.bmc.arsys.api.internal.ConversionUtil;
import com.bmc.thirdparty.org.apache.commons.lang.builder.EqualsBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.HashCodeBuilder;
import com.bmc.thirdparty.org.apache.commons.lang.builder.ToStringBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArithmeticOrRelationalOperand
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 7278982475786875358L;
    private OperandType m_operandType;
    private Object m_operand;

    ArithmeticOrRelationalOperand() {
        this.m_operandType = null;
        this.m_operand = null;
    }

    public ArithmeticOrRelationalOperand(OperandType operandType, int n2) {
        if (!(OperandType.FIELDID.equals(operandType) || OperandType.FIELDID_CURRENT.equals(operandType) || OperandType.FIELDID_TRANSACTION.equals(operandType) || OperandType.FIELDID_DB.equals(operandType) || operandType.toInt() >= 12 || operandType.toInt() <= 26)) {
            throw new IllegalArgumentException("datatype not supported by this method");
        }
        this.m_operandType = operandType;
        this.m_operand = new Integer(n2);
    }

    public ArithmeticOrRelationalOperand(int n2) {
        this.m_operandType = OperandType.FIELDID;
        this.m_operand = new Integer(n2);
    }

    public ArithmeticOrRelationalOperand(int n2, IQuerySource iQuerySource) {
        this.m_operandType = OperandType.FIELDID;
        this.m_operand = new QueryFormField(n2, iQuerySource);
    }

    public ArithmeticOrRelationalOperand(int n2, int n3, IQuerySource iQuerySource) {
        this.m_operandType = OperandType.FIELDID;
        this.m_operand = new QueryFormField(n2, n3, iQuerySource);
    }

    public ArithmeticOrRelationalOperand(QueryFormField queryFormField) {
        this.m_operandType = OperandType.FIELDID;
        this.m_operand = new QueryFormField(queryFormField.getFieldId(), queryFormField.getFuncId(), queryFormField.getSource());
    }

    public ArithmeticOrRelationalOperand(int n2, int n3) {
        this.m_operandType = this.toOperandType(n2);
        this.m_operand = new Integer(n3);
    }

    public ArithmeticOrRelationalOperand(Value value) {
        this.m_operandType = OperandType.VALUE;
        this.m_operand = value;
    }

    public ArithmeticOrRelationalOperand(ArithmeticOperationInfo arithmeticOperationInfo) {
        this.m_operandType = OperandType.ARITHMETIC_OP;
        this.m_operand = arithmeticOperationInfo;
    }

    public ArithmeticOrRelationalOperand(StatusHistoryValueIndicator statusHistoryValueIndicator) {
        this.m_operandType = OperandType.STATUS_HISTORY;
        this.m_operand = statusHistoryValueIndicator;
    }

    public ArithmeticOrRelationalOperand(List<Value> list) {
        this.m_operandType = OperandType.VALUE_SET;
        this.m_operand = list;
    }

    public ArithmeticOrRelationalOperand(CurrencyPartInfo currencyPartInfo) {
        this.m_operandType = OperandType.CURRENCY_FLD;
        this.m_operand = currencyPartInfo;
    }

    public ArithmeticOrRelationalOperand(OperandType operandType, CurrencyPartInfo currencyPartInfo) {
        this.m_operandType = operandType;
        this.m_operand = currencyPartInfo;
    }

    public ArithmeticOrRelationalOperand(int n2, CurrencyPartInfo currencyPartInfo) {
        this.m_operandType = this.toOperandType(n2);
        this.m_operand = currencyPartInfo;
    }

    public ArithmeticOrRelationalOperand(QueryInfo queryInfo) {
        this.m_operandType = OperandType.QUERY_INFO;
        this.m_operand = queryInfo;
    }

    public ArithmeticOrRelationalOperand(ValueSetQuery valueSetQuery) {
        this.m_operandType = OperandType.VALUE_SET_QUERY;
        this.m_operand = valueSetQuery;
    }

    OperandType toOperandType(int n2) {
        switch (n2) {
            case 1: {
                return OperandType.FIELDID;
            }
            case 2: {
                return OperandType.VALUE;
            }
            case 3: {
                return OperandType.ARITHMETIC_OP;
            }
            case 4: {
                return OperandType.STATUS_HISTORY;
            }
            case 5: {
                return OperandType.VALUE_SET;
            }
            case 6: {
                return OperandType.CURRENCY_FLD;
            }
            case 7: {
                return OperandType.VALUE_SET_QUERY;
            }
            case 50: {
                return OperandType.FIELDID_TRANSACTION;
            }
            case 51: {
                return OperandType.FIELDID_DB;
            }
            case 99: {
                return OperandType.FIELDID_CURRENT;
            }
            case 52: {
                return OperandType.LOCAL_VARIABLE;
            }
            case 53: {
                return OperandType.QUERY_INFO;
            }
            case 54: {
                return OperandType.CURRENCY_FLD_TRAN;
            }
            case 55: {
                return OperandType.CURRENCY_FLD_DB;
            }
            case 56: {
                return OperandType.CURRENCY_FLD_CURRENT;
            }
        }
        if (n2 >= 12 && n2 <= 26) {
            return OperandType.getOperandType(n2);
        }
        return null;
    }

    public OperandType getType() {
        return this.m_operandType;
    }

    public Object getValue() {
        return this.m_operand;
    }

    int getTypeInt() {
        return this.m_operandType.toInt();
    }

    int getIntValue() {
        return (Integer)this.m_operand;
    }

    public void setValue(Value value) {
        this.m_operandType = OperandType.VALUE;
        this.m_operand = value;
    }

    public Object clone() throws CloneNotSupportedException {
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = (ArithmeticOrRelationalOperand)super.clone();
        if (this.m_operand != null) {
            switch (this.getTypeInt()) {
                case 1: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 50: 
                case 51: 
                case 99: {
                    if (arithmeticOrRelationalOperand.m_operand instanceof QueryFormField) {
                        arithmeticOrRelationalOperand.m_operand = ((QueryFormField)this.m_operand).clone();
                        break;
                    }
                    arithmeticOrRelationalOperand.m_operand = new Integer(this.getIntValue());
                    break;
                }
                case 2: {
                    arithmeticOrRelationalOperand.m_operand = ((Value)this.m_operand).clone();
                    break;
                }
                case 3: {
                    arithmeticOrRelationalOperand.m_operand = ((ArithmeticOperationInfo)this.m_operand).clone();
                    break;
                }
                case 6: 
                case 54: 
                case 55: 
                case 56: {
                    arithmeticOrRelationalOperand.m_operand = ((CurrencyPartInfo)this.m_operand).clone();
                    break;
                }
                case 4: {
                    arithmeticOrRelationalOperand.m_operand = ((StatusHistoryValueIndicator)this.m_operand).clone();
                    break;
                }
                case 5: {
                    List list = (List)this.m_operand;
                    int n2 = list.size();
                    ArrayList<Value> arrayList = new ArrayList<Value>(n2);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Value value = (Value)list.get(i2);
                        if (value != null) {
                            arrayList.add((Value)value.clone());
                            continue;
                        }
                        arrayList.add(null);
                    }
                    arithmeticOrRelationalOperand.m_operand = arrayList;
                    break;
                }
                case 52: {
                    arithmeticOrRelationalOperand.m_operand = new Integer(this.getIntValue());
                    break;
                }
                case 53: {
                    arithmeticOrRelationalOperand.m_operand = ((QueryInfo)this.m_operand).clone();
                    break;
                }
                case 7: {
                    arithmeticOrRelationalOperand.m_operand = ((ValueSetQuery)this.m_operand).clone();
                    break;
                }
                default: {
                    arithmeticOrRelationalOperand.m_operand = null;
                }
            }
        }
        return arithmeticOrRelationalOperand;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ArithmeticOrRelationalOperand)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = (ArithmeticOrRelationalOperand)object;
        return new EqualsBuilder().append(this.m_operandType, arithmeticOrRelationalOperand.m_operandType).append(this.m_operand, arithmeticOrRelationalOperand.m_operand).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.m_operandType).append(this.m_operand).toHashCode();
    }

    void fromVariant(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return;
        }
        int n2 = ConversionUtil.getIntValue(ARTypeMgr.GetAt((Object)objectArray, 0));
        this.m_operandType = OperandType.getOperandType(n2);
        Object object = ARTypeMgr.GetAt((Object)objectArray, 1);
        switch (n2) {
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 50: 
            case 51: 
            case 99: {
                this.m_operand = new Integer(ConversionUtil.getIntValue(object));
                break;
            }
            case 2: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(Value.class, object, aRServerUser);
                break;
            }
            case 3: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(ArithmeticOperationInfo.class, object, aRServerUser);
                break;
            }
            case 6: 
            case 54: 
            case 55: 
            case 56: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(CurrencyPartInfo.class, object, aRServerUser);
                break;
            }
            case 4: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(StatusHistoryValueIndicator.class, object, aRServerUser);
                break;
            }
            case 5: {
                this.m_operand = ARTypeMgr.getInstance().ObjectListFromVariant(Value.class, object, aRServerUser);
                break;
            }
            case 52: {
                this.m_operand = new Integer(ConversionUtil.getIntValue(object));
                break;
            }
            case 53: {
                this.m_operand = ARTypeMgr.getInstance().ObjectFromVariant(QueryInfo.class, object, aRServerUser);
                break;
            }
        }
    }

    Object toVariant(ARServerUser aRServerUser) {
        Object[] objectArray = new Object[2];
        int n2 = this.getTypeInt();
        objectArray[0] = new Integer(n2);
        switch (n2) {
            case 1: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 50: 
            case 51: 
            case 99: {
                objectArray[1] = new Integer(ConversionUtil.getIntValue(this.m_operand));
                break;
            }
            case 2: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, aRServerUser);
                break;
            }
            case 3: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, aRServerUser);
                break;
            }
            case 6: 
            case 54: 
            case 55: 
            case 56: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, aRServerUser);
                break;
            }
            case 4: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, aRServerUser);
                break;
            }
            case 5: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectListFromVariant(Value.class, this.m_operand, aRServerUser);
                break;
            }
            case 52: {
                objectArray[1] = new Integer(ConversionUtil.getIntValue(this.m_operand));
                break;
            }
            case 53: {
                objectArray[1] = ARTypeMgr.getInstance().ObjectToVariant(this.m_operand, aRServerUser);
                break;
            }
        }
        return objectArray;
    }

    static ArithmeticOrRelationalOperand createInstance(Object[] objectArray, ARServerUser aRServerUser) {
        if (objectArray == null) {
            return null;
        }
        ArithmeticOrRelationalOperand arithmeticOrRelationalOperand = new ArithmeticOrRelationalOperand();
        if (objectArray.length == 2) {
            arithmeticOrRelationalOperand.fromVariant(objectArray, aRServerUser);
        }
        return arithmeticOrRelationalOperand;
    }

    public String toString() {
        return new ToStringBuilder(this, Config.getInstance().getToStringStyle()).append("Operand Type", this.m_operandType).append("Operand", this.m_operand).toString();
    }
}

