/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.fts.impl.lucene;

import com.bmc.arsys.fts.FTSService;
import com.bmc.arsys.fts.FTSServiceException;
import com.bmc.arsys.fts.impl.DocHandler.DocumentHandlerException;
import com.bmc.arsys.fts.impl.DocHandler.TikaDocHandler;
import com.bmc.arsys.fts.impl.FTSConfiguration;
import com.bmc.arsys.fts.impl.lucene.FTSIndexSearcher;
import com.bmc.arsys.fts.impl.lucene.WordIterator;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzer;
import com.bmc.arsys.fts.impl.lucene.analyzers.FTSAnalyzerConfigReader;
import com.bmc.arsys.fts.impl.lucene.query.FTSQueryParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.SimpleSpanFragmenter;
import org.apache.lucene.search.highlight.TokenSources;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.SimpleFSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneFTSService
implements FTSService {
    private static final Logger LOGGER = Logger.getLogger(LuceneFTSService.class);
    private static LuceneFTSService luceneFTSService = null;
    private static final int kConstantFields = 2;
    private static final int kTotalConstantFields = 5;
    private static final int FT_COMMIT_NO = 0;
    private static final int FT_COMMIT_YES = 1;
    private static final int FT_COMMIT_FIELD_DEFERRED = 2;
    private static final int FT_COMMIT_FIELD_FORCE = 4;
    private static final int kNormal = 0;
    private static final int kNormalCase = 1;
    private static final int kLiteral = 2;
    private static final int kLiteralCasel = 3;
    private static final int kNo = 0;
    private static final int kYes = 1;
    private static final String VERSION_DOCID = "##FTSIndexVersion##";
    private static final String VERSION_VERSION_FIELD = "##Version##";
    private static final String VERSION_DATE_FIELD = "##Date##";
    private static final String VERSION_VERSION = "1.0";
    private boolean caseSensitive;
    private String collectionDir;
    private String configurationDir;
    private String locale;
    private int searchThreshold;
    private static Analyzer ftsAnalyzer;
    private FTSAnalyzerConfigReader.FTSAnalyzerConfig analyzerConfig;
    private boolean isWriter = false;
    public boolean doNormal = false;
    public boolean doNormalCase = false;
    public boolean doLiteral = false;
    public boolean doLiteralCase = false;
    private int deletePolicyTime;
    private int searcherRetry = 1;
    private int searcherRetryDelay = 0;
    private static Date recentInit;
    private static Hashtable<String, ArrayList<FieldDataHolder>> entryFieldQueue;
    private static int memCheckCount;
    private static int checkCount;
    private static IndexWriter staticIndexWriter;
    private static ArrayList<IndexSearcher> indexSearcherQueue;

    private LuceneFTSService() {
    }

    public static synchronized LuceneFTSService getLuceneFTSService() {
        if (luceneFTSService == null) {
            luceneFTSService = new LuceneFTSService();
        }
        return luceneFTSService;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexCount() {
        int n = 0;
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = this.getIndexSearcher();
            if (indexSearcher != null) {
                n = indexSearcher.getIndexReader().numDocs();
            }
        }
        catch (Exception exception) {
            LOGGER.error((Object)"FTS: Error getting the index count.", (Throwable)exception);
        }
        finally {
            if (indexSearcher != null) {
                ((FTSIndexSearcher)indexSearcher).setCount(false);
            }
        }
        return n;
    }

    @Override
    public synchronized void init(FTSConfiguration fTSConfiguration) throws FTSServiceException {
        this.init(fTSConfiguration, true);
    }

    @Override
    public synchronized void init(FTSConfiguration fTSConfiguration, boolean bl) throws FTSServiceException {
        this.isWriter = bl;
        this.collectionDir = fTSConfiguration.getFullTextCollectionDir();
        this.caseSensitive = fTSConfiguration.isFullTextCaseInSensitive();
        this.locale = fTSConfiguration.getFullTextLocale();
        this.configurationDir = fTSConfiguration.getFullTextConfigurationDir();
        this.deletePolicyTime = fTSConfiguration.getDeletePolicyTime();
        String[] stringArray = fTSConfiguration.getIndexSearcherRetry().split(":");
        this.searcherRetry = new Integer(stringArray[0]);
        if (stringArray.length == 2) {
            this.searcherRetryDelay = new Integer(stringArray[1]);
        }
        this.searchThreshold = fTSConfiguration.getSearchThreshold() == 0 ? 1000000 : fTSConfiguration.getSearchThreshold();
        this.updateConfiguration();
        this.init(bl);
    }

    private boolean initExpired() {
        Boolean bl = false;
        Date date = new Date();
        if (date.getTime() - recentInit.getTime() >= 10000L) {
            bl = true;
        }
        return bl;
    }

    private synchronized void init(boolean bl) throws FTSServiceException {
        if (recentInit == null || this.initExpired()) {
            LOGGER.debug((Object)"The init is happening.");
            this.initAnalyzer(this.caseSensitive);
            if (bl) {
                IndexWriter indexWriter;
                if (staticIndexWriter != null) {
                    try {
                        staticIndexWriter.close();
                    }
                    catch (CorruptIndexException corruptIndexException) {
                        throw new FTSServiceException(this.getClass().getName() + " init: The index is corrupt", corruptIndexException);
                    }
                    catch (IOException iOException) {
                        throw new FTSServiceException(this.getClass().getName() + " init: Cannot close index", iOException);
                    }
                    staticIndexWriter = null;
                }
                if ((indexWriter = this.getIndexWriter(ftsAnalyzer)) != null) {
                    this.checkIndexVersion();
                    this.commit();
                } else {
                    LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + ftsAnalyzer + "'"));
                }
            }
            recentInit = new Date();
        } else {
            LOGGER.debug((Object)"Init is skipped due to one happening in last 10 seconds");
        }
    }

    private void checkIndexVersion() throws FTSServiceException {
        Document document = this.getDocumentById(VERSION_DOCID);
        if (document == null) {
            document = new Document();
            Field.Index index = Field.Index.NOT_ANALYZED;
            Field.Store store = Field.Store.YES;
            Field.TermVector termVector = Field.TermVector.NO;
            document.add((Fieldable)new Field("docId", VERSION_DOCID, store, index, termVector));
            index = Field.Index.NO;
            document.add((Fieldable)new Field(VERSION_VERSION_FIELD, VERSION_VERSION, store, index, termVector));
            document.add((Fieldable)new Field(VERSION_DATE_FIELD, new Date().toString(), store, index, termVector));
            try {
                staticIndexWriter.addDocument(document);
            }
            catch (IOException iOException) {
                throw new FTSServiceException(this.getClass().getName() + " checkIndexVersion: Error adding index version", iOException);
            }
        }
        if (!document.get(VERSION_VERSION_FIELD).equals(VERSION_VERSION)) {
            // empty if block
        }
    }

    @Override
    public void setDocBoost(String string, String string2, float f) throws FTSServiceException {
        this.notWriterExceptionCheck("setDocBoost");
        if (string2 == null || string2.equals("0") || string2.length() == 0) {
            FTSQueryParser fTSQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
            ArrayList<FTSService.EntryData> arrayList = this.getEntryIdsByQuery((Query)fTSQueryParser.schemaQuery((String)string), null, null, (boolean)false, (int)0, null, null, null, null, (int)0, null, null).resultList;
            for (FTSService.EntryData entryData : arrayList) {
                this.indexEntryFields(string, entryData.entryId, f, null, null, null, null, 0);
            }
            this.commit();
        } else {
            this.indexEntryFields(string, string2, f, null, null, null, null, 1);
        }
    }

    private int getFieldSize(ArrayList<FieldDataHolder> arrayList) {
        int n = 2;
        for (FieldDataHolder fieldDataHolder : arrayList) {
            if (fieldDataHolder.fieldNames.length == 1) {
                ++n;
                continue;
            }
            n = n + fieldDataHolder.fieldNames.length - 2;
        }
        return n;
    }

    @Override
    public synchronized void indexEntryFields(String string, String string2, float f, String[] stringArray, String[] stringArray2, BitSet[] bitSetArray, float[] fArray, int n) throws FTSServiceException {
        this.notWriterExceptionCheck("indexEntryFields");
        String string3 = this.buildDocId(string, string2);
        if (n == 2) {
            if (entryFieldQueue.containsKey(string3)) {
                ArrayList<FieldDataHolder> arrayList = entryFieldQueue.get(string3);
                arrayList.add(new FieldDataHolder(string, string2, f, stringArray, stringArray2, bitSetArray, fArray));
            } else {
                ArrayList<FieldDataHolder> arrayList = new ArrayList<FieldDataHolder>();
                arrayList.add(new FieldDataHolder(string, string2, f, stringArray, stringArray2, bitSetArray, fArray));
                entryFieldQueue.put(string3, arrayList);
            }
        } else if (n > 2) {
            if (entryFieldQueue.containsKey(string3)) {
                ArrayList<FieldDataHolder> arrayList = entryFieldQueue.get(string3);
                arrayList.add(new FieldDataHolder(string, string2, f, stringArray, stringArray2, bitSetArray, fArray));
                int n2 = this.getFieldSize(arrayList);
                String[] stringArray3 = new String[n2];
                String[] stringArray4 = new String[n2];
                BitSet[] bitSetArray2 = new BitSet[n2];
                float[] fArray2 = new float[n2];
                boolean bl = false;
                int n3 = 0;
                for (FieldDataHolder fieldDataHolder : arrayList) {
                    int n4;
                    int n5 = fieldDataHolder.fieldNames.length;
                    if (n5 > 1 && !bl) {
                        for (n4 = 0; n4 < 2; ++n4) {
                            stringArray3[n3] = fieldDataHolder.fieldNames[n4];
                            stringArray4[n3] = fieldDataHolder.values[n4];
                            bitSetArray2[n3] = fieldDataHolder.fullTextOptions[n4];
                            fArray2[n3] = fieldDataHolder.fieldBoost[n4];
                            ++n3;
                        }
                        bl = true;
                    }
                    n4 = 0;
                    if (n5 > 1) {
                        n4 = 2;
                    }
                    for (int i = n4; i < fieldDataHolder.fieldNames.length; ++i) {
                        stringArray3[n3] = fieldDataHolder.fieldNames[i];
                        stringArray4[n3] = fieldDataHolder.values[i];
                        bitSetArray2[n3] = fieldDataHolder.fullTextOptions[i];
                        fArray2[n3] = fieldDataHolder.fieldBoost[i];
                        ++n3;
                    }
                }
                this.indexEntryFieldsAll(string, string2, f, stringArray3, stringArray4, bitSetArray2, fArray2, n);
                entryFieldQueue.remove(string3);
            } else {
                this.indexEntryFieldsAll(string, string2, f, stringArray, stringArray2, bitSetArray, fArray, n);
            }
        } else {
            this.indexEntryFieldsAll(string, string2, f, stringArray, stringArray2, bitSetArray, fArray, n);
        }
    }

    @Override
    public void indexAttachmentByPath(String string, String string2, float f, String string3, List<String> list, BitSet bitSet, float f2, int n) throws FTSServiceException {
        String[] stringArray = new String[list.size()];
        String[] stringArray2 = new String[list.size()];
        BitSet[] bitSetArray = new BitSet[list.size()];
        float[] fArray = new float[list.size()];
        TikaDocHandler tikaDocHandler = new TikaDocHandler();
        int n2 = 0;
        for (String string4 : list) {
            String string5 = null;
            try {
                File file = new File(string4);
                string5 = tikaDocHandler.getText(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            catch (DocumentHandlerException documentHandlerException) {
                documentHandlerException.printStackTrace();
            }
            stringArray[n2] = string3;
            stringArray2[n2] = string5;
            bitSetArray[n2] = bitSet;
            fArray[n2] = f2;
            ++n2;
        }
        this.indexEntryFields(string, string2, f, stringArray, stringArray2, bitSetArray, fArray, n);
    }

    private void freeMemCheck() throws FTSServiceException {
        if (memCheckCount == checkCount) {
            memCheckCount = 0;
            Runtime runtime = Runtime.getRuntime();
            float f = runtime.freeMemory();
            float f2 = runtime.totalMemory();
            float f3 = f2 - f;
            float f4 = f3 / f2;
            LOGGER.debug((Object)("freeMemCheck is checking percent of memory used: " + f4));
            LOGGER.debug((Object)("freeMemCheck is checking percent of memory every: " + checkCount));
            if ((double)f4 >= 0.9) {
                checkCount = 1000;
                LOGGER.debug((Object)"freeMemCheck has determined memory is too low and issuing an init to free memory");
                this.init(true);
            } else {
                checkCount = (double)f4 >= 0.8 ? 100 : ((double)f4 >= 0.7 ? 500 : 1000);
            }
        } else {
            ++memCheckCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexEntryFieldsAll(String string, String string2, float f, String[] stringArray, String[] stringArray2, BitSet[] bitSetArray, float[] fArray, int n) throws FTSServiceException {
        try {
            String string3 = this.buildDocId(string, string2);
            Document document = this.getDocumentById(string3, true);
            Analyzer analyzer = ftsAnalyzer;
            if (document == null && stringArray == null) {
                return;
            }
            if (document == null) {
                IndexWriter indexWriter;
                document = this.createDocument(string3, string, string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] == null || stringArray[i].startsWith("DEL_")) continue;
                    int n2 = stringArray2[i].length() > 20 ? 20 : stringArray2[i].length();
                    LOGGER.info((Object)("FTS: Indexing with " + analyzer.getClass().getSimpleName() + "-> Schema id = " + string + ", Entry id = " + string2 + ", Field id =  " + stringArray[i] + ", Value(first 20) = " + stringArray2[i].substring(0, n2) + ", Literal indexing = " + bitSetArray[i].get(1)));
                    if (stringArray[i].equals("modifiedTime") || stringArray[i].equals("createTime")) {
                        Long l = Long.parseLong(stringArray2[i]);
                        document.add((Fieldable)new NumericField(stringArray[i], Field.Store.YES, true).setLongValue(l.longValue()));
                        continue;
                    }
                    document.add((Fieldable)new Field(stringArray[i] + "_orig", stringArray2[i], Field.Store.YES, Field.Index.NO, Field.TermVector.NO));
                    document.add((Fieldable)new Field(stringArray[i] + "_bytes", this.setFieldBytes(bitSetArray[i].get(1)), Field.Store.YES));
                    if (fArray == null || fArray[i] == 1.0f) continue;
                    document.add((Fieldable)new Field(stringArray[i] + "_fieldBoost", PayloadHelper.encodeFloat((float)fArray[i]), Field.Store.YES));
                }
                List list = document.getFields();
                document = this.createFieldVariations(document, list);
                if (f != 1.0f) {
                    document.setBoost(f);
                }
                if ((indexWriter = this.getIndexWriter(analyzer)) != null) {
                    indexWriter.addDocument(document);
                } else {
                    LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + analyzer + "'"));
                }
            } else {
                List list;
                List list2 = list = document.getFields();
                synchronized (list2) {
                    if (stringArray != null) {
                        String string4;
                        Object object;
                        int n3;
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            if (stringArray[n3] == null || stringArray[n3].startsWith("DEL_")) continue;
                            int n4 = stringArray2[n3].length() > 20 ? 20 : stringArray2[n3].length();
                            LOGGER.info((Object)("FTS: Updating with " + analyzer.getClass().getSimpleName() + "-> Schema id = " + string + ", Entry id = " + string2 + ", Field id =  " + stringArray[n3] + ", Value(first 20) = " + stringArray2[n3].substring(0, n4) + ", Literal indexing = " + bitSetArray[n3].get(1)));
                            if (stringArray[n3].equals("modifiedTime") || stringArray[n3].equals("createTime")) {
                                document.removeField(stringArray[n3]);
                                object = Long.parseLong(stringArray2[n3]);
                                document.add((Fieldable)new NumericField(stringArray[n3], Field.Store.YES, true).setLongValue(((Long)object).longValue()));
                                continue;
                            }
                            object = stringArray[n3] + "_orig";
                            string4 = stringArray[n3] + "_bytes";
                            document.removeField((String)object);
                            document.removeField(string4);
                            document.add((Fieldable)new Field((String)object, stringArray2[n3], Field.Store.YES, Field.Index.NO, Field.TermVector.NO));
                            document.add((Fieldable)new Field(string4, this.setFieldBytes(bitSetArray[n3].get(1)), Field.Store.YES));
                        }
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            if (stringArray[n3] == null || !stringArray[n3].startsWith("DEL_")) continue;
                            String string5 = stringArray[n3].substring(4);
                            object = string5 + "_orig";
                            string4 = string5 + "_bytes";
                            document.removeField((String)object);
                            document.removeField(string4);
                        }
                    }
                    document = this.createFieldVariations(document, list);
                    if (f != 1.0f) {
                        document.setBoost(f);
                    }
                }
                if (list.size() > 5) {
                    this.updateByField("docId", string3, document, analyzer);
                } else {
                    this.deleteEntryDocument(string3);
                }
            }
            if (n == 1 || n == 4) {
                this.commit();
            }
        }
        catch (CorruptIndexException corruptIndexException) {
            throw new FTSServiceException(this.getClass().getName() + " init: The index is corrupt", corruptIndexException);
        }
        catch (IOException iOException) {
            throw new FTSServiceException(this.getClass().getName() + " init: Cannot add to the index or close index", iOException);
        }
    }

    @Override
    public synchronized void commit() throws FTSServiceException {
        this.notWriterExceptionCheck("commit");
        try {
            staticIndexWriter.commit();
        }
        catch (CorruptIndexException corruptIndexException) {
            throw new FTSServiceException(this.getClass().getName() + " init: The index is corrupt", corruptIndexException);
        }
        catch (IOException iOException) {
            throw new FTSServiceException(this.getClass().getName() + " init: Cannot add to the index or close index", iOException);
        }
    }

    private Document createFieldVariations(Document document, List<Field> list) {
        ArrayList<Field> arrayList = new ArrayList<Field>(list);
        Field.Index index = Field.Index.ANALYZED;
        Field.Store store = Field.Store.NO;
        Field.TermVector termVector = Field.TermVector.WITH_POSITIONS_OFFSETS;
        for (AbstractField abstractField : arrayList) {
            String string = abstractField.name();
            if (!string.endsWith("_orig") || string.startsWith("createTime") || string.startsWith("modifiedTime")) continue;
            String string2 = document.get(string);
            String string3 = string.substring(0, string.length() - 5);
            byte[] byArray = document.getBinaryValue(string3 + "_bytes");
            byte[] byArray2 = document.getBinaryValue(string3 + "_fieldBoost");
            if (byArray.length != 4) continue;
            if (byArray[0] == 1) {
                document.add((Fieldable)this.boostField(new Field(string3, string2, store, index, termVector), byArray2));
            }
            if (byArray[1] == 1) {
                document.add((Fieldable)this.boostField(new Field(string3 + "_case", string2, store, index, termVector), byArray2));
            }
            if (byArray[2] == 1) {
                document.add((Fieldable)this.boostField(new Field(string3 + "_literal", string2.replaceAll("~!~", "\u0015"), store, index, termVector), byArray2));
            }
            if (byArray[3] != 1) continue;
            document.add((Fieldable)this.boostField(new Field(string3 + "_literalCase", string2.replaceAll("~!~", "\u0015"), store, index, termVector), byArray2));
        }
        return document;
    }

    private Field boostField(Field field, byte[] byArray) {
        if (byArray != null) {
            field.setBoost(PayloadHelper.decodeFloat((byte[])byArray));
        }
        return field;
    }

    private byte[] setFieldBytes(boolean bl) {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        if (this.doNormal || !this.caseSensitive && !bl) {
            byArray[0] = 1;
        }
        if (this.doNormalCase || this.caseSensitive && !bl) {
            byArray[1] = 1;
        }
        if (this.doLiteral || !this.caseSensitive && bl) {
            byArray[2] = 1;
        }
        if (this.doLiteralCase || this.caseSensitive && bl) {
            byArray[3] = 1;
        }
        return byArray;
    }

    private void addFieldToDocument(Document document, String string, Reader reader, BitSet bitSet) {
        document.add((Fieldable)new Field(string + "_orig", reader, Field.TermVector.NO));
        document.add((Fieldable)new Field(string + "_bytes", this.setFieldBytes(bitSet.get(1)), Field.Store.YES));
        List list = document.getFields();
        document = this.createFieldVariations(document, list);
    }

    @Override
    public void deleteEntryDocument(String string, String string2) throws FTSServiceException {
        this.notWriterExceptionCheck("deleteEntryDocument");
        LOGGER.info((Object)("FTS: delete from index - Schema id = " + string + ", Entry id = " + string2));
        String string3 = this.buildDocId(string, string2);
        this.deleteEntryDocument(string3);
    }

    @Override
    public void deleteIndexDir() throws FTSServiceException {
        this.notWriterExceptionCheck("deleteIndexDir");
        LOGGER.info((Object)"FTS: delete index - all document");
        this.close();
        boolean bl = true;
        File file = new File(this.collectionDir);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isFile() || fileArray[i].delete()) continue;
                bl = false;
            }
        }
        if (!bl) {
            throw new FTSServiceException(this.getClass().getName() + " deleteIndexDir: Failed to delete index.");
        }
    }

    @Override
    public synchronized void removeFieldFromDocumentsByQuery(String string, String[] stringArray, String[] stringArray2) throws FTSServiceException {
        this.notWriterExceptionCheck("removeFieldFromDocumentsByQuery");
        this.removeFieldFromDocumentsByQuery(string, stringArray, stringArray2, 1);
    }

    @Override
    public synchronized void removeFieldFromDocumentsByQuery(String string, String[] stringArray, String[] stringArray2, int n) throws FTSServiceException {
        this.notWriterExceptionCheck("removeFieldFromDocumentsByQuery(2)");
        if (n > 1) {
            String string2 = null;
            String string3 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals("schemaId")) {
                    string2 = stringArray2[i];
                    continue;
                }
                if (!stringArray[i].equals("entryId")) continue;
                string3 = stringArray2[i];
            }
            if (string2 != null) {
                String[] stringArray3 = new String[]{"DEL_" + string};
                String[] stringArray4 = new String[]{null};
                BitSet bitSet = new BitSet(1);
                bitSet.set(0);
                BitSet[] bitSetArray = new BitSet[]{bitSet};
                float[] fArray = new float[]{1.0f};
                this.indexEntryFields(string2, string3, 1.0f, stringArray3, stringArray4, bitSetArray, fArray, n);
            }
        } else {
            FTSQueryParser fTSQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
            Query query = fTSQueryParser.createDeleteFieldQuery(string, stringArray, stringArray2);
            IndexSearcher indexSearcher = this.getIndexSearcher();
            TopDocs topDocs = null;
            try {
                topDocs = indexSearcher.search(query, 10000);
                ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
                for (int i = 0; i < scoreDocArray.length; ++i) {
                    Document document = indexSearcher.doc(scoreDocArray[i].doc);
                    document.removeField(string + "_orig");
                    document.removeField(string + "_bytes");
                    List list = document.getFields();
                    Field field = document.getField("docId");
                    if (list.size() > 5) {
                        document = this.createFieldVariations(document, list);
                        this.updateByField("docId", field.stringValue(), document, ftsAnalyzer);
                        continue;
                    }
                    this.deleteEntryDocument(field.stringValue());
                }
                if (n == 1) {
                    this.commit();
                }
            }
            catch (IOException iOException) {
                throw new FTSServiceException(this.getClass().getName() + " removeFieldFromDocumentsByQuery: Problem searching the index", iOException);
            }
            finally {
                if (indexSearcher != null) {
                    ((FTSIndexSearcher)indexSearcher).setCount(false);
                }
            }
        }
    }

    @Override
    public List<FTSService.EntryData> getEntryIdsByQuery(String string, String[] stringArray, String[] stringArray2, BitSet[] bitSetArray) throws FTSServiceException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Search Schema ID: " + string + "; Field and Terms: " + this.getFieldTermsForLogger(stringArray, stringArray2)));
        }
        FTSQueryParser fTSQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
        Query query = fTSQueryParser.createQuery(string, stringArray, stringArray2, bitSetArray, this.caseSensitive);
        return this.getEntryIdsByQuery((Query)query, null, null, (boolean)false, (int)0, null, null, null, null, (int)0, null, null).resultList;
    }

    private String getFieldTermsForLogger(String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("[" + stringArray[i] + ":" + stringArray2[i] + "] ");
        }
        return stringBuffer.toString();
    }

    private String getSchemaFieldsForLogger(ArrayList<FTSService.QuerySchemas> arrayList) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (arrayList != null) {
            for (FTSService.QuerySchemas querySchemas : arrayList) {
                stringBuffer.append("[" + querySchemas.schemaId + ": ");
                for (String string : querySchemas.queryFieldNames) {
                    stringBuffer.append(string + ", ");
                }
                stringBuffer.append("] ");
            }
        }
        return stringBuffer.toString();
    }

    private String getReturnFieldsForLogger(ArrayList<FTSService.ReturnFilterFields> arrayList) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (arrayList != null) {
            for (FTSService.ReturnFilterFields returnFilterFields : arrayList) {
                stringBuffer.append(returnFilterFields.filterField + ", ");
            }
        }
        return stringBuffer.toString();
    }

    private boolean isUnqualifiedWildcard(String string, String string2, String string3) {
        boolean bl = false;
        if (string != null && string.trim().equals("%")) {
            bl = true;
        } else if (string2 != null && string2.trim().equals("%")) {
            bl = true;
        } else if (string3 != null && string3.trim().equals("%")) {
            bl = true;
        }
        return bl;
    }

    @Override
    public FTSService.FTSResultSet getEntryIdsByGlobalQuery(String string, String string2, String string3, ArrayList<FTSService.QuerySchemas> arrayList, String string4, ArrayList<FTSService.ReturnFilterFields> arrayList2, String string5, int n, String string6, int n2) throws FTSServiceException {
        return this.getEntryIdsByGlobalQuery(string, string2, string3, arrayList, string4, arrayList2, string5, n, string6, n2, "[", "]");
    }

    @Override
    public FTSService.FTSResultSet getEntryIdsByGlobalQuery(String string, String string2, String string3, ArrayList<FTSService.QuerySchemas> arrayList, String string4, ArrayList<FTSService.ReturnFilterFields> arrayList2, String string5, int n, String string6, int n2, String string7, String string8) throws FTSServiceException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Threshold set by AR: " + this.searchThreshold));
            LOGGER.debug((Object)("Search Terms - Must: " + string2 + "; Should: " + string + "; Must Not: " + string3));
            LOGGER.debug((Object)("Search Filter Query: " + string4));
            LOGGER.debug((Object)("Search Schema IDs and Fields - " + this.getSchemaFieldsForLogger(arrayList)));
            LOGGER.debug((Object)("Search Return Fields: " + this.getReturnFieldsForLogger(arrayList2)));
            LOGGER.debug((Object)("Search Sort Order: " + string5));
            LOGGER.debug((Object)("Search Result Option: " + n));
            LOGGER.debug((Object)("Search Return Entries: " + string6));
            LOGGER.debug((Object)("Search Max Return: " + n2));
        }
        boolean bl = false;
        bl = this.isUnqualifiedWildcard(string, string2, string3);
        if (bl && n == 2) {
            n = 1;
        }
        if (string != null && string.length() == 1 && string.codePointAt(0) == 32) {
            string = null;
        }
        if (string2 != null && string2.length() == 1 && string2.codePointAt(0) == 32) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 1 && string3.codePointAt(0) == 32) {
            string3 = null;
        }
        if (string4 != null && string4.length() == 1 && string4.codePointAt(0) == 32) {
            string4 = null;
        }
        FTSQueryParser fTSQueryParser = new FTSQueryParser((FTSAnalyzer)ftsAnalyzer);
        Query query = null;
        Query query2 = null;
        Hashtable<String, String> hashtable = null;
        if (string6 != null && string6.length() != 0) {
            hashtable = this.prepareReturnEntries(string6);
            LOGGER.debug((Object)("Number of entries to fetch for phase 2: " + hashtable.size()));
            query = fTSQueryParser.docIdQuery(hashtable);
            query2 = fTSQueryParser.createGlobalQuery(string, string2, string3, arrayList, this.caseSensitive);
        } else {
            query = bl ? fTSQueryParser.unqualifiedWildcardQuery(arrayList) : fTSQueryParser.createGlobalQuery(string, string2, string3, arrayList, this.caseSensitive);
        }
        Filter filter = null;
        if (string4 != null && (string6 == null || string6.length() == 0)) {
            filter = fTSQueryParser.createGlobalFilter(string4, this.caseSensitive);
        }
        String string9 = string5;
        if (string6 != null && string5 == null) {
            string9 = "4;2";
        }
        return this.getEntryIdsByQuery(query, query2, filter, true, n, arrayList2, arrayList, string9, hashtable, n2, string7, string8);
    }

    private Hashtable<String, String> prepareReturnEntries(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0) continue;
            String[] stringArray2 = stringArray[i].split("@@");
            hashtable.put(stringArray2[0], stringArray2[1]);
        }
        return hashtable;
    }

    private FTSService.FTSResultSet getEntryIdsByQuery(Query query, Query query2, Filter filter, boolean bl, int n, ArrayList<FTSService.ReturnFilterFields> arrayList, ArrayList<FTSService.QuerySchemas> arrayList2, String string, Hashtable<String, String> hashtable, int n2, String string2, String string3) throws FTSServiceException {
        Object object;
        Query query3 = null;
        FTSService.FTSResultSet fTSResultSet = new FTSService.FTSResultSet();
        ArrayList<FTSService.GlobalEntryData> arrayList3 = new ArrayList<FTSService.GlobalEntryData>();
        IndexSearcher indexSearcher = this.getIndexSearcher();
        TopDocs topDocs = null;
        int n3 = this.searchThreshold;
        if (n2 > 0 && n2 < this.searchThreshold) {
            n3 = n2;
        }
        LOGGER.debug((Object)("maxToReturn: " + n3));
        try {
            LOGGER.debug((Object)"Making initial search request");
            topDocs = indexSearcher.search(query, filter, n3);
            LOGGER.debug((Object)"Completed initial search request");
            fTSResultSet.numMatches = topDocs.totalHits;
            if (n != 3) {
                float f = topDocs.getMaxScore();
                object = topDocs.scoreDocs;
                if (n == 4) {
                    LOGGER.debug((Object)("Phase 1: Getting Enty ID / Schema data only: " + ((ScoreDoc[])object).length));
                } else {
                    LOGGER.debug((Object)("Phase 2:  Getting All column data: " + ((ScoreDoc[])object).length));
                }
                MapFieldSelector mapFieldSelector = null;
                if (!bl || bl && n == 4) {
                    mapFieldSelector = new MapFieldSelector(this.getFieldsToFetch(string));
                }
                for (int i = 0; i < ((ScoreDoc[])object).length; ++i) {
                    ArrayList<FTSService.ReturnFilterFields> arrayList4 = new ArrayList<FTSService.ReturnFilterFields>();
                    Document document = null;
                    document = !bl || bl && n == 4 ? indexSearcher.doc(object[i].doc, (FieldSelector)mapFieldSelector) : indexSearcher.doc(object[i].doc);
                    FTSService.EntryData entryData = bl ? new FTSService.GlobalEntryData() : new FTSService.EntryData();
                    Field field = document.getField("schemaId");
                    Field field2 = document.getField("entryId");
                    entryData.schemaId = field.stringValue();
                    if (field2 == null) continue;
                    entryData.entryId = field2.stringValue();
                    entryData.score = hashtable != null ? Float.parseFloat(hashtable.get(this.buildDocId(entryData.schemaId, entryData.entryId))) : object[i].score / f * 100.0f;
                    if (bl && n != 4 || bl && string != null) {
                        if (query3 == null && query2 == null) {
                            query3 = query.rewrite(indexSearcher.getIndexReader());
                        } else if (query3 == null) {
                            query3 = query2.rewrite(indexSearcher.getIndexReader());
                        }
                        Field field3 = document.getField("title_orig");
                        Field field4 = document.getField("createTime");
                        Field field5 = document.getField("modifiedTime");
                        entryData.title = field3 != null ? this.highlightTitleText(indexSearcher.getIndexReader(), object[i].doc, this.getFieldName(document, "title"), query3, field3.stringValue(), n, string2, string3) : "";
                        if (n != 4) {
                            entryData.excerpt = this.getExcerptText(document, n, query3, indexSearcher.getIndexReader(), object[i].doc, arrayList2, string2, string3);
                        }
                        entryData.createDate = field4 != null ? field4.stringValue() : "";
                        entryData.modifiedDate = field5 != null ? field5.stringValue() : "";
                        if (arrayList != null) {
                            for (FTSService.ReturnFilterFields returnFilterFields : arrayList) {
                                Field field6 = document.getField(returnFilterFields.filterField + "_orig");
                                String string4 = "";
                                if (field6 != null) {
                                    string4 = field6.stringValue();
                                }
                                arrayList4.add(new FTSService.ReturnFilterFields(returnFilterFields.filterField, string4));
                            }
                            entryData.returnFilterFields = arrayList4;
                        }
                    }
                    arrayList3.add((FTSService.GlobalEntryData)entryData);
                }
                if (n == 4) {
                    LOGGER.debug((Object)("Phase 1:  Completed getting Enty ID / Schema data only: " + arrayList3.size()));
                } else {
                    LOGGER.debug((Object)("Phase 2:  Completed getting All column data: " + arrayList3.size()));
                }
            }
        }
        catch (CorruptIndexException corruptIndexException) {
            throw new FTSServiceException(this.getClass().getName() + " getEntryIdsByQuery: Problem searching the index: Corrupt Index Exception ", corruptIndexException);
        }
        catch (IOException iOException) {
            throw new FTSServiceException(this.getClass().getName() + " getEntryIdsByQuery: Problem searching the index: IO Exception ", iOException);
        }
        finally {
            ((FTSIndexSearcher)indexSearcher).setCount(false);
        }
        if (!bl) {
            Collections.sort(arrayList3);
        } else if (bl && string != null) {
            EntryDataSorter entryDataSorter = new EntryDataSorter();
            entryDataSorter.setFieldsToSort(string);
            object = entryDataSorter;
            Collections.sort(arrayList3, object);
        }
        fTSResultSet.resultList = arrayList3;
        LOGGER.debug((Object)("Search results count: " + fTSResultSet.numMatches));
        return fTSResultSet;
    }

    private String[] getFieldsToFetch(String string) {
        if (string == null || string.length() == 0) {
            return new String[]{"schemaId", "entryId"};
        }
        String[] stringArray = string.split(";");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length / 2);
        arrayList.add("schemaId");
        arrayList.add("entryId");
        for (int i = 0; i < stringArray.length; i += 2) {
            if (stringArray[i].equals("0") || stringArray[i].equals("1") || stringArray[i].equals("4")) continue;
            if (stringArray[i].equals("2")) {
                arrayList.add("title");
                continue;
            }
            if (stringArray[i].equals("5")) {
                arrayList.add("createTime");
                continue;
            }
            if (stringArray[i].equals("6")) {
                arrayList.add("modifiedTime");
                continue;
            }
            if (stringArray[i].equals("3")) continue;
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public void deleteDocumentsContainingField(String string, String string2) throws FTSServiceException {
        this.notWriterExceptionCheck("deleteDocumentsContainingField");
        LOGGER.info((Object)("FTS: delete from index - Field = " + string + ", fieldValue = " + string2));
        this.deleteEntryDocument(string, string2, ftsAnalyzer);
        this.deleteEntryDocument(string + "_literal", string2, ftsAnalyzer);
        this.deleteEntryDocument(string + "_literalCase", string2, ftsAnalyzer);
        this.deleteEntryDocument(string + "_case", string2, ftsAnalyzer);
        this.deleteEntryDocument(string + "_noStem", string2, ftsAnalyzer);
        this.deleteEntryDocument(string + "_caseNoStem", string2, ftsAnalyzer);
        this.deleteEntryDocument(string + "_orig", string2, ftsAnalyzer);
        this.deleteEntryDocument(string + "_bytes", string2, ftsAnalyzer);
    }

    @Override
    public void updateConfiguration() throws FTSServiceException {
        try {
            if (ftsAnalyzer != null) {
                ((FTSAnalyzer)ftsAnalyzer).reload(this.caseSensitive);
            }
        }
        catch (Exception exception) {
            throw new FTSServiceException(this.getClass().getName() + " updateConfiguration(): Analyzer reload failed", exception);
        }
    }

    @Override
    public void close() throws FTSServiceException {
        this.notWriterExceptionCheck("close");
        try {
            if (indexSearcherQueue.size() != 0) {
                Iterator<IndexSearcher> iterator = indexSearcherQueue.iterator();
                while (iterator.hasNext()) {
                    IndexSearcher indexSearcher;
                    IndexSearcher indexSearcher2 = indexSearcher = iterator.next();
                    IndexReader indexReader = indexSearcher2.getIndexReader();
                    indexReader.close();
                    indexSearcher2.close();
                    indexReader = null;
                    indexSearcher2 = null;
                }
                indexSearcherQueue.clear();
            }
            if (staticIndexWriter != null) {
                staticIndexWriter.close();
                staticIndexWriter = null;
            }
            recentInit = null;
        }
        catch (IOException iOException) {
            throw new FTSServiceException(this.getClass().getName() + " close: Problem closing the index", iOException);
        }
    }

    private void initAnalyzer(boolean bl) {
        LOGGER.info((Object)"FTS: Initialize full text analyzers");
        if (this.configurationDir != null && !this.configurationDir.equals("")) {
            File file = new File(this.configurationDir + "/FTSLocaleConfig.xml");
            if (file.exists()) {
                FTSAnalyzerConfigReader fTSAnalyzerConfigReader = new FTSAnalyzerConfigReader();
                try {
                    this.analyzerConfig = fTSAnalyzerConfigReader.readConfig(this.configurationDir, this.locale);
                }
                catch (Exception exception) {
                    this.analyzerConfig = this.getDefaultAnalyzerConfig();
                    LOGGER.error((Object)(this.getClass().getName() + "initAnalyser: Failed to read FTSLocaleConfig.xml."), (Throwable)exception);
                }
            } else {
                this.analyzerConfig = this.getDefaultAnalyzerConfig();
                LOGGER.warn((Object)(this.getClass().getName() + "initAnalyser: FTSLocaleConfig.xml is not a file."));
            }
        } else {
            this.analyzerConfig = this.getDefaultAnalyzerConfig();
            LOGGER.warn((Object)(this.getClass().getName() + "initAnalyser: Configuration directory does not exist."));
        }
        if (ftsAnalyzer != null) {
            ftsAnalyzer = null;
        }
        ftsAnalyzer = new FTSAnalyzer(this.analyzerConfig, bl);
    }

    private FTSAnalyzerConfigReader.FTSAnalyzerConfig getDefaultAnalyzerConfig() {
        FTSAnalyzerConfigReader.FTSAnalyzerConfig fTSAnalyzerConfig = new FTSAnalyzerConfigReader.FTSAnalyzerConfig(new FTSAnalyzerConfigReader());
        fTSAnalyzerConfig.stemmer = "English";
        return fTSAnalyzerConfig;
    }

    private Document getDocumentById(String string) throws FTSServiceException {
        return this.getDocumentById(string, false);
    }

    private Document getDocumentById(String string, boolean bl) throws FTSServiceException {
        Document document = null;
        TopDocs topDocs = null;
        IndexSearcher indexSearcher = null;
        try {
            indexSearcher = this.getIndexSearcher();
            Term term = new Term("docId", string);
            TermQuery termQuery = new TermQuery(term);
            topDocs = indexSearcher.search((Query)termQuery, 1);
            if (topDocs.totalHits > 0) {
                ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
                for (int i = 0; i < scoreDocArray.length; ++i) {
                    document = indexSearcher.doc(scoreDocArray[0].doc);
                }
            }
        }
        catch (IOException iOException) {
            throw new FTSServiceException(this.getClass().getName() + " getDocumentById: Failed to retrieve document", iOException);
        }
        finally {
            if (indexSearcher != null) {
                ((FTSIndexSearcher)indexSearcher).setCount(false);
            }
        }
        return document;
    }

    private Document createDocument(String string, String string2, String string3) {
        Document document = new Document();
        Field.Index index = Field.Index.NOT_ANALYZED;
        Field.Store store = Field.Store.YES;
        Field.TermVector termVector = Field.TermVector.YES;
        Field field = new Field("docId", string, store, index, termVector);
        Field field2 = new Field("schemaId", string2, store, index, termVector);
        Field field3 = new Field("entryId", string3, store, index, termVector);
        document.add((Fieldable)field);
        document.add((Fieldable)field2);
        document.add((Fieldable)field3);
        return document;
    }

    private synchronized void updateByField(String string, String string2, Document document, Analyzer analyzer) throws FTSServiceException {
        try {
            IndexWriter indexWriter = this.getIndexWriter(analyzer);
            if (indexWriter != null) {
                Term term = new Term(string, string2);
                indexWriter.updateDocument(term, document);
            } else {
                LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + analyzer + "'"));
            }
        }
        catch (IOException iOException) {
            throw new FTSServiceException(this.getClass().getName() + " updateByField: Error updating documents with field name '" + string + "' and field value '" + string2, iOException);
        }
    }

    private synchronized void deleteEntryDocument(String string) throws FTSServiceException {
        try {
            IndexWriter indexWriter = this.getIndexWriter(ftsAnalyzer);
            if (indexWriter != null) {
                Term term = new Term("docId", string);
                indexWriter.deleteDocuments(term);
                this.commit();
            } else {
                LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + ftsAnalyzer + "'"));
            }
        }
        catch (IOException iOException) {
            throw new FTSServiceException(this.getClass().getName() + " deleteEntryDocument: Error deleting documents with field name '" + "docId" + "' and field data '" + string, iOException);
        }
    }

    private synchronized void deleteEntryDocument(String string, String string2, Analyzer analyzer) throws FTSServiceException {
        try {
            IndexWriter indexWriter = this.getIndexWriter(analyzer);
            if (indexWriter != null) {
                indexWriter.deleteDocuments(new Term(string, string2));
                this.commit();
            } else {
                LOGGER.warn((Object)("FTS: Missing IndexWriter for Analyzer '" + analyzer + "'"));
            }
        }
        catch (IOException iOException) {
            throw new FTSServiceException(this.getClass().getName() + " deleteEntryDocument: Error deleting documents with field name '" + string + "' and field data '" + string2, iOException);
        }
    }

    private synchronized IndexWriter getIndexWriter(Analyzer analyzer) throws FTSServiceException {
        if (staticIndexWriter == null) {
            File file = new File(this.collectionDir);
            NIOFSDirectory nIOFSDirectory = null;
            try {
                if (!LuceneFTSService.isWindows()) {
                    nIOFSDirectory = new NIOFSDirectory(file);
                    LOGGER.debug((Object)("FTS: NIOFSDirectory active. [" + LuceneFTSService.getOSPlatform() + "]"));
                } else {
                    nIOFSDirectory = new SimpleFSDirectory(file);
                    LOGGER.debug((Object)("FTS: SimpleFSDirectory active.  [" + LuceneFTSService.getOSPlatform() + "]"));
                }
                if (IndexWriter.isLocked((Directory)nIOFSDirectory)) {
                    IndexWriter.unlock((Directory)nIOFSDirectory);
                }
                staticIndexWriter = new IndexWriter((Directory)nIOFSDirectory, analyzer, (IndexDeletionPolicy)new FTSIndexDeletionPolicy(), IndexWriter.MaxFieldLength.UNLIMITED);
                staticIndexWriter.commit();
            }
            catch (IOException iOException) {
                throw new FTSServiceException(this.getClass().getName() + " getIndexWriter: Error getting index writer", iOException);
            }
        }
        return staticIndexWriter;
    }

    private static boolean isWindows() {
        String string = LuceneFTSService.getOSPlatform();
        return string.indexOf("win") >= 0;
    }

    private static String getOSPlatform() {
        return System.getProperty("os.name").toLowerCase();
    }

    private synchronized IndexSearcher getIndexSearcher() throws FTSServiceException {
        return this.getIndexSearcher(0);
    }

    private synchronized IndexSearcher getIndexSearcher(int n) throws FTSServiceException {
        FTSIndexSearcher fTSIndexSearcher;
        block12: {
            fTSIndexSearcher = null;
            try {
                if (indexSearcherQueue.size() == 0) {
                    IndexReader indexReader = IndexReader.open((String)this.collectionDir);
                    fTSIndexSearcher = new FTSIndexSearcher(indexReader);
                    indexSearcherQueue.add(fTSIndexSearcher);
                    break block12;
                }
                IndexReader indexReader = indexSearcherQueue.get(indexSearcherQueue.size() - 1).getIndexReader();
                if (!indexReader.isCurrent()) {
                    IndexReader indexReader2 = indexReader.reopen();
                    for (int i = indexSearcherQueue.size() - 1; i > -1; --i) {
                        if (((FTSIndexSearcher)indexSearcherQueue.get(i)).getCount() != 0) continue;
                        IndexSearcher indexSearcher = indexSearcherQueue.get(i);
                        IndexReader indexReader3 = indexSearcher.getIndexReader();
                        try {
                            indexReader3.close();
                            indexSearcher.close();
                        }
                        catch (AlreadyClosedException alreadyClosedException) {
                            LOGGER.debug((Object)("Lucene generated a non-fatal exception trying to close the reader object(s) during a clean-up of the cache and prior to an insert of a newly reopened. " + alreadyClosedException.getLocalizedMessage()), (Throwable)alreadyClosedException);
                        }
                        indexReader = null;
                        indexSearcher = null;
                        indexSearcherQueue.remove(i);
                    }
                    fTSIndexSearcher = new FTSIndexSearcher(indexReader2);
                    indexSearcherQueue.add(fTSIndexSearcher);
                    break block12;
                }
                fTSIndexSearcher = indexSearcherQueue.get(indexSearcherQueue.size() - 1);
            }
            catch (IOException iOException) {
                if (n < this.searcherRetry) {
                    int n2 = n + 1;
                    LOGGER.warn((Object)("Retry getIndexSearcher, retryCount: " + n2));
                    if (this.searcherRetryDelay == 0) {
                        return this.getIndexSearcher(n2);
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(this.searcherRetryDelay);
                        return this.getIndexSearcher(n2);
                    }
                    catch (InterruptedException interruptedException) {
                        break block12;
                    }
                }
                throw new FTSServiceException(this.getClass().getName() + " getIndexSearcher: Error getting index searcher.  Likely cause is index does not exist", iOException);
            }
        }
        if (fTSIndexSearcher != null) {
            fTSIndexSearcher.setCount(true);
        }
        return fTSIndexSearcher;
    }

    private String buildDocId(String string, String string2) {
        return string + "##" + string2;
    }

    private String getExcerptText(Document document, int n, Query query, IndexReader indexReader, int n2, ArrayList<FTSService.QuerySchemas> arrayList, String string, String string2) {
        String string3 = null;
        switch (n) {
            case 0: {
                string3 = "";
                break;
            }
            case 1: {
                string3 = this.getExcerpt(document, arrayList);
                break;
            }
            case 2: {
                string3 = this.getWAH(document, query, indexReader, n2, arrayList, string, string2);
                if (string3 != null && string3.length() != 0) break;
                string3 = this.getExcerpt(document, arrayList);
            }
        }
        boolean bl = false;
        String string4 = "s!_01-$:Lft";
        if (string != null && string.length() > 0) {
            string3 = string3.replace(string, string4);
            bl = true;
        }
        boolean bl2 = false;
        String string5 = "s!_01-$:Rht";
        if (string2 != null && string2.length() > 0) {
            string3 = string3.replace(string2, string5);
            bl2 = true;
        }
        string3 = string3.replaceAll("(?:\\<.*?\\>)+", " ");
        if (bl2) {
            string3 = string3.replace(string5, string2);
        }
        if (bl) {
            string3 = string3.replace(string4, string);
        }
        return string3;
    }

    private String getWAH(Document document, Query query, IndexReader indexReader, int n, ArrayList<FTSService.QuerySchemas> arrayList, String string, String string2) {
        List list = document.getFields();
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer("");
        LOGGER.debug((Object)("Number of pontential fields in entry to check for WAH: " + list.size()));
        LOGGER.debug((Object)("Getting WAH data for: " + n));
        while (iterator.hasNext()) {
            String string3;
            Field field = (Field)iterator.next();
            if (!field.name().endsWith("_orig") || field.name().equals("title_orig") || field.name().equals("createTime_orig") || field.name().equals("modifiedTime_orig")) continue;
            String string4 = field.stringValue();
            String string5 = field.name().substring(0, field.name().length() - 5);
            if (!this.userHasRights(string5 = this.getFieldName(document, string5), document.getField("schemaId").stringValue(), arrayList) || (string3 = this.doHighlight(indexReader, n, string5, query, string4, false, string, string2)) == null || string3.equals("")) continue;
            string3.replaceAll("\n", "").replaceAll("\f", "").replaceAll("\r", "").replaceAll("\t", "").trim();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" *** ");
            }
            stringBuffer.append(string3);
        }
        LOGGER.debug((Object)("Completed WAH data for: " + n));
        return stringBuffer.toString();
    }

    private String getFieldName(Document document, String string) {
        String string2 = null;
        byte[] byArray = document.getBinaryValue(string + "_bytes");
        if (byArray.length == 4) {
            if (byArray[0] == 1) {
                string2 = string;
            }
            if (byArray[1] == 1) {
                string2 = string + "_case";
            }
            if (byArray[2] == 1) {
                string2 = string + "_literal";
            }
            if (byArray[3] == 1) {
                string2 = string + "_literalCase";
            }
        }
        return string2;
    }

    private String doHighlight(IndexReader indexReader, int n, String string, Query query, String string2, boolean bl, String string3, String string4) {
        String string5 = null;
        try {
            TokenStream tokenStream = TokenSources.getTokenStream((IndexReader)indexReader, (int)n, (String)string);
            QueryScorer queryScorer = new QueryScorer(query, string);
            Object object = null;
            object = bl ? new NullFragmenter() : new SimpleSpanFragmenter(queryScorer);
            SimpleHTMLFormatter simpleHTMLFormatter = new SimpleHTMLFormatter(string3, string4);
            Highlighter highlighter = new Highlighter((Formatter)simpleHTMLFormatter, (Scorer)queryScorer);
            highlighter.setTextFragmenter((Fragmenter)object);
            string5 = highlighter.getBestFragment(tokenStream, string2);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)("IOException when trying to generate Words Around Hits " + iOException.getLocalizedMessage()));
            return "";
        }
        catch (InvalidTokenOffsetsException invalidTokenOffsetsException) {
            LOGGER.error((Object)("InvalidTokenOffsetsException when trying to generate Words Around Hits " + invalidTokenOffsetsException.getLocalizedMessage()));
            return "";
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string5;
    }

    private String highlightTitleText(IndexReader indexReader, int n, String string, Query query, String string2, int n2, String string3, String string4) {
        String string5 = null;
        if (string2 != null && string2.length() != 0 && n2 == 2) {
            string5 = this.doHighlight(indexReader, n, string, FTSQueryParser.createTitleQuery(query), string2, true, string3, string4);
            if (string5 == null) {
                string5 = string2;
            }
        } else {
            string5 = string2;
        }
        return string5;
    }

    private boolean userHasRights(String string, String string2, ArrayList<FTSService.QuerySchemas> arrayList) {
        boolean bl = false;
        block0: for (FTSService.QuerySchemas querySchemas : arrayList) {
            if (!string2.equals(querySchemas.schemaId)) continue;
            Iterator<String> iterator = querySchemas.queryFieldNames.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(string)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    private String getExcerpt(Document document, ArrayList<FTSService.QuerySchemas> arrayList) {
        List list = document.getFields();
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 30;
        while (iterator.hasNext()) {
            String string;
            Field field = (Field)iterator.next();
            if (!field.name().endsWith("_orig") || field.name().equals("title_orig") || field.name().equals("createTime_orig") || field.name().equals("modifiedTime_orig") || n <= 0 || !this.userHasRights(string = field.name().substring(0, field.name().length() - 5), document.getField("schemaId").stringValue(), arrayList)) continue;
            if (n != 30) {
                stringBuffer.append(" *** ");
            }
            String string2 = field.stringValue();
            n = this.getWords(string2, n, stringBuffer);
        }
        if (n == 0) {
            stringBuffer.append("...");
        }
        return stringBuffer.toString();
    }

    private int getWords(String string, int n, StringBuffer stringBuffer) {
        int n2 = 0;
        WordIterator wordIterator = new WordIterator(string);
        while (wordIterator.hasNext()) {
            wordIterator.next();
            if (n == 0) break;
            n2 = wordIterator.getEnd();
            --n;
        }
        stringBuffer.append(string.substring(0, n2));
        return n;
    }

    private void notWriterExceptionCheck(String string) throws FTSServiceException {
        if (!this.isWriter) {
            throw new FTSServiceException(this.getClass().getName() + " A writing method, " + string + ", was called to a non-writer instance of FTSService.");
        }
    }

    static {
        recentInit = null;
        entryFieldQueue = new Hashtable();
        memCheckCount = 0;
        checkCount = 1000;
        staticIndexWriter = null;
        indexSearcherQueue = new ArrayList();
    }

    public class FTSIndexDeletionPolicy
    implements IndexDeletionPolicy {
        public void onCommit(List list) throws IOException {
            LOGGER.debug((Object)"FTS-IndexDeletionPolicy::onCommit processing doDeletePolicy...");
            this.doDeletePolicy(list);
            LOGGER.debug((Object)"FTS-IndexDeletionPolicy::onCommit \tfinished doDeletePolicy...");
        }

        public void onInit(List list) throws IOException {
            LOGGER.debug((Object)"FTS-IndexDeletionPolicy::onInit processing doDeletePolicy...");
            this.doDeletePolicy(list);
            LOGGER.debug((Object)"FTS-IndexDeletionPolicy::onInit \tfinished doDeletePolicy...");
        }

        private void doDeletePolicy(List list) {
            LOGGER.debug((Object)("Delete Policy Time: " + LuceneFTSService.this.deletePolicyTime));
            int n = list.size();
            if (n > 1 && LuceneFTSService.this.deletePolicyTime > -1) {
                for (int i = 0; i < n - 1; ++i) {
                    try {
                        IndexCommit indexCommit = (IndexCommit)list.get(i);
                        long l = new Date().getTime();
                        long l2 = 1000 * LuceneFTSService.this.deletePolicyTime;
                        long l3 = ((IndexCommit)list.get(i + 1)).getTimestamp();
                        if (l - l3 <= l2) continue;
                        indexCommit.delete();
                        LOGGER.debug((Object)("FTS:Deleted prior-commit-point  Generation='" + indexCommit.getGeneration() + "'  File name='" + indexCommit.getSegmentsFileName() + "'  Version='" + indexCommit.getVersion() + "'  TS/CTS/Allowed/Delta='" + indexCommit.getTimestamp() + "/" + l + "/" + l2 + "/" + (l - l3) + "'  POS/Last='" + i + "/" + n + "'  Location='" + indexCommit.getDirectory() + "'."));
                        continue;
                    }
                    catch (IOException iOException) {
                        LOGGER.warn((Object)("FTS:Error(non-fatal) in doDeletePolicy: " + iOException.getLocalizedMessage()), (Throwable)iOException);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryDataSorter
    implements Comparator<FTSService.GlobalEntryData> {
        private String[] fieldsToSort = null;

        private EntryDataSorter() {
        }

        public void setFieldsToSort(String string) {
            this.fieldsToSort = string.split(";");
        }

        @Override
        public int compare(FTSService.GlobalEntryData globalEntryData, FTSService.GlobalEntryData globalEntryData2) {
            int n = 0;
            int n2 = 0;
            boolean bl = true;
            while (bl && n2 < this.fieldsToSort.length) {
                Number number;
                Object object;
                Object object2;
                String string = this.fieldsToSort[n2];
                if (string.equals("4")) {
                    object2 = Float.valueOf(globalEntryData.score);
                    object = Float.valueOf(globalEntryData2.score);
                    number = Float.valueOf(((Float)object2).floatValue() - ((Float)object).floatValue());
                    if (((Float)number).floatValue() != 0.0f) {
                        n = this.fieldsToSort[n2 + 1].equals("1") ? ((Float)object2).compareTo((Float)object) : ((Float)object2).compareTo((Float)object) * -1;
                        bl = false;
                        continue;
                    }
                    if (n2 < this.fieldsToSort.length - 1) {
                        n2 += 2;
                        continue;
                    }
                    n = 0;
                    continue;
                }
                if (string.equals("5") || string.equals("6")) {
                    object2 = this.getDateFieldData(string, globalEntryData);
                    object = this.getDateFieldData(string, globalEntryData2);
                    number = (Long)object2 - (Long)object;
                    if ((Long)number != 0L) {
                        n = this.fieldsToSort[n2 + 1].equals("1") ? ((Long)object2).compareTo((Long)object) : ((Long)object2).compareTo((Long)object) * -1;
                        bl = false;
                        continue;
                    }
                    if (n2 < this.fieldsToSort.length - 1) {
                        n2 += 2;
                        continue;
                    }
                    n = 0;
                    continue;
                }
                object2 = this.getFieldData(string, globalEntryData);
                if (!((String)object2).equals(object = this.getFieldData(string, globalEntryData2))) {
                    n = this.fieldsToSort[n2 + 1].equals("1") ? ((String)object2).compareToIgnoreCase((String)object) : ((String)object2).compareToIgnoreCase((String)object) * -1;
                    bl = false;
                    continue;
                }
                if (n2 < this.fieldsToSort.length - 1) {
                    n2 += 2;
                    continue;
                }
                n = 0;
                return 0;
            }
            return n;
        }

        private long getDateFieldData(String string, FTSService.GlobalEntryData globalEntryData) {
            long l = 0L;
            l = string.equals("6") ? Long.parseLong(globalEntryData.modifiedDate) : Long.parseLong(globalEntryData.createDate);
            return l;
        }

        private String getFieldData(String string, FTSService.GlobalEntryData globalEntryData) {
            String string2 = "";
            if (string.equals("0")) {
                string2 = globalEntryData.schemaId;
            } else if (string.equals("1")) {
                string2 = globalEntryData.entryId;
            } else if (string.equals("2")) {
                string2 = globalEntryData.title;
            } else if (string.equals("3")) {
                string2 = globalEntryData.excerpt;
            } else {
                ArrayList<FTSService.ReturnFilterFields> arrayList = globalEntryData.returnFilterFields;
                for (FTSService.ReturnFilterFields returnFilterFields : arrayList) {
                    if (!string.equals("\"" + returnFilterFields.filterField + "\"")) continue;
                    string2 = returnFilterFields.value;
                    break;
                }
            }
            return string2;
        }
    }

    private class FieldDataHolder {
        public String schemaId;
        public String entryId;
        public float docBoost;
        public String[] fieldNames;
        public String[] values;
        public BitSet[] fullTextOptions;
        public float[] fieldBoost;

        FieldDataHolder(String string, String string2, float f, String[] stringArray, String[] stringArray2, BitSet[] bitSetArray, float[] fArray) {
            this.schemaId = string;
            this.entryId = string2;
            this.docBoost = f;
            this.fieldNames = stringArray;
            this.values = stringArray2;
            this.fullTextOptions = bitSetArray;
            this.fieldBoost = fArray;
        }
    }
}

