/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.demo.javadriver;

import com.bmc.arsys.demo.javadriver.InputReader;
import com.bmc.arsys.demo.javadriver.JavaDriver;
import com.bmc.arsys.demo.javadriver.SyncObject;
import com.bmc.arsys.demo.javadriver.ThreadControlBlock;
import java.io.IOException;

class CommandProcessor {
    static final int SLEEP_ADJUST_FACTOR = 1;

    CommandProcessor() {
    }

    void randomSleep(long l, long l2) {
        int n = JavaDriver.getRandomNumber();
        if (n < 0) {
            n *= -1;
        }
        long l3 = l + ((long)n * (l2 - l) + (long)((JavaDriver.RAND_MAX + 1) / 2)) / (long)(JavaDriver.RAND_MAX + 1);
        JavaDriver.outputWriter.printResult("\n   Sleeping for " + l3 + " second(s)\n");
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        if (!threadControlBlock.isResultFileOpened()) {
            try {
                Thread.sleep(l3 * 1000L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            threadControlBlock.threadSleep(l3 * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseWaitingThreads() {
        SyncObject syncObject;
        JavaDriver.outputWriter.driverPrintHeader("RELEASE WAITING THREADS");
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        SyncObject syncObject2 = syncObject = threadControlBlock.getReleaseObject();
        synchronized (syncObject2) {
            syncObject.setFlag(true);
            syncObject.notifyAll();
        }
    }

    void sleepTimer() throws IOException {
        long l = InputReader.getLong("Number of seconds (0): ", 0L);
        JavaDriver.outputWriter.printResult("\n   Sleeping for" + l + " second(s) . . .\n");
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        threadControlBlock.threadSleep(l * 1000L);
    }

    void millisecondSleepTimer() throws IOException {
        JavaDriver.outputWriter.driverPrintHeader("MILLISECOND SLEEP TIMER");
        long l = InputReader.getLong("Number of milliseconds (0): ", 0L);
        ThreadControlBlock threadControlBlock = JavaDriver.getThreadControlBlockPtr();
        threadControlBlock.threadSleep(l);
    }

    void randomSleepTimer() throws IOException {
        long l = InputReader.getLong("Lower Bound (0): ", 0L);
        long l2 = InputReader.getLong("Upper Bound (0): ", 0L);
        if (l2 < l) {
            JavaDriver.outputWriter.driverPrintError(" **** upper bound is less than lower bound\n");
            return;
        }
        this.randomSleep(l, l2);
    }
}

