/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arrpc.nio;

import com.bmc.arsys.arrpc.nio.ArClientRequestHandler;
import com.bmc.arsys.arrpc.nio.ArRpcCallHandler;
import com.bmc.arsys.arrpc.nio.ArSelectorThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcPortmapClient;
import org.acplt.oncrpc.server.OncRpcDispatchable;
import org.acplt.oncrpc.server.OncRpcServerTransportRegistrationInfo;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ArTcpServerTransportBase {
    private static Logger case = Logger.getLogger(ArTcpServerTransportBase.class);
    private final ServerSocketChannel char = ServerSocketChannel.open();
    private final Selector do;
    private int try = 0;
    protected ArClientConnectionAcceptor acceptor;
    private boolean byte;
    private OncRpcDispatchable int;
    private int new;
    private OncRpcServerTransportRegistrationInfo[] if;
    private int for;
    ArSelectorThread[] callSelectors;
    protected int transmissionTimeout = 90000;
    private String a;

    public ArTcpServerTransportBase(InetAddress inetAddress, int n) throws IOException {
        this.char.socket().bind(new InetSocketAddress(inetAddress, n));
        this.char.configureBlocking(false);
        this.do = Selector.open();
        SelectionKey selectionKey = this.char.register(this.do, 16);
        this.acceptor = this.createAcceptor();
        selectionKey.attach(this.acceptor);
        this.initCallSelector();
    }

    protected ArClientConnectionAcceptor createAcceptor() {
        return new ArClientConnectionAcceptor();
    }

    protected abstract void initCallSelector() throws IOException;

    public ArTcpServerTransportBase(OncRpcDispatchable oncRpcDispatchable, InetAddress inetAddress, int n, OncRpcServerTransportRegistrationInfo[] oncRpcServerTransportRegistrationInfoArray, int n2, boolean bl) throws OncRpcException, IOException {
        this(inetAddress, n);
        System.out.println("Server binding to TCP port " + n);
        case.info((Object)("Server binding to TCP port " + n));
        this.for = n == 0 ? this.char.socket().getLocalPort() : n;
        this.int = oncRpcDispatchable;
        if (n2 < 1024) {
            n2 = 1024;
        }
        this.new = n2;
        this.if = oncRpcServerTransportRegistrationInfoArray;
        this.byte = bl;
    }

    public void register() throws OncRpcException {
        if (this.byte) {
            try {
                OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getByName("127.0.0.1"));
                int n = this.if.length;
                for (int i = 0; i < n; ++i) {
                    oncRpcPortmapClient.setPort(this.if[i].program, this.if[i].version, 6, this.for);
                }
            }
            catch (Throwable throwable) {
                throw new OncRpcException(16);
            }
        }
    }

    public void unregister() throws OncRpcException {
        if (this.byte) {
            try {
                OncRpcPortmapClient oncRpcPortmapClient = new OncRpcPortmapClient(InetAddress.getByName("127.0.0.1"));
                int n = this.if.length;
                for (int i = 0; i < n; ++i) {
                    oncRpcPortmapClient.unsetPort(this.if[i].program, this.if[i].version);
                }
            }
            catch (Throwable throwable) {
                throw new OncRpcException(16);
            }
        }
    }

    public void setTransmissionTimeout(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("transmission timeout must be > 0");
        }
        this.transmissionTimeout = n;
    }

    public int getTransmissionTimeout() {
        return this.transmissionTimeout;
    }

    public void setCharacterEncoding(String string) {
        this.a = string;
    }

    public String getCharacterEncoding() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            case.debug((Object)("Starting Reactor thread thats listening for client connections " + Thread.currentThread().getId()));
            Selector selector = this.do;
            while (!Thread.interrupted()) {
                Set<SelectionKey> set;
                selector.select();
                case.trace((Object)"******************************selector selected");
                Set<SelectionKey> set2 = set = selector.selectedKeys();
                synchronized (set2) {
                    Iterator<SelectionKey> iterator = set.iterator();
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (iterator.hasNext()) {
                        SelectionKey selectionKey = iterator.next();
                        case.trace((Object)("******************************Selector " + selectionKey.selector().hashCode() + " SelectionKey " + selectionKey.hashCode()));
                        if (!selectionKey.isValid() || !selectionKey.isAcceptable() || arrayList.contains(selectionKey.attachment())) continue;
                        arrayList.add(selectionKey.attachment());
                        case.trace((Object)("******************************Selector " + selectionKey.selector().hashCode() + " SelectionKey " + selectionKey.hashCode() + " contains a package"));
                        this.a(selectionKey);
                    }
                    arrayList.clear();
                    set.clear();
                }
            }
            return;
        }
        catch (Throwable throwable) {
            case.error((Object)"Exception in reactor thread.", throwable);
            System.out.println(throwable.getMessage());
            throwable.printStackTrace();
            return;
        }
        finally {
            this.cleanUp();
        }
    }

    private void a(SelectionKey selectionKey) {
        ArClientRequestHandler arClientRequestHandler = (ArClientRequestHandler)selectionKey.attachment();
        case.debug((Object)("dispatch SelectionKey " + selectionKey.hashCode() + " to attached connection acceptor: " + (arClientRequestHandler == null ? null : Integer.valueOf(arClientRequestHandler.hashCode()))));
        if (arClientRequestHandler != null) {
            arClientRequestHandler.handleRequest(selectionKey);
        }
    }

    public void cleanUp() {
        if (this.char != null) {
            try {
                this.do.close();
                this.acceptor.close();
                this.char.socket().close();
                this.char.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void finalize() throws Throwable {
        this.cleanUp();
        super.finalize();
    }

    protected ArSelectorThread[] getCallSelectors() {
        return this.callSelectors;
    }

    protected void setCallSelectors(ArSelectorThread[] arSelectorThreadArray) {
        this.callSelectors = arSelectorThreadArray;
    }

    protected void setCallSelector(int n, ArSelectorThread arSelectorThread) {
        if (this.callSelectors != null) {
            this.callSelectors[n] = arSelectorThread;
        }
    }

    protected OncRpcDispatchable getCallDispatcher() {
        return this.int;
    }

    protected int getSocketBufferSize() {
        return this.new;
    }

    protected class ArClientConnectionAcceptor
    implements ArClientRequestHandler {
        protected ArClientConnectionAcceptor() {
        }

        synchronized ArSelectorThread getNextSelector() {
            if (ArTcpServerTransportBase.this.try == ArTcpServerTransportBase.this.callSelectors.length) {
                ArTcpServerTransportBase.this.try = 0;
            }
            ArSelectorThread arSelectorThread = ArTcpServerTransportBase.this.callSelectors[ArTcpServerTransportBase.this.try++];
            return arSelectorThread;
        }

        public void handleRequest(SelectionKey selectionKey) {
            SocketChannel socketChannel = null;
            try {
                if (selectionKey.isValid() && selectionKey.isAcceptable() && (socketChannel = ArTcpServerTransportBase.this.char.accept()) != null) {
                    case.debug((Object)"Client connection accepted. Registering handler");
                    ArSelectorThread arSelectorThread = this.getNextSelector();
                    ArRpcCallHandler arRpcCallHandler = this.createHandler(arSelectorThread, socketChannel);
                    arSelectorThread.addHandler(arRpcCallHandler);
                }
            }
            catch (Throwable throwable) {
                case.error((Object)"Error accepting a connection or registering the handler for a connection", throwable);
                selectionKey.cancel();
                try {
                    selectionKey.channel().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (socketChannel != null) {
                        socketChannel.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public ArRpcCallHandler createHandler(ArSelectorThread arSelectorThread, SocketChannel socketChannel) throws IOException {
            throw new IOException("Method need to be overridden");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            int n = 0;
            ArSelectorThread[] arSelectorThreadArray = ArTcpServerTransportBase.this.callSelectors;
            synchronized (ArTcpServerTransportBase.this.callSelectors) {
                while (n < ArTcpServerTransportBase.this.callSelectors.length) {
                    ArTcpServerTransportBase.this.callSelectors[n++].close();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

