/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.web.servlet.tags;

import com.bmc.thirdparty.org.springframework.web.servlet.tags.HtmlEscapingAwareTag;
import com.bmc.thirdparty.org.springframework.web.util.ExpressionEvaluationUtils;
import com.bmc.thirdparty.org.springframework.web.util.HtmlUtils;
import com.bmc.thirdparty.org.springframework.web.util.JavaScriptUtils;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;

public class EscapeBodyTag
extends HtmlEscapingAwareTag
implements BodyTag {
    private boolean javaScriptEscape = false;
    private BodyContent bodyContent;

    public void setJavaScriptEscape(String javaScriptEscape) throws JspException {
        this.javaScriptEscape = ExpressionEvaluationUtils.evaluateBoolean("javaScriptEscape", javaScriptEscape, this.pageContext);
    }

    protected int doStartTagInternal() {
        return 2;
    }

    public void doInitBody() {
    }

    public void setBodyContent(BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public int doAfterBody() throws JspException {
        try {
            String content = this.readBodyContent();
            content = this.isHtmlEscape() ? HtmlUtils.htmlEscape(content) : content;
            content = this.javaScriptEscape ? JavaScriptUtils.javaScriptEscape(content) : content;
            this.writeBodyContent(content);
        }
        catch (IOException ex) {
            throw new JspException("Could not write escaped body", (Throwable)ex);
        }
        return 0;
    }

    protected String readBodyContent() throws IOException {
        return this.bodyContent.getString();
    }

    protected void writeBodyContent(String content) throws IOException {
        this.bodyContent.getEnclosingWriter().print(content);
    }
}

