/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.remoting.httpinvoker;

import com.bmc.thirdparty.org.aopalliance.intercept.MethodInterceptor;
import com.bmc.thirdparty.org.aopalliance.intercept.MethodInvocation;
import com.bmc.thirdparty.org.springframework.aop.support.AopUtils;
import com.bmc.thirdparty.org.springframework.remoting.RemoteAccessException;
import com.bmc.thirdparty.org.springframework.remoting.RemoteConnectFailureException;
import com.bmc.thirdparty.org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import com.bmc.thirdparty.org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import com.bmc.thirdparty.org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocation;
import com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocationBasedAccessor;
import com.bmc.thirdparty.org.springframework.remoting.support.RemoteInvocationResult;
import java.net.ConnectException;

public class HttpInvokerClientInterceptor
extends RemoteInvocationBasedAccessor
implements MethodInterceptor,
HttpInvokerClientConfiguration {
    private String codebaseUrl;
    private HttpInvokerRequestExecutor httpInvokerRequestExecutor = new SimpleHttpInvokerRequestExecutor();

    public void setCodebaseUrl(String codebaseUrl) {
        this.codebaseUrl = codebaseUrl;
    }

    public String getCodebaseUrl() {
        return this.codebaseUrl;
    }

    public void setHttpInvokerRequestExecutor(HttpInvokerRequestExecutor httpInvokerRequestExecutor) {
        this.httpInvokerRequestExecutor = httpInvokerRequestExecutor;
    }

    public HttpInvokerRequestExecutor getHttpInvokerRequestExecutor() {
        return this.httpInvokerRequestExecutor;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (AopUtils.isToStringMethod(methodInvocation.getMethod())) {
            return "HTTP invoker proxy for service URL [" + this.getServiceUrl() + "]";
        }
        RemoteInvocation invocation = this.createRemoteInvocation(methodInvocation);
        RemoteInvocationResult result = null;
        try {
            result = this.executeRequest(invocation);
        }
        catch (Throwable ex) {
            throw this.convertHttpInvokerAccessException(ex);
        }
        return this.recreateRemoteInvocationResult(result);
    }

    protected RemoteInvocationResult executeRequest(RemoteInvocation invocation) throws Exception {
        return this.getHttpInvokerRequestExecutor().executeRequest(this, invocation);
    }

    protected RemoteAccessException convertHttpInvokerAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            throw new RemoteConnectFailureException("Cannot connect to HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
        }
        if (ex instanceof ClassNotFoundException) {
            throw new RemoteAccessException("Cannot deserialize result from HTTP invoker remote service [" + this.getServiceUrl() + "]", ex);
        }
        throw new RemoteAccessException("Cannot access HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
    }
}

