/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.pluginsvr.binding;

import com.bmc.arsys.pluginsvr.ARPluginServerConfiguration;
import com.bmc.arsys.pluginsvr.ARWorkQueueMonitor;
import com.bmc.arsys.pluginsvr.binding.ARPluginSvrThreadPoolExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ARPluginSvrExecutorFactory {
    private static Logger log = Logger.getLogger(ARPluginSvrExecutorFactory.class);
    private static Executor selectionExecutor;
    private static ARPluginSvrThreadPoolExecutor rpcCallExecutor;
    private static BlockingQueue<Runnable> workQueue;
    private static ThreadFactory threadFactory;

    public static Executor getSelectionExecutor() {
        if (selectionExecutor == null) {
            ARPluginSvrExecutorFactory.createSelectionExecutor();
        }
        return selectionExecutor;
    }

    public static Executor getRPCCallExecutor() {
        if (rpcCallExecutor == null) {
            ARPluginSvrExecutorFactory.createExecutor();
        }
        return rpcCallExecutor;
    }

    public static Executor terminateAllPlugins() {
        if (rpcCallExecutor != null) {
            rpcCallExecutor.shutdown();
        }
        return rpcCallExecutor;
    }

    private static synchronized void createExecutor() {
        if (rpcCallExecutor == null) {
            ARPluginServerConfiguration aRPluginServerConfiguration = ARPluginServerConfiguration.getInstance();
            workQueue = new LinkedBlockingQueue<Runnable>();
            log.info((Object)("ARPluginSvrThreadPoolExecutor: coreT:" + aRPluginServerConfiguration.getNumCoreThreads() + " maxT:" + aRPluginServerConfiguration.getMaxThreads() + " ThreadAliveIdleInSecond:" + aRPluginServerConfiguration.getThreadTimeout()));
            threadFactory = Executors.defaultThreadFactory();
            long l = aRPluginServerConfiguration.getThreadTimeout();
            if (l == 0L) {
                l = Long.MAX_VALUE;
            }
            rpcCallExecutor = new ARPluginSvrThreadPoolExecutor(aRPluginServerConfiguration.getNumCoreThreads(), aRPluginServerConfiguration.getMaxThreads(), aRPluginServerConfiguration.getThreadTimeout(), TimeUnit.SECONDS, workQueue, threadFactory);
            try {
                rpcCallExecutor.prestartAllCoreThreads();
            }
            catch (Throwable throwable) {
                log.error((Object)("Can not prestart all core threads: " + throwable));
            }
            if (aRPluginServerConfiguration.getWorkQueueMonitorLogInterval() > 0L) {
                Thread thread = new Thread(new ARWorkQueueMonitor(rpcCallExecutor, threadFactory, workQueue));
                thread.start();
            }
        }
    }

    private static synchronized void createSelectionExecutor() {
        if (selectionExecutor == null) {
            selectionExecutor = new ThreadPoolExecutor(ARPluginServerConfiguration.getInstance().getNumSelectorThreads(), ARPluginServerConfiguration.getInstance().getNumSelectorThreads(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
    }

    protected void finalize() throws Throwable {
        ARPluginSvrExecutorFactory.terminateAllPlugins();
        super.finalize();
    }
}

