/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugins.ftsplugin;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.plugins.ftsplugin.FTSPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FTSPluginTest {
    private FTSPlugin plugin;
    public static final int schemaid = 41;
    public static final String char_field = "536870913";
    public static final String char_field2 = "536870914";
    public static final String attach_field = "536870915";
    public static final String diary_field = "536870916";
    public static final String entryid = "011";
    public static final String entryid2 = "012";
    public static final String entryid3 = "013";
    public static final String entryid4 = "014";
    public static final String char_returnField1 = "536770001";
    public static final String char_returnField2 = "536770002";
    public static String delimStr = new String(new Character('\u0001').toString());

    @BeforeClass
    public static void beforeClass() throws Exception {
        System.out.println("FTS plugin tests started ");
        FTSPluginTest.copyDirectory(new File("..\\..\\tests\\data\\plugins\\ftsplugin"), new File("c:\\temp"));
        FTSPluginTest.copyDirectory(new File("..\\..\\src\\etc\\arfts\\conf"), new File("c:\\temp\\config"));
    }

    @AfterClass
    public static void afterClass() {
        System.out.println("Done with FTS plugin tests ");
    }

    @Before
    public void beforeTest() throws Exception {
        this.plugin = new FTSPlugin();
        FTSPlugin.init(null);
        this.initFTS();
    }

    @After
    public void afterTest() throws Exception {
        this.deleteAllIndices();
        this.plugin.terminate(null);
    }

    @Test
    public void testInitOperation() throws Exception {
        System.out.println("testInitOperation");
        this.initFTS();
    }

    @Test
    public void testSetDocBoost() throws Exception {
        System.out.println("testSetDocBoostEffectOnRelevancy");
        this.test_setDocBoostEffectOnRelevancy();
    }

    @Test
    public void testIndexCharField() throws Exception {
        System.out.println("testIndexCharField");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
    }

    @Test
    public void testIndexCharFieldMultiple() throws Exception {
        System.out.println("testmultipleIndexCharField");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.indexFTS(41, char_field, entryid2, new Value("sour"), false, 1);
        this.indexFTS(41, char_field, entryid3, new Value("sour grape"), false, 1);
    }

    @Test
    public void testSearchIndex() throws Exception {
        System.out.println("testSearchIndex");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        List<Value> list = this.getFTS(41, char_field, "%apple%");
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)2, (Object)list.size());
        Assert.assertEquals((Object)entryid, (Object)list.get(0).toString());
    }

    @Test
    public void testSearchMultipleIndex() throws Exception {
        System.out.println("testSearchMultipleIndex");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.indexFTS(41, char_field, entryid2, new Value("sour"), false, 1);
        this.indexFTS(41, char_field, entryid3, new Value("sour grape"), false, 1);
        List<Value> list = this.getFTS(41, char_field, "%sour%");
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)4, (Object)list.size());
        for (Value value : list) {
            if (value.getDataType().toInt() == 3) continue;
            if (entryid3.equals(value.toString())) {
                Assert.assertEquals((Object)entryid3, (Object)value.toString());
                continue;
            }
            Assert.assertEquals((Object)entryid2, (Object)value.toString());
        }
    }

    @Test
    public void testIndexSearchAnotherCharField() throws Exception {
        System.out.println("testIndexSearchAnotherCharField");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.indexFTS(41, char_field2, entryid, new Value("sweet orange"), false, 1);
        List<Value> list = this.getFTS(41, char_field2, "%orange%");
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)2, (Object)list.size());
        Assert.assertEquals((Object)entryid, (Object)list.get(0).toString());
    }

    @Test
    public void testUpdateIndexCharField() throws Exception {
        System.out.println("testUpdateIndexCharField");
        this.indexFTS(41, char_field, entryid, new Value("banana"), false, 1);
        this.indexFTS(41, char_field2, entryid, new Value("sweet orange"), false, 1);
        this.indexFTS(41, char_field, entryid, new Value("An apple a day keeps the doctor away"), false, 1);
        List<Value> list = this.getFTS(41, char_field, "%doctor%");
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)2, (Object)list.size());
        Assert.assertEquals((Object)entryid, (Object)list.get(0).toString());
        list = this.getFTS(41, char_field2, "%orange%");
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)2, (Object)list.size());
        Assert.assertEquals((Object)entryid, (Object)list.get(0).toString());
        list = this.getFTS(41, char_field, "banana");
        Assert.assertNull(list);
    }

    @Test
    public void testIndexSearchAttachFieldTextFile() throws Exception {
        String string = "c:\\temp\\fts.txt";
        System.out.println("testIndexSearchAttachFieldTextFile: " + string);
        this.testIndexSearchAttachField(string, "%text%");
    }

    @Test
    public void testIndexSearchAttachFieldLargeTextFile() throws Exception {
        String string = "c:\\temp\\ftslarge.txt";
        System.out.println("testIndexSearchAttachFieldLargeTextFile: " + string);
        this.testIndexSearchAttachField(string, "%ANDROMEDE%");
    }

    @Test
    public void testIndexSearchAttachFieldDocFile() throws Exception {
        String string = "c:\\temp\\fts.doc";
        System.out.println("testIndexSearchAttachFieldDocFile: " + string);
        this.testIndexSearchAttachField(string, "%word%");
    }

    @Test
    public void testIndexSearchAttachFieldLargeDocFile() throws Exception {
        String string = "c:\\temp\\ftslarge.doc";
        System.out.println("testIndexSearchAttachFieldLargeDocFile: " + string);
        this.testIndexSearchAttachField(string, "%GENEMEDE%");
    }

    @Test
    public void testIndexSearchAttachFieldPDFFile() throws Exception {
        String string = "c:\\temp\\fts.pdf";
        System.out.println("testIndexSearchAttachFieldPDFFile: " + string);
        this.testIndexSearchAttachField(string, "%Restart IIS%");
    }

    @Test
    public void testIndexSearchAttachFieldPPTFile() throws Exception {
        String string = "c:\\temp\\fts.ppt";
        System.out.println("testIndexSearchAttachFieldPPTFile: " + string);
        this.testIndexSearchAttachField(string, "%powerpoint%");
    }

    @Test
    public void testIndexSearchAttachFieldXMLFile() throws Exception {
        String string = "c:\\temp\\fts.xml";
        System.out.println("testIndexSearchAttachFieldXMLFile: " + string);
        this.testIndexSearchAttachField(string, "%clover%");
    }

    @Test
    public void testIndexSearchAttachFieldHTMLFile() throws Exception {
        String string = "c:\\temp\\fts.html";
        System.out.println("testIndexSearchAttachFieldHTMLFile: " + string);
        this.testIndexSearchAttachField(string, "%webservice%");
    }

    @Test
    public void testIndexSearchAttachFieldRTFFile() throws Exception {
        String string = "c:\\temp\\fts.rtf";
        System.out.println("testIndexSearchAttachFieldRTFFile: " + string);
        this.testIndexSearchAttachField(string, "%TikaDocHandler%");
    }

    @Test
    public void testIndexSearchAttachFieldACTFile() throws Exception {
        String string = "c:\\temp\\fts.act";
        System.out.println("testIndexSearchAttachFieldACTFile: " + string);
        this.testIndexSearchAttachField(string, "%UserGroup%");
    }

    @Test
    public void testIndexSearchAttachFieldJPGFile() throws Exception {
        String string = "c:\\temp\\fts.jpg";
        System.out.println("testIndexSearchAttachFieldJPGFile: " + string);
        this.testIndexSearchAttachField(string, "%jpg%");
    }

    @Test
    public void testIndexSearchAttachFieldMultiFile() throws Exception {
        String string = "c:\\temp\\fts.doc";
        System.out.println("testIndexSearchAttachFieldMultiFile: " + string);
        this.testIndexSearchAttachField(string, "%fts%");
        string = "c:\\temp\\fts.bat";
        this.testIndexSearchAttachField(string, "%build%");
    }

    @Test
    public void testIndexSearchAttachFieldZeroLenFile() throws Exception {
        String string = "c:\\temp\\zero.zip";
        System.out.println("testIndexSearchAttachFieldZeroLenFile: " + string);
        this.testIndexSearchAttachField(string, "%zip%");
    }

    private void testIndexSearchAttachField(String string, String string2) throws Exception {
        AttachmentValue attachmentValue = new AttachmentValue(string, string);
        if (attachmentValue.getLocationType() != 1 && attachmentValue.getLocationType() != 2) {
            Assert.fail((String)"Bad Location type in Attachment, probably file does not exist");
        }
        this.indexFTS(41, attach_field, entryid4, new Value(attachmentValue), false, 1);
        List<Value> list = this.getFTS(41, attach_field, string2);
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)2, (Object)list.size());
        Assert.assertEquals((Object)entryid4, (Object)list.get(0).toString());
        this.deleteFTS(41, attach_field, entryid4);
        attachmentValue.setLocationType(1);
        attachmentValue.setFilePath(string);
        this.indexFTS(41, attach_field, entryid4, new Value(attachmentValue), false, 1);
        list = this.getFTS(41, attach_field, string2);
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)2, (Object)list.size());
        Assert.assertEquals((Object)entryid4, (Object)list.get(0).toString());
    }

    @Test
    public void testIndexSearchDiaryField() throws Exception {
        System.out.println("testIndexSearchDiaryField");
        boolean bl = false;
        DiaryListValue diaryListValue = new DiaryListValue();
        diaryListValue.setAppendedText("added new entry");
        try {
            this.indexFTS(41, diary_field, entryid4, new Value(diaryListValue), false, 1);
        }
        catch (ARException aRException) {
            bl = true;
            Assert.assertEquals((Object)663, (Object)((int)((StatusInfo)aRException.getLastStatus().get(0)).getMessageNum()));
        }
        Assert.assertEquals((Object)true, (Object)bl);
    }

    @Test
    public void testDeletingDocuments1() throws Exception {
        System.out.println("testDeletingDocuments1");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.deleteFTS(41, null, null);
        List<Value> list = this.getFTS(41, char_field, "apple");
        Assert.assertNull(list);
    }

    @Test
    public void testDeletingDocuments2() throws Exception {
        System.out.println("testDeletingDocuments2");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.deleteFTS(41, null, entryid);
        List<Value> list = this.getFTS(41, char_field, "apple");
        Assert.assertNull(list);
    }

    @Test
    public void testDeletingDocuments3() throws Exception {
        System.out.println("testDeletingDocuments3");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.deleteFTS(41, char_field, null);
        List<Value> list = this.getFTS(41, char_field, "apple");
        Assert.assertNull(list);
    }

    @Test
    public void testDeletingDocuments4() throws Exception {
        System.out.println("testDeletingDocuments4");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.indexFTS(41, char_field2, entryid, new Value("banana"), false, 1);
        this.deleteFTS(41, char_field, entryid);
        List<Value> list = this.getFTS(41, char_field2, "banana");
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)2, (Object)list.size());
        Assert.assertEquals((Object)entryid, (Object)list.get(0).toString());
        list = this.getFTS(41, char_field, "apple");
        Assert.assertNull(list);
    }

    @Test
    public void testDeletingDocuments5() throws Exception {
        System.out.println("testDeletingDocuments5");
        this.indexFTS(41, char_field, entryid, new Value("apple"), false, 1);
        this.deleteFTS(0, null, null);
        try {
            List<Value> list = this.getFTS(41, char_field, "apple");
            Assert.assertTrue((boolean)false);
        }
        catch (ARException aRException) {
            String string = aRException.getMessage();
            Assert.assertTrue((boolean)string.contains("Likely cause is index does not exist"));
        }
    }

    @Test
    public void testMultiGetOperation_noReturnFields_Opt_0() throws Exception {
        System.out.println("testMultiGetOperation_noReturnFields_Opt_0");
        int n = 100;
        int n2 = 102;
        int n3 = 103;
        this.prepareIndexForMultiGetOperation(n, n2, n3, false);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(8));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n + ";");
        stringBuffer.append(n2 + ";");
        stringBuffer.append(n3);
        arrayList.add(new Value(stringBuffer.toString()));
        this.prepareComplexInputArguments(arrayList, stringBuffer, false, 0);
        List<Value> list = this.plugin.filterAPICall(null, arrayList);
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)4, (Object)list.size());
        Assert.assertEquals((Object)"3", (Object)list.get(0).toString().trim());
        for (int i = 1; i < list.size(); ++i) {
            String string = list.get(i).toString();
            String[] stringArray = string.split(";");
            Assert.assertTrue((stringArray.length >= 8 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiGetOperation_withReturnFields_Opt_0() throws Exception {
        System.out.println("testMultiGetOperation_withReturnFields_Opt_0");
        int n = 100;
        int n2 = 102;
        int n3 = 103;
        this.prepareIndexForMultiGetOperation(n, n2, n3, true);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(8));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n + ";");
        stringBuffer.append(n2 + ";");
        stringBuffer.append(n3);
        arrayList.add(new Value(stringBuffer.toString()));
        this.prepareComplexInputArguments(arrayList, stringBuffer, true, 0);
        List<Value> list = this.plugin.filterAPICall(null, arrayList);
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)4, (Object)list.size());
        Assert.assertEquals((Object)"3", (Object)list.get(0).toString().trim());
        for (int i = 1; i < list.size(); ++i) {
            String string = list.get(i).toString();
            String[] stringArray = string.split(";");
            Assert.assertTrue((stringArray.length == 14 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)stringArray[7].equalsIgnoreCase("3"));
            String string2 = stringArray[0];
            Assert.assertTrue((boolean)stringArray[8].equalsIgnoreCase(delimStr + char_returnField1 + delimStr));
            Assert.assertTrue((boolean)stringArray[9].equalsIgnoreCase(delimStr + string2 + "_returnField1" + delimStr));
            Assert.assertTrue((boolean)stringArray[10].equalsIgnoreCase(delimStr + char_returnField2 + delimStr));
            Assert.assertTrue((boolean)stringArray[11].equalsIgnoreCase(delimStr + string2 + "_returnField2" + delimStr));
            Assert.assertTrue((boolean)stringArray[12].equalsIgnoreCase(delimStr + "title" + delimStr));
            Assert.assertTrue((boolean)stringArray[13].equalsIgnoreCase(delimStr + string2 + "_title" + delimStr));
        }
    }

    @Test
    public void testMultiGetOperation_noReturnFields_Opt_1() throws Exception {
        System.out.println("testMultiGetOperation_noReturnFields_Opt_1");
        int n = 100;
        int n2 = 102;
        int n3 = 103;
        this.prepareIndexForMultiGetOperation(n, n2, n3, false);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(8));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n + ";");
        stringBuffer.append(n2 + ";");
        stringBuffer.append(n3);
        arrayList.add(new Value(stringBuffer.toString()));
        this.prepareComplexInputArguments(arrayList, stringBuffer, false, 1);
        List<Value> list = this.plugin.filterAPICall(null, arrayList);
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)4, (Object)list.size());
        Assert.assertEquals((Object)"3", (Object)list.get(0).toString().trim());
        for (int i = 1; i < list.size(); ++i) {
            String string = list.get(i).toString();
            String[] stringArray = string.split(";");
            Assert.assertTrue((stringArray.length >= 8 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiGetOperation_withReturnFields_Opt_1() throws Exception {
        System.out.println("testMultiGetOperation_withReturnFields_Opt_1");
        int n = 100;
        int n2 = 102;
        int n3 = 103;
        this.prepareIndexForMultiGetOperation(n, n2, n3, true);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(8));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n + ";");
        stringBuffer.append(n2 + ";");
        stringBuffer.append(n3);
        arrayList.add(new Value(stringBuffer.toString()));
        this.prepareComplexInputArguments(arrayList, stringBuffer, true, 1);
        List<Value> list = this.plugin.filterAPICall(null, arrayList);
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)4, (Object)list.size());
        Assert.assertEquals((Object)"3", (Object)list.get(0).toString().trim());
        for (int i = 1; i < list.size(); ++i) {
            String string = list.get(i).toString();
            String[] stringArray = string.split(";");
            Assert.assertTrue((stringArray.length == 14 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)stringArray[7].equalsIgnoreCase("3"));
            String string2 = stringArray[0];
            Assert.assertTrue((boolean)stringArray[8].equalsIgnoreCase(delimStr + char_returnField1 + delimStr));
            Assert.assertTrue((boolean)stringArray[9].equalsIgnoreCase(delimStr + string2 + "_returnField1" + delimStr));
            Assert.assertTrue((boolean)stringArray[10].equalsIgnoreCase(delimStr + char_returnField2 + delimStr));
            Assert.assertTrue((boolean)stringArray[11].equalsIgnoreCase(delimStr + string2 + "_returnField2" + delimStr));
            Assert.assertTrue((boolean)stringArray[12].equalsIgnoreCase(delimStr + "title" + delimStr));
            Assert.assertTrue((boolean)stringArray[13].equalsIgnoreCase(delimStr + string2 + "_title" + delimStr));
        }
    }

    @Test
    public void testMultiGetOperation_noReturnFields_Opt_2() throws Exception {
        System.out.println("testMultiGetOperation_noReturnFields_Opt_2");
        int n = 100;
        int n2 = 102;
        int n3 = 103;
        this.prepareIndexForMultiGetOperation(n, n2, n3, false);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(8));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n + ";");
        stringBuffer.append(n2 + ";");
        stringBuffer.append(n3);
        arrayList.add(new Value(stringBuffer.toString()));
        this.prepareComplexInputArguments(arrayList, stringBuffer, false, 2);
        List<Value> list = this.plugin.filterAPICall(null, arrayList);
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)4, (Object)list.size());
        Assert.assertEquals((Object)"3", (Object)list.get(0).toString().trim());
        for (int i = 1; i < list.size(); ++i) {
            String string = list.get(i).toString();
            String[] stringArray = string.split(";");
            Assert.assertTrue((stringArray.length >= 8 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultiGetOperation_withReturnFields_Opt_2() throws Exception {
        System.out.println("testMultiGetOperation_withReturnFields_Opt_2");
        int n = 100;
        int n2 = 102;
        int n3 = 103;
        this.prepareIndexForMultiGetOperation(n, n2, n3, true);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(8));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n + ";");
        stringBuffer.append(n2 + ";");
        stringBuffer.append(n3);
        arrayList.add(new Value(stringBuffer.toString()));
        this.prepareComplexInputArguments(arrayList, stringBuffer, true, 2);
        List<Value> list = this.plugin.filterAPICall(null, arrayList);
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)4, (Object)list.size());
        Assert.assertEquals((Object)"3", (Object)list.get(0).toString().trim());
        for (int i = 1; i < list.size(); ++i) {
            String string = list.get(i).toString();
            String[] stringArray = string.split(";");
            Assert.assertTrue((stringArray.length == 14 ? 1 : 0) != 0);
            Assert.assertTrue((boolean)stringArray[7].equalsIgnoreCase("3"));
            String string2 = stringArray[0];
            Assert.assertTrue((boolean)stringArray[8].equalsIgnoreCase(delimStr + char_returnField1 + delimStr));
            Assert.assertTrue((boolean)stringArray[9].equalsIgnoreCase(delimStr + string2 + "_returnField1" + delimStr));
            Assert.assertTrue((boolean)stringArray[10].equalsIgnoreCase(delimStr + char_returnField2 + delimStr));
            Assert.assertTrue((boolean)stringArray[11].equalsIgnoreCase(delimStr + string2 + "_returnField2" + delimStr));
            Assert.assertTrue((boolean)stringArray[12].equalsIgnoreCase(delimStr + "title" + delimStr));
            Assert.assertTrue((boolean)stringArray[13].equalsIgnoreCase(delimStr + string2 + "_title" + delimStr));
        }
    }

    @Test
    public void testMultiGetOperation_noReturnFields_Opt_3() throws Exception {
        System.out.println("testMultiGetOperation_noReturnFields_Opt_3");
        int n = 100;
        int n2 = 102;
        int n3 = 103;
        this.prepareIndexForMultiGetOperation(n, n2, n3, false);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(8));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n + ";");
        stringBuffer.append(n2 + ";");
        stringBuffer.append(n3);
        arrayList.add(new Value(stringBuffer.toString()));
        this.prepareComplexInputArguments(arrayList, stringBuffer, false, 3);
        List<Value> list = this.plugin.filterAPICall(null, arrayList);
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)1, (Object)list.size());
        Assert.assertEquals((Object)"3", (Object)list.get(0).toString().trim());
    }

    @Test
    public void testMultiGetOperation_withReturnFields_Opt_3() throws Exception {
        System.out.println("testMultiGetOperation_withReturnFields_Opt_3");
        int n = 100;
        int n2 = 102;
        int n3 = 103;
        this.prepareIndexForMultiGetOperation(n, n2, n3, true);
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(8));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n + ";");
        stringBuffer.append(n2 + ";");
        stringBuffer.append(n3);
        arrayList.add(new Value(stringBuffer.toString()));
        this.prepareComplexInputArguments(arrayList, stringBuffer, true, 3);
        List<Value> list = this.plugin.filterAPICall(null, arrayList);
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)1, (Object)list.size());
        Assert.assertEquals((Object)"3", (Object)list.get(0).toString().trim());
    }

    private void prepareComplexInputArguments(List<Value> list, StringBuffer stringBuffer, boolean bl, int n) {
        this.prepareFieldListStr(list, stringBuffer);
        this.prepareFTOptionListStr(list, stringBuffer);
        list.add(new Value(""));
        list.add(new Value("apple OR banana OR grape"));
        list.add(new Value(""));
        list.add(new Value(""));
        list.add(new Value(n));
        list.add(new Value("1;2"));
        if (bl) {
            list.add(new Value("536770001;536770002;title"));
        } else {
            list.add(new Value(""));
        }
        list.add(new Value(0));
        list.add(new Value(""));
    }

    private void prepareIndexForMultiGetOperation(int n, int n2, int n3, boolean bl) throws Exception {
        int n4 = n;
        this.indexFTS(n4, char_field, entryid, new Value("apple"), false, 1);
        this.indexFTS(n4, char_field2, entryid, new Value("apple1"), false, 1);
        this.indexFTS(n4, "title", entryid, new Value(n4 + "_title"), false, 1);
        if (bl) {
            this.indexFTS(n4, char_returnField1, entryid, new Value(n4 + "_returnField1"), false, 1);
            this.indexFTS(n4, char_returnField2, entryid, new Value(n4 + "_returnField2"), false, 1);
        }
        n4 = n2;
        this.indexFTS(n4, char_field, entryid, new Value("banana"), false, 1);
        this.indexFTS(n4, char_field2, entryid, new Value("banana1"), false, 1);
        this.indexFTS(n4, "title", entryid, new Value(n4 + "_title"), false, 1);
        if (bl) {
            this.indexFTS(n4, char_returnField1, entryid, new Value(n4 + "_returnField1"), false, 1);
            this.indexFTS(n4, char_returnField2, entryid, new Value(n4 + "_returnField2"), false, 1);
        }
        n4 = n3;
        this.indexFTS(n4, char_field, entryid, new Value("grape"), false, 1);
        this.indexFTS(n4, "title", entryid, new Value(n4 + "_title"), false, 1);
        if (bl) {
            this.indexFTS(n4, char_returnField1, entryid, new Value(n4 + "_returnField1"), false, 1);
            this.indexFTS(n4, char_returnField2, entryid, new Value(n4 + "_returnField2"), false, 1);
        }
    }

    private void prepareFieldListStr(List<Value> list, StringBuffer stringBuffer) {
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append("536870913;");
        stringBuffer.append(char_field2);
        stringBuffer.append("#");
        stringBuffer.append("536870913;");
        stringBuffer.append(char_field2);
        stringBuffer.append("#");
        stringBuffer.append(char_field);
        list.add(new Value(stringBuffer.toString()));
    }

    private void prepareFTOptionListStr(List<Value> list, StringBuffer stringBuffer) {
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(Integer.toString(1) + ";");
        stringBuffer.append(Integer.toString(1));
        stringBuffer.append("#");
        stringBuffer.append(Integer.toString(1) + ";");
        stringBuffer.append(Integer.toString(1));
        stringBuffer.append("#");
        stringBuffer.append(Integer.toString(1));
        list.add(new Value(stringBuffer.toString()));
    }

    private void deleteAllIndices() throws Exception {
        this.deleteFTS(0, null, null);
    }

    private void initFTS() throws Exception {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(0));
        arrayList.add(new Value("c:\\arfts\\index\\test"));
        arrayList.add(new Value("c:\\temp\\config"));
        arrayList.add(new Value(1));
        arrayList.add(new Value("c:\\arfts\\stop.txt"));
        arrayList.add(new Value(500));
        arrayList.add(new Value("en"));
        this.plugin.filterAPICall(null, arrayList);
    }

    private void indexFTS(int n, String string, String string2, Value value, boolean bl, int n2) throws Exception {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        if (bl) {
            arrayList.add(new Value(2));
        } else {
            arrayList.add(new Value(1));
        }
        arrayList.add(new Value(n));
        arrayList.add(new Value(string));
        arrayList.add(new Value(string2));
        arrayList.add(new Value(0));
        arrayList.add(new Value(0));
        arrayList.add(value);
        arrayList.add(new Value(1));
        arrayList.add(new Value(n2));
        this.plugin.filterAPICall(null, arrayList);
    }

    private void deleteFTS(int n, String string, String string2) throws Exception {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(3));
        if (n != 0) {
            arrayList.add(new Value(41));
            if (string != null && string.length() != 0 || string2 != null) {
                arrayList.add(new Value(string));
                if (string2 != null) {
                    arrayList.add(new Value(entryid));
                }
            }
        }
        this.plugin.filterAPICall(null, arrayList);
    }

    private List<Value> getFTS(int n, String string, String string2) throws Exception {
        ArrayList<Value> arrayList = new ArrayList<Value>();
        arrayList.add(new Value(4));
        arrayList.add(new Value(n));
        arrayList.add(new Value(string));
        arrayList.add(new Value(string2));
        arrayList.add(new Value(1));
        return this.plugin.filterAPICall(null, arrayList);
    }

    private void test_setDocBoostEffectOnRelevancy() throws Exception {
        List<Value> list = null;
        ArrayList<Object> arrayList = null;
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[4];
        float[] fArray4 = new float[4];
        this.indexFTS(41, char_field, entryid, new Value("toasteronthemaxsetting one"), false, 1);
        this.indexFTS(41, char_field, entryid2, new Value("toasteronthemaxsetting two"), false, 1);
        this.indexFTS(41, char_field, entryid3, new Value("toasteronthemaxsetting three"), false, 1);
        this.indexFTS(41, char_field, entryid4, new Value("toasteronthemaxsetting four"), false, 1);
        for (int i = 11; i <= 14; ++i) {
            arrayList = new ArrayList<Value>();
            arrayList.add(new Value(9));
            arrayList.add(new Value(41));
            arrayList.add(new Value(Integer.toString(i)));
            arrayList.add(new Value(1.0));
            this.plugin.filterAPICall(null, arrayList);
        }
        list = this.getFTS(41, char_field, "toasteronthemaxsetting");
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)8, (Object)list.size());
        fArray[0] = (float)list.get(1).getDoubleValue();
        fArray[1] = (float)list.get(3).getDoubleValue();
        fArray[2] = (float)list.get(5).getDoubleValue();
        fArray[3] = (float)list.get(7).getDoubleValue();
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(fArray[0]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(fArray[1]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(fArray[2]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(fArray[3]));
        arrayList = new ArrayList();
        arrayList.add(new Value(9));
        arrayList.add(new Value(41));
        arrayList.add(new Value(entryid2));
        arrayList.add(new Value(1.5));
        this.plugin.filterAPICall(null, arrayList);
        list = this.getFTS(41, char_field, "toasteronthemaxsetting");
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)8, (Object)list.size());
        fArray2[0] = (float)list.get(1).getDoubleValue();
        fArray2[1] = (float)list.get(3).getDoubleValue();
        fArray2[2] = (float)list.get(5).getDoubleValue();
        fArray2[3] = (float)list.get(7).getDoubleValue();
        Assert.assertTrue((fArray2[1] == 100.0f ? 1 : 0) != 0);
        Assert.assertTrue((fArray2[0] < fArray2[1] ? 1 : 0) != 0);
        Assert.assertTrue((fArray2[2] < fArray2[1] ? 1 : 0) != 0);
        Assert.assertTrue((fArray2[3] < fArray2[1] ? 1 : 0) != 0);
        arrayList = new ArrayList();
        arrayList.add(new Value(9));
        arrayList.add(new Value(41));
        arrayList.add(new Value(entryid3));
        arrayList.add(new Value(0.5));
        this.plugin.filterAPICall(null, arrayList);
        list = this.getFTS(41, char_field, "toasteronthemaxsetting");
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)8, (Object)list.size());
        fArray3[0] = (float)list.get(1).getDoubleValue();
        fArray3[1] = (float)list.get(3).getDoubleValue();
        fArray3[2] = (float)list.get(5).getDoubleValue();
        fArray3[3] = (float)list.get(7).getDoubleValue();
        Assert.assertTrue((fArray3[1] == 100.0f ? 1 : 0) != 0);
        Assert.assertTrue((fArray3[0] < fArray3[1] ? 1 : 0) != 0);
        Assert.assertTrue((fArray3[3] < fArray3[1] ? 1 : 0) != 0);
        Assert.assertTrue((fArray3[2] < fArray3[3] ? 1 : 0) != 0);
        arrayList = new ArrayList();
        arrayList.add(new Value(9));
        arrayList.add(new Value(41));
        arrayList.add(new Value(entryid2));
        arrayList.add(new Value(1.0));
        this.plugin.filterAPICall(null, arrayList);
        arrayList = new ArrayList();
        arrayList.add(new Value(9));
        arrayList.add(new Value(41));
        arrayList.add(new Value(entryid3));
        arrayList.add(new Value(1.0));
        this.plugin.filterAPICall(null, arrayList);
        list = this.getFTS(41, char_field, "toasteronthemaxsetting");
        Assert.assertNotNull(list);
        Assert.assertEquals((Object)8, (Object)list.size());
        fArray4[0] = (float)list.get(1).getDoubleValue();
        fArray4[1] = (float)list.get(3).getDoubleValue();
        fArray4[2] = (float)list.get(5).getDoubleValue();
        fArray4[3] = (float)list.get(7).getDoubleValue();
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(fArray4[0]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(fArray4[1]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(fArray4[2]));
        Assert.assertEquals((Object)Float.valueOf(100.0f), (Object)Float.valueOf(fArray4[3]));
    }

    private static void copyDirectory(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            if (!file2.exists()) {
                file2.mkdir();
            }
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                FTSPluginTest.copyDirectory(new File(file, stringArray[i]), new File(file2, stringArray[i]));
            }
        } else {
            int n;
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
    }

    static {
        BasicConfigurator.configure();
    }
}

