/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.scheduling.quartz;

import com.bmc.thirdparty.org.springframework.beans.BeanWrapperImpl;
import com.bmc.thirdparty.org.springframework.beans.MutablePropertyValues;
import com.bmc.thirdparty.org.springframework.scheduling.quartz.AdaptableJobFactory;
import com.bmc.thirdparty.org.springframework.scheduling.quartz.QuartzJobBean;
import com.bmc.thirdparty.org.springframework.scheduling.quartz.SchedulerContextAware;
import java.util.Map;
import org.quartz.SchedulerContext;
import org.quartz.spi.TriggerFiredBundle;

public class SpringBeanJobFactory
extends AdaptableJobFactory
implements SchedulerContextAware {
    private boolean ignoredUnknownProperties = true;
    private SchedulerContext schedulerContext;

    public void setIgnoredUnknownProperties(boolean ignoredUnknownProperties) {
        this.ignoredUnknownProperties = ignoredUnknownProperties;
    }

    public void setSchedulerContext(SchedulerContext schedulerContext) {
        this.schedulerContext = schedulerContext;
    }

    protected Object createJobInstance(TriggerFiredBundle bundle) {
        BeanWrapperImpl bw = new BeanWrapperImpl(bundle.getJobDetail().getJobClass());
        if (this.isEligibleForPropertyPopulation(bw.getWrappedInstance())) {
            MutablePropertyValues pvs = new MutablePropertyValues();
            if (this.schedulerContext != null) {
                pvs.addPropertyValues((Map)this.schedulerContext);
            }
            pvs.addPropertyValues((Map)bundle.getJobDetail().getJobDataMap());
            pvs.addPropertyValues((Map)bundle.getTrigger().getJobDataMap());
            bw.setPropertyValues(pvs, this.ignoredUnknownProperties);
        }
        return bw.getWrappedInstance();
    }

    protected boolean isEligibleForPropertyPopulation(Object jobObject) {
        return !(jobObject instanceof QuartzJobBean);
    }
}

