/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.jdbc.datasource;

import com.bmc.thirdparty.org.springframework.jdbc.datasource.DelegatingDataSource;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class UserCredentialsDataSourceAdapter
extends DelegatingDataSource {
    private String username;
    private String password;
    private final ThreadLocal threadBoundCredentials = new ThreadLocal();

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCredentialsForCurrentThread(String username, String password) {
        this.threadBoundCredentials.set(new String[]{username, password});
    }

    public void removeCredentialsFromCurrentThread() {
        this.threadBoundCredentials.set(null);
    }

    public final Connection getConnection() throws SQLException {
        String[] threadCredentials = (String[])this.threadBoundCredentials.get();
        if (threadCredentials != null) {
            return this.doGetConnection(threadCredentials[0], threadCredentials[1]);
        }
        return this.doGetConnection(this.username, this.password);
    }

    protected Connection doGetConnection(String username, String password) throws SQLException {
        Assert.state(this.getTargetDataSource() != null, "targetDataSource is required");
        if (StringUtils.hasLength(username)) {
            return this.getTargetDataSource().getConnection(username, password);
        }
        return this.getTargetDataSource().getConnection();
    }
}

