/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.arencrypt;

import com.bmc.arsys.arencrypt.AREncryptionException;
import com.bmc.arsys.arencrypt.ARPPKey;
import com.bmc.arsys.arencrypt.b;
import com.bmc.arsys.utils.LogBytes;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ARPublicKey
extends ARPPKey {
    protected Key getRsaKey() throws AREncryptionException {
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(this.getBigModulus(), this.getBigExponent());
        try {
            String string = this.case();
            KeyFactory keyFactory = string != null ? KeyFactory.getInstance(this.byte(), string) : KeyFactory.getInstance(this.byte());
            this.encKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            if (this.debug) {
                LogBytes.printByteArrayAsHex(((RSAPublicKey)this.encKey).getModulus().toByteArray(), "RSA public Modulus: \n");
                LogBytes.printByteArrayAsHex(((RSAPublicKey)this.encKey).getPublicExponent().toByteArray(), "RSA public Exponent: \n");
            }
        }
        catch (Exception exception) {
            throw new AREncryptionException(exception, 9006);
        }
        return this.encKey;
    }

    protected void setKeyID() {
        this.keyID = "PubKey";
    }

    public String toString() {
        return super.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.keyID).toHashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof b)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ARPublicKey aRPublicKey = (ARPublicKey)object;
        return new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.keyID, (Object)aRPublicKey.keyID).isEquals();
    }
}

