/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.definition;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DiaryListValue;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.StructItemInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.definition.BaseItemData;
import com.bmc.arsys.apiext.definition.CommandLineBase;
import com.bmc.arsys.apiext.definition.CompletionEvent;
import com.bmc.arsys.apiext.definition.DefinitionEvent;
import com.bmc.arsys.apiext.definition.DefinitionException;
import com.bmc.arsys.apiext.definition.DefinitionItemType;
import com.bmc.arsys.apiext.definition.DefinitionOptions;
import com.bmc.arsys.apiext.definition.ExpansionEvent;
import com.bmc.arsys.apiext.definition.ExportCommandParser;
import com.bmc.arsys.apiext.definition.IDefinitionListener;
import com.bmc.arsys.apiext.definition.InitializationEvent;
import com.bmc.arsys.apiext.definition.ProcessEvent;
import com.bmc.arsys.apiext.definition.Util;
import com.bmc.arsys.artranscode.ARCharSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionImport
extends CommandLineBase {
    private static final String long = System.getProperty("line.separator");
    private static final String else = "   objectdata     :+";
    private static Logger b = Logger.getLogger((String)"com.bmc.arsys.api.definition");
    private boolean void = false;
    private boolean new = false;
    private static final int goto = 5;
    private final int try = 0;
    private final List<IDefinitionListener> char = new ArrayList<IDefinitionListener>();
    private final int byte = 0;
    private final int int = 0;
    private List<List<String>> case = null;
    private boolean for = true;

    public static void main(String[] stringArray) {
        DefinitionImport definitionImport = new DefinitionImport();
        definitionImport.if();
        if (stringArray.length == 1 && stringArray[0].equals("--version")) {
            definitionImport.printVersion();
        } else if (stringArray.length > 5) {
            DefinitionOptions definitionOptions = null;
            try {
                definitionOptions = definitionImport.parseCommandLine(stringArray);
                definitionImport.validateCommandLine(definitionOptions, false);
            }
            catch (Exception exception) {
                System.err.println("Unable to parse command line parameters. Please verify your parameters.");
            }
            if (definitionOptions != null) {
                try {
                    definitionImport.setOptions(definitionOptions);
                    definitionOptions.validate();
                    definitionOptions.connect();
                    if (definitionOptions.getContext().isAdministrator() || definitionOptions.getContext().isSubAdministrator()) {
                        if (definitionOptions.getCommandSetFile() != null) {
                            File file = new File(definitionOptions.getCommandSetFile());
                            ExportCommandParser exportCommandParser = new ExportCommandParser(definitionOptions);
                            exportCommandParser.populateFromFile(file, false);
                        }
                        definitionImport.importObjects();
                    } else if (b.isEnabledFor((Priority)Level.ERROR)) {
                        b.error((Object)"Only users that belong to the Administrator or Sub Administrator groups can import definitions.");
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (b.isEnabledFor((Priority)Level.ERROR)) {
                        b.error((Object)"Import failed: Unable to load the AR System JNI interface. Please make sure your environment includes the location of the AR System native libraries");
                    }
                }
                catch (Error error) {
                    if (b.isEnabledFor((Priority)Level.ERROR)) {
                        b.error((Object)MessageFormat.format("Import failed: {0}", error.getMessage()));
                    }
                }
                catch (Exception exception) {
                    if (!(exception instanceof ARException) && b.isEnabledFor((Priority)Level.ERROR)) {
                        b.error((Object)MessageFormat.format("Import failed: {0}{1}", System.getProperty("line.separator"), exception.getMessage()));
                    }
                }
            }
        } else {
            definitionImport.printUsage(false);
        }
    }

    public void addListener(IDefinitionListener iDefinitionListener) {
        this.char.add(iDefinitionListener);
    }

    public List<StatusInfo> importObjects() throws DefinitionException, ARException, IOException {
        boolean bl = this.getOptions().isXML();
        if (b.isEnabledFor((Priority)Level.INFO)) {
            b.info((Object)MessageFormat.format("Importing objects from {0} to {1}", this.getOptions().getFileName(), this.getOptions().getServer()));
        }
        List<StatusInfo> list = null;
        File file = null;
        try {
            List<StatusInfo> list2;
            File object;
            String string;
            if (!bl && (string = this.getOptions().getFileName()) != null && string.endsWith(".def") && (object = new File(string)).exists()) {
                String string2 = null;
                string2 = this.getOptions().getCharset() != null ? this.getOptions().getCharset() : ARCharSet.getServerKnownCodeSet((String)System.getProperty("file.encoding"));
                if (string2.equalsIgnoreCase("shift_jis")) {
                    string2 = "EUC_JP";
                }
                if (System.getProperty("file.encoding").equalsIgnoreCase("MS932")) {
                    string2 = "EUC_JP";
                }
                if ((file = DefinitionImport.updateDefFileWithCharSet(this.getOptions(), string2, true)) != null) {
                    b.info((Object)("Charset is missing in the definition file, using charset : " + string2));
                }
            }
            if (!bl) {
                this.do();
            } else {
                this.for = false;
            }
            this.getOptions().connect();
            this.checkDSOLicense();
            boolean bl2 = false;
            bl2 = this.getOptions().getItems() == null || this.getOptions().getItems() != null && this.getOptions().getItems().isEmpty();
            list = bl2 ? this.do(bl) : this.if(bl);
            if (this.case != null && !this.case.isEmpty() && (list2 = this.a(bl2)) != null && !list2.isEmpty()) {
                if (list == null) {
                    list = list2;
                } else {
                    list.addAll(list2);
                }
            }
        }
        catch (ARException aRException) {
            for (IDefinitionListener iDefinitionListener : this.char) {
                iDefinitionListener.event(new CompletionEvent(0, 0, 0, aRException.getLastStatus()));
            }
            throw aRException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        for (IDefinitionListener iDefinitionListener : this.char) {
            iDefinitionListener.event(new CompletionEvent(0, 0, 0, list));
        }
        return list;
    }

    public static File updateDefFileWithCharSet(DefinitionOptions definitionOptions, String string, boolean bl) throws DefinitionException {
        String string2 = null;
        FileOutputStream fileOutputStream = null;
        File file = new File(definitionOptions.getFileName());
        if (bl && file.exists()) {
            string2 = DefinitionImport.getDefFileCharSet(definitionOptions);
        }
        if (string2 != null) {
            return null;
        }
        File file2 = null;
        byte[] byArray = null;
        try {
            try {
                byArray = DefinitionImport.getBytesFromFile(new File(definitionOptions.getFileName()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DefinitionException("Unable to open export file", fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new DefinitionException("Unable to open export file", iOException);
            }
            File file3 = new File(definitionOptions.getFileName());
            int n = definitionOptions.getFileName().lastIndexOf("\\");
            String string3 = definitionOptions.getFileName().substring(0, n + 1) + "Fixed_DS_" + file3.getName();
            file2 = new File(string3);
            fileOutputStream = new FileOutputStream(file2, bl);
            String string4 = "char-set: " + string + long;
            fileOutputStream.write(string4.getBytes());
            fileOutputStream.write(byArray);
            definitionOptions.setFileName(file2.getAbsolutePath());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DefinitionException("Unable to open export file", unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DefinitionException("Unable to open export file", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new DefinitionException("Unable to write to export file", iOException);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new DefinitionException("Unable to close export file", iOException);
            }
        }
        return file2;
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        long l = file.length();
        if (l > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] byArray = new byte[(int)l];
        int n2 = 0;
        for (n = 0; n < byArray.length && (n2 = fileInputStream.read(byArray, n, byArray.length - n)) >= 0; n += n2) {
        }
        if (n < byArray.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        fileInputStream.close();
        return byArray;
    }

    public static String getDefFileCharSet(DefinitionOptions definitionOptions) throws DefinitionException {
        String string = null;
        BufferedReader bufferedReader = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(definitionOptions.getFileName());
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = bufferedReader.readLine();
            if (string2 != null && string2.startsWith("char-set: ")) {
                string = string2.substring("char-set: ".length());
                bufferedReader.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DefinitionException("Unable to open export file", fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new DefinitionException("Unable to open export file", iOException);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new DefinitionException("Unable to close export file", iOException);
                }
            }
        }
        return string;
    }

    public void removeListener(IDefinitionListener iDefinitionListener) {
        this.char.remove(iDefinitionListener);
    }

    private void if() {
        this.char.add(new IDefinitionListener(){

            public void event(DefinitionEvent definitionEvent) {
                if (definitionEvent instanceof CompletionEvent) {
                    List<StatusInfo> list = ((CompletionEvent)definitionEvent).getStatusList();
                    if (list != null) {
                        for (StatusInfo statusInfo : list) {
                            if (statusInfo.getMessageType() == 2) {
                                DefinitionImport.this.void = true;
                            }
                            if (statusInfo.getMessageType() != 1) continue;
                            DefinitionImport.this.new = true;
                        }
                    }
                    if (DefinitionImport.this.void) {
                        if (b.isEnabledFor((Priority)Level.ERROR)) {
                            b.error((Object)"Import completed with errors");
                        }
                    } else if (DefinitionImport.this.new) {
                        if (b.isEnabledFor((Priority)Level.INFO)) {
                            b.info((Object)"Import completed with warnings");
                        }
                    } else if (b.isEnabledFor((Priority)Level.INFO)) {
                        b.info((Object)"Import completed");
                    }
                    if ((DefinitionImport.this.void || DefinitionImport.this.new) && list != null) {
                        for (StatusInfo statusInfo : list) {
                            if (statusInfo.getMessageType() == 2) {
                                if (!b.isEnabledFor((Priority)Level.ERROR)) continue;
                                b.error((Object)statusInfo);
                                continue;
                            }
                            if (!b.isEnabledFor((Priority)Level.INFO)) continue;
                            b.info((Object)statusInfo);
                        }
                    }
                } else if (definitionEvent instanceof InitializationEvent) {
                    InitializationEvent initializationEvent = (InitializationEvent)definitionEvent;
                    switch (initializationEvent.getEvent()) {
                        case 1: {
                            if (!b.isEnabledFor((Priority)Level.INFO)) break;
                            b.info((Object)"Connecting to server");
                            break;
                        }
                        case 3: {
                            if (!b.isEnabledFor((Priority)Level.INFO)) break;
                            b.info((Object)MessageFormat.format("Importing {0} objects to {1}", initializationEvent.getNumItems(), DefinitionImport.this.getOptions().getFileName()));
                            break;
                        }
                    }
                } else if (definitionEvent instanceof ExpansionEvent || definitionEvent instanceof ProcessEvent) {
                    // empty if block
                }
            }
        });
    }

    private String if(String string) {
        String string2 = null;
        if (string.startsWith("   name           : ")) {
            string2 = string.replace("   name           : ", "");
        }
        return string2;
    }

    private DefinitionItemType a(String string) {
        if (string.startsWith("begin active link")) {
            return DefinitionItemType.ACTIVE_LINK;
        }
        if (string.startsWith("begin admin ext")) {
            return DefinitionItemType.ADMIN_EXT;
        }
        if (string.startsWith("begin char menu")) {
            return DefinitionItemType.MENU;
        }
        if (string.startsWith("begin container")) {
            return DefinitionItemType.CONTAINER;
        }
        if (string.startsWith("begin distributed mapping")) {
            return DefinitionItemType.DISTRIBUTED_MAPPING;
        }
        if (string.startsWith("begin filter")) {
            return DefinitionItemType.FILTER;
        }
        if (string.startsWith("begin escalation")) {
            return DefinitionItemType.ESCALATION;
        }
        if (!string.startsWith("begin group")) {
            if (string.startsWith("begin schema")) {
                return DefinitionItemType.FORM;
            }
            if (string.startsWith("begin schema data")) {
                return DefinitionItemType.FORM_DATA;
            }
            if (string.startsWith("begin distributed pool")) {
                return DefinitionItemType.DISTRIBUTED_POOL;
            }
            if (string.startsWith("begin vui")) {
                return DefinitionItemType.VIEW;
            }
            if (!string.startsWith("begin lock block")) {
                if (string.startsWith("begin application")) {
                    return DefinitionItemType.APPLICATION;
                }
                if (string.startsWith("begin image")) {
                    return DefinitionItemType.IMAGE;
                }
            }
        }
        return null;
    }

    private List<StatusInfo> do(boolean bl) throws ARException, IOException {
        ArrayList<StatusInfo> arrayList = new ArrayList();
        int n = 0;
        if (this.getOptions().isOverwrite()) {
            n |= 1;
            if (!this.getOptions().isDeleteExcessFields()) {
                n |= 0x40;
            }
            if (!this.getOptions().isDeleteExcessViews()) {
                n |= 0x1000;
            }
            if (this.getOptions().isPreserveIndex()) {
                n |= 0x20000;
            }
            if (this.getOptions().isPreserveVUINamespace()) {
                n |= 0x40000;
            }
            if (this.getOptions().isPreserveAppForms()) {
                n |= 0x80000;
            }
            if (this.getOptions().isImportWithAppOwner()) {
                n |= 0x100000;
            }
            n |= this.getOptions().getConflictHandling();
        }
        this.getOptions().getContext().importDefFromFile(this.getOptions().getFileName(), n, null, this.getOptions().getLabelName());
        arrayList = this.getOptions().getContext().getLastStatus();
        return arrayList;
    }

    private List<StatusInfo> if(boolean bl) throws ARException, IOException {
        ArrayList<StatusInfo> arrayList = new ArrayList();
        List<StructItemInfo> list = this.convertToItemList(bl);
        this.getOptions().getContext().login();
        int n = 0;
        if (this.getOptions().isOverwrite()) {
            n |= 1;
            if (!this.getOptions().isDeleteExcessFields()) {
                n |= 0x40;
            }
            if (!this.getOptions().isDeleteExcessViews()) {
                n |= 0x1000;
            }
            if (this.getOptions().isPreserveIndex()) {
                n |= 0x20000;
            }
            if (this.getOptions().isPreserveVUINamespace()) {
                n |= 0x40000;
            }
            if (this.getOptions().isPreserveAppForms()) {
                n |= 0x80000;
            }
            if (this.getOptions().isImportWithAppOwner()) {
                n |= 0x100000;
            }
            n |= this.getOptions().getConflictHandling();
        }
        if (list != null && !list.isEmpty()) {
            this.getOptions().getContext().importDefFromFile(this.getOptions().getFileName(), n, list, this.getOptions().getLabelName());
        } else if ((this.case == null || this.case.isEmpty()) && b.isEnabledFor((Priority)Level.INFO)) {
            b.info((Object)"Import Aborted. There are no objects to import");
            this.void = true;
        }
        arrayList = this.getOptions().getContext().getLastStatus();
        return arrayList;
    }

    private List<StatusInfo> a(boolean bl) throws IOException, DefinitionException, ARException {
        ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
        boolean bl2 = true;
        if (this.case != null && !this.case.isEmpty()) {
            for (List<String> list : this.case) {
                Object object;
                Object object2;
                Object object3;
                DefinitionItemType definitionItemType;
                Entry entry = null;
                String string = null;
                String string2 = null;
                String string3 = null;
                boolean bl3 = false;
                if (list.get(0).startsWith("begin Flashboards")) {
                    entry = this.a(list);
                    string3 = (String)((Value)entry.get((Object)8)).getValue();
                    bl3 = true;
                    string = "Flashboard";
                    string2 = "FLASHBOARD";
                } else {
                    entry = this.if(list);
                    string = (String)((Value)entry.get((Object)41000)).getValue();
                    string2 = (String)((Value)entry.get((Object)41052)).getValue();
                    string3 = (String)((Value)entry.get((Object)41050)).getValue();
                }
                if (!bl) {
                    DefinitionItemType definitionItemType2 = definitionItemType = !bl3 ? this.a(string, string2) : DefinitionItemType.FLASHBOARD;
                    if (definitionItemType != null && (object3 = this.getOptions().getItems().get((Object)definitionItemType)) != null && !object3.isEmpty()) {
                        object2 = object3.iterator();
                        while (object2.hasNext()) {
                            object = (BaseItemData)object2.next();
                            if (string3.equals(((BaseItemData)object).getName())) {
                                bl2 = true;
                                break;
                            }
                            bl2 = false;
                        }
                    }
                }
                if (!bl2) continue;
                definitionItemType = null;
                object3 = this.getDataVisualizationQualifier(string, string2, string3);
                object2 = this.getOptions().getContext().getListEntry(this.getDataVisualizationForm(), (QualifierInfo)object3, 0, 1, null, null, false, null);
                if (object2 != null && !object2.isEmpty()) {
                    try {
                        definitionItemType = this.getOptions().getContext().getEntry(this.getDataVisualizationForm(), ((EntryListInfo)object2.get(0)).getEntryID(), null);
                    }
                    catch (ARException aRException) {
                        Object object4 = aRException.getLastStatus();
                        if (object4 != null && !object4.isEmpty()) {
                            boolean bl4 = false;
                            Iterator iterator = object4.iterator();
                            while (iterator.hasNext()) {
                                StatusInfo statusInfo = (StatusInfo)iterator.next();
                                if (statusInfo.getMessageNum() != 302L) continue;
                                bl4 = true;
                                break;
                            }
                            if (!bl4) {
                                throw aRException;
                            }
                        }
                        throw aRException;
                    }
                }
                if (definitionItemType != null) {
                    for (Object object4 : entry.keySet()) {
                        definitionItemType.put((Integer)object4, (Value)entry.get(object4));
                    }
                    object = definitionItemType.getEntryId();
                    definitionItemType.remove(1);
                    definitionItemType.remove(2);
                    definitionItemType.remove(3);
                    definitionItemType.remove(5);
                    definitionItemType.remove(6);
                    definitionItemType.remove(15);
                    this.getOptions().getContext().setEntry(this.getDataVisualizationForm(), (String)object, (Entry)definitionItemType, null, 0);
                    arrayList.addAll(this.getOptions().getContext().getLastStatus());
                    continue;
                }
                entry.remove((Object)1);
                entry.remove((Object)2);
                entry.remove((Object)3);
                entry.remove((Object)5);
                entry.remove((Object)6);
                entry.remove((Object)15);
                this.getOptions().getContext().mergeEntry(this.getDataVisualizationForm(), entry, 0);
                arrayList.addAll(this.getOptions().getContext().getLastStatus());
            }
        }
        return arrayList;
    }

    private DefinitionItemType a(String string, String string2) {
        if ("Flashboard".equals(string)) {
            if ("FLASHBOARD".equals(string2)) {
                return DefinitionItemType.FLASHBOARD;
            }
            if ("ALARM".equals(string2)) {
                return DefinitionItemType.FLASHBOARD_ALARM;
            }
            if ("VARIABLE".equals(string2)) {
                return DefinitionItemType.FLASHBOARD_VARIABLE;
            }
        }
        return null;
    }

    private void do() throws IOException, DefinitionException {
        String string = this.getOptions().getFileName();
        this.case = new ArrayList<List<String>>();
        BufferedReader bufferedReader = Util.openFile(string, null);
        String string2 = null;
        int n = 0;
        boolean bl = false;
        ArrayList<String> arrayList = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                ++n;
                if (string2.startsWith("begin Data Visualization Definition") || string2.startsWith("begin Data Visulaization Definition") || string2.startsWith("begin Flashboards") || string2.startsWith("begin Flashboards")) {
                    arrayList = new ArrayList<String>();
                    bl = true;
                } else if (string2.startsWith("end")) {
                    bl = false;
                    if (arrayList != null) {
                        this.case.add(arrayList);
                    }
                    arrayList = null;
                } else if (string2.startsWith("begin ")) {
                    this.for = false;
                }
                if (arrayList == null || !bl) continue;
                arrayList.add(string2);
            }
        }
        catch (Exception exception) {
            throw new DefinitionException("Error encountered while parsing definition file for content", exception.getCause());
        }
        finally {
            bufferedReader.close();
        }
    }

    private Entry if(List<String> list) throws ARException {
        Entry entry = null;
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String object : list) {
                if (object.startsWith(else)) {
                    stringBuilder.append(object.substring(else.length()).replaceAll("[\r\n]", ""));
                    continue;
                }
                if (!object.startsWith("   objectdata     :")) continue;
                stringBuilder.append(object.substring("   objectdata     :".length()).replaceAll("[\r\n]", ""));
            }
            int n = stringBuilder.length();
            if (n > 0) {
                entry = new Entry();
                Pattern pattern = Pattern.compile("( \\d+,\\d,\\\"(.*?)\\\";)");
                Matcher matcher = pattern.matcher(stringBuilder.toString());
                block5: while (matcher.find()) {
                    String string = matcher.group();
                    int n2 = string.indexOf(44);
                    int n3 = string.indexOf(44, n2 + 1);
                    int n4 = Integer.parseInt(string.substring(1, n2));
                    int n5 = Integer.parseInt(string.substring(n2 + 1, n3));
                    String string2 = string.substring(n3 + 2, string.length() - 2);
                    switch (n5) {
                        case 6: {
                            long l = Long.parseLong(string2);
                            if (n4 == 41051) {
                                if (l == 1L) {
                                    entry.put(Integer.valueOf(n4), new Value((Object)0L, DataType.ENUM));
                                    continue block5;
                                }
                                entry.put(Integer.valueOf(n4), new Value());
                                continue block5;
                            }
                            entry.put(Integer.valueOf(n4), new Value((Object)l, DataType.ENUM));
                            continue block5;
                        }
                        case 5: {
                            DiaryListValue diaryListValue = DiaryListValue.decode((String)string2);
                            entry.put(Integer.valueOf(n4), new Value(diaryListValue));
                            continue block5;
                        }
                    }
                    entry.put(Integer.valueOf(n4), new Value(string2, DataType.toDataType((int)n5)));
                }
            }
        }
        return entry;
    }

    private Entry a(List<String> list) throws ARException {
        Entry entry = null;
        String string = null;
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String object : list) {
                if (object.startsWith(else)) {
                    stringBuilder.append(object.substring(else.length()).replaceAll("[\r\n]", ""));
                    continue;
                }
                if (!object.startsWith("   objectdata     :")) continue;
                stringBuilder.append(object.substring("   objectdata     :".length()).replaceAll("[\r\n]", ""));
            }
            int n = stringBuilder.length();
            if (n > 0) {
                entry = new Entry();
                Pattern pattern = Pattern.compile("( \\d+,\\d,\\\"(.*?)\\\";)");
                Matcher matcher = pattern.matcher(stringBuilder.toString());
                String string2 = null;
                String string3 = null;
                String string4 = "";
                String string5 = "";
                String string6 = "2";
                String string7 = null;
                String string8 = "3";
                String string9 = "0";
                String string10 = "";
                String string11 = "";
                String string12 = "";
                String string13 = "";
                String string14 = "1";
                String string15 = "1";
                String string16 = "0";
                String string17 = "10";
                String string18 = "1";
                String string19 = "0";
                String string20 = "0";
                String string21 = "0";
                String string22 = "0";
                String string23 = "1";
                String string24 = "0";
                String string25 = "0";
                String string26 = "0";
                String string27 = "1";
                String string28 = "0";
                String string29 = "0";
                block36: while (matcher.find()) {
                    String string30 = matcher.group();
                    int n2 = string30.indexOf(44);
                    int n3 = string30.indexOf(44, n2 + 1);
                    int n4 = Integer.parseInt(string30.substring(1, n2));
                    int n5 = Integer.parseInt(string30.substring(n2 + 1, n3));
                    String string31 = string30.substring(n3 + 2, string30.length() - 2);
                    boolean bl = n4 < 40000 || n4 > 41000;
                    switch (n4) {
                        case 40000: {
                            string3 = string31;
                            break;
                        }
                        case 40151: {
                            string13 = string31;
                            break;
                        }
                        case 40152: {
                            string16 = string31;
                            break;
                        }
                        case 40153: {
                            string17 = string31;
                            break;
                        }
                        case 40155: {
                            string14 = string31;
                            break;
                        }
                        case 40156: {
                            string19 = string31;
                            break;
                        }
                        case 40157: {
                            string6 = string31;
                            break;
                        }
                        case 40158: {
                            string23 = string31;
                            break;
                        }
                        case 40159: {
                            string8 = string31;
                            break;
                        }
                        case 40160: {
                            string15 = string31;
                            break;
                        }
                        case 40161: {
                            string18 = string31;
                            break;
                        }
                        case 40162: {
                            string12 = string31;
                            break;
                        }
                        case 40163: {
                            string29 = string31;
                            break;
                        }
                        case 40164: {
                            string28 = string31;
                            break;
                        }
                        case 40166: {
                            string24 = string31;
                            break;
                        }
                        case 40167: {
                            string25 = string31;
                            break;
                        }
                        case 40173: {
                            string7 = string31;
                            break;
                        }
                        case 40174: {
                            string20 = string31;
                            break;
                        }
                        case 40175: {
                            string21 = string31;
                            break;
                        }
                        case 40176: {
                            string4 = string31;
                            break;
                        }
                        case 40177: {
                            string5 = string31;
                            break;
                        }
                        case 40178: {
                            string22 = string31;
                            break;
                        }
                        case 40200: {
                            string2 = string31;
                            break;
                        }
                        case 40201: {
                            string27 = string31;
                            break;
                        }
                        case 40202: {
                            string26 = string31;
                            break;
                        }
                        case 40203: {
                            string10 = string31;
                            break;
                        }
                        case 40204: {
                            string11 = string31;
                            break;
                        }
                    }
                    if (!bl) continue;
                    switch (n5) {
                        case 6: {
                            long l = Long.parseLong(string31);
                            if (n4 == 41051) {
                                if (l == 1L) {
                                    entry.put(Integer.valueOf(n4), new Value((Object)0L, DataType.ENUM));
                                    continue block36;
                                }
                                entry.put(Integer.valueOf(n4), new Value());
                                continue block36;
                            }
                            entry.put(Integer.valueOf(n4), new Value((Object)l, DataType.ENUM));
                            continue block36;
                        }
                        case 5: {
                            try {
                                DiaryListValue aRException = DiaryListValue.decode((String)string31);
                                entry.put(Integer.valueOf(n4), new Value(aRException));
                            }
                            catch (ARException aRException) {
                                entry.put(Integer.valueOf(n4), new Value(""));
                            }
                            continue block36;
                        }
                    }
                    entry.put(Integer.valueOf(n4), new Value(string31, DataType.toDataType((int)n5)));
                }
                entry.put(Integer.valueOf(41000), new Value("Flashboard", DataType.CHAR));
                entry.put(Integer.valueOf(41050), (Value)entry.get((Object)8));
                entry.put(Integer.valueOf(41052), new Value("FLASHBOARD", DataType.CHAR));
                string = "<?xml version=\"1.0\" ?><flashboard name=\"" + entry.get((Object)8) + "\" guid=\"" + string2 + "\" title=\"" + string4 + "\" fbtype=\"" + string28 + "\" charttype=\"" + string6 + "\" color=\"" + string7 + "\"><options drilldown=\"" + string20 + "\" customize=\"" + string21 + "\" displaytype=\"" + string22 + "\"/><legend show=\"" + string23 + "\" title=\"" + string5 + "\" placement=\"" + string8 + "\"/><axis orientation=\"" + string29 + "\"/><x label=\"" + string12 + "\" showgrid=\"" + string14 + "\"/><y label=\"" + string13 + "\" showgrid=\"" + string15 + "\" auto=\"" + string18 + "\" min=\"" + string16 + "\" max=\"" + string17 + "\"/><timeframe show=\"" + string19 + "\" type=\"" + string9 + "\" startdate=\"" + string24 + "\" enddate=\"" + string25 + "\"/><variable name=\"" + entry.get((Object)8) + "\" guid=\"" + string3 + "\" enable=\"" + string27 + "\" label=\"" + string11 + "\" color=\"" + string10 + "\" style=\"" + string26 + "\"/></flashboard>";
                entry.put(Integer.valueOf(41053), new Value(string, DataType.CHAR));
            }
        }
        return entry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ImportItem {
        private String int;
        private boolean do = false;
        private String if;
        private List<String> a = new ArrayList<String>();
        private DefinitionItemType for;

        ImportItem() {
        }

        public String getContent() {
            return this.int;
        }

        public String getName() {
            return this.if;
        }

        public List<String> getSubItems() {
            return this.a;
        }

        public DefinitionItemType getType() {
            return this.for;
        }

        public boolean isInLockedBlock() {
            return this.do;
        }

        public void setContent(String string) {
            this.int = string;
        }

        public void setInLockedBlock(boolean bl) {
            this.do = bl;
        }

        public void setName(String string) {
            this.if = string;
        }

        public void setSubItems(List<String> list) {
            this.a = list;
        }

        public void setType(DefinitionItemType definitionItemType) {
            this.for = definitionItemType;
        }
    }
}

