/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.transaction.support;

import com.bmc.thirdparty.org.apache.commons.logging.Log;
import com.bmc.thirdparty.org.apache.commons.logging.LogFactory;
import com.bmc.thirdparty.org.springframework.beans.factory.InitializingBean;
import com.bmc.thirdparty.org.springframework.transaction.PlatformTransactionManager;
import com.bmc.thirdparty.org.springframework.transaction.TransactionDefinition;
import com.bmc.thirdparty.org.springframework.transaction.TransactionException;
import com.bmc.thirdparty.org.springframework.transaction.TransactionStatus;
import com.bmc.thirdparty.org.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import com.bmc.thirdparty.org.springframework.transaction.support.DefaultTransactionDefinition;
import com.bmc.thirdparty.org.springframework.transaction.support.TransactionCallback;

public class TransactionTemplate
extends DefaultTransactionDefinition
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PlatformTransactionManager transactionManager = null;

    public TransactionTemplate() {
    }

    public TransactionTemplate(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionTemplate(PlatformTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        super(transactionDefinition);
        this.transactionManager = transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void afterPropertiesSet() {
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("transactionManager is required");
        }
    }

    public Object execute(TransactionCallback action) throws TransactionException {
        if (this.transactionManager instanceof CallbackPreferringPlatformTransactionManager) {
            return ((CallbackPreferringPlatformTransactionManager)this.transactionManager).execute(this, action);
        }
        TransactionStatus status = this.transactionManager.getTransaction(this);
        Object result = null;
        try {
            result = action.doInTransaction(status);
        }
        catch (RuntimeException ex) {
            this.rollbackOnException(status, ex);
            throw ex;
        }
        catch (Error err) {
            this.rollbackOnException(status, err);
            throw err;
        }
        this.transactionManager.commit(status);
        return result;
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) throws TransactionException {
        this.logger.debug("Initiating transaction rollback on application exception", ex);
        try {
            this.transactionManager.rollback(status);
        }
        catch (RuntimeException ex2) {
            this.logger.error("Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error("Application exception overridden by rollback error", ex);
            throw err;
        }
    }
}

