/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.transaction.jta;

import com.bmc.thirdparty.org.springframework.transaction.TransactionDefinition;
import com.bmc.thirdparty.org.springframework.transaction.TransactionSystemException;
import com.bmc.thirdparty.org.springframework.transaction.jta.JtaTransactionManager;
import com.bmc.thirdparty.org.springframework.transaction.jta.JtaTransactionObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class WebLogicJtaTransactionManager
extends JtaTransactionManager {
    private static final String USER_TRANSACTION_CLASS_NAME = "weblogic.transaction.UserTransaction";
    private static final String CLIENT_TRANSACTION_MANAGER_CLASS_NAME = "weblogic.transaction.ClientTransactionManager";
    private static final String TRANSACTION_MANAGER_CLASS_NAME = "weblogic.transaction.TransactionManager";
    private static final String TRANSACTION_CLASS_NAME = "weblogic.transaction.Transaction";
    private static final String TRANSACTION_HELPER_CLASS_NAME = "weblogic.transaction.TransactionHelper";
    private static final String TX_HELPER_CLASS_NAME = "weblogic.transaction.TxHelper";
    private static final String ISOLATION_LEVEL_KEY = "ISOLATION LEVEL";
    private boolean weblogicUserTransactionAvailable;
    private Method beginWithNameMethod;
    private Method beginWithNameAndTimeoutMethod;
    private boolean weblogicTransactionManagerAvailable;
    private Method forceResumeMethod;
    private Method setPropertyMethod;
    private Class transactionHelperClass;
    private Object transactionHelper;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$transaction$Transaction;
    static /* synthetic */ Class class$java$io$Serializable;

    public WebLogicJtaTransactionManager() throws TransactionSystemException {
        this.setUserTransactionName(null);
    }

    public void afterPropertiesSet() throws TransactionSystemException {
        super.afterPropertiesSet();
        this.loadWebLogicTransactionClasses();
    }

    protected UserTransaction retrieveUserTransaction() throws TransactionSystemException {
        this.loadWebLogicTransactionHelperClass();
        try {
            this.logger.debug("Retrieving JTA UserTransaction from WebLogic TransactionHelper/TxHelper");
            Method getUserTransactionMethod = this.transactionHelperClass.getMethod("getUserTransaction", new Class[0]);
            return (UserTransaction)getUserTransactionMethod.invoke(this.transactionHelper, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            throw new TransactionSystemException("WebLogic's TransactionHelper/TxHelper.getUserTransaction() method failed", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not invoke WebLogic's TransactionHelper/TxHelper.getUserTransaction() method", ex);
        }
    }

    protected TransactionManager retrieveTransactionManager() throws TransactionSystemException {
        this.loadWebLogicTransactionHelperClass();
        try {
            this.logger.debug("Retrieving JTA TransactionManager from WebLogic TransactionHelper/TxHelper");
            Method getTransactionManagerMethod = this.transactionHelperClass.getMethod("getTransactionManager", new Class[0]);
            return (TransactionManager)getTransactionManagerMethod.invoke(this.transactionHelper, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            throw new TransactionSystemException("WebLogic's TransactionHelper/TxHelper.getTransactionManager() method failed", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not invoke WebLogic's TransactionHelper/TxHelper.getTransactionManager() method", ex);
        }
    }

    private void loadWebLogicTransactionHelperClass() throws TransactionSystemException {
        if (this.transactionHelperClass == null) {
            try {
                try {
                    this.transactionHelperClass = this.getClass().getClassLoader().loadClass(TRANSACTION_HELPER_CLASS_NAME);
                    Method getTransactionHelperMethod = this.transactionHelperClass.getMethod("getTransactionHelper", new Class[0]);
                    this.transactionHelper = getTransactionHelperMethod.invoke(null, new Object[0]);
                    this.logger.debug("WebLogic 8.1+ TransactionHelper found");
                }
                catch (ClassNotFoundException ex) {
                    this.transactionHelperClass = this.getClass().getClassLoader().loadClass(TX_HELPER_CLASS_NAME);
                    this.logger.debug("WebLogic 7.0 TxHelper found");
                }
            }
            catch (InvocationTargetException ex) {
                throw new TransactionSystemException("WebLogic's TransactionHelper.getTransactionHelper() method failed", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new TransactionSystemException("Could not initialize WebLogicJtaTransactionManager because WebLogic API classes are not available", ex);
            }
        }
    }

    private void loadWebLogicTransactionClasses() throws TransactionSystemException {
        try {
            Class<?> userTransactionClass = this.getClass().getClassLoader().loadClass(USER_TRANSACTION_CLASS_NAME);
            this.weblogicUserTransactionAvailable = userTransactionClass.isInstance(this.getUserTransaction());
            if (this.weblogicUserTransactionAvailable) {
                this.beginWithNameMethod = userTransactionClass.getMethod("begin", class$java$lang$String == null ? (class$java$lang$String = WebLogicJtaTransactionManager.class$("java.lang.String")) : class$java$lang$String);
                this.beginWithNameAndTimeoutMethod = userTransactionClass.getMethod("begin", class$java$lang$String == null ? (class$java$lang$String = WebLogicJtaTransactionManager.class$("java.lang.String")) : class$java$lang$String, Integer.TYPE);
                this.logger.info("Support for WebLogic transaction names available");
            } else {
                this.logger.info("Support for WebLogic transaction names not available");
            }
            Class<?> transactionManagerClass = null;
            try {
                transactionManagerClass = this.getClass().getClassLoader().loadClass(CLIENT_TRANSACTION_MANAGER_CLASS_NAME);
                this.logger.debug("WebLogic 8.1+ ClientTransactionManager found");
            }
            catch (ClassNotFoundException ex) {
                transactionManagerClass = this.getClass().getClassLoader().loadClass(TRANSACTION_MANAGER_CLASS_NAME);
                this.logger.debug("WebLogic 7.0 TransactionManager found");
            }
            this.weblogicTransactionManagerAvailable = transactionManagerClass.isInstance(this.getTransactionManager());
            if (this.weblogicTransactionManagerAvailable) {
                this.forceResumeMethod = transactionManagerClass.getMethod("forceResume", class$javax$transaction$Transaction == null ? (class$javax$transaction$Transaction = WebLogicJtaTransactionManager.class$("javax.transaction.Transaction")) : class$javax$transaction$Transaction);
                Class<?> transactionClass = this.getClass().getClassLoader().loadClass(TRANSACTION_CLASS_NAME);
                this.setPropertyMethod = transactionClass.getMethod("setProperty", class$java$lang$String == null ? (class$java$lang$String = WebLogicJtaTransactionManager.class$("java.lang.String")) : class$java$lang$String, class$java$io$Serializable == null ? (class$java$io$Serializable = WebLogicJtaTransactionManager.class$("java.io.Serializable")) : class$java$io$Serializable);
                this.logger.debug("Support for WebLogic forceResume available");
            } else {
                this.logger.warn("Support for WebLogic forceResume not available");
            }
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not initialize WebLogicJtaTransactionManager because WebLogic API classes are not available", ex);
        }
    }

    protected void doJtaBegin(JtaTransactionObject txObject, TransactionDefinition definition) throws NotSupportedException, SystemException {
        if (this.weblogicUserTransactionAvailable && definition.getName() != null) {
            try {
                if (definition.getTimeout() > -1) {
                    this.beginWithNameAndTimeoutMethod.invoke((Object)txObject.getUserTransaction(), definition.getName(), new Integer(definition.getTimeout()));
                }
                this.beginWithNameMethod.invoke((Object)txObject.getUserTransaction(), definition.getName());
            }
            catch (InvocationTargetException ex) {
                throw new TransactionSystemException("WebLogic's UserTransaction.begin() method failed", ex.getTargetException());
            }
            catch (Exception ex) {
                throw new TransactionSystemException("Could not invoke WebLogic's UserTransaction.begin() method", ex);
            }
        } else {
            this.applyTimeout(txObject, definition.getTimeout());
            txObject.getUserTransaction().begin();
        }
        if (this.weblogicTransactionManagerAvailable) {
            if (definition.getIsolationLevel() != -1) {
                try {
                    Transaction tx = this.getTransactionManager().getTransaction();
                    Integer isolationLevel = new Integer(definition.getIsolationLevel());
                    this.setPropertyMethod.invoke((Object)tx, ISOLATION_LEVEL_KEY, isolationLevel);
                }
                catch (InvocationTargetException ex) {
                    throw new TransactionSystemException("WebLogic's Transaction.setProperty() method failed", ex.getTargetException());
                }
                catch (Exception ex) {
                    throw new TransactionSystemException("Could not invoke WebLogic's Transaction.setProperty() method", ex);
                }
            }
        } else {
            this.applyIsolationLevel(txObject, definition.getIsolationLevel());
        }
    }

    protected void doJtaResume(JtaTransactionObject txObject, Object suspendedTransaction) throws InvalidTransactionException, SystemException {
        try {
            this.getTransactionManager().resume((Transaction)suspendedTransaction);
        }
        catch (InvalidTransactionException ex) {
            if (!this.weblogicTransactionManagerAvailable) {
                throw ex;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Standard JTA resume threw InvalidTransactionException: " + ex.getMessage() + " - trying WebLogic JTA forceResume");
            }
            try {
                this.forceResumeMethod.invoke((Object)this.getTransactionManager(), suspendedTransaction);
            }
            catch (InvocationTargetException ex2) {
                throw new TransactionSystemException("WebLogic's TransactionManager.forceResume() method failed", ex2.getTargetException());
            }
            catch (Exception ex2) {
                throw new TransactionSystemException("Could not access WebLogic's TransactionManager.forceResume() method", ex2);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

