/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.instrument.classloading.oc4j;

import com.bmc.thirdparty.org.springframework.instrument.classloading.LoadTimeWeaver;
import com.bmc.thirdparty.org.springframework.instrument.classloading.oc4j.OC4JClassPreprocessorAdapter;
import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import java.lang.instrument.ClassFileTransformer;
import oracle.classloader.util.ClassLoaderUtilities;
import oracle.classloader.util.ClassPreprocessor;

public class OC4JLoadTimeWeaver
implements LoadTimeWeaver {
    private final ClassLoader classLoader;

    public OC4JLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public OC4JLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull(classLoader, "ClassLoader must not be null");
        this.classLoader = classLoader;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        Assert.notNull(transformer, "Transformer must not be null");
        OC4JClassPreprocessorAdapter processor = new OC4JClassPreprocessorAdapter(transformer);
        ClassLoaderUtilities.addPreprocessor((ClassLoader)this.classLoader, (ClassPreprocessor)processor);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        return ClassLoaderUtilities.copy((ClassLoader)this.classLoader);
    }
}

