/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.ws.client;

import com.bmc.arsys.ws.client.PolicyDetails;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axis.MessageContext;
import org.apache.ws.axis.security.WSDoAllSender;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoBase;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.RequestData;

public class WsPluginSender
extends WSDoAllSender {
    private static final long serialVersionUID = -8905511215599153916L;
    private PolicyDetails pd = null;

    WsPluginSender(PolicyDetails policyDetails) {
        this.pd = policyDetails;
    }

    private Crypto loadCrypto(PolicyDetails policyDetails, Properties properties) throws WSSecurityException {
        String string = properties.getProperty("org.apache.ws.security.crypto.provider");
        if (string == null) {
            throw new WSSecurityException("WSHandler: loadKeyStore: no crypto provider in properties file");
        }
        Crypto crypto = CryptoFactory.getInstance((Properties)properties);
        if (crypto == null) {
            throw new WSSecurityException("WSHandler: Signature: CryptoFactory could not create a crypto");
        }
        try {
            KeyStore keyStore = crypto.getKeyStore();
            String string2 = null;
            if (keyStore != null) {
                string2 = keyStore.getType();
            }
            keyStore = string2 == null ? KeyStore.getInstance(KeyStore.getDefaultType()) : KeyStore.getInstance(string2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(policyDetails.getKsBytes());
            String string3 = null;
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                if (string4.indexOf(".keystore.password") <= 0) continue;
                string3 = properties.getProperty(string4);
            }
            if (string3 == null) {
                keyStore.load(byteArrayInputStream, null);
            } else {
                keyStore.load(byteArrayInputStream, string3.toCharArray());
            }
            ((CryptoBase)crypto).setKeyStore(keyStore);
        }
        catch (KeyStoreException keyStoreException) {
            throw new WSSecurityException("unable to create keystore", (Throwable)keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new WSSecurityException("no such algorithm", (Throwable)noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new WSSecurityException("certificate exception", (Throwable)certificateException);
        }
        catch (IOException iOException) {
            throw new WSSecurityException("io exception", (Throwable)iOException);
        }
        return crypto;
    }

    public Crypto loadSignatureCrypto(RequestData requestData) throws WSSecurityException {
        this.setPasswordCallBack(requestData);
        Crypto crypto = null;
        String string = this.getString("signaturePropFile", requestData.getMsgContext());
        if (string != null) {
            crypto = (Crypto)cryptos.get(string);
            if (crypto == null) {
                try {
                    crypto = CryptoFactory.getInstance((String)string, (ClassLoader)this.getURlClassLoader(requestData));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new WSSecurityException("Error loading Crypto instance", (Throwable)malformedURLException);
                }
                cryptos.put(string, crypto);
            }
        } else {
            Properties properties = (Properties)this.getOption("SignaturePropRefId");
            if (properties != null) {
                crypto = (Crypto)cryptos.get(this.pd.getPolicyId());
                if (crypto == null) {
                    crypto = this.loadCrypto(this.pd, properties);
                    cryptos.put(this.pd.getPolicyId(), crypto);
                }
            } else {
                throw new WSSecurityException("WSHandler: Signature: no crypto properties");
            }
        }
        return crypto;
    }

    protected URLClassLoader getURlClassLoader(RequestData requestData) throws MalformedURLException {
        File file = new File(this.pd.getKeystoreFilePath());
        URL uRL = file.toURI().toURL();
        return new URLClassLoader(new URL[]{uRL}, this.getClassLoader(requestData.getMsgContext()));
    }

    public Crypto loadEncryptionCrypto(RequestData requestData) throws WSSecurityException {
        this.setPasswordCallBack(requestData);
        Crypto crypto = null;
        String string = this.getString("encryptionPropFile", requestData.getMsgContext());
        if (string != null) {
            crypto = (Crypto)cryptos.get(string);
            if (crypto == null) {
                try {
                    crypto = CryptoFactory.getInstance((String)string, (ClassLoader)this.getURlClassLoader(requestData));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new WSSecurityException("Error loading Crypto instance", (Throwable)malformedURLException);
                }
                cryptos.put(string, crypto);
            }
        } else {
            Properties properties = (Properties)this.getOption("encryptionPropRefId");
            if (properties != null) {
                crypto = (Crypto)cryptos.get(this.pd.getPolicyId());
                if (crypto == null) {
                    crypto = this.loadCrypto(this.pd, properties);
                    cryptos.put(this.pd.getPolicyId(), crypto);
                }
            } else {
                throw new WSSecurityException("WSHandler: Encryption: no crypto properties");
            }
        }
        return crypto;
    }

    public Crypto loadDecryptionCrypto(RequestData requestData) throws WSSecurityException {
        this.setPasswordCallBack(requestData);
        Crypto crypto = null;
        String string = this.getString("decryptionPropFile", requestData.getMsgContext());
        if (string != null) {
            crypto = (Crypto)cryptos.get(string);
            if (crypto == null) {
                try {
                    crypto = CryptoFactory.getInstance((String)string, (ClassLoader)this.getURlClassLoader(requestData));
                }
                catch (MalformedURLException malformedURLException) {
                    throw new WSSecurityException("Error loading Crypto instance", (Throwable)malformedURLException);
                }
                cryptos.put(string, crypto);
            }
        } else {
            Properties properties = (Properties)this.getOption("decryptionPropRefId");
            if (properties != null) {
                crypto = (Crypto)cryptos.get(this.pd.getPolicyId());
                if (crypto == null) {
                    crypto = this.loadCrypto(this.pd, properties);
                    cryptos.put(this.pd.getPolicyId(), crypto);
                }
            } else {
                throw new WSSecurityException("WSHandler: Decryption: no crypto properties");
            }
        }
        return crypto;
    }

    protected void setPasswordCallBack(RequestData requestData) {
        Object object = this.getOption("passwordCallbackRef");
        if (object != null && object instanceof CallbackHandler) {
            ((MessageContext)requestData.getMsgContext()).setProperty("passwordCallbackRef", object);
        }
    }
}

