/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.apiext.data;

import com.bmc.arsys.api.ARBulkException;
import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ARServerUser;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.BulkEntryReturn;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.EntryListInfo;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RelationalOperationInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.apiext.data.ARImportException;
import com.bmc.arsys.apiext.data.BaseObject;
import com.bmc.arsys.apiext.data.Converter;
import com.bmc.arsys.apiext.data.DataOptions;
import com.bmc.arsys.apiext.data.EntryFactory;
import com.bmc.arsys.apiext.data.FieldInformation;
import com.bmc.arsys.apiext.data.FormInformation;
import com.bmc.arsys.apiext.data.IParseListener;
import com.bmc.arsys.apiext.data.IParser;
import com.bmc.arsys.apiext.data.ImportErrors;
import com.bmc.arsys.apiext.data.ImportOptions;
import com.bmc.arsys.apiext.data.Mapping;
import com.bmc.arsys.apiext.data.MappingOptions;
import com.bmc.arsys.apiext.data.ParseEvent;
import com.bmc.arsys.apiext.data.RecordResult;
import com.bmc.arsys.apiext.data.ThreadLocalStorage;
import com.bmc.arsys.apiext.data.Util;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseImporter
extends BaseObject
implements Callable<ImportOptions> {
    public static final String DATA_FILE_FORM = "ARImport_Data_Holder";
    protected ImportOptions options;
    private IParser bZ;
    private EntryFactory b6 = null;
    private FormInformation b1 = null;
    private FormInformation b9 = null;
    private String ca = null;
    private IParseListener b0;
    private int cg = 0;
    private boolean cd = false;
    private boolean b3 = true;
    private String bX = "";
    private ARServerUser bY;
    private DataOptions b4;
    private int cf;
    private LinkedList<Entry> b2 = new LinkedList();
    private LinkedList<List<String>> b8 = new LinkedList();
    private LinkedList<String> b7 = new LinkedList();
    private boolean cc = false;
    private boolean ch = false;
    private boolean cb = false;
    public SimpleDateFormat simpleDateFormater = new SimpleDateFormat("MMM d, yyyy HH:mm:ss.S");
    public Date importStartTime;
    public Date importEndTime;
    private int ce;
    private int b5;
    private String ci;

    public boolean isUseBulk() {
        return this.ch;
    }

    public void setUseBulk(boolean bl) {
        this.ch = bl;
    }

    public boolean isBulkCompatible() {
        return this.cc;
    }

    public void setBulkCompatible(boolean bl) {
        this.cc = bl;
    }

    public String getServerPatchString() {
        return this.ci;
    }

    public void setServerPatchString(String string) {
        this.ci = string;
    }

    public int getServerMajorVersion() {
        return this.ce;
    }

    public void setServerMajorVersion(int n) {
        this.ce = n;
    }

    public int getServerMinorVersion() {
        return this.b5;
    }

    public void setServerMinorVersion(int n) {
        this.b5 = n;
    }

    public boolean isCompatibleServer() {
        return this.cb;
    }

    public void setCompatibleServer(boolean bl) {
        this.cb = bl;
    }

    @Override
    public ImportOptions call() {
        Logger logger = this.options.getLoggersList().get(this.options.getLogFile());
        if (logger == null) {
            logger = Logger.getLogger((String)"com.bmc.arsys.apiext.data");
        }
        ThreadLocalStorage.setLogger(logger);
        try {
            this.startImport();
        }
        catch (ARImportException aRImportException) {
            logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED.toDefMsg(), this.options.getFileOptions().getDataFile(), aRImportException), (Throwable)aRImportException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)MessageFormat.format(ImportErrors.DATA_FILE_NOT_OPENED.toDefMsg(), this.options.getFileOptions().getDataFile(), fileNotFoundException), (Throwable)fileNotFoundException);
        }
        catch (Exception exception) {
            logger.error((Object)MessageFormat.format(ImportErrors.IMPORT_FAILED.toDefMsg(), this.options.getFileOptions().getDataFile(), exception), (Throwable)exception);
        }
        return this.options;
    }

    public BaseImporter(ImportOptions importOptions) throws ARImportException {
        this.options = importOptions;
        this.bY = importOptions.getContext();
        this.b4 = importOptions.getDataOptions();
        this.setBulkCompatible(this.calculateBulkCompatibility());
        this.setCompatibleServer(this.new());
        this.setUseBulk(this.try());
        this.cf = this.a(this.b4.getDuplicateIdHandling().getMergeOption());
        this.createParser();
        this.createListener();
    }

    protected boolean calculateBulkCompatibility() {
        this.setServerMajorVersion(this.bY.getServerVersionMajor());
        this.setServerMinorVersion(this.bY.getServerVersionMinor());
        this.setServerPatchString(this.bY.getServerVersionPatch());
        return this.getServerMajorVersion() >= 7 && (this.getServerMajorVersion() >= 8 || this.getServerMinorVersion() > 0);
    }

    protected abstract IParser createParser() throws ARImportException;

    protected void createListener() {
        this.b0 = new IParseListener(){

            public void handleEvent(ParseEvent parseEvent) throws ARImportException, ARException {
                Logger logger = ThreadLocalStorage.getLogger();
                try {
                    switch (parseEvent.getType()) {
                        case 0: {
                            if (!BaseImporter.this.b2.isEmpty()) {
                                if (BaseImporter.this.getTargetForm() != null) {
                                    BaseImporter.this.getOptions().getResults().resetRecordCount(BaseImporter.this.getTargetForm().getName(), BaseImporter.this.b2.size());
                                }
                                if (BaseImporter.this.isUseBulk()) {
                                    BaseImporter.this.bulkImportEntry(BaseImporter.this.b8, BaseImporter.this.b7);
                                } else {
                                    BaseImporter.this.importEntries(BaseImporter.this.b8, BaseImporter.this.b7);
                                }
                            }
                            if (parseEvent.getData() != null && BaseImporter.this.getTargetForm() != null) {
                                BaseImporter.this.importEndTime = new Date();
                                double d = BaseImporter.this.importEndTime.getTime() - BaseImporter.this.importStartTime.getTime();
                                BaseImporter.this.importStartTime = BaseImporter.this.importEndTime;
                                d /= 1000.0;
                                if (BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) > 0 || BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName()) > 0) {
                                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_STATUS.toDefMsg() + BaseImporter.this.options.getFileOptions().getDataFile(), d, BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName(), BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) + BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName())));
                                } else {
                                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_COMPLTED.toDefMsg() + BaseImporter.this.options.getFileOptions().getDataFile(), d, BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName()));
                                }
                            }
                            BaseImporter.this.handleNewFormEvent((FormInformation)parseEvent.getData());
                            break;
                        }
                        case 1: {
                            if (BaseImporter.this.getTargetForm() != null) {
                                BaseImporter.this.getOptions().getResults().incrementRecordCount(BaseImporter.this.getTargetForm().getName());
                            }
                            BaseImporter.this.handleDataEvent((List)parseEvent.getData(), parseEvent.getLine());
                            if (BaseImporter.this.b2.isEmpty() || BaseImporter.this.b2.size() < BaseImporter.this.options.getDataOptions().getTransactionSize()) break;
                            if (BaseImporter.this.getTargetForm() != null) {
                                BaseImporter.this.getOptions().getResults().resetRecordCount(BaseImporter.this.getTargetForm().getName(), BaseImporter.this.b2.size());
                            }
                            if (BaseImporter.this.isUseBulk()) {
                                BaseImporter.this.bulkImportEntry(BaseImporter.this.b8, BaseImporter.this.b7);
                                break;
                            }
                            BaseImporter.this.importEntries(BaseImporter.this.b8, BaseImporter.this.b7);
                            break;
                        }
                        case 2: {
                            if (!BaseImporter.this.b2.isEmpty()) {
                                if (BaseImporter.this.getTargetForm() != null) {
                                    BaseImporter.this.getOptions().getResults().resetRecordCount(BaseImporter.this.getTargetForm().getName(), BaseImporter.this.b2.size());
                                }
                                if (BaseImporter.this.isUseBulk()) {
                                    BaseImporter.this.bulkImportEntry(BaseImporter.this.b8, BaseImporter.this.b7);
                                } else {
                                    BaseImporter.this.importEntries(BaseImporter.this.b8, BaseImporter.this.b7);
                                }
                            }
                            if (BaseImporter.this.getTargetForm() != null) {
                                BaseImporter.this.importEndTime = new Date();
                                double d = BaseImporter.this.importEndTime.getTime() - BaseImporter.this.importStartTime.getTime();
                                d /= 1000.0;
                                if (BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) > 0 || BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName()) > 0) {
                                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_STATUS.toDefMsg() + BaseImporter.this.options.getFileOptions().getDataFile(), d, BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName(), BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) + BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName())));
                                } else {
                                    logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_COMPLTED.toDefMsg() + BaseImporter.this.options.getFileOptions().getDataFile(), d, BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName()));
                                }
                            }
                            BaseImporter.this.handleEndEvent();
                            break;
                        }
                        case 3: {
                            BaseImporter.this.handleTitlesEvent((List)parseEvent.getData());
                            break;
                        }
                        case 4: {
                            BaseImporter.this.handleStartTransaction();
                            break;
                        }
                        case 5: {
                            BaseImporter.this.handleEndTransaction(1);
                            break;
                        }
                        case 6: {
                            BaseImporter.this.handleEndTransaction(2);
                        }
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    if (BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) > 0 || BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName()) > 0) {
                        logger.error((Object)MessageFormat.format(ImportErrors.OUTOFMEM_ERROR2.toDefMsg(), BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName(), BaseImporter.this.getOptions().getResults().getErrorCount(BaseImporter.this.getTargetForm().getName()) + BaseImporter.this.getOptions().getResults().getSkipCount(BaseImporter.this.getTargetForm().getName())));
                    } else {
                        logger.error((Object)MessageFormat.format(ImportErrors.OUTOFMEM_ERROR1.toDefMsg(), BaseImporter.this.getOptions().getResults().getSuccessCount(BaseImporter.this.getTargetForm().getName()), BaseImporter.this.getTargetForm().getName()));
                    }
                    throw outOfMemoryError;
                }
            }

            public boolean isAbort() {
                return false;
            }
        };
        if (this.bZ != null) {
            this.bZ.addListener(this.b0);
        }
    }

    protected List<BulkEntryReturn> handleEndTransaction(int n) throws ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        List list = null;
        if (this.cd) {
            this.cd = false;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)ImportErrors.END_BULK_TRANSACTION.toDefMsg());
            }
            list = this.options.getContext().endBulkEntryTransaction(n);
        }
        return list;
    }

    protected void handleStartTransaction() throws ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        try {
            if (this.options.getDataOptions().getTransactionSize() > 1) {
                this.cg = 0;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)ImportErrors.START_BULK_TRANSACTION.toDefMsg());
                }
                this.options.getContext().beginBulkEntryTransaction();
                this.cd = true;
            }
        }
        catch (ARException aRException) {
            logger.warn((Object)MessageFormat.format(ImportErrors.ERROR_IN_BULK_TRANSACTION.toDefMsg(), "beginBulkEntryTransaction"));
            throw new ARImportException(ImportErrors.ERROR_IN_BULK_TRANSACTION.toDefMsg(), aRException);
        }
    }

    protected void handleTitlesEvent(List<String> list) throws ARException {
    }

    protected List<BulkEntryReturn> handleEndEvent() throws ARException {
        List<BulkEntryReturn> list = null;
        if (this.cd) {
            list = this.handleEndTransaction(1);
        }
        return list;
    }

    protected void handleDataEvent(List<String> list, String string) throws ARImportException, ARException {
        if (this.getParser().isAbort()) {
            if (this.getParser().isCopyToLog()) {
                Util.logEntry(string);
            }
        } else if (this.isProcessDataSet()) {
            this.createEntry(list, string);
        }
    }

    protected void handleNewFormEvent(FormInformation formInformation) throws ARImportException, ARException {
    }

    public ImportOptions getOptions() {
        return this.options;
    }

    public void setOptions(ImportOptions importOptions) {
        this.options = importOptions;
    }

    public abstract void startImport() throws ARImportException, IOException, ARException;

    protected void importEntry(FormInformation formInformation, Entry entry) throws ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        if (this.b4.getDuplicateFields() != null && this.b4.getDuplicateFields().size() > 0) {
            QualifierInfo qualifierInfo = this.a(entry, this.b4.getDuplicateFields());
            if (this.isCompatibleServer() && this.b4.getMultiMatch().equals((Object)DataOptions.MultiMatch.USEFIRST)) {
                this.importEntry(formInformation, entry, qualifierInfo);
            } else if (qualifierInfo != null) {
                List list;
                ArrayList<EntryListFieldInfo> arrayList = new ArrayList<EntryListFieldInfo>(1);
                arrayList.add(new EntryListFieldInfo(1));
                int n = 0;
                if (this.b4.getMultiMatch() == DataOptions.MultiMatch.USEFIRST) {
                    n = 1;
                }
                try {
                    list = this.bY.getListEntry(formInformation.getName(), qualifierInfo, 0, n, null, arrayList, false, null);
                }
                catch (ARException aRException) {
                    list = null;
                }
                if (list != null && !list.isEmpty()) {
                    if (this.b4.getMultiMatch() == DataOptions.MultiMatch.SKIP) {
                        logger.info((Object)MessageFormat.format(ImportErrors.DUPLICATE_RECORDES_FOUND.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName())));
                        this.getOptions().getResults().incrementSkipCount(this.getTargetForm().getName(), false);
                    } else {
                        for (EntryListInfo entryListInfo : list) {
                            entry.setEntryId(entryListInfo.getEntryID());
                            this.bX = this.bY.mergeEntry(formInformation.getName(), entry, this.cf);
                            if (this.getEntryFactory() != null) {
                                this.getEntryFactory().setLastId(this.bX);
                            }
                            if (!logger.isTraceEnabled()) continue;
                            logger.trace((Object)MessageFormat.format(ImportErrors.ENTRY_CREATED.toDefMsg(), this.bX));
                        }
                    }
                } else {
                    if (this.b4.getDuplicateIdHandling() == DataOptions.DuplicateHandling.GEN_NEW_ID || entry.containsKey((Object)1) && ((Value)entry.get((Object)1)).getValue() == null) {
                        entry.remove((Object)1);
                    } else {
                        this.cf = this.a(2);
                    }
                    int n2 = this.cf;
                    this.cf = this.a(this.b4.getDuplicateIdHandling().getMergeOption());
                    this.bX = this.bY.mergeEntry(formInformation.getName(), entry, n2);
                    if (this.getEntryFactory() != null) {
                        this.getEntryFactory().setLastId(this.bX);
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)MessageFormat.format(ImportErrors.ENTRY_CREATED.toDefMsg(), this.bX));
                    }
                }
            } else {
                if (this.b4.getDuplicateIdHandling() == DataOptions.DuplicateHandling.GEN_NEW_ID || entry.containsKey((Object)1) && ((Value)entry.get((Object)1)).getValue() == null) {
                    entry.remove((Object)1);
                }
                this.bX = this.bY.mergeEntry(formInformation.getName(), entry, this.cf);
                if (this.getEntryFactory() != null) {
                    this.getEntryFactory().setLastId(this.bX);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)MessageFormat.format(ImportErrors.ENTRY_CREATED.toDefMsg(), this.bX));
                }
            }
        } else {
            if (this.b4.getDuplicateIdHandling() == DataOptions.DuplicateHandling.GEN_NEW_ID || entry.containsKey((Object)1) && ((Value)entry.get((Object)1)).getValue() == null) {
                entry.remove((Object)1);
            }
            this.bX = this.bY.mergeEntry(formInformation.getName(), entry, this.cf);
            if (this.getEntryFactory() != null) {
                this.getEntryFactory().setLastId(this.bX);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)MessageFormat.format(ImportErrors.ENTRY_CREATED.toDefMsg(), this.bX));
            }
        }
    }

    protected void importEntry(FormInformation formInformation, Entry entry, QualifierInfo qualifierInfo) throws ARException {
        Logger logger = ThreadLocalStorage.getLogger();
        try {
            if (entry.containsKey((Object)1) && ((Value)entry.get((Object)1)).getValue() == null) {
                entry.remove((Object)1);
            }
            this.bX = this.bY.mergeEntry(formInformation.getName(), entry, this.cf, qualifierInfo, 1);
            if (this.getEntryFactory() != null) {
                this.getEntryFactory().setLastId(this.bX);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)MessageFormat.format(ImportErrors.ENTRY_CREATED.toDefMsg(), this.bX));
            }
        }
        catch (ARException aRException) {
            StatusInfo[] statusInfoArray = aRException.getLastStatus().toArray(new StatusInfo[0]);
            long l = statusInfoArray[0].getMessageNum();
            if (288L == l) {
                this.setCompatibleServer(false);
                this.importEntry(formInformation, entry);
            }
            throw aRException;
        }
    }

    private int a(int n) {
        Logger logger = ThreadLocalStorage.getLogger();
        int n2 = n;
        if (this.options.getDataOptions().isDisablePattern()) {
            n2 |= 0x800;
        }
        if (this.options.getDataOptions().isDisableRequired()) {
            n2 |= 0x400;
        }
        if (this.options.getDataOptions().isSuppressFilters()) {
            try {
                if (this.getOptions().getContext() != null && this.getOptions().getContext().isAdministrator()) {
                    n2 |= 0x1000;
                }
            }
            catch (ARException aRException) {
                logger.error((Object)ImportErrors.USER_NOT_DETERMINED.toDefMsg(), (Throwable)aRException);
            }
        }
        return n2;
    }

    private QualifierInfo a(Entry entry, List<Integer> list) {
        QualifierInfo qualifierInfo = null;
        if (list != null && list.size() > 0) {
            ArrayList<QualifierInfo> arrayList = new ArrayList<QualifierInfo>(list.size());
            for (Integer n : list) {
                Value value = (Value)entry.get((Object)n);
                if (value == null) continue;
                RelationalOperationInfo relationalOperationInfo = new RelationalOperationInfo();
                relationalOperationInfo.setOperation(1);
                relationalOperationInfo.setLeftOperand(new ArithmeticOrRelationalOperand(n.intValue()));
                relationalOperationInfo.setRightOperand(new ArithmeticOrRelationalOperand(value));
                QualifierInfo qualifierInfo2 = new QualifierInfo(relationalOperationInfo);
                arrayList.add(qualifierInfo2);
            }
            if (!arrayList.isEmpty()) {
                int n = arrayList.size();
                if (n == 1) {
                    return (QualifierInfo)arrayList.get(0);
                }
                qualifierInfo = new QualifierInfo(1, (QualifierInfo)arrayList.get(0), null);
                if (n == 2) {
                    qualifierInfo.setRightOperand((QualifierInfo)arrayList.get(1));
                } else {
                    for (int i = 1; i < n; ++i) {
                        if (i + 1 < n) {
                            qualifierInfo.setRightOperand((QualifierInfo)arrayList.get(i));
                            qualifierInfo = new QualifierInfo(1, qualifierInfo, null);
                            continue;
                        }
                        qualifierInfo.setRightOperand((QualifierInfo)arrayList.get(i));
                    }
                }
            }
        }
        return qualifierInfo;
    }

    protected void verifyCoreFields(FormInformation formInformation, Entry entry) {
    }

    public EntryFactory getEntryFactory() {
        return this.b6;
    }

    public void setEntryFactory(EntryFactory entryFactory) {
        this.b6 = entryFactory;
    }

    protected void createEntry(List<String> list, String string) throws ARImportException, ARException, NullPointerException {
        if (this.getEntryFactory() == null) {
            this.setEntryFactory(new EntryFactory(this.getParser(), this.options, this.getSourceForm(), this.getTargetForm()));
        }
        Entry entry = null;
        try {
            entry = this.getEntryFactory().createEntry(list, string);
            if (entry != null) {
                this.b2.add(entry);
                this.b8.add(list);
                this.b7.add(string);
            }
        }
        catch (Exception exception) {
            this.handleException(exception, list, string, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doFallback(List<String> list, ArrayList<Integer> arrayList, Entry entry, ArrayList<Integer> arrayList2, String string) throws ARException, ARImportException, NullPointerException {
        Value value;
        String string2;
        Object object;
        Logger logger = ThreadLocalStorage.getLogger();
        MappingOptions mappingOptions = this.options.getMappingOptions(this.b1.getName(), this.b9.getName());
        if (mappingOptions == null) {
            mappingOptions = this.options.getMappingOptions(DATA_FILE_FORM, this.b9.getName());
        }
        if (mappingOptions == null) {
            throw new NullPointerException(ImportErrors.MAP_INFO_NULL.toDefMsg());
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!this.isFallback(arrayList.get(i), arrayList2)) continue;
            arrayList2.remove(arrayList.get(i));
            this.getEntryFactory().applyFallbackMappings(mappingOptions, this.b1, this.b9, list, arrayList.get(i));
            object = mappingOptions.getFallbacks().get(arrayList.get(i));
            if (object == null) {
                throw new NullPointerException(ImportErrors.NO_MAPPING_FOUND.toDefMsg() + arrayList.get(i));
            }
            FieldInformation fieldInformation = this.b9.getFields().get(arrayList.get(i));
            if (fieldInformation == null) {
                throw new NullPointerException("Field id " + arrayList.get(i) + "does not exist on schema: " + this.b9.getName());
            }
            Converter converter = new Converter(this.options);
            if (fieldInformation.getDataType() == null) continue;
            if (((Mapping)object).getType() == Mapping.Type.CONSTANT) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)MessageFormat.format(ImportErrors.SET_VALUE_FOR_CONSTANT.toDefMsg(), fieldInformation.getFieldId(), object));
                }
                entry.put(Integer.valueOf(fieldInformation.getFieldId()), new Value(((Mapping)object).getConstant()));
                continue;
            }
            if (((Mapping)object).getType() == Mapping.Type.COMPOUND) {
                Value value2 = converter.convertToARValue(fieldInformation, ((Mapping)object).getCompoundValue());
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)MessageFormat.format(ImportErrors.APPLY_FALLBACK.toDefMsg(), fieldInformation.getFieldId(), value2, object));
                }
                entry.put(Integer.valueOf(fieldInformation.getFieldId()), value2);
                continue;
            }
            if (((Mapping)object).getType() == Mapping.Type.KEYWORD) {
                Value value3 = converter.getKeywordValue(fieldInformation, (Mapping)object);
                entry.put(Integer.valueOf(fieldInformation.getFieldId()), value3);
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)MessageFormat.format(ImportErrors.APPLY_FALLBACK.toDefMsg(), fieldInformation.getFieldId(), value3, object));
                continue;
            }
            int n = ((Mapping)object).getTokenIndex();
            if (n <= -1 || n > list.size() - 1) continue;
            string2 = list.get(n);
            value = converter.convertToARValue(fieldInformation, string2);
            entry.put(Integer.valueOf(fieldInformation.getFieldId()), value);
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)MessageFormat.format(ImportErrors.APPLY_FALLBACK.toDefMsg(), fieldInformation.getFieldId(), value, object));
        }
        try {
            this.importEntry(this.b9, entry);
            List list2 = this.getOptions().getContext().getLastStatus();
            if (list2 != null && list2.size() > 0) {
                if (((StatusInfo)list2.get(0)).getMessageType() == 1) {
                    if (this.getSourceForm() == null || this.getTargetForm() == null) throw new ARImportException(ImportErrors.FORMS_NOT_FOUND.toDefMsg());
                    this.getOptions().getResults().addWarning(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), ((StatusInfo)this.getOptions().getContext().getLastStatus().get(0)).getMessageText(), null));
                    logger.warn((Object)MessageFormat.format(ImportErrors.IMPORT_WITH_WARNING.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName())));
                    this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                    return;
                } else {
                    this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                }
                return;
            } else {
                this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
            }
            return;
        }
        catch (ARException aRException) {
            arrayList.clear();
            object = aRException.getLastStatus().toArray(new StatusInfo[0]);
            for (int i = 0; i < ((StatusInfo[])object).length; ++i) {
                long l = object[i].getMessageNum();
                string2 = object[i].getAppendedText();
                value = string2.split(" ");
                for (int j = 0; j < ((String[])value).length; ++j) {
                    try {
                        arrayList.add(Integer.parseInt(value[j]));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (380L != l) continue;
                logger.info((Object)MessageFormat.format(ImportErrors.AR_ERROR_FILTER_REF_NO_MATCH_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), aRException.getMessage(), System.getProperty("line.separator"), string));
                return;
            }
            if (this.isFallback(arrayList.get(0), arrayList2)) {
                this.doFallback(list, arrayList, entry, arrayList2, string);
                return;
            }
            this.getOptions().getResults().addError(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), aRException.getMessage(), string));
        }
    }

    protected String getCurrentSource() {
        return this.ca;
    }

    protected void setCurrentSource(String string) {
        this.ca = string;
    }

    protected FormInformation getSourceForm() {
        if (this.b1 == null) {
            this.b1 = this.options.getFirstFileForm();
        }
        return this.b1;
    }

    protected void setSourceForm(FormInformation formInformation) {
        this.b1 = formInformation;
    }

    protected FormInformation getTargetForm() throws ARException {
        return this.b9;
    }

    protected void setTargetForm(FormInformation formInformation) {
        this.b9 = formInformation;
    }

    public IParser getParser() throws ARImportException {
        if (this.bZ == null) {
            this.bZ = this.createParser();
            this.createListener();
        }
        return this.bZ;
    }

    protected boolean isProcessDataSet() {
        return this.b3;
    }

    protected void setProcessDataSet(boolean bl) {
        this.b3 = bl;
    }

    protected boolean isFallback(Integer n, ArrayList<Integer> arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).equals(n)) continue;
            return true;
        }
        return false;
    }

    protected void handleException(Exception exception, List<String> list, String string, Entry entry) throws ARException, ARImportException {
        Object object;
        Object object2;
        Logger logger = ThreadLocalStorage.getLogger();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (exception instanceof ARException) {
            if (this.options.getDataOptions().getBadRecordHandling() != DataOptions.BadRecords.FALLBACK) {
                this.getOptions().getResults().addError(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), string));
            }
            object2 = (ARException)((Object)exception);
            object = object2.getLastStatus().toArray(new StatusInfo[0]);
            for (int i = 0; i < ((StatusInfo[])object).length; ++i) {
                long l = object[i].getMessageNum();
                String string2 = object[i].getAppendedText();
                if (string2 != null) {
                    String[] stringArray = string2.split(" ");
                    for (int j = 0; j < stringArray.length; ++j) {
                        try {
                            arrayList.add(Integer.parseInt(stringArray[j]));
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if (380L != l) continue;
                logger.info((Object)MessageFormat.format(ImportErrors.AR_ERROR_FILTER_REF_NO_MATCH_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string));
                return;
            }
        } else {
            this.getOptions().getResults().addError(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.ERROR, this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), string));
            logger.warn((Object)ImportErrors.EXCEPTION_ENCOUNTERED.toDefMsg(), (Throwable)exception);
        }
        if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.FALLBACK && entry != null) {
            try {
                object2 = this.options.getMappingOptions(this.b1.getName(), this.b9.getName());
                if (object2 == null) {
                    object2 = this.options.getMappingOptions(DATA_FILE_FORM, this.b9.getName());
                }
                if (object2 == null) {
                    throw new NullPointerException(ImportErrors.MAP_INFO_NULL.toDefMsg());
                }
                object = ((MappingOptions)object2).getFallbacks().keySet().toArray();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (int i = 0; i < ((StatusInfo[])object).length; ++i) {
                    arrayList2.add((Integer)object[i]);
                }
                this.doFallback(list, arrayList, entry, arrayList2, string);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        } else {
            if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.STOP) {
                logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string));
                logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE.toDefMsg());
                throw new ARImportException(exception);
            }
            if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.SKIP) {
                logger.info((Object)ImportErrors.SKIP_RECORD.toDefMsg());
                logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string));
            } else if (this.options.getDataOptions().getBadRecordHandling() == DataOptions.BadRecords.ALERTUSER && this.options.getUserAlertListener() != null) {
                int n = this.options.getUserAlertListener().handleUserAlert(this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), string, exception.getMessage());
                switch (n) {
                    case 0: {
                        logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string));
                        logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER.toDefMsg());
                        this.getParser().setAbort(true);
                        this.handleEndTransaction(2);
                        break;
                    }
                    case 2: {
                        logger.info((Object)MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string));
                        logger.info((Object)ImportErrors.STOP_ON_FIRST_FAILURE_BY_USER_COPY_REST.toDefMsg());
                        this.getParser().setAbort(true);
                        this.getParser().setCopyToLog(true);
                        this.handleEndTransaction(2);
                        break;
                    }
                    default: {
                        object = MessageFormat.format(ImportErrors.IMPORT_ERROR.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), exception.getMessage(), System.getProperty("line.separator"), string);
                        logger.info((Object)ImportErrors.SKIP_RECORD_INSTRUCTED_BY_USER.toDefMsg());
                        logger.info(object);
                        break;
                    }
                }
            }
        }
    }

    protected void importEntries(LinkedList<List<String>> linkedList, LinkedList<String> linkedList2) throws ARException, ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        int n = this.b2.size();
        Entry entry = null;
        List<String> list = null;
        String string = null;
        for (int i = 0; i < n; ++i) {
            try {
                string = linkedList2.removeFirst();
                if (this.getParser().isAbort()) {
                    if (!this.getParser().isCopyToLog()) continue;
                    Util.logEntry(string);
                    continue;
                }
                entry = this.b2.removeFirst();
                list = linkedList.removeFirst();
                if (this.getTargetForm() != null) {
                    this.getOptions().getResults().incrementRecordCount(this.getTargetForm().getName());
                }
                this.importEntry(this.getTargetForm(), entry);
                ++this.cg;
                List list2 = this.getOptions().getContext().getLastStatus();
                if (list2 != null && list2.size() > 0) {
                    if (((StatusInfo)list2.get(0)).getMessageType() == 1) {
                        if (this.getSourceForm() != null && this.getTargetForm() != null) {
                            this.getOptions().getResults().addWarning(this.getTargetForm().getName(), new RecordResult(this.getSourceForm().getName(), this.getTargetForm().getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.getTargetForm().getName()), ((StatusInfo)this.getOptions().getContext().getLastStatus().get(0)).getMessageText(), null));
                            logger.warn((Object)MessageFormat.format(ImportErrors.IMPORT_WITH_WARNING.toDefMsg(), this.getOptions().getResults().getRecordCount(this.getTargetForm().getName())));
                            this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                            continue;
                        }
                        throw new ARImportException(ImportErrors.FORMS_NOT_FOUND.toDefMsg());
                    }
                    this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                    continue;
                }
                this.getOptions().getResults().incrementSuccessCount(this.getTargetForm().getName());
                continue;
            }
            catch (Exception exception) {
                if (list == null || entry == null) {
                    throw new ARImportException(exception);
                }
                this.handleException(exception, list, string, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bulkImportEntry(LinkedList<List<String>> linkedList, LinkedList<String> linkedList2) throws ARException, ARImportException {
        Logger logger = ThreadLocalStorage.getLogger();
        List<BulkEntryReturn> list = null;
        int n = this.b2.size();
        Entry entry = null;
        try {
            this.handleStartTransaction();
            for (int i = 0; i < n; ++i) {
                entry = this.b2.get(i);
                this.importEntry(this.getTargetForm(), entry);
                ++this.cg;
            }
            list = this.handleEndEvent();
            this.checkLogStatus(list, n);
        }
        catch (ARBulkException aRBulkException) {
            List list2 = aRBulkException.getBulkEntryReturn();
            int n2 = list2.size() - 1;
            if (n2 >= 0) {
                BulkEntryReturn bulkEntryReturn = (BulkEntryReturn)list2.get(n2);
                logger.warn((Object)MessageFormat.format(ImportErrors.ERROR_IN_BULK_TRANSACTION.toDefMsg(), bulkEntryReturn.getStatusList()));
            } else {
                logger.warn((Object)MessageFormat.format(ImportErrors.ERROR_IN_BULK_TRANSACTION.toDefMsg(), new Object[]{aRBulkException}));
            }
            try {
                if (n2 > 0) {
                    this.handleStartTransaction();
                    for (int i = 0; i < n2; ++i) {
                        entry = this.b2.remove();
                        linkedList.remove();
                        linkedList2.remove();
                        this.importEntry(this.getTargetForm(), entry);
                        ++this.cg;
                    }
                    list = this.handleEndEvent();
                    this.checkLogStatus(list, n2);
                }
                this.importEntries(linkedList, linkedList2);
            }
            catch (ARBulkException aRBulkException2) {
                logger.error((Object)MessageFormat.format(ImportErrors.SECOND_ATTEMPT_BULK_TRANSACTION_FAILED.toDefMsg(), new Object[]{aRBulkException2}), (Throwable)aRBulkException2);
                throw new ARImportException(ImportErrors.ERROR_IN_END_BULK_TRANSACTION_EXCEPTION.toDefMsg());
            }
        }
        catch (ARImportException aRImportException) {
            if (!this.cd) {
                this.importEntries(linkedList, linkedList2);
            }
        }
        finally {
            this.b2.clear();
            linkedList.clear();
            linkedList2.clear();
        }
    }

    protected void checkLogStatus(List<BulkEntryReturn> list, int n) {
        Logger logger = ThreadLocalStorage.getLogger();
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < n; ++i) {
                List list2;
                if (this.b9 != null) {
                    this.getOptions().getResults().incrementRecordCount(this.b9.getName());
                }
                if ((list2 = list.get(i).getStatusList()) != null && list2.size() > 0) {
                    Iterator iterator = list2.iterator();
                    StringBuffer stringBuffer = null;
                    while (iterator.hasNext()) {
                        StatusInfo statusInfo = (StatusInfo)iterator.next();
                        if (((StatusInfo)list2.get(0)).getMessageType() != 1) continue;
                        if (stringBuffer == null) {
                            stringBuffer = new StringBuffer();
                        }
                        stringBuffer.append(statusInfo.toString()).append(" ; ");
                    }
                    if (stringBuffer != null && this.b1 != null && this.b9 != null) {
                        this.getOptions().getResults().addWarning(this.b9.getName(), new RecordResult(this.b1.getName(), this.b9.getName(), RecordResult.Status.WARN, this.getOptions().getResults().getRecordCount(this.b9.getName()), stringBuffer.toString(), null));
                        logger.warn((Object)MessageFormat.format(ImportErrors.IMPORT_WITH_WARNING.toDefMsg(), this.getOptions().getResults().getRecordCount(this.b9.getName()), stringBuffer.toString()));
                    }
                    this.getOptions().getResults().incrementSuccessCount(this.b9.getName());
                    continue;
                }
                this.getOptions().getResults().incrementSuccessCount(this.b9.getName());
            }
        } else {
            this.getOptions().getResults().incrementSuccessCount(this.b9.getName());
        }
    }

    private boolean new() {
        if (this.getServerMajorVersion() > 7) {
            return true;
        }
        if (this.getServerMajorVersion() == 7 && this.getServerMinorVersion() >= 6) {
            if (this.getServerMinorVersion() == 6) {
                int n;
                String[] stringArray;
                try {
                    stringArray = this.getServerPatchString().toLowerCase().split("build");
                    n = Integer.parseInt(stringArray[0].trim());
                }
                catch (Exception exception) {
                    stringArray = null;
                    n = -1;
                }
                if (n < 4) {
                    return false;
                }
                if (n == 4) {
                    int n2;
                    try {
                        String[] stringArray2 = stringArray[1].trim().split(" ");
                        n2 = Integer.parseInt(stringArray2[0].trim());
                    }
                    catch (Exception exception) {
                        n2 = -1;
                    }
                    if (n2 == 1) {
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean try() {
        return this.isBulkCompatible() && this.options.getDataOptions().getTransactionSize() > 1 && (null == this.options.getDataOptions().getDuplicateFields() || this.options.getDataOptions().isForceBulk() || this.isCompatibleServer() && !this.options.getDataOptions().getMultiMatch().equals((Object)DataOptions.MultiMatch.UPDATEALL));
    }
}

