/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.arsys.plugin.sample;

import com.bmc.arsys.api.ARException;
import com.bmc.arsys.api.ArithmeticOrRelationalOperand;
import com.bmc.arsys.api.AttachmentFieldLimit;
import com.bmc.arsys.api.AttachmentValue;
import com.bmc.arsys.api.CharacterFieldLimit;
import com.bmc.arsys.api.DataType;
import com.bmc.arsys.api.DateInfo;
import com.bmc.arsys.api.DateOnlyFieldLimit;
import com.bmc.arsys.api.DateTimeFieldLimit;
import com.bmc.arsys.api.DecimalFieldLimit;
import com.bmc.arsys.api.Entry;
import com.bmc.arsys.api.EntryListFieldInfo;
import com.bmc.arsys.api.FieldLimit;
import com.bmc.arsys.api.IntegerFieldLimit;
import com.bmc.arsys.api.OutputInteger;
import com.bmc.arsys.api.QualifierInfo;
import com.bmc.arsys.api.RealFieldLimit;
import com.bmc.arsys.api.SortInfo;
import com.bmc.arsys.api.StatisticsResultInfo;
import com.bmc.arsys.api.StatusInfo;
import com.bmc.arsys.api.Time;
import com.bmc.arsys.api.TimeOnlyFieldLimit;
import com.bmc.arsys.api.Timestamp;
import com.bmc.arsys.api.Value;
import com.bmc.arsys.api.VendorForm;
import com.bmc.arsys.pluginsvr.plugins.ARDBCPlugin;
import com.bmc.arsys.pluginsvr.plugins.ARPluggable;
import com.bmc.arsys.pluginsvr.plugins.ARPluginContext;
import com.bmc.arsys.pluginsvr.plugins.ARPluginInfo;
import com.bmc.arsys.pluginsvr.plugins.ARVendorField;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARDBCSample
extends ARDBCPlugin {
    private Connection con;
    private ARPluginInfo pluginInfo = new ARPluginInfo("SAMPLE_JDBC_PLUGIN", (ARPluggable)this);
    private static final String NAME = "SAMPLE_JDBC_PLUGIN";
    private static final String DBNAME = "SamplePlugin";

    synchronized ArrayList<VendorForm> getTables() throws SQLException {
        Statement statement = this.con.createStatement();
        ArrayList<VendorForm> arrayList = new ArrayList<VendorForm>();
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = this.con.getMetaData();
        resultSet = databaseMetaData.getTables(null, null, null, null);
        while (resultSet.next()) {
            String string = resultSet.getString("TABLE_NAME");
            if (!string.startsWith("ar")) continue;
            VendorForm vendorForm = new VendorForm(NAME, string);
            arrayList.add(vendorForm);
        }
        resultSet.close();
        statement.close();
        return arrayList;
    }

    synchronized ArrayList<ARVendorField> getColumns(String string) throws SQLException {
        Statement statement = this.con.createStatement();
        ArrayList<ARVendorField> arrayList = new ArrayList<ARVendorField>();
        String string2 = "Select TOP 1 * from " + string;
        ResultSet resultSet = statement.executeQuery(string2);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        block12: for (int i = 1; i <= n; ++i) {
            String string3 = resultSetMetaData.getColumnName(i);
            int n2 = resultSetMetaData.getColumnType(i);
            DateOnlyFieldLimit dateOnlyFieldLimit = null;
            switch (n2) {
                case 1: {
                    n2 = 4;
                    dateOnlyFieldLimit = new CharacterFieldLimit(1, 0, 0, null, null, 0);
                    break;
                }
                case 3: {
                    n2 = 10;
                    dateOnlyFieldLimit = new DecimalFieldLimit("-99999999999999999999999999.99", "99999999999999999999999999.99", 3);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n2 = 3;
                    dateOnlyFieldLimit = new RealFieldLimit(-1.845E19, 1.845E19, 6);
                    break;
                }
                case 4: {
                    n2 = 2;
                    new IntegerFieldLimit(-2147483647, Integer.MAX_VALUE);
                    break;
                }
                case 2004: {
                    n2 = 11;
                    dateOnlyFieldLimit = new AttachmentFieldLimit(200000, 0, 0);
                    break;
                }
                case -1: {
                    n2 = 4;
                    dateOnlyFieldLimit = new CharacterFieldLimit(0, 0, 0, null, null, 0);
                    break;
                }
                case 12: {
                    n2 = 4;
                    dateOnlyFieldLimit = new CharacterFieldLimit(255, 0, 0, null, null, 0);
                    break;
                }
                case 91: {
                    n2 = 13;
                    dateOnlyFieldLimit = new DateOnlyFieldLimit();
                    break;
                }
                case 92: {
                    n2 = 14;
                    dateOnlyFieldLimit = new TimeOnlyFieldLimit();
                    break;
                }
                case 93: {
                    n2 = 7;
                    dateOnlyFieldLimit = new DateTimeFieldLimit();
                    break;
                }
                default: {
                    continue block12;
                }
            }
            ARVendorField aRVendorField = new ARVendorField(string3, 0, n2, (FieldLimit)dateOnlyFieldLimit);
            arrayList.add(aRVendorField);
        }
        resultSet.close();
        statement.close();
        return arrayList;
    }

    Entry getRecord(String string, List<ARVendorField> list, String string2) throws SQLException {
        Statement statement = this.con.createStatement();
        Entry entry = null;
        String string3 = "Select * from " + string;
        ResultSet resultSet = statement.executeQuery(string3);
        HashMap<Integer, Value> hashMap = null;
        int n = 1;
        if (resultSet != null && list != null) {
            while (resultSet.next()) {
                String string4 = "";
                hashMap = new HashMap<Integer, Value>();
                for (int i = 0; i < list.size(); ++i) {
                    Value value;
                    String string5;
                    ARVendorField aRVendorField = list.get(i);
                    if (aRVendorField.getFieldId() == 1) {
                        string4 = string5 = Integer.toString(n++);
                        value = new Value(string5, DataType.toDataType((int)aRVendorField.getDataType()));
                        hashMap.put(new Integer(aRVendorField.getFieldId()), value);
                        continue;
                    }
                    string5 = resultSet.getString(aRVendorField.getName());
                    value = new Value(string5, DataType.toDataType((int)aRVendorField.getDataType()));
                    hashMap.put(new Integer(aRVendorField.getFieldId()), value);
                }
                if (!string4.equals(string2)) continue;
                break;
            }
            entry = new Entry(hashMap);
            resultSet.close();
        }
        statement.close();
        return entry;
    }

    List<Entry> getRecords(String string, List<ARVendorField> list, QualifierInfo qualifierInfo) throws SQLException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        Statement statement = this.con.createStatement();
        String string2 = "Select * from " + string;
        ResultSet resultSet = statement.executeQuery(string2);
        int n = 1;
        if (resultSet != null && list != null) {
            while (resultSet.next()) {
                HashMap<Integer, Value> hashMap = new HashMap<Integer, Value>();
                for (int i = 0; i < list.size(); ++i) {
                    Value value;
                    String string3;
                    ARVendorField aRVendorField = list.get(i);
                    if (aRVendorField.getFieldId() == 1) {
                        string3 = Integer.toString(n++);
                        value = new Value(string3, DataType.toDataType((int)aRVendorField.getDataType()));
                        hashMap.put(new Integer(aRVendorField.getFieldId()), value);
                        continue;
                    }
                    string3 = resultSet.getString(aRVendorField.getName());
                    value = new Value(string3, DataType.toDataType((int)aRVendorField.getDataType()));
                    hashMap.put(new Integer(aRVendorField.getFieldId()), value);
                }
                Entry entry = new Entry(hashMap);
                arrayList.add(entry);
            }
            resultSet.close();
        }
        statement.close();
        return arrayList;
    }

    String createRecord(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, Entry entry) throws SQLException {
        String string2 = null;
        Statement statement = this.con.createStatement();
        if (string != null && list != null && entry != null) {
            ARVendorField aRVendorField;
            int n;
            String string3 = "Insert into " + string + " (";
            for (n = 0; n < list.size(); ++n) {
                aRVendorField = list.get(n);
                if (aRVendorField.getFieldId() == 1) continue;
                string3 = string3 + aRVendorField.getName();
                if (n + 1 >= list.size()) continue;
                string3 = string3 + ",";
            }
            string3 = string3 + ") Values (";
            block11: for (n = 0; n < list.size(); ++n) {
                aRVendorField = list.get(n);
                Value value = (Value)entry.get((Object)aRVendorField.getFieldId());
                if (aRVendorField.getFieldId() == 1) continue;
                switch (aRVendorField.getDataType()) {
                    case 4: {
                        string3 = string3 + " '" + (String)value.getValue() + "' ";
                        break;
                    }
                    case 10: {
                        string3 = string3 + " " + ((BigDecimal)value.getValue()).doubleValue() + "  ";
                        break;
                    }
                    case 3: {
                        string3 = string3 + " " + (Double)value.getValue() + "  ";
                        break;
                    }
                    case 2: {
                        string3 = string3 + " " + (Integer)value.getValue() + " ";
                        break;
                    }
                    case 11: {
                        string3 = string3 + " " + value.getValue() + " ";
                        break;
                    }
                    case 13: {
                        string3 = string3 + " " + ((DateInfo)value.getValue()).getValue() + " ";
                        break;
                    }
                    case 7: {
                        string3 = string3 + " " + ((Timestamp)value.getValue()).getValue() + " ";
                        break;
                    }
                    case 14: {
                        string3 = string3 + " " + ((Time)value.getValue()).getValue() + " ";
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                if (n + 1 >= list.size()) continue;
                string3 = string3 + ",";
            }
            n = statement.executeUpdate(string3 = string3 + ")");
            if (n > 0) {
                string2 = Integer.toString(n);
            }
        }
        statement.close();
        return string2;
    }

    public void cancel(ARPluginContext aRPluginContext, long l) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "cancel()");
        super.cancel(aRPluginContext, l);
    }

    public void commit(ARPluginContext aRPluginContext, long l) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "commit()");
        super.commit(aRPluginContext, l);
    }

    public String createEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, Entry entry) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "createEntry()");
        String string2 = null;
        try {
            string2 = this.createRecord(aRPluginContext, string, list, entry);
        }
        catch (SQLException sQLException) {
            new ARException(Arrays.asList(new StatusInfo(2, 1007L, "Error creating entry for table " + string, sQLException.getMessage())));
        }
        return string2;
    }

    public void deleteEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "deleteEntry()");
    }

    public AttachmentValue getBLOB(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2, int n) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "getBlob()");
        return super.getBLOB(aRPluginContext, string, list, l, string2, n);
    }

    public Entry getEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2, int[] nArray) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "getEntry()");
        Entry entry = null;
        try {
            entry = this.getRecord(string, list, string2);
        }
        catch (SQLException sQLException) {
            StatusInfo statusInfo = new StatusInfo(2, 1004L, "Error fetching entry " + string2 + " from table " + string, sQLException.getMessage());
            ArrayList<StatusInfo> arrayList = new ArrayList<StatusInfo>();
            arrayList.add(statusInfo);
            throw new ARException(arrayList);
        }
        if (entry == null) {
            new ARException(Arrays.asList(new StatusInfo(2, 1006L, "No such entry " + string2 + " for table " + string, "")));
        }
        return entry;
    }

    public List<StatisticsResultInfo> getEntryStatistics(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, QualifierInfo qualifierInfo, ArithmeticOrRelationalOperand arithmeticOrRelationalOperand, int n, int[] nArray) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "getEntryStatistics()");
        return super.getEntryStatistics(aRPluginContext, string, list, l, qualifierInfo, arithmeticOrRelationalOperand, n, nArray);
    }

    public List<Entry> getListEntryWithFields(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, QualifierInfo qualifierInfo, List<SortInfo> list2, List<EntryListFieldInfo> list3, int n, int n2, OutputInteger outputInteger) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "getListEntryWithFields()");
        List<Object> list4 = new ArrayList();
        try {
            list4 = this.getRecords(string, list, qualifierInfo);
        }
        catch (SQLException sQLException) {
            new ARException(Arrays.asList(new StatusInfo(2, 1004L, "Error fetching entries for given qualification from table " + string, sQLException.getMessage())));
        }
        if (list4 == null || list4.size() == 0) {
            new ARException(Arrays.asList(new StatusInfo(2, 1005L, "No entries for table " + string, "")));
        }
        return list4;
    }

    public List<VendorForm> getListForms(ARPluginContext aRPluginContext) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "getListForms()");
        ArrayList<VendorForm> arrayList = null;
        try {
            arrayList = this.getTables();
        }
        catch (SQLException sQLException) {
            new ARException(Arrays.asList(new StatusInfo(2, 1004L, "Error fetching table names from the datasource", sQLException.getMessage())));
        }
        return arrayList;
    }

    public List<ARVendorField> getMultipleFields(ARPluginContext aRPluginContext, VendorForm vendorForm) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "getMultipleFields()");
        ArrayList<ARVendorField> arrayList = null;
        try {
            arrayList = this.getColumns(vendorForm.getTableName());
        }
        catch (SQLException sQLException) {
            new ARException(Arrays.asList(new StatusInfo(2, 1003L, "Error fetching Columnnames for the table " + vendorForm.getTableName(), sQLException.getMessage())));
        }
        return arrayList;
    }

    public void rollback(ARPluginContext aRPluginContext, long l) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "rollBack()");
    }

    public void setBLOB(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2, int n, AttachmentValue attachmentValue) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "setBlob()");
    }

    public void setEntry(ARPluginContext aRPluginContext, String string, List<ARVendorField> list, long l, String string2, Entry entry, Timestamp timestamp) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "setEntry()");
    }

    public void initialize(ARPluginContext aRPluginContext) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "initialize()");
        String string = "jdbc:odbc:SamplePlugin";
        String string2 = "sun.jdbc.odbc.JdbcOdbcDriver";
        String string3 = "sa";
        String string4 = "";
        try {
            String string5 = aRPluginContext.getConfigItem(this.pluginInfo, "dburl");
            if (string5 != null && !string5.equals("")) {
                string = string5;
            }
            if ((string5 = aRPluginContext.getConfigItem(this.pluginInfo, "driver")) != null && !string5.equals("")) {
                string2 = string5;
            }
            if ((string5 = aRPluginContext.getConfigItem(this.pluginInfo, "user")) != null && !string5.equals("")) {
                string3 = string5;
            }
            if ((string5 = aRPluginContext.getConfigItem(this.pluginInfo, "password")) != null) {
                string4 = string5;
            }
            Class.forName(string2);
            this.con = DriverManager.getConnection(string, string3, string4);
        }
        catch (Exception exception) {
            new ARException(Arrays.asList(new StatusInfo(2, 1000L, "Error establishing jdbc connection to the datasource " + string, exception.getMessage())));
        }
    }

    public void onEvent(ARPluginContext aRPluginContext, int n) throws ARException {
        aRPluginContext.logMessage(this.pluginInfo, 0, "onEvent()");
        super.onEvent(aRPluginContext, n);
    }

    public void terminate(ARPluginContext aRPluginContext) throws ARException {
        try {
            aRPluginContext.logMessage(this.pluginInfo, 0, "terminate()");
            this.con.close();
        }
        catch (Exception exception) {
            new ARException(Arrays.asList(new StatusInfo(2, 1001L, "Error closing jdbc connection to the datasource", DBNAME)));
        }
    }
}

