/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.core;

import com.bmc.thirdparty.org.springframework.util.Assert;
import com.bmc.thirdparty.org.springframework.util.ClassUtils;
import com.bmc.thirdparty.org.springframework.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BridgeMethodResolver {
    static /* synthetic */ Class class$java$lang$Object;

    public static Method findBridgedMethod(Method bridgeMethod) {
        Assert.notNull(bridgeMethod, "Method must not be null");
        if (!bridgeMethod.isBridge()) {
            return bridgeMethod;
        }
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        Method[] methods = ReflectionUtils.getAllDeclaredMethods(bridgeMethod.getDeclaringClass());
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method candidateMethod = methods[i2];
            if (!BridgeMethodResolver.isBridgedCandidateFor(candidateMethod, bridgeMethod)) continue;
            candidateMethods.add(candidateMethod);
        }
        Method result = candidateMethods.size() == 1 ? (Method)candidateMethods.get(0) : BridgeMethodResolver.searchCandidates(candidateMethods, bridgeMethod);
        if (result == null) {
            throw new IllegalStateException("Unable to locate bridged method for bridge method '" + bridgeMethod + "'");
        }
        return result;
    }

    private static Method searchCandidates(List candidateMethods, Method bridgeMethod) {
        Map typeParameterMap = BridgeMethodResolver.createTypeVariableMap(bridgeMethod.getDeclaringClass());
        for (int i2 = 0; i2 < candidateMethods.size(); ++i2) {
            Method candidateMethod = (Method)candidateMethods.get(i2);
            if (!BridgeMethodResolver.isBridgeMethodFor(bridgeMethod, candidateMethod, typeParameterMap)) continue;
            return candidateMethod;
        }
        return null;
    }

    private static boolean isBridgedCandidateFor(Method candidateMethod, Method bridgeMethod) {
        return !candidateMethod.isBridge() && !candidateMethod.equals(bridgeMethod) && candidateMethod.getName().equals(bridgeMethod.getName()) && candidateMethod.getParameterTypes().length == bridgeMethod.getParameterTypes().length;
    }

    static boolean isBridgeMethodFor(Method bridgeMethod, Method candidateMethod, Map typeVariableMap) {
        Method method = BridgeMethodResolver.findGenericDeclaration(bridgeMethod);
        return method != null ? BridgeMethodResolver.isResolvedTypeMatch(method, candidateMethod, typeVariableMap) : false;
    }

    private static Method findGenericDeclaration(Method bridgeMethod) {
        Class<?> superclass = bridgeMethod.getDeclaringClass().getSuperclass();
        while (!(class$java$lang$Object == null ? BridgeMethodResolver.class$("java.lang.Object") : class$java$lang$Object).equals(superclass)) {
            Method method = BridgeMethodResolver.searchForMatch(superclass, bridgeMethod);
            if (method != null && !method.isBridge()) {
                return method;
            }
            superclass = superclass.getSuperclass();
        }
        Class[] interfaces = ClassUtils.getAllInterfacesForClass(bridgeMethod.getDeclaringClass());
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            Class anInterface = interfaces[i2];
            Method method = BridgeMethodResolver.searchForMatch(anInterface, bridgeMethod);
            if (method == null || method.isBridge()) continue;
            return method;
        }
        return null;
    }

    private static boolean isResolvedTypeMatch(Method genericMethod, Method candidateMethod, Map typeVariableMap) {
        Type[] genericParameters = genericMethod.getGenericParameterTypes();
        Object[] resolvedTypes = new Class[genericParameters.length];
        for (int i2 = 0; i2 < genericParameters.length; ++i2) {
            Type genericParameter = genericParameters[i2];
            if (genericParameter instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)genericParameter;
                resolvedTypes[i2] = (Class)typeVariableMap.get(tv.getName());
                continue;
            }
            resolvedTypes[i2] = genericParameter instanceof ParameterizedType ? (Class)((ParameterizedType)genericParameter).getRawType() : (Class)genericParameter;
        }
        return Arrays.equals(resolvedTypes, candidateMethod.getParameterTypes());
    }

    private static Method searchForMatch(Class type, Method bridgeMethod) {
        return ReflectionUtils.findMethod(type, bridgeMethod.getName(), bridgeMethod.getParameterTypes());
    }

    static Map createTypeVariableMap(Class cls) {
        HashMap typeVariableMap = new HashMap();
        Type genericType = cls.getGenericSuperclass();
        Class<Object> type = cls.getSuperclass();
        while (!(class$java$lang$Object == null ? BridgeMethodResolver.class$("java.lang.Object") : class$java$lang$Object).equals(type)) {
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt1 = (ParameterizedType)genericType;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(typeVariableMap, pt1);
            }
            genericType = type.getGenericSuperclass();
            type = type.getSuperclass();
        }
        type = cls;
        while (type.isMemberClass()) {
            genericType = type.getGenericSuperclass();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(typeVariableMap, pt);
            }
            type = type.getEnclosingClass();
        }
        Type[] genericInterfaces = cls.getGenericInterfaces();
        BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(genericInterfaces, typeVariableMap);
        return typeVariableMap;
    }

    private static void extractTypeVariablesFromGenericInterfaces(Type[] genericInterfaces, Map typeVariableMap) {
        for (int i2 = 0; i2 < genericInterfaces.length; ++i2) {
            Type genericInterface = genericInterfaces[i2];
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericInterface;
                BridgeMethodResolver.populateTypeMapFromParameterizedType(typeVariableMap, pt);
                continue;
            }
            if (!(genericInterface instanceof Class)) continue;
            BridgeMethodResolver.extractTypeVariablesFromGenericInterfaces(((Class)genericInterface).getGenericInterfaces(), typeVariableMap);
        }
    }

    private static void populateTypeMapFromParameterizedType(Map typeVariableMap, ParameterizedType type) {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
        for (int i2 = 0; i2 < actualTypeArguments.length; ++i2) {
            Type actualTypeArgument = actualTypeArguments[i2];
            if (actualTypeArgument instanceof Class) {
                typeVariableMap.put(typeVariables[i2].getName(), (Class)actualTypeArgument);
                continue;
            }
            if (!(actualTypeArgument instanceof TypeVariable)) continue;
            TypeVariable typeVariableArgument = (TypeVariable)actualTypeArgument;
            Type[] bounds = typeVariableArgument.getBounds();
            Class boundClass = BridgeMethodResolver.extractClassTypeVariable(typeVariableArgument);
            if (boundClass == null) continue;
            typeVariableMap.put(typeVariables[i2].getName(), boundClass);
        }
    }

    private static Class extractClassTypeVariable(TypeVariable typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        Type result = null;
        if (bounds.length > 0) {
            Type bound = bounds[0];
            if (bound instanceof ParameterizedType) {
                result = ((ParameterizedType)bound).getRawType();
            } else if (bound instanceof Class) {
                result = bound;
            } else if (bound instanceof TypeVariable) {
                result = BridgeMethodResolver.extractClassTypeVariable((TypeVariable)bound);
            }
        }
        return result instanceof Class ? (Class)result : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

