/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.thirdparty.org.springframework.beans;

public abstract class PropertyAccessorUtils {
    public static String getPropertyName(String propertyPath) {
        int separatorIndex = propertyPath.indexOf(91);
        return separatorIndex != -1 ? propertyPath.substring(0, separatorIndex) : propertyPath;
    }

    public static int getFirstNestedPropertySeparatorIndex(String propertyPath) {
        return PropertyAccessorUtils.getNestedPropertySeparatorIndex(propertyPath, false);
    }

    public static int getLastNestedPropertySeparatorIndex(String propertyPath) {
        return PropertyAccessorUtils.getNestedPropertySeparatorIndex(propertyPath, true);
    }

    private static int getNestedPropertySeparatorIndex(String propertyPath, boolean last) {
        int i2;
        boolean inKey = false;
        int length = propertyPath.length();
        int n2 = i2 = last ? length - 1 : 0;
        while (last ? i2 >= 0 : i2 < length) {
            switch (propertyPath.charAt(i2)) {
                case '[': 
                case ']': {
                    inKey = !inKey;
                    break;
                }
                case '.': {
                    if (inKey) break;
                    return i2;
                }
            }
            if (last) {
                --i2;
                continue;
            }
            ++i2;
        }
        return -1;
    }

    public static String canonicalPropertyName(String propertyName) {
        if (propertyName == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer(propertyName);
        int searchIndex = 0;
        while (searchIndex != -1) {
            int keyEnd;
            int keyStart = buf.toString().indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = buf.toString().indexOf("]", keyStart + "[".length())) == -1) continue;
            String key = buf.substring(keyStart + "[".length(), keyEnd);
            if (key.startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                buf.delete(keyStart + 1, keyStart + 2);
                buf.delete(keyEnd - 2, keyEnd - 1);
                keyEnd -= 2;
            }
            searchIndex = keyEnd + "]".length();
        }
        return buf.toString();
    }

    public static String[] canonicalPropertyNames(String[] propertyNames) {
        if (propertyNames == null) {
            return null;
        }
        String[] result = new String[propertyNames.length];
        for (int i2 = 0; i2 < propertyNames.length; ++i2) {
            result[i2] = PropertyAccessorUtils.canonicalPropertyName(propertyNames[i2]);
        }
        return result;
    }
}

